/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.tests.support;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class MyKeyPairGenerator1
extends KeyPairGenerator {
    public int keySize;
    public SecureRandom secureRandom;
    public AlgorithmParameterSpec paramSpec;

    public MyKeyPairGenerator1() {
        super("MyKeyPairGenerator1");
    }

    public MyKeyPairGenerator1(String pp) {
        super(pp);
    }

    public String getAlgorithm() {
        return "MyKeyPairGenerator1";
    }

    public static final String getResAlgorithm() {
        return "MyKeyPairGenerator1";
    }

    public void initialize(int keysize, SecureRandom random) {
        if (keysize < 0 || keysize % 100 != 0) {
            throw new InvalidParameterException("Incorrect keysize parameter");
        }
        if (random == null) {
            throw new InvalidParameterException("Incorrect random");
        }
        this.keySize = keysize;
        this.secureRandom = random;
    }

    public KeyPair generateKeyPair() {
        try {
            return new KeyPair(new PubKey(), new PrivKey());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void initialize(AlgorithmParameterSpec param, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (random == null) {
            throw new InvalidParameterException("Incorrect random");
        }
        if (param == null) {
            throw new InvalidAlgorithmParameterException("Incorrect param");
        }
        this.paramSpec = param;
        this.secureRandom = random;
    }

    public class PrivKey
    implements PrivateKey {
        private String algorithm = "MyKeyPairGenerator1";
        private String format = "test1";
        private byte[] encoded = new byte[10];

        public String getAlgorithm() {
            return this.algorithm;
        }

        public String getFormat() {
            return this.format;
        }

        public byte[] getEncoded() {
            return this.encoded;
        }
    }

    public class PubKey
    implements PublicKey {
        private String algorithm = "MyKeyPairGenerator1";
        private String format = "test1";
        private byte[] encoded = new byte[10];

        public String getAlgorithm() {
            return this.algorithm;
        }

        public String getFormat() {
            return this.format;
        }

        public byte[] getEncoded() {
            return this.encoded;
        }
    }
}

