/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.tests.support;

import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import javax.crypto.SecretKey;
import org.apache.harmony.security.tests.support.SpiEngUtils;

public class KeyStoreTestSupport {
    public static final String srvKeyStore = "KeyStore";
    public static String[] validValues = new String[]{"bks", "BKS", "bKS", "Bks", "bKs", "BkS"};
    public static String defaultType = "bks";
    public static boolean JKSSupported = false;
    public static String defaultProviderName = null;
    public static Provider defaultProvider = null;

    static {
        defaultProvider = SpiEngUtils.isSupport(defaultType, srvKeyStore);
        JKSSupported = defaultProvider != null;
        defaultProviderName = JKSSupported ? defaultProvider.getName() : null;
    }

    public static class AnotherEntry
    implements KeyStore.Entry {
    }

    public static class ProtPar
    implements KeyStore.ProtectionParameter {
    }

    public static class MCertificate
    extends Certificate {
        private final byte[] encoding;
        private final String type;

        public MCertificate(String type, byte[] encoding) {
            super(type);
            this.encoding = encoding;
            this.type = type;
        }

        public byte[] getEncoded() throws CertificateEncodingException {
            return (byte[])this.encoding.clone();
        }

        public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        }

        public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        }

        public String toString() {
            return "[MCertificate, type: " + this.getType() + "]";
        }

        public PublicKey getPublicKey() {
            return new PublicKey(){

                public String getAlgorithm() {
                    return MCertificate.this.type;
                }

                public byte[] getEncoded() {
                    return MCertificate.this.encoding;
                }

                public String getFormat() {
                    return "test";
                }
            };
        }
    }

    public static class MyPrivateKey
    implements PrivateKey {
        private String algorithm;
        private String format;
        private byte[] encoded;

        public MyPrivateKey(String algorithm, String format, byte[] encoded) {
            this.algorithm = algorithm;
            this.format = format;
            this.encoded = encoded;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public String getFormat() {
            return this.format;
        }

        public byte[] getEncoded() {
            return this.encoded;
        }
    }

    public static class SKey
    implements SecretKey {
        private String type;
        private byte[] encoded;

        public SKey(String type, byte[] encoded) {
            this.type = type;
            this.encoded = encoded;
        }

        public String getAlgorithm() {
            return this.type;
        }

        public byte[] getEncoded() {
            return this.encoded;
        }

        public String getFormat() {
            return "test";
        }
    }
}

