/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.tests.java.util;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import junit.framework.TestCase;
import tests.support.Support_MapTest2;

public class WeakHashMapTest
extends TestCase {
    Object[] keyArray = new Object[100];
    Object[] valueArray = new Object[100];
    WeakHashMap whm;
    Object[] KEY_ARRAY;
    Object[] VALUE_ARRAY;

    public void test_Constructor() {
        int i;
        new Support_MapTest2(new WeakHashMap<String, String>()).runTest();
        this.whm = new WeakHashMap();
        for (i = 0; i < 100; ++i) {
            this.whm.put(this.keyArray[i], this.valueArray[i]);
        }
        for (i = 0; i < 100; ++i) {
            WeakHashMapTest.assertTrue((String)"Incorrect value retrieved", (this.whm.get(this.keyArray[i]) == this.valueArray[i] ? 1 : 0) != 0);
        }
    }

    public void test_ConstructorI() {
        int i;
        this.whm = new WeakHashMap(50);
        for (i = 0; i < 100; ++i) {
            this.whm.put(this.keyArray[i], this.valueArray[i]);
        }
        for (i = 0; i < 100; ++i) {
            WeakHashMapTest.assertTrue((String)"Incorrect value retrieved", (this.whm.get(this.keyArray[i]) == this.valueArray[i] ? 1 : 0) != 0);
        }
        WeakHashMap<String, String> empty = new WeakHashMap<String, String>(0);
        WeakHashMapTest.assertNull((String)"Empty weakhashmap access", empty.get("nothing"));
        empty.put("something", "here");
        WeakHashMapTest.assertTrue((String)"cannot get element", (empty.get("something") == "here" ? 1 : 0) != 0);
    }

    public void test_ConstructorIF() {
        int i;
        this.whm = new WeakHashMap(50, 0.5f);
        for (i = 0; i < 100; ++i) {
            this.whm.put(this.keyArray[i], this.valueArray[i]);
        }
        for (i = 0; i < 100; ++i) {
            WeakHashMapTest.assertTrue((String)"Incorrect value retrieved", (this.whm.get(this.keyArray[i]) == this.valueArray[i] ? 1 : 0) != 0);
        }
        WeakHashMap<String, String> empty = new WeakHashMap<String, String>(0, 0.75f);
        WeakHashMapTest.assertNull((String)"Empty hashtable access", empty.get("nothing"));
        empty.put("something", "here");
        WeakHashMapTest.assertTrue((String)"cannot get element", (empty.get("something") == "here" ? 1 : 0) != 0);
    }

    public void test_ConstructorLjava_util_Map() {
        MockMap mockMap = new MockMap();
        WeakHashMap map = new WeakHashMap(mockMap);
        WeakHashMapTest.assertEquals((String)"Size should be 0", (int)0, (int)map.size());
    }

    public void test_clear() {
        int i;
        this.whm = new WeakHashMap();
        for (i = 0; i < 100; ++i) {
            this.whm.put(this.keyArray[i], this.valueArray[i]);
        }
        this.whm.clear();
        WeakHashMapTest.assertTrue((String)"Cleared map should be empty", (boolean)this.whm.isEmpty());
        for (i = 0; i < 100; ++i) {
            WeakHashMapTest.assertNull((String)"Cleared map should only return null", this.whm.get(this.keyArray[i]));
        }
    }

    public void test_containsKeyLjava_lang_Object() {
        int i;
        this.whm = new WeakHashMap();
        for (i = 0; i < 100; ++i) {
            this.whm.put(this.keyArray[i], this.valueArray[i]);
        }
        for (i = 0; i < 100; ++i) {
            WeakHashMapTest.assertTrue((String)"Should contain referenced key", (boolean)this.whm.containsKey(this.keyArray[i]));
        }
        this.keyArray[25] = null;
        this.keyArray[50] = null;
    }

    public void test_containsValueLjava_lang_Object() {
        int i;
        this.whm = new WeakHashMap();
        for (i = 0; i < 100; ++i) {
            this.whm.put(this.keyArray[i], this.valueArray[i]);
        }
        for (i = 0; i < 100; ++i) {
            WeakHashMapTest.assertTrue((String)"Should contain referenced value", (boolean)this.whm.containsValue(this.valueArray[i]));
        }
        this.keyArray[25] = null;
        this.keyArray[50] = null;
    }

    public void test_entrySet() {
        WeakHashMap<Object, Object> weakMap = new WeakHashMap<Object, Object>();
        this.KEY_ARRAY = new Object[100];
        this.VALUE_ARRAY = new Object[100];
        for (int i = 0; i < 100; ++i) {
            this.KEY_ARRAY[i] = new Integer(i);
            this.VALUE_ARRAY[i] = new Long(i);
            weakMap.put(this.KEY_ARRAY[i], this.VALUE_ARRAY[i]);
        }
        List<Object> keys = Arrays.asList(this.KEY_ARRAY);
        List<Object> values = Arrays.asList(this.VALUE_ARRAY);
        Set entrySet = weakMap.entrySet();
        WeakHashMapTest.assertEquals((String)"Assert 0: Incorrect number of entries returned", (int)100, (int)entrySet.size());
        for (Map.Entry entry : entrySet) {
            WeakHashMapTest.assertTrue((String)"Assert 1: Invalid map entry key returned", (boolean)keys.contains(entry.getKey()));
            WeakHashMapTest.assertTrue((String)"Assert 2: Invalid map entry value returned", (boolean)values.contains(entry.getValue()));
            WeakHashMapTest.assertTrue((String)"Assert 3: Entry not in entry set", (boolean)entrySet.contains(entry));
        }
        values = null;
        keys = null;
        this.KEY_ARRAY[50] = null;
        int count = 0;
        do {
            System.gc();
            System.gc();
            Runtime.getRuntime().runFinalization();
        } while (++count <= 5 && entrySet.size() == 100);
        if (count == 5 && entrySet.size() == 100) {
            return;
        }
        WeakHashMapTest.assertEquals((String)"Assert 4: Incorrect number of entries after gc", (int)99, (int)entrySet.size());
        WeakHashMapTest.assertSame((String)"Assert 5: Entries not identical", entrySet.iterator().next(), entrySet.iterator().next());
        int size = entrySet.size();
        Iterator it = entrySet.iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
            --size;
            if (!it.hasNext()) continue;
            it.next();
        }
        WeakHashMapTest.assertEquals((String)"Assert 6: entry set count mismatch", (int)size, (int)entrySet.size());
        int entries = 0;
        it = entrySet.iterator();
        while (it.hasNext()) {
            it.next();
            ++entries;
        }
        WeakHashMapTest.assertEquals((String)"Assert 6: count mismatch", (int)size, (int)entries);
        it = entrySet.iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        WeakHashMapTest.assertEquals((String)"Assert 7: entry set not empty", (int)0, (int)entrySet.size());
        WeakHashMapTest.assertTrue((String)"Assert 8:  iterator not empty", (!entrySet.iterator().hasNext() ? 1 : 0) != 0);
    }

    public void test_entrySet_2() {
        this.whm = new WeakHashMap();
        for (int i = 0; i < 100; ++i) {
            this.whm.put(this.keyArray[i], this.valueArray[i]);
        }
        List<Object> keys = Arrays.asList(this.keyArray);
        List<Object> values = Arrays.asList(this.valueArray);
        Set entrySet = this.whm.entrySet();
        WeakHashMapTest.assertTrue((String)("Incorrect number of entries returned--wanted 100, got: " + entrySet.size()), (entrySet.size() == 100 ? 1 : 0) != 0);
        for (Map.Entry entry : entrySet) {
            WeakHashMapTest.assertTrue((String)"Invalid map entry returned--bad key", (boolean)keys.contains(entry.getKey()));
            WeakHashMapTest.assertTrue((String)"Invalid map entry returned--bad key", (boolean)values.contains(entry.getValue()));
        }
        keys = null;
        values = null;
        this.keyArray[50] = null;
        int count = 0;
        do {
            System.gc();
            System.gc();
            Runtime.getRuntime().runFinalization();
        } while (++count <= 5 && entrySet.size() == 100);
        WeakHashMapTest.assertTrue((String)("Incorrect number of entries returned after gc--wanted 99, got: " + entrySet.size()), (entrySet.size() == 99 ? 1 : 0) != 0);
    }

    public void test_getLjava_lang_Object() {
        WeakHashMapTest.assertTrue((String)"Used to test", (boolean)true);
    }

    public void test_isEmpty() {
        this.whm = new WeakHashMap();
        WeakHashMapTest.assertTrue((String)"New map should be empty", (boolean)this.whm.isEmpty());
        Object myObject = new Object();
        this.whm.put(myObject, myObject);
        WeakHashMapTest.assertTrue((String)"Map should not be empty", (!this.whm.isEmpty() ? 1 : 0) != 0);
        this.whm.remove(myObject);
        WeakHashMapTest.assertTrue((String)"Map with elements removed should be empty", (boolean)this.whm.isEmpty());
    }

    public void test_putLjava_lang_ObjectLjava_lang_Object() {
        WeakHashMap map = new WeakHashMap();
        map.put(null, "value");
        System.gc();
        System.runFinalization();
        map.remove("nothing");
        WeakHashMapTest.assertEquals((String)"null key was removed", (int)1, (int)map.size());
    }

    public void test_putAllLjava_util_Map() {
        MockMap mockMap = new MockMap();
        WeakHashMap map = new WeakHashMap();
        map.putAll(mockMap);
        WeakHashMapTest.assertEquals((String)"Size should be 0", (int)0, (int)map.size());
    }

    public void test_removeLjava_lang_Object() {
        this.whm = new WeakHashMap();
        for (int i = 0; i < 100; ++i) {
            this.whm.put(this.keyArray[i], this.valueArray[i]);
        }
        WeakHashMapTest.assertTrue((String)"Remove returned incorrect value", (this.whm.remove(this.keyArray[25]) == this.valueArray[25] ? 1 : 0) != 0);
        WeakHashMapTest.assertNull((String)"Remove returned incorrect value", this.whm.remove(this.keyArray[25]));
        WeakHashMapTest.assertEquals((String)"Size should be 99 after remove", (int)99, (int)this.whm.size());
    }

    public void test_size() {
        WeakHashMapTest.assertTrue((String)"Used to test", (boolean)true);
    }

    public void test_keySet() {
        this.whm = new WeakHashMap();
        for (int i = 0; i < 100; ++i) {
            this.whm.put(this.keyArray[i], this.valueArray[i]);
        }
        List<Object> keys = Arrays.asList(this.keyArray);
        List<Object> values = Arrays.asList(this.valueArray);
        Set keySet = this.whm.keySet();
        WeakHashMapTest.assertEquals((String)"Incorrect number of keys returned,", (int)100, (int)keySet.size());
        for (Object key : keySet) {
            WeakHashMapTest.assertTrue((String)"Invalid map entry returned--bad key", (boolean)keys.contains(key));
        }
        keys = null;
        values = null;
        this.keyArray[50] = null;
        int count = 0;
        do {
            System.gc();
            System.gc();
            Runtime.getRuntime().runFinalization();
        } while (++count <= 5 && keySet.size() == 100);
        WeakHashMapTest.assertEquals((String)"Incorrect number of keys returned after gc,", (int)99, (int)keySet.size());
    }

    public void test_keySet_hasNext() {
        WeakHashMap map = new WeakHashMap();
        ConstantHashClass cl = new ConstantHashClass(2);
        map.put(new ConstantHashClass(1), null);
        map.put(cl, null);
        map.put(new ConstantHashClass(3), null);
        Iterator iter = map.keySet().iterator();
        iter.next();
        iter.next();
        System.gc();
        WeakHashMapTest.assertFalse((String)"Wrong hasNext() value", (boolean)iter.hasNext());
    }

    public void test_values() {
        this.whm = new WeakHashMap();
        for (int i = 0; i < 100; ++i) {
            this.whm.put(this.keyArray[i], this.valueArray[i]);
        }
        List<Object> keys = Arrays.asList(this.keyArray);
        List<Object> values = Arrays.asList(this.valueArray);
        Collection valuesCollection = this.whm.values();
        WeakHashMapTest.assertEquals((String)"Incorrect number of keys returned,", (int)100, (int)valuesCollection.size());
        for (Object value : valuesCollection) {
            WeakHashMapTest.assertTrue((String)"Invalid map entry returned--bad value", (boolean)values.contains(value));
        }
        keys = null;
        values = null;
        this.keyArray[50] = null;
        int count = 0;
        do {
            System.gc();
            System.gc();
            Runtime.getRuntime().runFinalization();
        } while (++count <= 5 && valuesCollection.size() == 100);
        WeakHashMapTest.assertEquals((String)"Incorrect number of keys returned after gc,", (int)99, (int)valuesCollection.size());
    }

    protected void setUp() {
        for (int i = 0; i < 100; ++i) {
            this.keyArray[i] = new Object();
            this.valueArray[i] = new Object();
        }
    }

    protected void tearDown() {
    }

    static class ConstantHashClass {
        private int id = 0;

        public ConstantHashClass(int id) {
            this.id = id;
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "ConstantHashClass[id=" + this.id + "]";
        }
    }

    class MockMap
    extends AbstractMap {
        MockMap() {
        }

        public Set entrySet() {
            return null;
        }

        public int size() {
            return 0;
        }
    }
}

