/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.tests.java.util;

import java.io.Serializable;
import java.util.UnknownFormatFlagsException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.harmony.testframework.serialization.SerializationTest;

public class UnknownFormatFlagsExceptionTest
extends TestCase {
    private static final SerializationTest.SerializableAssert exComparator = new SerializationTest.SerializableAssert(){

        public void assertDeserialized(Serializable initial, Serializable deserialized) {
            SerializationTest.THROWABLE_COMPARATOR.assertDeserialized(initial, deserialized);
            UnknownFormatFlagsException initEx = (UnknownFormatFlagsException)initial;
            UnknownFormatFlagsException desrEx = (UnknownFormatFlagsException)deserialized;
            Assert.assertEquals((String)"Flags", (String)initEx.getFlags(), (String)desrEx.getFlags());
        }
    };

    public void test_unknownFormatFlagsException() {
        try {
            new UnknownFormatFlagsException(null);
            UnknownFormatFlagsExceptionTest.fail((String)"should throw NullPointerExcepiton");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void test_getFlags() {
        String s = "MYTESTSTRING";
        UnknownFormatFlagsException UnknownFormatFlagsException2 = new UnknownFormatFlagsException(s);
        UnknownFormatFlagsExceptionTest.assertEquals((String)s, (String)UnknownFormatFlagsException2.getFlags());
    }

    public void test_getMessage() {
        String s = "MYTESTSTRING";
        UnknownFormatFlagsException UnknownFormatFlagsException2 = new UnknownFormatFlagsException(s);
        UnknownFormatFlagsExceptionTest.assertNotNull((Object)UnknownFormatFlagsException2.getMessage());
    }

    public void testSerializationSelf() throws Exception {
        SerializationTest.verifySelf(new UnknownFormatFlagsException("MYTESTSTRING"), exComparator);
    }

    public void testSerializationCompatibility() throws Exception {
        SerializationTest.verifyGolden((TestCase)this, new UnknownFormatFlagsException("MYTESTSTRING"), exComparator);
    }
}

