/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.tests.java.util;

import java.util.UUID;
import junit.framework.TestCase;
import org.apache.harmony.testframework.serialization.SerializationTest;

public class UUIDTest
extends TestCase {
    public void test_ConstructorJJ() {
        UUID uuid = new UUID(-568210367123287600L, -6384696206158828554L);
        UUIDTest.assertEquals((int)2, (int)uuid.variant());
        UUIDTest.assertEquals((int)1, (int)uuid.version());
        UUIDTest.assertEquals((long)130742845922168750L, (long)uuid.timestamp());
        UUIDTest.assertEquals((long)130742845922168750L, (long)uuid.timestamp());
        UUIDTest.assertEquals((int)10085, (int)uuid.clockSequence());
        UUIDTest.assertEquals((long)690568981494L, (long)uuid.node());
    }

    public void test_getLeastSignificantBits() {
        UUID uuid = new UUID(0L, 0L);
        UUIDTest.assertEquals((long)0L, (long)uuid.getLeastSignificantBits());
        uuid = new UUID(0L, Long.MIN_VALUE);
        UUIDTest.assertEquals((long)Long.MIN_VALUE, (long)uuid.getLeastSignificantBits());
        uuid = new UUID(0L, Long.MAX_VALUE);
        UUIDTest.assertEquals((long)Long.MAX_VALUE, (long)uuid.getLeastSignificantBits());
    }

    public void test_getMostSignificantBits() {
        UUID uuid = new UUID(0L, 0L);
        UUIDTest.assertEquals((long)0L, (long)uuid.getMostSignificantBits());
        uuid = new UUID(Long.MIN_VALUE, 0L);
        UUIDTest.assertEquals((long)Long.MIN_VALUE, (long)uuid.getMostSignificantBits());
        uuid = new UUID(Long.MAX_VALUE, 0L);
        UUIDTest.assertEquals((long)Long.MAX_VALUE, (long)uuid.getMostSignificantBits());
    }

    public void test_version() {
        UUID uuid = new UUID(0L, 0L);
        UUIDTest.assertEquals((int)0, (int)uuid.version());
        uuid = new UUID(4096L, 0L);
        UUIDTest.assertEquals((int)1, (int)uuid.version());
        uuid = new UUID(8192L, 0L);
        UUIDTest.assertEquals((int)2, (int)uuid.version());
        uuid = new UUID(12288L, 0L);
        UUIDTest.assertEquals((int)3, (int)uuid.version());
        uuid = new UUID(16384L, 0L);
        UUIDTest.assertEquals((int)4, (int)uuid.version());
        uuid = new UUID(20480L, 0L);
        UUIDTest.assertEquals((int)5, (int)uuid.version());
    }

    public void test_variant() {
        UUID uuid = new UUID(0L, 0L);
        UUIDTest.assertEquals((int)0, (int)uuid.variant());
        uuid = new UUID(0L, 0x7000000000000000L);
        UUIDTest.assertEquals((int)0, (int)uuid.variant());
        uuid = new UUID(0L, 0x3000000000000000L);
        UUIDTest.assertEquals((int)0, (int)uuid.variant());
        uuid = new UUID(0L, 0x1000000000000000L);
        UUIDTest.assertEquals((int)0, (int)uuid.variant());
        uuid = new UUID(0L, Long.MIN_VALUE);
        UUIDTest.assertEquals((int)2, (int)uuid.variant());
        uuid = new UUID(0L, -5764607523034234880L);
        UUIDTest.assertEquals((int)2, (int)uuid.variant());
        uuid = new UUID(0L, -6917529027641081856L);
        UUIDTest.assertEquals((int)2, (int)uuid.variant());
        uuid = new UUID(0L, -8070450532247928832L);
        UUIDTest.assertEquals((int)2, (int)uuid.variant());
        uuid = new UUID(0L, -4611686018427387904L);
        UUIDTest.assertEquals((int)6, (int)uuid.variant());
        uuid = new UUID(0L, -3458764513820540928L);
        UUIDTest.assertEquals((int)6, (int)uuid.variant());
        uuid = new UUID(0L, -2305843009213693952L);
        UUIDTest.assertEquals((int)7, (int)uuid.variant());
        uuid = new UUID(0L, -1152921504606846976L);
        UUIDTest.assertEquals((int)7, (int)uuid.variant());
    }

    public void test_timestamp() {
        UUID uuid = new UUID(4096L, Long.MIN_VALUE);
        UUIDTest.assertEquals((long)0L, (long)uuid.timestamp());
        uuid = new UUID(8608480567158444851L, Long.MIN_VALUE);
        UUIDTest.assertEquals((long)0x333555577777777L, (long)uuid.timestamp());
        uuid = new UUID(0L, Long.MIN_VALUE);
        try {
            uuid.timestamp();
            UUIDTest.fail((String)"No UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        uuid = new UUID(8192L, Long.MIN_VALUE);
        try {
            uuid.timestamp();
            UUIDTest.fail((String)"No UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void test_clockSequence() {
        UUID uuid = new UUID(4096L, Long.MIN_VALUE);
        UUIDTest.assertEquals((int)0, (int)uuid.clockSequence());
        uuid = new UUID(4096L, -8070732007224639488L);
        UUIDTest.assertEquals((int)4095, (int)uuid.clockSequence());
        uuid = new UUID(4096L, -4611967493404098560L);
        UUIDTest.assertEquals((int)16383, (int)uuid.clockSequence());
        uuid = new UUID(0L, Long.MIN_VALUE);
        try {
            uuid.clockSequence();
            UUIDTest.fail((String)"No UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        uuid = new UUID(8192L, Long.MIN_VALUE);
        try {
            uuid.clockSequence();
            UUIDTest.fail((String)"No UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void test_node() {
        UUID uuid = new UUID(4096L, Long.MIN_VALUE);
        UUIDTest.assertEquals((long)0L, (long)uuid.node());
        uuid = new UUID(4096L, -9223090561878065153L);
        UUIDTest.assertEquals((long)0xFFFFFFFFFFFFL, (long)uuid.node());
        uuid = new UUID(0L, Long.MIN_VALUE);
        try {
            uuid.node();
            UUIDTest.fail((String)"No UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        uuid = new UUID(8192L, Long.MIN_VALUE);
        try {
            uuid.node();
            UUIDTest.fail((String)"No UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void test_compareTo() {
        UUID uuid1 = new UUID(0L, 0L);
        UUIDTest.assertEquals((int)0, (int)uuid1.compareTo(uuid1));
        UUID uuid2 = new UUID(1L, 0L);
        UUIDTest.assertEquals((int)-1, (int)uuid1.compareTo(uuid2));
        UUIDTest.assertEquals((int)1, (int)uuid2.compareTo(uuid1));
        uuid2 = new UUID(0L, 1L);
        UUIDTest.assertEquals((int)-1, (int)uuid1.compareTo(uuid2));
        UUIDTest.assertEquals((int)1, (int)uuid2.compareTo(uuid1));
    }

    public void test_hashCode() {
        UUID uuid = new UUID(0L, 0L);
        UUIDTest.assertEquals((int)0, (int)uuid.hashCode());
        uuid = new UUID(123L, 123L);
        UUID uuidClone = new UUID(123L, 123L);
        UUIDTest.assertEquals((int)uuid.hashCode(), (int)uuidClone.hashCode());
    }

    public void test_equalsObject() {
        UUID uuid1 = new UUID(0L, 0L);
        UUIDTest.assertEquals((Object)uuid1, (Object)uuid1);
        UUIDTest.assertFalse((boolean)uuid1.equals(null));
        UUIDTest.assertFalse((boolean)uuid1.equals("NOT A UUID"));
        UUID uuid2 = new UUID(0L, 0L);
        UUIDTest.assertEquals((Object)uuid1, (Object)uuid2);
        UUIDTest.assertEquals((Object)uuid2, (Object)uuid1);
        uuid1 = new UUID(-568210367123287600L, -6384696206158828554L);
        uuid2 = new UUID(-568210367123287600L, -6384696206158828554L);
        UUIDTest.assertEquals((Object)uuid1, (Object)uuid2);
        UUIDTest.assertEquals((Object)uuid2, (Object)uuid1);
        uuid2 = new UUID(-568210367123287600L, -6384696206158828553L);
        UUIDTest.assertFalse((boolean)uuid1.equals(uuid2));
        UUIDTest.assertFalse((boolean)uuid2.equals(uuid1));
    }

    public void test_toString() {
        UUID uuid = new UUID(-568210367123287600L, -6384696206158828554L);
        String actual = uuid.toString();
        UUIDTest.assertEquals((String)"f81d4fae-7dec-11d0-a765-00a0c91e6bf6", (String)actual);
        uuid = new UUID(4096L, Long.MIN_VALUE);
        actual = uuid.toString();
        UUIDTest.assertEquals((String)"00000000-0000-1000-8000-000000000000", (String)actual);
    }

    public void testSerializationSelf() throws Exception {
        SerializationTest.verifySelf(new UUID(-568210367123287600L, -6384696206158828554L));
    }

    public void testSerializationCompatibility() throws Exception {
        SerializationTest.verifyGolden((TestCase)this, new UUID(-568210367123287600L, -6384696206158828554L));
    }

    public void test_randomUUID() {
        UUID uuid = UUID.randomUUID();
        UUIDTest.assertEquals((int)2, (int)uuid.variant());
        UUIDTest.assertEquals((int)4, (int)uuid.version());
    }

    public void test_nameUUIDFromBytes() throws Exception {
        byte[] name = new byte[]{107, -89, -72, 17, -99, -83, 17, -47, -128, -76, 0, -64, 79, -44, 48, -56};
        UUID uuid = UUID.nameUUIDFromBytes(name);
        UUIDTest.assertEquals((int)2, (int)uuid.variant());
        UUIDTest.assertEquals((int)3, (int)uuid.version());
        UUIDTest.assertEquals((long)-5767591888853461179L, (long)uuid.getLeastSignificantBits());
        UUIDTest.assertEquals((long)1499058437454118826L, (long)uuid.getMostSignificantBits());
        uuid = UUID.nameUUIDFromBytes(new byte[0]);
        UUIDTest.assertEquals((int)2, (int)uuid.variant());
        UUIDTest.assertEquals((int)3, (int)uuid.version());
        UUIDTest.assertEquals((long)-6232971331865394562L, (long)uuid.getLeastSignificantBits());
        UUIDTest.assertEquals((long)-3162216497309273596L, (long)uuid.getMostSignificantBits());
        try {
            UUID.nameUUIDFromBytes(null);
            UUIDTest.fail((String)"No NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void test_fromString() {
        UUID actual = UUID.fromString("f81d4fae-7dec-11d0-a765-00a0c91e6bf6");
        UUID expected = new UUID(-568210367123287600L, -6384696206158828554L);
        UUIDTest.assertEquals((Object)expected, (Object)actual);
        UUIDTest.assertEquals((int)2, (int)actual.variant());
        UUIDTest.assertEquals((int)1, (int)actual.version());
        UUIDTest.assertEquals((long)130742845922168750L, (long)actual.timestamp());
        UUIDTest.assertEquals((int)10085, (int)actual.clockSequence());
        UUIDTest.assertEquals((long)690568981494L, (long)actual.node());
        actual = UUID.fromString("00000000-0000-1000-8000-000000000000");
        expected = new UUID(4096L, Long.MIN_VALUE);
        UUIDTest.assertEquals((Object)expected, (Object)actual);
        UUIDTest.assertEquals((int)2, (int)actual.variant());
        UUIDTest.assertEquals((int)1, (int)actual.version());
        UUIDTest.assertEquals((long)0L, (long)actual.timestamp());
        UUIDTest.assertEquals((int)0, (int)actual.clockSequence());
        UUIDTest.assertEquals((long)0L, (long)actual.node());
        try {
            UUID.fromString(null);
            UUIDTest.fail((String)"No NPE");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            UUID.fromString("");
            UUIDTest.fail((String)"No IAE");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            UUID.fromString("f81d4fae_7dec-11d0-a765-00a0c91e6bf6");
            UUIDTest.fail((String)"No IAE");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            UUID.fromString("f81d4fae-7dec_11d0-a765-00a0c91e6bf6");
            UUIDTest.fail((String)"No IAE");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            UUID.fromString("f81d4fae-7dec-11d0_a765-00a0c91e6bf6");
            UUIDTest.fail((String)"No IAE");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            UUID.fromString("f81d4fae-7dec-11d0-a765_00a0c91e6bf6");
            UUIDTest.fail((String)"No IAE");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_fromString_LString_Exception() {
        UUID uuid = UUID.fromString("0-0-0-0-0");
        try {
            uuid = UUID.fromString("0-0-0-0-");
            UUIDTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            uuid = UUID.fromString("-0-0-0-0-0");
            UUIDTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            uuid = UUID.fromString("-0-0-0-0");
            UUIDTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            uuid = UUID.fromString("-0-0-0-");
            UUIDTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            uuid = UUID.fromString("0--0-0-0");
            UUIDTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            uuid = UUID.fromString("0-0-0-0-");
            UUIDTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            uuid = UUID.fromString("-1-0-0-0-0");
            UUIDTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        uuid = UUID.fromString("123456789-0-0-0-0");
        UUIDTest.assertEquals((long)2541551402828693504L, (long)uuid.getMostSignificantBits());
        UUIDTest.assertEquals((long)0L, (long)uuid.getLeastSignificantBits());
        uuid = UUID.fromString("111123456789-0-0-0-0");
        UUIDTest.assertEquals((long)2541551402828693504L, (long)uuid.getMostSignificantBits());
        UUIDTest.assertEquals((long)0L, (long)uuid.getLeastSignificantBits());
        uuid = UUID.fromString("7fffffffffffffff-0-0-0-0");
        UUIDTest.assertEquals((long)-4294967296L, (long)uuid.getMostSignificantBits());
        UUIDTest.assertEquals((long)0L, (long)uuid.getLeastSignificantBits());
        try {
            uuid = UUID.fromString("8000000000000000-0-0-0-0");
            UUIDTest.fail((String)"should throw NumberFormatException");
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        uuid = UUID.fromString("7fffffffffffffff-7fffffffffffffff-7fffffffffffffff-0-0");
        UUIDTest.assertEquals((long)-1L, (long)uuid.getMostSignificantBits());
        UUIDTest.assertEquals((long)0L, (long)uuid.getLeastSignificantBits());
        uuid = UUID.fromString("0-0-0-7fffffffffffffff-7fffffffffffffff");
        UUIDTest.assertEquals((long)0L, (long)uuid.getMostSignificantBits());
        UUIDTest.assertEquals((long)-1L, (long)uuid.getLeastSignificantBits());
        try {
            uuid = UUID.fromString("0-0-0-8000000000000000-0");
            UUIDTest.fail((String)"should throw NumberFormatException");
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            uuid = UUID.fromString("0-0-0-0-8000000000000000");
            UUIDTest.fail((String)"should throw NumberFormatException");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

