/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.tests.java.util;

import java.io.Serializable;
import java.util.MissingFormatWidthException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.harmony.testframework.serialization.SerializationTest;

public class MissingFormatWidthExceptionTest
extends TestCase {
    private static final SerializationTest.SerializableAssert exComparator = new SerializationTest.SerializableAssert(){

        public void assertDeserialized(Serializable initial, Serializable deserialized) {
            SerializationTest.THROWABLE_COMPARATOR.assertDeserialized(initial, deserialized);
            MissingFormatWidthException initEx = (MissingFormatWidthException)initial;
            MissingFormatWidthException desrEx = (MissingFormatWidthException)deserialized;
            Assert.assertEquals((String)"FormatSpecifier", (String)initEx.getFormatSpecifier(), (String)desrEx.getFormatSpecifier());
        }
    };

    public void test_missingFormatWidthException() {
        try {
            new MissingFormatWidthException(null);
            MissingFormatWidthExceptionTest.fail((String)"should throw NullPointerExcepiton");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void test_getFormatSpecifier() {
        String s = "MYTESTSTRING";
        MissingFormatWidthException missingFormatWidthException = new MissingFormatWidthException(s);
        MissingFormatWidthExceptionTest.assertEquals((String)s, (String)missingFormatWidthException.getFormatSpecifier());
    }

    public void test_getMessage() {
        String s = "MYTESTSTRING";
        MissingFormatWidthException missingFormatWidthException = new MissingFormatWidthException(s);
        MissingFormatWidthExceptionTest.assertTrue((null != missingFormatWidthException.getMessage() ? 1 : 0) != 0);
    }

    public void testSerializationSelf() throws Exception {
        SerializationTest.verifySelf(new MissingFormatWidthException("MYTESTSTRING"), exComparator);
    }

    public void testSerializationCompatibility() throws Exception {
        SerializationTest.verifyGolden((TestCase)this, new MissingFormatWidthException("MYTESTSTRING"), exComparator);
    }
}

