/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.tests.java.util;

import java.io.Serializable;
import java.util.MissingFormatArgumentException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.harmony.testframework.serialization.SerializationTest;

public class MissingFormatArgumentExceptionTest
extends TestCase {
    private static final SerializationTest.SerializableAssert exComparator = new SerializationTest.SerializableAssert(){

        public void assertDeserialized(Serializable initial, Serializable deserialized) {
            SerializationTest.THROWABLE_COMPARATOR.assertDeserialized(initial, deserialized);
            MissingFormatArgumentException initEx = (MissingFormatArgumentException)initial;
            MissingFormatArgumentException desrEx = (MissingFormatArgumentException)deserialized;
            Assert.assertEquals((String)"FormatSpecifier", (String)initEx.getFormatSpecifier(), (String)desrEx.getFormatSpecifier());
        }
    };

    public void test_missingFormatArgumentException() {
        try {
            new MissingFormatArgumentException(null);
            MissingFormatArgumentExceptionTest.fail((String)"should throw NullPointerExcepiton.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void test_getFormatSpecifier() {
        String s = "MYTESTSTRING";
        MissingFormatArgumentException missingFormatArgumentException = new MissingFormatArgumentException(s);
        MissingFormatArgumentExceptionTest.assertEquals((String)s, (String)missingFormatArgumentException.getFormatSpecifier());
    }

    public void test_getMessage() {
        String s = "MYTESTSTRING";
        MissingFormatArgumentException missingFormatArgumentException = new MissingFormatArgumentException(s);
        MissingFormatArgumentExceptionTest.assertTrue((null != missingFormatArgumentException.getMessage() ? 1 : 0) != 0);
    }

    public void testSerializationSelf() throws Exception {
        SerializationTest.verifySelf(new MissingFormatArgumentException("MYTESTSTRING"), exComparator);
    }

    public void testSerializationCompatibility() throws Exception {
        SerializationTest.verifyGolden((TestCase)this, new MissingFormatArgumentException("MYTESTSTRING"), exComparator);
    }
}

