/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.tests.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.TestCase;

@TestTargetClass(value=Map.Entry.class)
public class MapEntryTest
extends TestCase {
    Map.Entry me = null;
    HashMap hm = null;
    Iterator i = null;

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getKey", args={})
    public void testGetKey() {
        MapEntryTest.assertTrue((boolean)this.hm.containsKey(this.me.getKey()));
        this.hm.clear();
        try {
            this.me.getKey();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="getValue", args={})
    public void testGetValue() {
        MapEntryTest.assertTrue((boolean)this.hm.containsValue(this.me.getValue()));
        this.hm.clear();
        try {
            this.me.getValue();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="RI does not throw following exceptions: UnsupportedOperationException,ClassCastException, IllegalArgumentException and NullPointerException", method="setValue", args={Object.class})
    public void testSetValue() {
        Mock_HashMap mhm = new Mock_HashMap();
        mhm.fakePut(new Integer(1), "One");
        mhm.fakePut(new Integer(2), "Two");
        this.i = mhm.entrySet().iterator();
        this.me = (Map.Entry)this.i.next();
        this.me.setValue("Wrong element");
        this.hm.clear();
        try {
            this.me.setValue("");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="equals", args={Object.class})
    public void testEquals() {
        Map.Entry me1 = (Map.Entry)this.i.next();
        MapEntryTest.assertFalse((boolean)((Object)this.me).equals(me1));
        MapEntryTest.assertFalse((boolean)((Object)this.me).equals((Object)this));
        me1 = this.me;
        MapEntryTest.assertTrue((boolean)((Object)this.me).equals(me1));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hashCode", args={})
    public void testHashCode() {
        Map.Entry me1 = (Map.Entry)this.i.next();
        MapEntryTest.assertTrue((((Object)this.me).hashCode() != ((Object)me1).hashCode() ? 1 : 0) != 0);
    }

    protected void setUp() throws Exception {
        this.hm = new HashMap();
        this.hm.put(new Integer(1), "one");
        this.hm.put(new Integer(2), "two");
        this.i = this.hm.entrySet().iterator();
        this.me = (Map.Entry)this.i.next();
        super.setUp();
    }

    class Mock_HashMap
    extends HashMap {
        Mock_HashMap() {
        }

        public Object put(Object key, Object val) {
            if (val == null) {
                throw new NullPointerException();
            }
            if (val.getClass() == Double.class) {
                throw new ClassCastException();
            }
            if (((String)val).equals("Wrong element")) {
                throw new IllegalArgumentException();
            }
            throw new UnsupportedOperationException();
        }

        public Object fakePut(Object key, Object val) {
            return super.put(key, val);
        }
    }
}

