/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.tests.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;

@TestTargetClass(value=ListIterator.class)
public class ListIteratorTest
extends TestCase {
    ListIterator<Integer> l = null;
    static Object[] objArray;

    public ListIteratorTest() {
        objArray = new Object[100];
        for (int i = 0; i < objArray.length; ++i) {
            ListIteratorTest.objArray[i] = new Integer(i);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hasNext", args={})
    public void testHasNext() {
        for (int i = 0; i < objArray.length; ++i) {
            ListIteratorTest.assertTrue((boolean)this.l.hasNext());
            this.l.next();
        }
        ListIteratorTest.assertFalse((boolean)this.l.hasNext());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="next", args={})
    public void testNext() {
        for (int i = 0; i < objArray.length; ++i) {
            ListIteratorTest.assertTrue((boolean)objArray[i].equals(this.l.next()));
        }
        try {
            this.l.next();
            ListIteratorTest.fail((String)"NoSuchElementException expected");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="remove", args={})
    public void testRemove() {
        try {
            this.l.remove();
            ListIteratorTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        for (int i = 0; i < objArray.length; ++i) {
            this.l.next();
            this.l.remove();
            ListIteratorTest.assertFalse((boolean)this.l.hasPrevious());
        }
        try {
            this.l.remove();
            ListIteratorTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        Mock_ListIterator ml = new Mock_ListIterator();
        try {
            ml.remove();
            ListIteratorTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hasPrevious", args={})
    public void testHasPrevious() {
        ListIteratorTest.assertFalse((boolean)this.l.hasPrevious());
        for (int i = 0; i < objArray.length; ++i) {
            this.l.next();
            ListIteratorTest.assertTrue((boolean)this.l.hasPrevious());
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="previous", args={})
    public void testPrevious() {
        try {
            this.l.previous();
            ListIteratorTest.fail((String)"NoSuchElementException expected");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        while (this.l.hasNext()) {
            this.l.next();
        }
        for (int i = objArray.length - 1; i > -1; --i) {
            ListIteratorTest.assertTrue((boolean)objArray[i].equals(this.l.previous()));
        }
        try {
            this.l.previous();
            ListIteratorTest.fail((String)"NoSuchElementException expected");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="nextIndex", args={})
    public void testNextIndex() {
        for (int i = 0; i < objArray.length; ++i) {
            ListIteratorTest.assertTrue((boolean)objArray[i].equals(this.l.nextIndex()));
            this.l.next();
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="previousIndex", args={})
    public void testPreviousIndex() {
        for (int i = 0; i < objArray.length; ++i) {
            ListIteratorTest.assertTrue((boolean)objArray[i].equals(this.l.previousIndex() + 1));
            this.l.next();
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="set", args={Object.class})
    public void testSet() {
        try {
            this.l.set(new Integer(1));
            ListIteratorTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        for (int i = 0; i < objArray.length; ++i) {
            this.l.next();
            this.l.set((Integer)objArray[objArray.length - i - 1]);
        }
        this.l.remove();
        try {
            this.l.set(new Integer(1));
            ListIteratorTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        Mock_ListIterator ml = new Mock_ListIterator();
        ml.next();
        try {
            ml.set("Wrong element");
            ListIteratorTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            ml.set(new Double("3.14"));
            ListIteratorTest.fail((String)"ClassCastException expected");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        try {
            ml.set("");
            ListIteratorTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="add", args={Object.class})
    public void testAdd() {
        this.l.add(new Integer(33));
        Mock_ListIterator ml = new Mock_ListIterator();
        ml.next();
        try {
            ml.add("Wrong element");
            ListIteratorTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            ml.add(new Double("3.14"));
            ListIteratorTest.fail((String)"ClassCastException expected");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        try {
            ml.add("");
            ListIteratorTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        LinkedList<Object> ll = new LinkedList<Object>();
        for (int i = 0; i < objArray.length; ++i) {
            ll.add(objArray[i]);
        }
        this.l = ll.listIterator();
    }

    class Mock_ListIterator
    implements ListIterator {
        Mock_ListIterator() {
        }

        public void add(Object o) {
            if (((String)o).equals("Wrong element")) {
                throw new IllegalArgumentException();
            }
            if (o.getClass() == Double.class) {
                throw new ClassCastException();
            }
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return false;
        }

        public boolean hasPrevious() {
            return false;
        }

        public Object next() {
            return null;
        }

        public int nextIndex() {
            return 0;
        }

        public Object previous() {
            return null;
        }

        public int previousIndex() {
            return 0;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object o) {
            if (((String)o).equals("Wrong element")) {
                throw new IllegalArgumentException();
            }
            if (o.getClass() == Double.class) {
                throw new ClassCastException();
            }
            throw new UnsupportedOperationException();
        }
    }
}

