/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.tests.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import junit.framework.TestCase;
import tests.support.Support_MapTest2;
import tests.support.Support_UnmodifiableCollectionTest;

@TestTargetClass(value=LinkedHashMap.class)
public class LinkedHashMapTest
extends TestCase {
    LinkedHashMap hm;
    static final int hmSize = 1000;
    static Object[] objArray;
    static Object[] objArray2;

    public LinkedHashMapTest() {
        objArray = new Object[1000];
        objArray2 = new Object[1000];
        for (int i = 0; i < objArray.length; ++i) {
            LinkedHashMapTest.objArray[i] = new Integer(i);
            LinkedHashMapTest.objArray2[i] = objArray[i].toString();
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="LinkedHashMap", args={})
    public void test_Constructor() {
        new Support_MapTest2(new LinkedHashMap<String, String>()).runTest();
        LinkedHashMap hm2 = new LinkedHashMap();
        LinkedHashMapTest.assertEquals((String)"Created incorrect LinkedHashMap", (int)0, (int)hm2.size());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="LinkedHashMap", args={int.class})
    public void test_ConstructorI() {
        LinkedHashMap hm2 = new LinkedHashMap(5);
        LinkedHashMapTest.assertEquals((String)"Created incorrect LinkedHashMap", (int)0, (int)hm2.size());
        try {
            new LinkedHashMap(-1);
            LinkedHashMapTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        LinkedHashMap<String, String> empty = new LinkedHashMap<String, String>(0);
        LinkedHashMapTest.assertNull((String)"Empty LinkedHashMap access", empty.get("nothing"));
        empty.put("something", "here");
        LinkedHashMapTest.assertTrue((String)"cannot get element", (empty.get("something") == "here" ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="LinkedHashMap", args={int.class, float.class})
    public void test_ConstructorIF() {
        LinkedHashMap hm2 = new LinkedHashMap(5, 0.5f);
        LinkedHashMapTest.assertEquals((String)"Created incorrect LinkedHashMap", (int)0, (int)hm2.size());
        try {
            new LinkedHashMap(0, 0.0f);
            LinkedHashMapTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        LinkedHashMap<String, String> empty = new LinkedHashMap<String, String>(0, 0.75f);
        LinkedHashMapTest.assertNull((String)"Empty hashtable access", empty.get("nothing"));
        empty.put("something", "here");
        LinkedHashMapTest.assertTrue((String)"cannot get element", (empty.get("something") == "here" ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="LinkedHashMap", args={Map.class})
    public void test_ConstructorLjava_util_Map() {
        TreeMap<Object, Object> myMap = new TreeMap<Object, Object>();
        for (int counter = 0; counter < 1000; ++counter) {
            myMap.put(objArray2[counter], objArray[counter]);
        }
        LinkedHashMap hm2 = new LinkedHashMap(myMap);
        for (int counter = 0; counter < 1000; ++counter) {
            LinkedHashMapTest.assertTrue((String)"Failed to construct correct LinkedHashMap", (this.hm.get(objArray2[counter]) == hm2.get(objArray2[counter]) ? 1 : 0) != 0);
        }
        try {
            new LinkedHashMap(null);
            LinkedHashMapTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="get", args={Object.class})
    public void test_getLjava_lang_Object() {
        LinkedHashMapTest.assertNull((String)"Get returned non-null for non existent key", this.hm.get("T"));
        this.hm.put("T", "HELLO");
        LinkedHashMapTest.assertEquals((String)"Get returned incorecct value for existing key", (Object)"HELLO", this.hm.get("T"));
        LinkedHashMap m = new LinkedHashMap();
        m.put(null, "test");
        LinkedHashMapTest.assertEquals((String)"Failed with null key", (Object)"test", m.get(null));
        LinkedHashMapTest.assertNull((String)"Failed with missing key matching null hash", m.get(new Integer(0)));
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="", method="put", args={Object.class, Object.class})
    public void test_putLjava_lang_ObjectLjava_lang_Object() {
        this.hm.put("KEY", "VALUE");
        LinkedHashMapTest.assertEquals((String)"Failed to install key/value pair", (Object)"VALUE", this.hm.get("KEY"));
        LinkedHashMap<Number, String> m = new LinkedHashMap<Number, String>();
        m.put(new Short(0), "short");
        m.put(null, "test");
        m.put(new Integer(0), "int");
        LinkedHashMapTest.assertEquals((String)"Failed adding to bucket containing null", (Object)"short", m.get(new Short(0)));
        LinkedHashMapTest.assertEquals((String)"Failed adding to bucket containing null2", (Object)"int", m.get(new Integer(0)));
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies only positive functionality.", method="putAll", args={Map.class})
    public void test_putAllLjava_util_Map() {
        LinkedHashMap hm2 = new LinkedHashMap();
        hm2.putAll(this.hm);
        for (int i = 0; i < 1000; ++i) {
            LinkedHashMapTest.assertTrue((String)"Failed to clear all elements", (boolean)hm2.get(new Integer(i).toString()).equals(new Integer(i)));
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies NullPointerException.", method="putAll", args={Map.class})
    public void test_putAll_Ljava_util_Map_Null() {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        try {
            linkedHashMap.putAll(new MockMapNull());
            LinkedHashMapTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            linkedHashMap = new LinkedHashMap(new MockMapNull());
            LinkedHashMapTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="entrySet", args={})
    public void test_entrySet() {
        Set s = this.hm.entrySet();
        Iterator i = s.iterator();
        LinkedHashMapTest.assertTrue((String)"Returned set of incorrect size", (this.hm.size() == s.size() ? 1 : 0) != 0);
        while (i.hasNext()) {
            Map.Entry m = i.next();
            LinkedHashMapTest.assertTrue((String)"Returned incorrect entry set", (this.hm.containsKey(m.getKey()) && this.hm.containsValue(m.getValue()) ? 1 : 0) != 0);
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="keySet", args={})
    public void test_keySet() {
        Set s = this.hm.keySet();
        LinkedHashMapTest.assertTrue((String)"Returned set of incorrect size()", (s.size() == this.hm.size() ? 1 : 0) != 0);
        for (int i = 0; i < objArray.length; ++i) {
            LinkedHashMapTest.assertTrue((String)"Returned set does not contain all keys", (boolean)s.contains(objArray[i].toString()));
        }
        LinkedHashMap m = new LinkedHashMap();
        m.put(null, "test");
        LinkedHashMapTest.assertTrue((String)"Failed with null key", (boolean)m.keySet().contains(null));
        LinkedHashMapTest.assertNull((String)"Failed with null key", m.keySet().iterator().next());
        LinkedHashMap<Integer, String> map = new LinkedHashMap<Integer, String>(101);
        map.put(new Integer(1), "1");
        map.put(new Integer(102), "102");
        map.put(new Integer(203), "203");
        Iterator it = map.keySet().iterator();
        Integer remove1 = (Integer)it.next();
        it.hasNext();
        it.remove();
        Integer remove2 = (Integer)it.next();
        it.remove();
        ArrayList<Integer> list = new ArrayList<Integer>(Arrays.asList(new Integer(1), new Integer(102), new Integer(203)));
        list.remove(remove1);
        list.remove(remove2);
        LinkedHashMapTest.assertTrue((String)"Wrong result", (boolean)it.next().equals(list.get(0)));
        LinkedHashMapTest.assertEquals((String)"Wrong size", (int)1, (int)map.size());
        LinkedHashMapTest.assertTrue((String)"Wrong contents", (boolean)map.keySet().iterator().next().equals(list.get(0)));
        LinkedHashMap<Integer, String> map2 = new LinkedHashMap<Integer, String>(101);
        map2.put(new Integer(1), "1");
        map2.put(new Integer(4), "4");
        Iterator it2 = map2.keySet().iterator();
        Integer remove3 = (Integer)it2.next();
        Integer next = remove3 == 1 ? new Integer(4) : new Integer(1);
        it2.hasNext();
        it2.remove();
        LinkedHashMapTest.assertTrue((String)"Wrong result 2", (boolean)it2.next().equals(next));
        LinkedHashMapTest.assertEquals((String)"Wrong size 2", (int)1, (int)map2.size());
        LinkedHashMapTest.assertTrue((String)"Wrong contents 2", (boolean)map2.keySet().iterator().next().equals(next));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="values", args={})
    public void test_values() {
        Collection c = this.hm.values();
        LinkedHashMapTest.assertTrue((String)"Returned collection of incorrect size()", (c.size() == this.hm.size() ? 1 : 0) != 0);
        for (int i = 0; i < objArray.length; ++i) {
            LinkedHashMapTest.assertTrue((String)"Returned collection does not contain all keys", (boolean)c.contains(objArray[i]));
        }
        LinkedHashMap<Object, Object> myLinkedHashMap = new LinkedHashMap<Object, Object>();
        for (int i = 0; i < 100; ++i) {
            myLinkedHashMap.put(objArray2[i], objArray[i]);
        }
        Collection<Integer> values = myLinkedHashMap.values();
        new Support_UnmodifiableCollectionTest("Test Returned Collection From LinkedHashMap.values()", values).runTest();
        values.remove(new Integer(0));
        LinkedHashMapTest.assertTrue((String)"Removing from the values collection should remove from the original map", (!myLinkedHashMap.containsValue(new Integer(0)) ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="remove", args={Object.class})
    public void test_removeLjava_lang_Object() {
        int size = this.hm.size();
        Integer y = new Integer(9);
        Integer x = (Integer)this.hm.remove(y.toString());
        LinkedHashMapTest.assertTrue((String)"Remove returned incorrect value", (boolean)x.equals(new Integer(9)));
        LinkedHashMapTest.assertNull((String)"Failed to remove given key", this.hm.get(new Integer(9)));
        LinkedHashMapTest.assertTrue((String)"Failed to decrement size", (this.hm.size() == size - 1 ? 1 : 0) != 0);
        LinkedHashMapTest.assertNull((String)"Remove of non-existent key returned non-null", this.hm.remove("LCLCLC"));
        LinkedHashMap m = new LinkedHashMap();
        m.put(null, "test");
        LinkedHashMapTest.assertNull((String)"Failed with same hash as null", m.remove(new Integer(0)));
        LinkedHashMapTest.assertEquals((String)"Failed with null key", (Object)"test", m.remove(null));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clear", args={})
    public void test_clear() {
        this.hm.clear();
        LinkedHashMapTest.assertEquals((String)"Clear failed to reset size", (int)0, (int)this.hm.size());
        for (int i = 0; i < 1000; ++i) {
            LinkedHashMapTest.assertNull((String)"Failed to clear all elements", this.hm.get(objArray2[i]));
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="clone", args={})
    public void test_clone() {
        LinkedHashMap hm2 = (LinkedHashMap)this.hm.clone();
        LinkedHashMapTest.assertTrue((String)"Clone answered equivalent LinkedHashMap", (hm2 != this.hm ? 1 : 0) != 0);
        for (int counter = 0; counter < 1000; ++counter) {
            LinkedHashMapTest.assertTrue((String)"Clone answered unequal LinkedHashMap", (this.hm.get(objArray2[counter]) == hm2.get(objArray2[counter]) ? 1 : 0) != 0);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("key", "value");
        Set keys = map.keySet();
        Collection values = map.values();
        LinkedHashMapTest.assertEquals((String)"values() does not work", (Object)"value", values.iterator().next());
        LinkedHashMapTest.assertEquals((String)"keySet() does not work", (Object)"key", keys.iterator().next());
        AbstractMap map2 = (AbstractMap)map.clone();
        map2.put("key", "value2");
        Collection values2 = map2.values();
        LinkedHashMapTest.assertTrue((String)"values() is identical", (values2 != values ? 1 : 0) != 0);
        LinkedHashMapTest.assertEquals((String)"values() was not cloned", (Object)"value2", values2.iterator().next());
        map2.clear();
        map2.put("key2", "value3");
        Set key2 = map2.keySet();
        LinkedHashMapTest.assertTrue((String)"keySet() is identical", (key2 != keys ? 1 : 0) != 0);
        LinkedHashMapTest.assertEquals((String)"keySet() was not cloned", (Object)"key2", key2.iterator().next());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="containsKey", args={Object.class})
    public void test_containsKeyLjava_lang_Object() {
        LinkedHashMapTest.assertTrue((String)"Returned false for valid key", (boolean)this.hm.containsKey(new Integer(876).toString()));
        LinkedHashMapTest.assertTrue((String)"Returned true for invalid key", (!this.hm.containsKey("KKDKDKD") ? 1 : 0) != 0);
        LinkedHashMap m = new LinkedHashMap();
        m.put(null, "test");
        LinkedHashMapTest.assertTrue((String)"Failed with null key", (boolean)m.containsKey(null));
        LinkedHashMapTest.assertTrue((String)"Failed with missing key matching null hash", (!m.containsKey(new Integer(0)) ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="containsValue", args={Object.class})
    public void test_containsValueLjava_lang_Object() {
        LinkedHashMapTest.assertTrue((String)"Returned false for valid value", (boolean)this.hm.containsValue(new Integer(875)));
        LinkedHashMapTest.assertTrue((String)"Returned true for invalid valie", (!this.hm.containsValue(new Integer(-9)) ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="isEmpty", args={})
    public void test_isEmpty() {
        LinkedHashMapTest.assertTrue((String)"Returned false for new map", (boolean)new LinkedHashMap().isEmpty());
        LinkedHashMapTest.assertTrue((String)"Returned true for non-empty", (!this.hm.isEmpty() ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="size", args={})
    public void test_size() {
        LinkedHashMapTest.assertTrue((String)"Returned incorrect size", (this.hm.size() == objArray.length + 2 ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="entrySet", args={})
    public void test_ordered_entrySet() {
        Integer jj;
        Map.Entry m;
        int i;
        int sz = 100;
        LinkedHashMap<Integer, String> lhm = new LinkedHashMap<Integer, String>();
        for (i = 0; i < sz; ++i) {
            Integer ii = new Integer(i);
            lhm.put(ii, ii.toString());
        }
        Set s1 = lhm.entrySet();
        Iterator it1 = s1.iterator();
        LinkedHashMapTest.assertTrue((String)"Returned set of incorrect size 1", (lhm.size() == s1.size() ? 1 : 0) != 0);
        i = 0;
        while (it1.hasNext()) {
            Map.Entry m2 = it1.next();
            Integer jj2 = (Integer)m2.getKey();
            LinkedHashMapTest.assertTrue((String)"Returned incorrect entry set 1", (jj2 == i ? 1 : 0) != 0);
            ++i;
        }
        LinkedHashMap<Integer, String> lruhm = new LinkedHashMap<Integer, String>(200, 0.75f, true);
        for (i = 0; i < sz; ++i) {
            Integer ii = new Integer(i);
            lruhm.put(ii, ii.toString());
        }
        Set s3 = lruhm.entrySet();
        Iterator it3 = s3.iterator();
        LinkedHashMapTest.assertTrue((String)"Returned set of incorrect size 2", (lruhm.size() == s3.size() ? 1 : 0) != 0);
        for (i = 0; i < sz && it3.hasNext(); ++i) {
            Map.Entry m3 = it3.next();
            Integer jj3 = (Integer)m3.getKey();
            LinkedHashMapTest.assertTrue((String)"Returned incorrect entry set 2", (jj3 == i ? 1 : 0) != 0);
        }
        int p = 0;
        for (i = 0; i < sz; i += 2) {
            String ii = (String)lruhm.get(new Integer(i));
            p += Integer.parseInt(ii);
        }
        LinkedHashMapTest.assertEquals((String)"invalid sum of even numbers", (int)2450, (int)p);
        Set s2 = lruhm.entrySet();
        Iterator it2 = s2.iterator();
        LinkedHashMapTest.assertTrue((String)"Returned set of incorrect size 3", (lruhm.size() == s2.size() ? 1 : 0) != 0);
        for (i = 1; i < sz && it2.hasNext(); i += 2) {
            m = it2.next();
            jj = (Integer)m.getKey();
            LinkedHashMapTest.assertTrue((String)"Returned incorrect entry set 3", (jj == i ? 1 : 0) != 0);
        }
        for (i = 0; i < sz && it2.hasNext(); i += 2) {
            m = it2.next();
            jj = (Integer)m.getKey();
            LinkedHashMapTest.assertTrue((String)"Returned incorrect entry set 4", (jj == i ? 1 : 0) != 0);
        }
        LinkedHashMapTest.assertTrue((String)"Entries left to iterate on", (!it2.hasNext() ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="keySet", args={})
    public void test_ordered_keySet() {
        Integer jj;
        int i;
        int sz = 100;
        LinkedHashMap<Integer, String> lhm = new LinkedHashMap<Integer, String>();
        for (i = 0; i < sz; ++i) {
            Integer ii = new Integer(i);
            lhm.put(ii, ii.toString());
        }
        Set s1 = lhm.keySet();
        Iterator it1 = s1.iterator();
        LinkedHashMapTest.assertTrue((String)"Returned set of incorrect size", (lhm.size() == s1.size() ? 1 : 0) != 0);
        i = 0;
        while (it1.hasNext()) {
            Integer jj2 = (Integer)it1.next();
            LinkedHashMapTest.assertTrue((String)"Returned incorrect entry set", (jj2 == i ? 1 : 0) != 0);
            ++i;
        }
        LinkedHashMap<Integer, String> lruhm = new LinkedHashMap<Integer, String>(200, 0.75f, true);
        for (i = 0; i < sz; ++i) {
            Integer ii = new Integer(i);
            lruhm.put(ii, ii.toString());
        }
        Set s3 = lruhm.keySet();
        Iterator it3 = s3.iterator();
        LinkedHashMapTest.assertTrue((String)"Returned set of incorrect size", (lruhm.size() == s3.size() ? 1 : 0) != 0);
        for (i = 0; i < sz && it3.hasNext(); ++i) {
            Integer jj3 = (Integer)it3.next();
            LinkedHashMapTest.assertTrue((String)"Returned incorrect entry set", (jj3 == i ? 1 : 0) != 0);
        }
        int p = 0;
        for (i = 0; i < sz; i += 2) {
            String ii = (String)lruhm.get(new Integer(i));
            p += Integer.parseInt(ii);
        }
        LinkedHashMapTest.assertEquals((String)"invalid sum of even numbers", (int)2450, (int)p);
        Set s2 = lruhm.keySet();
        Iterator it2 = s2.iterator();
        LinkedHashMapTest.assertTrue((String)"Returned set of incorrect size", (lruhm.size() == s2.size() ? 1 : 0) != 0);
        for (i = 1; i < sz && it2.hasNext(); i += 2) {
            jj = (Integer)it2.next();
            LinkedHashMapTest.assertTrue((String)"Returned incorrect entry set", (jj == i ? 1 : 0) != 0);
        }
        for (i = 0; i < sz && it2.hasNext(); i += 2) {
            jj = (Integer)it2.next();
            LinkedHashMapTest.assertTrue((String)"Returned incorrect entry set", (jj == i ? 1 : 0) != 0);
        }
        LinkedHashMapTest.assertTrue((String)"Entries left to iterate on", (!it2.hasNext() ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="values", args={})
    public void test_ordered_values() {
        Integer jj;
        int i;
        int sz = 100;
        LinkedHashMap<Integer, Integer> lhm = new LinkedHashMap<Integer, Integer>();
        for (i = 0; i < sz; ++i) {
            Integer ii = new Integer(i);
            lhm.put(ii, new Integer(i * 2));
        }
        Collection s1 = lhm.values();
        Iterator it1 = s1.iterator();
        LinkedHashMapTest.assertTrue((String)"Returned set of incorrect size 1", (lhm.size() == s1.size() ? 1 : 0) != 0);
        i = 0;
        while (it1.hasNext()) {
            Integer jj2 = (Integer)it1.next();
            LinkedHashMapTest.assertTrue((String)"Returned incorrect entry set 1", (jj2 == i * 2 ? 1 : 0) != 0);
            ++i;
        }
        LinkedHashMap<Integer, Integer> lruhm = new LinkedHashMap<Integer, Integer>(200, 0.75f, true);
        for (i = 0; i < sz; ++i) {
            Integer ii = new Integer(i);
            lruhm.put(ii, new Integer(i * 2));
        }
        Collection s3 = lruhm.values();
        Iterator it3 = s3.iterator();
        LinkedHashMapTest.assertTrue((String)"Returned set of incorrect size", (lruhm.size() == s3.size() ? 1 : 0) != 0);
        for (i = 0; i < sz && it3.hasNext(); ++i) {
            Integer jj3 = (Integer)it3.next();
            LinkedHashMapTest.assertTrue((String)"Returned incorrect entry set", (jj3 == i * 2 ? 1 : 0) != 0);
        }
        int p = 0;
        for (i = 0; i < sz; i += 2) {
            Integer ii = (Integer)lruhm.get(new Integer(i));
            p += ii.intValue();
        }
        LinkedHashMapTest.assertTrue((String)"invalid sum of even numbers", (p == 4900 ? 1 : 0) != 0);
        Collection s2 = lruhm.values();
        Iterator it2 = s2.iterator();
        LinkedHashMapTest.assertTrue((String)"Returned set of incorrect size", (lruhm.size() == s2.size() ? 1 : 0) != 0);
        for (i = 1; i < sz && it2.hasNext(); i += 2) {
            jj = (Integer)it2.next();
            LinkedHashMapTest.assertTrue((String)"Returned incorrect entry set", (jj == i * 2 ? 1 : 0) != 0);
        }
        for (i = 0; i < sz && it2.hasNext(); i += 2) {
            jj = (Integer)it2.next();
            LinkedHashMapTest.assertTrue((String)"Returned incorrect entry set", (jj == i * 2 ? 1 : 0) != 0);
        }
        LinkedHashMapTest.assertTrue((String)"Entries left to iterate on", (!it2.hasNext() ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Doesn't verify null as a parameter.", method="removeEldestEntry", args={Map.Entry.class})
    public void test_remove_eldest() {
        int i;
        int sz = 10;
        CacheMap lhm = new CacheMap();
        for (i = 0; i < sz; ++i) {
            Integer ii = new Integer(i);
            lhm.put(ii, new Integer(i * 2));
        }
        Collection s1 = lhm.values();
        Iterator it1 = s1.iterator();
        LinkedHashMapTest.assertTrue((String)"Returned set of incorrect size 1", (lhm.size() == s1.size() ? 1 : 0) != 0);
        i = 5;
        while (it1.hasNext()) {
            Integer jj = (Integer)it1.next();
            LinkedHashMapTest.assertTrue((String)"Returned incorrect entry set 1", (jj == i * 2 ? 1 : 0) != 0);
            ++i;
        }
        LinkedHashMapTest.assertTrue((String)"Entries left in map", (!it1.hasNext() ? 1 : 0) != 0);
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="", method="LinkedHashMap", args={int.class, float.class, boolean.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="put", args={Object.class, Object.class})})
    public void testLinkedHashMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(10, 0.75f, true);
        map.put("key1", "value1");
        map.put("key2", "value2");
        map.put("key3", "value3");
        Iterator iterator = map.keySet().iterator();
        String id = (String)iterator.next();
        map.get(id);
        try {
            iterator.next();
            LinkedHashMapTest.fail((String)"expected ConcurrentModificationException was not thrown.");
        }
        catch (ConcurrentModificationException e) {
            // empty catch block
        }
        LinkedHashMap mapClone = (LinkedHashMap)map.clone();
        iterator = map.keySet().iterator();
        id = (String)iterator.next();
        mapClone.get(id);
        try {
            iterator.next();
        }
        catch (ConcurrentModificationException e) {
            LinkedHashMapTest.fail((String)"expected ConcurrentModificationException was not thrown.");
        }
        try {
            new LinkedHashMap(-10, 0.75f, true);
            LinkedHashMapTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new LinkedHashMap(10, -0.75f, true);
            LinkedHashMapTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    protected void setUp() {
        this.hm = new LinkedHashMap();
        for (int i = 0; i < objArray.length; ++i) {
            this.hm.put(objArray2[i], objArray[i]);
        }
        this.hm.put("test", null);
        this.hm.put(null, "test");
    }

    protected void tearDown() {
    }

    private static class MockMapNull
    extends AbstractMap {
        private MockMapNull() {
        }

        public Set entrySet() {
            return null;
        }

        public int size() {
            return 10;
        }
    }

    static final class CacheMap
    extends LinkedHashMap {
        CacheMap() {
        }

        protected boolean removeEldestEntry(Map.Entry e) {
            return this.size() > 5;
        }
    }
}

