/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.tests.java.util;

import java.io.Serializable;
import java.util.IllegalFormatWidthException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.harmony.testframework.serialization.SerializationTest;

public class IllegalFormatWidthExceptionTest
extends TestCase {
    private static final SerializationTest.SerializableAssert exComparator = new SerializationTest.SerializableAssert(){

        public void assertDeserialized(Serializable initial, Serializable deserialized) {
            SerializationTest.THROWABLE_COMPARATOR.assertDeserialized(initial, deserialized);
            IllegalFormatWidthException initEx = (IllegalFormatWidthException)initial;
            IllegalFormatWidthException desrEx = (IllegalFormatWidthException)deserialized;
            Assert.assertEquals((String)"Width", (int)initEx.getWidth(), (int)desrEx.getWidth());
        }
    };

    public void test_illegalFormatWidthException() {
        int width = Integer.MAX_VALUE;
        IllegalFormatWidthException illegalFormatWidthException = new IllegalFormatWidthException(width);
        IllegalFormatWidthExceptionTest.assertEquals((int)width, (int)illegalFormatWidthException.getWidth());
    }

    public void test_getWidth() {
        int width = 12345;
        IllegalFormatWidthException illegalFormatWidthException = new IllegalFormatWidthException(width);
        IllegalFormatWidthExceptionTest.assertEquals((int)width, (int)illegalFormatWidthException.getWidth());
    }

    public void test_getMessage() {
        int width = 12345;
        IllegalFormatWidthException illegalFormatWidthException = new IllegalFormatWidthException(width);
        IllegalFormatWidthExceptionTest.assertTrue((null != illegalFormatWidthException.getMessage() ? 1 : 0) != 0);
    }

    public void testSerializationSelf() throws Exception {
        SerializationTest.verifySelf(new IllegalFormatWidthException(12345), exComparator);
    }

    public void testSerializationCompatibility() throws Exception {
        SerializationTest.verifyGolden((TestCase)this, new IllegalFormatWidthException(12345), exComparator);
    }
}

