/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.tests.java.util;

import java.io.Serializable;
import java.util.IllegalFormatPrecisionException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.harmony.testframework.serialization.SerializationTest;

public class IllegalFormatPrecisionExceptionTest
extends TestCase {
    private static final SerializationTest.SerializableAssert exComparator = new SerializationTest.SerializableAssert(){

        public void assertDeserialized(Serializable initial, Serializable deserialized) {
            SerializationTest.THROWABLE_COMPARATOR.assertDeserialized(initial, deserialized);
            IllegalFormatPrecisionException initEx = (IllegalFormatPrecisionException)initial;
            IllegalFormatPrecisionException desrEx = (IllegalFormatPrecisionException)deserialized;
            Assert.assertEquals((String)"Precision", (int)initEx.getPrecision(), (int)desrEx.getPrecision());
        }
    };

    public void test_illegalFormatPrecisionException() {
        IllegalFormatPrecisionException illegalFormatPrecisionException = new IllegalFormatPrecisionException(Integer.MIN_VALUE);
        IllegalFormatPrecisionExceptionTest.assertEquals((int)Integer.MIN_VALUE, (int)illegalFormatPrecisionException.getPrecision());
    }

    public void test_getPrecision() {
        int precision = 12345;
        IllegalFormatPrecisionException illegalFormatPrecisionException = new IllegalFormatPrecisionException(precision);
        IllegalFormatPrecisionExceptionTest.assertEquals((int)precision, (int)illegalFormatPrecisionException.getPrecision());
    }

    public void test_getMessage() {
        int precision = 12345;
        IllegalFormatPrecisionException illegalFormatPrecisionException = new IllegalFormatPrecisionException(precision);
        IllegalFormatPrecisionExceptionTest.assertTrue((null != illegalFormatPrecisionException.getMessage() ? 1 : 0) != 0);
    }

    public void testSerializationSelf() throws Exception {
        SerializationTest.verifySelf(new IllegalFormatPrecisionException(12345), exComparator);
    }

    public void testSerializationCompatibility() throws Exception {
        SerializationTest.verifyGolden((TestCase)this, new IllegalFormatPrecisionException(12345), exComparator);
    }
}

