/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.tests.java.util;

import java.io.Serializable;
import java.util.IllegalFormatFlagsException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.harmony.testframework.serialization.SerializationTest;

public class IllegalFormatFlagsExceptionTest
extends TestCase {
    private static final SerializationTest.SerializableAssert exComparator = new SerializationTest.SerializableAssert(){

        public void assertDeserialized(Serializable initial, Serializable deserialized) {
            SerializationTest.THROWABLE_COMPARATOR.assertDeserialized(initial, deserialized);
            IllegalFormatFlagsException initEx = (IllegalFormatFlagsException)initial;
            IllegalFormatFlagsException desrEx = (IllegalFormatFlagsException)deserialized;
            Assert.assertEquals((String)"Flags", (String)initEx.getFlags(), (String)desrEx.getFlags());
        }
    };

    public void test_illegalFormatFlagsException() {
        try {
            new IllegalFormatFlagsException(null);
            IllegalFormatFlagsExceptionTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void test_getFlags() {
        String flags = "TESTFLAGS";
        IllegalFormatFlagsException illegalFormatFlagsException = new IllegalFormatFlagsException(flags);
        IllegalFormatFlagsExceptionTest.assertEquals((String)flags, (String)illegalFormatFlagsException.getFlags());
    }

    public void test_getMessage() {
        String flags = "TESTFLAGS";
        IllegalFormatFlagsException illegalFormatFlagsException = new IllegalFormatFlagsException(flags);
        IllegalFormatFlagsExceptionTest.assertTrue((null != illegalFormatFlagsException.getMessage() ? 1 : 0) != 0);
    }

    public void testSerializationSelf() throws Exception {
        SerializationTest.verifySelf(new IllegalFormatFlagsException("TESTFLAGS"), exComparator);
    }

    public void testSerializationCompatibility() throws Exception {
        SerializationTest.verifyGolden((TestCase)this, new IllegalFormatFlagsException("TESTFLAGS"), exComparator);
    }
}

