/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.tests.java.util;

import java.io.Serializable;
import java.util.IllegalFormatConversionException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.harmony.testframework.serialization.SerializationTest;

public class IllegalFormatConversionExceptionTest
extends TestCase {
    private static final SerializationTest.SerializableAssert exComparator = new SerializationTest.SerializableAssert(){

        public void assertDeserialized(Serializable initial, Serializable deserialized) {
            SerializationTest.THROWABLE_COMPARATOR.assertDeserialized(initial, deserialized);
            IllegalFormatConversionException initEx = (IllegalFormatConversionException)initial;
            IllegalFormatConversionException desrEx = (IllegalFormatConversionException)deserialized;
            Assert.assertEquals((String)"ArgumentClass", initEx.getArgumentClass(), desrEx.getArgumentClass());
            Assert.assertEquals((String)"Conversion", (char)initEx.getConversion(), (char)desrEx.getConversion());
        }
    };

    public void test_illegalFormatConversionException() {
        try {
            new IllegalFormatConversionException(' ', null);
            IllegalFormatConversionExceptionTest.fail((String)"should throw NullPointerExcetpion.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void test_getArgumentClass() {
        char c = '*';
        Class<String> argClass = String.class;
        IllegalFormatConversionException illegalFormatConversionException = new IllegalFormatConversionException(c, argClass);
        IllegalFormatConversionExceptionTest.assertEquals(argClass, illegalFormatConversionException.getArgumentClass());
    }

    public void test_getConversion() {
        char c = '*';
        Class<String> argClass = String.class;
        IllegalFormatConversionException illegalFormatConversionException = new IllegalFormatConversionException(c, argClass);
        IllegalFormatConversionExceptionTest.assertEquals((char)c, (char)illegalFormatConversionException.getConversion());
    }

    public void test_getMessage() {
        char c = '*';
        Class<String> argClass = String.class;
        IllegalFormatConversionException illegalFormatConversionException = new IllegalFormatConversionException(c, argClass);
        IllegalFormatConversionExceptionTest.assertTrue((null != illegalFormatConversionException.getMessage() ? 1 : 0) != 0);
    }

    public void testSerializationSelf() throws Exception {
        SerializationTest.verifySelf(new IllegalFormatConversionException('*', String.class), exComparator);
    }

    public void testSerializationCompatibility() throws Exception {
        SerializationTest.verifyGolden((TestCase)this, new IllegalFormatConversionException('*', String.class), exComparator);
    }
}

