/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.tests.java.util;

import java.io.Serializable;
import java.util.IllegalFormatCodePointException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.harmony.testframework.serialization.SerializationTest;

public class IllegalFormatCodePointExceptionTest
extends TestCase {
    private static final SerializationTest.SerializableAssert exComparator = new SerializationTest.SerializableAssert(){

        public void assertDeserialized(Serializable initial, Serializable deserialized) {
            SerializationTest.THROWABLE_COMPARATOR.assertDeserialized(initial, deserialized);
            IllegalFormatCodePointException initEx = (IllegalFormatCodePointException)initial;
            IllegalFormatCodePointException desrEx = (IllegalFormatCodePointException)deserialized;
            Assert.assertEquals((String)"CodePoint", (int)initEx.getCodePoint(), (int)desrEx.getCodePoint());
        }
    };

    public void test_illegalFormatCodePointException() {
        IllegalFormatCodePointException illegalFormatCodePointException = new IllegalFormatCodePointException(-1);
        IllegalFormatCodePointExceptionTest.assertTrue((null != illegalFormatCodePointException ? 1 : 0) != 0);
    }

    public void test_getCodePoint() {
        int codePoint = 12345;
        IllegalFormatCodePointException illegalFormatCodePointException = new IllegalFormatCodePointException(codePoint);
        IllegalFormatCodePointExceptionTest.assertEquals((int)codePoint, (int)illegalFormatCodePointException.getCodePoint());
    }

    public void test_getMessage() {
        int codePoint = 12345;
        IllegalFormatCodePointException illegalFormatCodePointException = new IllegalFormatCodePointException(codePoint);
        IllegalFormatCodePointExceptionTest.assertTrue((null != illegalFormatCodePointException.getMessage() ? 1 : 0) != 0);
    }

    public void testSerializationSelf() throws Exception {
        SerializationTest.verifySelf(new IllegalFormatCodePointException(12345), exComparator);
    }

    public void testSerializationCompatibility() throws Exception {
        SerializationTest.verifyGolden((TestCase)this, new IllegalFormatCodePointException(12345), exComparator);
    }
}

