/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.tests.java.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.harmony.testframework.serialization.SerializationTest;

public class IdentityHashMapTest
extends TestCase {
    private static final SerializationTest.SerializableAssert COMPARATOR = new SerializationTest.SerializableAssert(){

        public void assertDeserialized(Serializable initial, Serializable deserialized) {
            IdentityHashMap init = (IdentityHashMap)initial;
            IdentityHashMap desr = (IdentityHashMap)deserialized;
            Assert.assertEquals((String)"Size", (int)init.size(), (int)desr.size());
        }
    };

    public void test_null_Keys_and_Values() {
        IdentityHashMap<String, String> map = new IdentityHashMap<String, String>();
        String result = map.put(null, null);
        IdentityHashMapTest.assertTrue((String)"testA can not find null key", (boolean)map.containsKey(null));
        IdentityHashMapTest.assertTrue((String)"testA can not find null value", (boolean)map.containsValue(null));
        IdentityHashMapTest.assertNull((String)"testA can not get null value for null key", map.get(null));
        IdentityHashMapTest.assertNull((String)"testA put returned wrong value", result);
        String value = "a value";
        result = map.put(null, value);
        IdentityHashMapTest.assertTrue((String)"testB can not find null key", (boolean)map.containsKey(null));
        IdentityHashMapTest.assertTrue((String)"testB can not find a value with null key", (boolean)map.containsValue(value));
        IdentityHashMapTest.assertTrue((String)"testB can not get value for null key", (map.get(null) == value ? 1 : 0) != 0);
        IdentityHashMapTest.assertNull((String)"testB put returned wrong value", (Object)result);
        String key = "a key";
        result = map.put(key, null);
        IdentityHashMapTest.assertTrue((String)"testC can not find a key with null value", (boolean)map.containsKey(key));
        IdentityHashMapTest.assertTrue((String)"testC can not find null value", (boolean)map.containsValue(null));
        IdentityHashMapTest.assertNull((String)"testC can not get null value for key", map.get(key));
        IdentityHashMapTest.assertNull((String)"testC put returned wrong value", (Object)result);
        String anothervalue = "another value";
        result = map.put(null, anothervalue);
        IdentityHashMapTest.assertTrue((String)"testD can not find null key", (boolean)map.containsKey(null));
        IdentityHashMapTest.assertTrue((String)"testD can not find a value with null key", (boolean)map.containsValue(anothervalue));
        IdentityHashMapTest.assertTrue((String)"testD can not get value for null key", (map.get(null) == anothervalue ? 1 : 0) != 0);
        IdentityHashMapTest.assertTrue((String)"testD put returned wrong value", (result == value ? 1 : 0) != 0);
        result = map.remove(null);
        IdentityHashMapTest.assertTrue((String)"testE remove returned wrong value", (result == anothervalue ? 1 : 0) != 0);
        IdentityHashMapTest.assertTrue((String)"testE should not find null key", (!map.containsKey(null) ? 1 : 0) != 0);
        IdentityHashMapTest.assertTrue((String)"testE should not find a value with null key", (!map.containsValue(anothervalue) ? 1 : 0) != 0);
        IdentityHashMapTest.assertNull((String)"testE should not get value for null key", map.get(null));
    }

    public void test_putLjava_lang_ObjectLjava_lang_Object() {
        IdentityHashMap<String, String> map = new IdentityHashMap<String, String>();
        String value = "Some value";
        map.put(null, value);
        IdentityHashMapTest.assertSame((String)"Assert 0: Failure getting null key", (Object)value, map.get(null));
        String key = "Some key";
        map.put(key, null);
        IdentityHashMapTest.assertNull((String)"Assert 1: Failure getting null value", map.get(key));
    }

    public void test_remove() {
        IdentityHashMap<String, String> map = new IdentityHashMap<String, String>();
        map.put(null, null);
        map.put("key1", "value1");
        map.put("key2", "value2");
        map.remove("key1");
        IdentityHashMapTest.assertTrue((String)"Did not remove key1", (!map.containsKey("key1") ? 1 : 0) != 0);
        IdentityHashMapTest.assertTrue((String)"Did not remove the value for key1", (!map.containsValue("value1") ? 1 : 0) != 0);
        IdentityHashMapTest.assertTrue((String)"Modified key2", (map.get("key2") != null && map.get("key2") == "value2" ? 1 : 0) != 0);
        IdentityHashMapTest.assertNull((String)"Modified null entry", map.get(null));
    }

    public void test_removeLjava_lang_Object() {
        IdentityHashMap<String, String> hashMap = new IdentityHashMap<String, String>();
        hashMap.remove("absent");
        IdentityHashMapTest.assertEquals((String)"Assert 0: Size is incorrect", (int)0, (int)hashMap.size());
        hashMap.put("key", "value");
        hashMap.remove("key");
        IdentityHashMapTest.assertEquals((String)"Assert 1: After removing non-null element size is incorrect", (int)0, (int)hashMap.size());
        hashMap.put(null, null);
        IdentityHashMapTest.assertEquals((String)"Assert 2: adding literal null failed", (int)1, (int)hashMap.size());
        hashMap.remove(null);
        IdentityHashMapTest.assertEquals((String)"Assert 3: After removing null element size is incorrect", (int)0, (int)hashMap.size());
    }

    public void test_sets() {
        IdentityHashMap<String, String> map = new IdentityHashMap<String, String>();
        map.put("key", "value");
        map.put(null, null);
        map.put("a key", null);
        map.put("another key", null);
        Set keyset = map.keySet();
        Collection valueset = map.values();
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            IdentityHashMapTest.assertTrue((String)"EntrySetIterator can not find entry ", (boolean)entries.contains(entry));
            IdentityHashMapTest.assertTrue((String)"entry key not found in map", (boolean)map.containsKey(entry.getKey()));
            IdentityHashMapTest.assertTrue((String)"entry value not found in map", (boolean)map.containsValue(entry.getValue()));
            IdentityHashMapTest.assertTrue((String)"entry key not found in the keyset", (boolean)keyset.contains(entry.getKey()));
            IdentityHashMapTest.assertTrue((String)"entry value not found in the valueset", (boolean)valueset.contains(entry.getValue()));
        }
    }

    public void test_entrySet_removeAll() {
        IdentityHashMap<Integer, Integer> map = new IdentityHashMap<Integer, Integer>();
        for (int i = 0; i < 1000; ++i) {
            map.put(new Integer(i), new Integer(i));
        }
        Set set = map.entrySet();
        set.removeAll(set);
        IdentityHashMapTest.assertEquals((String)"did not remove all elements in the map", (int)0, (int)map.size());
        IdentityHashMapTest.assertTrue((String)"did not remove all elements in the entryset", (boolean)set.isEmpty());
        Iterator it = set.iterator();
        IdentityHashMapTest.assertTrue((String)"entrySet iterator still has elements", (!it.hasNext() ? 1 : 0) != 0);
    }

    public void test_keySet_clear() {
        IdentityHashMap<Integer, Integer> map = new IdentityHashMap<Integer, Integer>();
        for (int i = 0; i < 1000; ++i) {
            map.put(new Integer(i), new Integer(i));
        }
        Set set = map.keySet();
        set.clear();
        IdentityHashMapTest.assertEquals((String)"did not remove all elements in the map", (int)0, (int)map.size());
        IdentityHashMapTest.assertTrue((String)"did not remove all elements in the keyset", (boolean)set.isEmpty());
        Iterator it = set.iterator();
        IdentityHashMapTest.assertTrue((String)"keySet iterator still has elements", (!it.hasNext() ? 1 : 0) != 0);
    }

    public void test_values() {
        IdentityHashMap<Integer, Integer> map = new IdentityHashMap<Integer, Integer>();
        for (int i = 0; i < 10; ++i) {
            map.put(new Integer(i), new Integer(i));
        }
        Integer key = new Integer(20);
        Integer value = new Integer(40);
        map.put(key, value);
        Collection vals = map.values();
        boolean result = vals.remove(key);
        IdentityHashMapTest.assertTrue((String)"removed entries incorrectly", (map.size() == 11 && !result ? 1 : 0) != 0);
        IdentityHashMapTest.assertTrue((String)"removed key incorrectly", (boolean)map.containsKey(key));
        IdentityHashMapTest.assertTrue((String)"removed value incorrectly", (boolean)map.containsValue(value));
        result = vals.remove(value);
        IdentityHashMapTest.assertTrue((String)"Did not remove entry as expected", (map.size() == 10 && result ? 1 : 0) != 0);
        IdentityHashMapTest.assertTrue((String)"Did not remove key as expected", (!map.containsKey(key) ? 1 : 0) != 0);
        IdentityHashMapTest.assertTrue((String)"Did not remove value as expected", (!map.containsValue(value) ? 1 : 0) != 0);
        key = new Integer(1);
        value = new Integer(100);
        map.put(key, value);
        result = vals.remove(key);
        IdentityHashMapTest.assertTrue((String)"TestB. removed entries incorrectly", (map.size() == 11 && !result ? 1 : 0) != 0);
        IdentityHashMapTest.assertTrue((String)"TestB. removed key incorrectly", (boolean)map.containsKey(key));
        IdentityHashMapTest.assertTrue((String)"TestB. removed value incorrectly", (boolean)map.containsValue(value));
        result = vals.remove(value);
        IdentityHashMapTest.assertTrue((String)"TestB. Did not remove entry as expected", (map.size() == 10 && result ? 1 : 0) != 0);
        IdentityHashMapTest.assertTrue((String)"TestB. Did not remove key as expected", (!map.containsKey(key) ? 1 : 0) != 0);
        IdentityHashMapTest.assertTrue((String)"TestB. Did not remove value as expected", (!map.containsValue(value) ? 1 : 0) != 0);
        vals.clear();
        IdentityHashMapTest.assertEquals((String)"Did not remove all entries as expected", (int)0, (int)map.size());
    }

    public void test_keySet_removeAll() {
        IdentityHashMap<Integer, Integer> map = new IdentityHashMap<Integer, Integer>();
        for (int i = 0; i < 1000; ++i) {
            map.put(new Integer(i), new Integer(i));
        }
        Set set = map.keySet();
        set.removeAll(set);
        IdentityHashMapTest.assertEquals((String)"did not remove all elements in the map", (int)0, (int)map.size());
        IdentityHashMapTest.assertTrue((String)"did not remove all elements in the keyset", (boolean)set.isEmpty());
        Iterator it = set.iterator();
        IdentityHashMapTest.assertTrue((String)"keySet iterator still has elements", (!it.hasNext() ? 1 : 0) != 0);
    }

    public void test_keySet_retainAll() {
        IdentityHashMap<Integer, Integer> map = new IdentityHashMap<Integer, Integer>();
        for (int i = 0; i < 1000; ++i) {
            map.put(new Integer(i), new Integer(i));
        }
        Set set = map.keySet();
        boolean result = set.retainAll(set);
        IdentityHashMapTest.assertTrue((String)"retain all should return false", (!result ? 1 : 0) != 0);
        IdentityHashMapTest.assertEquals((String)"did not retain all", (int)1000, (int)set.size());
        result = set.retainAll(new TreeSet());
        IdentityHashMapTest.assertTrue((String)"retain all should return true", (boolean)result);
        IdentityHashMapTest.assertEquals((String)"did not remove all elements in the map", (int)0, (int)map.size());
        IdentityHashMapTest.assertTrue((String)"did not remove all elements in the keyset", (boolean)set.isEmpty());
        Iterator it = set.iterator();
        IdentityHashMapTest.assertTrue((String)"keySet iterator still has elements", (!it.hasNext() ? 1 : 0) != 0);
    }

    public void test_keyset_remove() {
        IdentityHashMap map = new IdentityHashMap();
        Integer key = new Integer(21);
        map.put(new Integer(1), null);
        map.put(new Integer(11), null);
        map.put(key, null);
        map.put(new Integer(31), null);
        map.put(new Integer(41), null);
        map.put(new Integer(51), null);
        map.put(new Integer(61), null);
        map.put(new Integer(71), null);
        map.put(new Integer(81), null);
        map.put(new Integer(91), null);
        Set set = map.keySet();
        HashSet newset = new HashSet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (element == key) {
                it.remove();
                continue;
            }
            newset.add(element);
        }
        int size = newset.size();
        IdentityHashMapTest.assertTrue((String)"keyset and newset don't have same size", (newset.size() == size ? 1 : 0) != 0);
        IdentityHashMapTest.assertTrue((String)"element is in newset ", (!newset.contains(key) ? 1 : 0) != 0);
        IdentityHashMapTest.assertTrue((String)"element not removed from keyset", (!set.contains(key) ? 1 : 0) != 0);
        IdentityHashMapTest.assertTrue((String)"element not removed from map", (!map.containsKey(key) ? 1 : 0) != 0);
        IdentityHashMapTest.assertTrue((String)"newset and keyset do not have same elements 1", (boolean)((Object)newset).equals(set));
        IdentityHashMapTest.assertTrue((String)"newset and keyset do not have same elements 2", (boolean)((Object)set).equals(newset));
    }

    public void test_clone_scenario1() {
        IdentityHashMap hashMap = new IdentityHashMap();
        IdentityHashMapTest.assertEquals((int)0, (int)hashMap.hashCode());
        Object cloneHashMap = hashMap.clone();
        ((IdentityHashMap)cloneHashMap).put("key", "value");
        IdentityHashMapTest.assertEquals((int)0, (int)hashMap.hashCode());
        IdentityHashMapTest.assertTrue((0 != cloneHashMap.hashCode() ? 1 : 0) != 0);
    }

    public void test_clone_scenario2() {
        IdentityHashMap<String, String> hashMap = new IdentityHashMap<String, String>();
        IdentityHashMapTest.assertEquals((int)0, (int)hashMap.hashCode());
        Object cloneHashMap = hashMap.clone();
        hashMap.put("key", "value");
        IdentityHashMapTest.assertEquals((int)1, (int)hashMap.size());
        IdentityHashMapTest.assertEquals((int)0, (int)((IdentityHashMap)cloneHashMap).size());
        IdentityHashMapTest.assertEquals((Object)"value", hashMap.get("key"));
        IdentityHashMapTest.assertNull(((IdentityHashMap)cloneHashMap).get("key"));
        IdentityHashMapTest.assertTrue((0 != hashMap.hashCode() ? 1 : 0) != 0);
        IdentityHashMapTest.assertEquals((int)0, (int)cloneHashMap.hashCode());
    }

    public void test_clone_scenario3() {
        IdentityHashMap<String, String> hashMap = new IdentityHashMap<String, String>();
        IdentityHashMapTest.assertEquals((int)0, (int)hashMap.hashCode());
        hashMap.put("key", "value");
        Object cloneHashMap = hashMap.clone();
        IdentityHashMapTest.assertEquals((int)1, (int)hashMap.size());
        IdentityHashMapTest.assertEquals((int)1, (int)((IdentityHashMap)cloneHashMap).size());
        IdentityHashMapTest.assertEquals((Object)"value", hashMap.get("key"));
        IdentityHashMapTest.assertEquals((Object)"value", ((IdentityHashMap)cloneHashMap).get("key"));
        IdentityHashMapTest.assertEquals((int)hashMap.hashCode(), (int)cloneHashMap.hashCode());
    }

    public void test_clone_scenario4() {
        IdentityHashMap<Object, Object> hashMap = new IdentityHashMap<Object, Object>();
        Object cloneHashMap = hashMap.clone();
        IdentityHashMapTest.assertNull(((IdentityHashMap)cloneHashMap).get(null));
        hashMap.put(null, cloneHashMap);
        IdentityHashMapTest.assertNull(((IdentityHashMap)cloneHashMap).get(null));
        IdentityHashMapTest.assertEquals((Object)cloneHashMap, hashMap.get(null));
    }

    public void test_clone_scenario5() throws Exception {
        IdentityHashMap hashMap = new IdentityHashMap();
        Object cloneHashMap = hashMap.clone();
        IdentityHashMapTest.assertNull(hashMap.remove(null));
        ((IdentityHashMap)cloneHashMap).put(null, cloneHashMap);
        IdentityHashMapTest.assertNull(hashMap.remove(null));
        IdentityHashMapTest.assertEquals((Object)cloneHashMap, ((IdentityHashMap)cloneHashMap).get(null));
    }

    public void testSerializationCompatibility() throws Exception {
        IdentityHashMap<String, String> identityHashMap = new IdentityHashMap<String, String>();
        identityHashMap.put("key1", "value1");
        identityHashMap.put("key2", "value2");
        identityHashMap.put("key3", "value3");
        SerializationTest.verifyGolden((TestCase)this, identityHashMap, COMPARATOR);
    }
}

