/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.tests.java.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import junit.framework.TestCase;
import org.apache.harmony.testframework.serialization.SerializationTest;
import tests.support.Support_MapTest2;
import tests.support.Support_UnmodifiableCollectionTest;

public class HashMapTest
extends TestCase {
    HashMap hm;
    static final int hmSize = 1000;
    static Object[] objArray;
    static Object[] objArray2;

    public HashMapTest() {
        objArray = new Object[1000];
        objArray2 = new Object[1000];
        for (int i = 0; i < objArray.length; ++i) {
            HashMapTest.objArray[i] = new Integer(i);
            HashMapTest.objArray2[i] = objArray[i].toString();
        }
    }

    public void test_Constructor() {
        new Support_MapTest2(new HashMap<String, String>()).runTest();
        HashMap hm2 = new HashMap();
        HashMapTest.assertEquals((String)"Created incorrect HashMap", (int)0, (int)hm2.size());
    }

    public void test_ConstructorI() {
        HashMap hm2 = new HashMap(5);
        HashMapTest.assertEquals((String)"Created incorrect HashMap", (int)0, (int)hm2.size());
        try {
            new HashMap(-1);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        HashMapTest.fail((String)"Failed to throw IllegalArgumentException for initial capacity < 0");
        HashMap<String, String> empty = new HashMap<String, String>(0);
        HashMapTest.assertNull((String)"Empty hashmap access", empty.get("nothing"));
        empty.put("something", "here");
        HashMapTest.assertTrue((String)"cannot get element", (empty.get("something") == "here" ? 1 : 0) != 0);
    }

    public void test_ConstructorIF() {
        HashMap hm2 = new HashMap(5, 0.5f);
        HashMapTest.assertEquals((String)"Created incorrect HashMap", (int)0, (int)hm2.size());
        try {
            new HashMap(0, 0.0f);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        HashMapTest.fail((String)"Failed to throw IllegalArgumentException for initial load factor <= 0");
        HashMap<String, String> empty = new HashMap<String, String>(0, 0.75f);
        HashMapTest.assertNull((String)"Empty hashtable access", empty.get("nothing"));
        empty.put("something", "here");
        HashMapTest.assertTrue((String)"cannot get element", (empty.get("something") == "here" ? 1 : 0) != 0);
    }

    public void test_ConstructorLjava_util_Map() {
        TreeMap<Object, Object> myMap = new TreeMap<Object, Object>();
        for (int counter = 0; counter < 1000; ++counter) {
            myMap.put(objArray2[counter], objArray[counter]);
        }
        HashMap hm2 = new HashMap(myMap);
        for (int counter = 0; counter < 1000; ++counter) {
            HashMapTest.assertTrue((String)"Failed to construct correct HashMap", (this.hm.get(objArray2[counter]) == hm2.get(objArray2[counter]) ? 1 : 0) != 0);
        }
        try {
            MockMap mockMap = new MockMap();
            this.hm = new HashMap(mockMap);
            HashMapTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a", "a");
        SubMap map2 = new SubMap(map);
        HashMapTest.assertTrue((boolean)map2.containsKey("a"));
        HashMapTest.assertTrue((boolean)map2.containsValue("a"));
    }

    public void test_clear() {
        int i;
        this.hm.clear();
        HashMapTest.assertEquals((String)"Clear failed to reset size", (int)0, (int)this.hm.size());
        for (int i2 = 0; i2 < 1000; ++i2) {
            HashMapTest.assertNull((String)"Failed to clear all elements", this.hm.get(objArray2[i2]));
        }
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (i = -32767; i < 32768; ++i) {
            map.put(i, "foobar");
        }
        map.clear();
        HashMapTest.assertEquals((String)"Failed to reset size on large integer map", (int)0, (int)this.hm.size());
        for (i = -32767; i < 32768; ++i) {
            HashMapTest.assertNull((String)"Failed to clear integer map values", map.get(i));
        }
    }

    public void test_clone() {
        HashMap hm2 = (HashMap)this.hm.clone();
        HashMapTest.assertTrue((String)"Clone answered equivalent HashMap", (hm2 != this.hm ? 1 : 0) != 0);
        for (int counter = 0; counter < 1000; ++counter) {
            HashMapTest.assertTrue((String)"Clone answered unequal HashMap", (this.hm.get(objArray2[counter]) == hm2.get(objArray2[counter]) ? 1 : 0) != 0);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "value");
        Set keys = map.keySet();
        Collection values = map.values();
        HashMapTest.assertEquals((String)"values() does not work", (Object)"value", values.iterator().next());
        HashMapTest.assertEquals((String)"keySet() does not work", (Object)"key", keys.iterator().next());
        AbstractMap map2 = (AbstractMap)map.clone();
        map2.put("key", "value2");
        Collection values2 = map2.values();
        HashMapTest.assertTrue((String)"values() is identical", (values2 != values ? 1 : 0) != 0);
        HashMapTest.assertEquals((String)"values() was not cloned", (Object)"value2", values2.iterator().next());
        map2.clear();
        map2.put("key2", "value3");
        Set key2 = map2.keySet();
        HashMapTest.assertTrue((String)"keySet() is identical", (key2 != keys ? 1 : 0) != 0);
        HashMapTest.assertEquals((String)"keySet() was not cloned", (Object)"key2", key2.iterator().next());
        HashMap<Integer, MockClonable> hashmap = new HashMap<Integer, MockClonable>();
        MockClonable mock = new MockClonable(1);
        hashmap.put(1, mock);
        HashMapTest.assertEquals((int)1, (int)((MockClonable)hashmap.get((Object)Integer.valueOf((int)1))).i);
        HashMap hm3 = (HashMap)hashmap.clone();
        HashMapTest.assertEquals((int)1, (int)((MockClonable)hm3.get((Object)Integer.valueOf((int)1))).i);
        mock.i = 0;
        HashMapTest.assertEquals((int)0, (int)((MockClonable)hashmap.get((Object)Integer.valueOf((int)1))).i);
        HashMapTest.assertEquals((int)0, (int)((MockClonable)hm3.get((Object)Integer.valueOf((int)1))).i);
    }

    public void test_containsKeyLjava_lang_Object() {
        HashMapTest.assertTrue((String)"Returned false for valid key", (boolean)this.hm.containsKey(new Integer(876).toString()));
        HashMapTest.assertTrue((String)"Returned true for invalid key", (!this.hm.containsKey("KKDKDKD") ? 1 : 0) != 0);
        HashMap m = new HashMap();
        m.put(null, "test");
        HashMapTest.assertTrue((String)"Failed with null key", (boolean)m.containsKey(null));
        HashMapTest.assertTrue((String)"Failed with missing key matching null hash", (!m.containsKey(new Integer(0)) ? 1 : 0) != 0);
    }

    public void test_containsValueLjava_lang_Object() {
        HashMapTest.assertTrue((String)"Returned false for valid value", (boolean)this.hm.containsValue(new Integer(875)));
        HashMapTest.assertTrue((String)"Returned true for invalid valie", (!this.hm.containsValue(new Integer(-9)) ? 1 : 0) != 0);
    }

    public void test_entrySet() {
        Set s = this.hm.entrySet();
        Iterator i = s.iterator();
        HashMapTest.assertTrue((String)"Returned set of incorrect size", (this.hm.size() == s.size() ? 1 : 0) != 0);
        while (i.hasNext()) {
            Map.Entry m = i.next();
            HashMapTest.assertTrue((String)"Returned incorrect entry set", (this.hm.containsKey(m.getKey()) && this.hm.containsValue(m.getValue()) ? 1 : 0) != 0);
        }
        Iterator iter = s.iterator();
        s.remove(iter.next());
        HashMapTest.assertEquals((int)1001, (int)s.size());
    }

    public void test_getLjava_lang_Object() {
        HashMapTest.assertNull((String)"Get returned non-null for non existent key", this.hm.get("T"));
        this.hm.put("T", "HELLO");
        HashMapTest.assertEquals((String)"Get returned incorrect value for existing key", (Object)"HELLO", this.hm.get("T"));
        HashMap m = new HashMap();
        m.put(null, "test");
        HashMapTest.assertEquals((String)"Failed with null key", (Object)"test", m.get(null));
        HashMapTest.assertNull((String)"Failed with missing key matching null hash", m.get(new Integer(0)));
        ReusableKey k = new ReusableKey();
        HashMap<ReusableKey, String> map = new HashMap<ReusableKey, String>();
        k.setKey(1);
        map.put(k, "value1");
        k.setKey(18);
        HashMapTest.assertNull(map.get(k));
        k.setKey(17);
        HashMapTest.assertNull(map.get(k));
    }

    public void test_proxies() {
        MockInterface proxyKey = (MockInterface)Proxy.newProxyInstance(MockInterface.class.getClassLoader(), new Class[]{MockInterface.class}, (InvocationHandler)new MockHandler(new MockClass()));
        MockInterface proxyValue = (MockInterface)Proxy.newProxyInstance(MockInterface.class.getClassLoader(), new Class[]{MockInterface.class}, (InvocationHandler)new MockHandler(new MockClass()));
        Object val = new Object();
        this.hm.put(proxyKey, val);
        HashMapTest.assertEquals((String)"Failed with proxy object key", (Object)val, this.hm.get(proxyKey));
        HashMapTest.assertTrue((String)"Failed to find proxy key", (boolean)this.hm.containsKey(proxyKey));
        HashMapTest.assertEquals((String)"Failed to remove proxy object key", (Object)val, this.hm.remove(proxyKey));
        HashMapTest.assertFalse((String)"Should not have found proxy key", (boolean)this.hm.containsKey(proxyKey));
        Object k = new Object();
        this.hm.put(k, proxyValue);
        HashMapTest.assertTrue((String)"Failed to find proxy object as value", (boolean)this.hm.containsValue(proxyValue));
        HashMap<MockInterface, MockInterface> map = new HashMap<MockInterface, MockInterface>();
        map.put(proxyKey, proxyValue);
        HashMapTest.assertTrue((String)"Failed to find proxy key", (boolean)map.containsKey(proxyKey));
        HashMapTest.assertEquals((int)1, (int)map.size());
        Object[] entries = map.entrySet().toArray();
        Map.Entry entry = (Map.Entry)entries[0];
        HashMapTest.assertTrue((String)"Failed to find proxy association", (boolean)map.entrySet().contains(entry));
    }

    public void test_isEmpty() {
        HashMapTest.assertTrue((String)"Returned false for new map", (boolean)new HashMap().isEmpty());
        HashMapTest.assertTrue((String)"Returned true for non-empty", (!this.hm.isEmpty() ? 1 : 0) != 0);
    }

    public void test_keySet() {
        Set s = this.hm.keySet();
        HashMapTest.assertTrue((String)"Returned set of incorrect size()", (s.size() == this.hm.size() ? 1 : 0) != 0);
        for (int i = 0; i < objArray.length; ++i) {
            HashMapTest.assertTrue((String)"Returned set does not contain all keys", (boolean)s.contains(objArray[i].toString()));
        }
        HashMap m = new HashMap();
        m.put(null, "test");
        HashMapTest.assertTrue((String)"Failed with null key", (boolean)m.keySet().contains(null));
        HashMapTest.assertNull((String)"Failed with null key", m.keySet().iterator().next());
        HashMap<Integer, String> map = new HashMap<Integer, String>(101);
        map.put(new Integer(1), "1");
        map.put(new Integer(102), "102");
        map.put(new Integer(203), "203");
        Iterator it = map.keySet().iterator();
        Integer remove1 = (Integer)it.next();
        it.hasNext();
        it.remove();
        Integer remove2 = (Integer)it.next();
        it.remove();
        ArrayList<Integer> list = new ArrayList<Integer>(Arrays.asList(new Integer(1), new Integer(102), new Integer(203)));
        list.remove(remove1);
        list.remove(remove2);
        HashMapTest.assertTrue((String)"Wrong result", (boolean)it.next().equals(list.get(0)));
        HashMapTest.assertEquals((String)"Wrong size", (int)1, (int)map.size());
        HashMapTest.assertTrue((String)"Wrong contents", (boolean)map.keySet().iterator().next().equals(list.get(0)));
        HashMap<Integer, String> map2 = new HashMap<Integer, String>(101);
        map2.put(new Integer(1), "1");
        map2.put(new Integer(4), "4");
        Iterator it2 = map2.keySet().iterator();
        Integer remove3 = (Integer)it2.next();
        Integer next = remove3 == 1 ? new Integer(4) : new Integer(1);
        it2.hasNext();
        it2.remove();
        HashMapTest.assertTrue((String)"Wrong result 2", (boolean)it2.next().equals(next));
        HashMapTest.assertEquals((String)"Wrong size 2", (int)1, (int)map2.size());
        HashMapTest.assertTrue((String)"Wrong contents 2", (boolean)map2.keySet().iterator().next().equals(next));
    }

    public void test_putLjava_lang_ObjectLjava_lang_Object() {
        Integer key;
        this.hm.put("KEY", "VALUE");
        HashMapTest.assertEquals((String)"Failed to install key/value pair", (Object)"VALUE", this.hm.get("KEY"));
        HashMap<Number, String> m = new HashMap<Number, String>();
        m.put(new Short(0), "short");
        m.put(null, "test");
        m.put(new Integer(0), "int");
        HashMapTest.assertEquals((String)"Failed adding to bucket containing null", (Object)"short", m.get(new Short(0)));
        HashMapTest.assertEquals((String)"Failed adding to bucket containing null2", (Object)"int", m.get(new Integer(0)));
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (int i = -32767; i < 32768; ++i) {
            map.put(i, "foobar");
        }
        Integer myKey = new Integer(0);
        map.put(myKey, "myValue");
        HashMapTest.assertTrue((boolean)map.containsKey(myKey));
        HashMapTest.assertEquals((String)"myValue", (String)((String)map.get(myKey)));
        boolean found = false;
        Iterator itr = map.keySet().iterator();
        while (itr.hasNext() && !(found = (key = (Integer)itr.next()) == myKey)) {
        }
        HashMapTest.assertFalse((String)"Should not find new key instance in hashmap", (boolean)found);
        HashMapTest.assertNotNull(map.remove(myKey));
        map.put(myKey, "myValue");
        HashMapTest.assertTrue((boolean)map.containsKey(myKey));
        HashMapTest.assertEquals((String)"myValue", (String)((String)map.get(myKey)));
        itr = map.keySet().iterator();
        while (itr.hasNext() && !(found = (key = (Integer)itr.next()) == myKey)) {
        }
        HashMapTest.assertTrue((String)"Did not find new key instance in hashmap", (boolean)found);
        HashMap<Object, String> objmap = new HashMap<Object, String>();
        for (int i = 0; i < 32768; ++i) {
            objmap.put(i, "foobar");
        }
        MyKey aKey = new MyKey();
        HashMapTest.assertNull((Object)objmap.put(aKey, "value"));
        HashMapTest.assertNull(objmap.remove(new MyKey()));
        HashMapTest.assertEquals((Object)"foobar", objmap.get(0));
        HashMapTest.assertEquals((Object)"value", objmap.get(aKey));
    }

    public void test_putAllLjava_util_Map() {
        HashMap hm2 = new HashMap();
        hm2.putAll(this.hm);
        for (int i = 0; i < 1000; ++i) {
            HashMapTest.assertTrue((String)"Failed to clear all elements", (boolean)hm2.get(new Integer(i).toString()).equals(new Integer(i)));
        }
        MockMap mockMap = new MockMap();
        hm2 = new HashMap();
        hm2.putAll(mockMap);
        HashMapTest.assertEquals((String)"Size should be 0", (int)0, (int)hm2.size());
    }

    public void test_putAllLjava_util_Map_Null() {
        HashMap hashMap = new HashMap();
        try {
            hashMap.putAll(new MockMapNull());
            HashMapTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            hashMap = new HashMap(new MockMapNull());
            HashMapTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void test_removeLjava_lang_Object() {
        int i;
        int size = this.hm.size();
        Integer y = new Integer(9);
        Integer x = (Integer)this.hm.remove(y.toString());
        HashMapTest.assertTrue((String)"Remove returned incorrect value", (boolean)x.equals(new Integer(9)));
        HashMapTest.assertNull((String)"Failed to remove given key", this.hm.get(new Integer(9)));
        HashMapTest.assertTrue((String)"Failed to decrement size", (this.hm.size() == size - 1 ? 1 : 0) != 0);
        HashMapTest.assertNull((String)"Remove of non-existent key returned non-null", this.hm.remove("LCLCLC"));
        HashMap m = new HashMap();
        m.put(null, "test");
        HashMapTest.assertNull((String)"Failed with same hash as null", m.remove(new Integer(0)));
        HashMapTest.assertEquals((String)"Failed with null key", (Object)"test", m.remove(null));
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        for (int i2 = 0; i2 < 32768; ++i2) {
            map.put(i2, "const");
        }
        Object[] values = new Object[32768];
        for (i = 0; i < 32768; ++i) {
            values[i] = new Object();
            map.put(i, values[i]);
        }
        for (i = Short.MAX_VALUE; i >= 0; --i) {
            HashMapTest.assertEquals((String)"Failed to remove same value", (Object)values[i], map.remove(i));
        }
        map = new HashMap();
        for (i = -32767; i < 32768; ++i) {
            map.put(i, "foobar");
        }
        HashMapTest.assertNull(map.remove(new MyKey()));
        HashMapTest.assertEquals((Object)"foobar", map.get(0));
        map.remove(0);
        HashMapTest.assertNull(map.get(0));
    }

    public void test_size() {
        HashMapTest.assertTrue((String)"Returned incorrect size", (this.hm.size() == objArray.length + 2 ? 1 : 0) != 0);
    }

    public void test_values() {
        Collection c = this.hm.values();
        HashMapTest.assertTrue((String)"Returned collection of incorrect size()", (c.size() == this.hm.size() ? 1 : 0) != 0);
        for (int i = 0; i < objArray.length; ++i) {
            HashMapTest.assertTrue((String)"Returned collection does not contain all keys", (boolean)c.contains(objArray[i]));
        }
        HashMap<Object, Object> myHashMap = new HashMap<Object, Object>();
        for (int i = 0; i < 100; ++i) {
            myHashMap.put(objArray2[i], objArray[i]);
        }
        Collection<Integer> values = myHashMap.values();
        new Support_UnmodifiableCollectionTest("Test Returned Collection From HashMap.values()", values).runTest();
        values.remove(new Integer(0));
        HashMapTest.assertTrue((String)"Removing from the values collection should remove from the original map", (!myHashMap.containsValue(new Integer(0)) ? 1 : 0) != 0);
    }

    public void test_toString() {
        HashMap m = new HashMap();
        m.put(m, m);
        String result = m.toString();
        HashMapTest.assertTrue((String)"should contain self ref", (result.indexOf("(this") > -1 ? 1 : 0) != 0);
    }

    public void test_Map_Entry_hashCode() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>(10);
        Integer key = new Integer(1);
        Integer val = new Integer(2);
        map.put(key, val);
        int expected = key.hashCode() ^ val.hashCode();
        HashMapTest.assertEquals((int)expected, (int)map.hashCode());
        key = new Integer(4);
        val = new Integer(8);
        map.put(key, val);
        HashMapTest.assertEquals((int)(expected += key.hashCode() ^ val.hashCode()), (int)map.hashCode());
    }

    public void test_EntrySet() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(new Integer(1), "ONE");
        Set entrySet = map.entrySet();
        Iterator e = entrySet.iterator();
        Map.Entry real = e.next();
        MockEntry copyEntry = new MockEntry();
        HashMapTest.assertEquals(real, (Object)copyEntry);
        HashMapTest.assertTrue((boolean)entrySet.contains(copyEntry));
        entrySet.remove(copyEntry);
        HashMapTest.assertFalse((boolean)entrySet.contains(copyEntry));
    }

    protected void setUp() {
        this.hm = new HashMap();
        for (int i = 0; i < objArray.length; ++i) {
            this.hm.put(objArray2[i], objArray[i]);
        }
        this.hm.put("test", null);
        this.hm.put(null, "test");
    }

    public void testSerializationSelf() throws Exception {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("key", "value");
        SerializationTest.verifySelf(hm);
        hm.put(null, "null");
        SerializationTest.verifySelf(hm);
    }

    public void testSerializationCompatibility() throws Exception {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("key", "value");
        SerializationTest.verifyGolden((TestCase)this, hm);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SubMap<K, V>
    extends HashMap<K, V> {
        public SubMap(Map<? extends K, ? extends V> m) {
            super(m);
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException();
        }
    }

    private static class MockEntry
    implements Map.Entry {
        private MockEntry() {
        }

        public Object getKey() {
            return new Integer(1);
        }

        public Object getValue() {
            return "ONE";
        }

        public Object setValue(Object object) {
            return null;
        }
    }

    class MockClonable
    implements Cloneable {
        public int i;

        public MockClonable(int i) {
            this.i = i;
        }

        protected Object clone() throws CloneNotSupportedException {
            return new MockClonable(this.i);
        }
    }

    static class ReusableKey {
        private int key = 0;

        ReusableKey() {
        }

        public void setKey(int key) {
            this.key = key;
        }

        public int hashCode() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReusableKey)) {
                return false;
            }
            return this.key == ((ReusableKey)o).key;
        }
    }

    static class MyKey {
        public int hashCode() {
            return 0;
        }
    }

    class MockHandler
    implements InvocationHandler {
        Object obj;

        public MockHandler(Object o) {
            this.obj = o;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            Object result = null;
            try {
                result = m.invoke(this.obj, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }
    }

    class MockClass
    implements MockInterface {
        MockClass() {
        }

        public String mockMethod() {
            return "This is a MockClass";
        }
    }

    static interface MockInterface {
        public String mockMethod();
    }

    private static class MockMapNull
    extends AbstractMap {
        private MockMapNull() {
        }

        public Set entrySet() {
            return null;
        }

        public int size() {
            return 10;
        }
    }

    class MockMap
    extends AbstractMap {
        MockMap() {
        }

        public Set entrySet() {
            return null;
        }

        public int size() {
            return 0;
        }
    }
}

