/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.tests.java.util;

import java.io.Serializable;
import java.util.FormatFlagsConversionMismatchException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.harmony.testframework.serialization.SerializationTest;

public class FormatFlagsConversionMismatchExceptionTest
extends TestCase {
    private static final SerializationTest.SerializableAssert exComparator = new SerializationTest.SerializableAssert(){

        public void assertDeserialized(Serializable initial, Serializable deserialized) {
            SerializationTest.THROWABLE_COMPARATOR.assertDeserialized(initial, deserialized);
            FormatFlagsConversionMismatchException initEx = (FormatFlagsConversionMismatchException)initial;
            FormatFlagsConversionMismatchException desrEx = (FormatFlagsConversionMismatchException)deserialized;
            Assert.assertEquals((String)"Flags", (String)initEx.getFlags(), (String)desrEx.getFlags());
            Assert.assertEquals((String)"Conversion", (char)initEx.getConversion(), (char)desrEx.getConversion());
        }
    };

    public void test_formatFlagsConversionMismatchException() {
        try {
            new FormatFlagsConversionMismatchException(null, ' ');
            FormatFlagsConversionMismatchExceptionTest.fail((String)"should throw NullPointerException.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void test_getFlags() {
        String flags = "MYTESTFLAGS";
        char conversion = 'T';
        FormatFlagsConversionMismatchException formatFlagsConversionMismatchException = new FormatFlagsConversionMismatchException(flags, conversion);
        FormatFlagsConversionMismatchExceptionTest.assertEquals((String)flags, (String)formatFlagsConversionMismatchException.getFlags());
    }

    public void test_getConversion() {
        String flags = "MYTESTFLAGS";
        char conversion = 'T';
        FormatFlagsConversionMismatchException formatFlagsConversionMismatchException = new FormatFlagsConversionMismatchException(flags, conversion);
        FormatFlagsConversionMismatchExceptionTest.assertEquals((char)conversion, (char)formatFlagsConversionMismatchException.getConversion());
    }

    public void test_getMessage() {
        String flags = "MYTESTFLAGS";
        char conversion = 'T';
        FormatFlagsConversionMismatchException formatFlagsConversionMismatchException = new FormatFlagsConversionMismatchException(flags, conversion);
        FormatFlagsConversionMismatchExceptionTest.assertTrue((null != formatFlagsConversionMismatchException.getMessage() ? 1 : 0) != 0);
    }

    public void testSerializationSelf() throws Exception {
        SerializationTest.verifySelf(new FormatFlagsConversionMismatchException("MYTESTFLAGS", 'T'), exComparator);
    }

    public void testSerializationCompatibility() throws Exception {
        SerializationTest.verifyGolden((TestCase)this, new FormatFlagsConversionMismatchException("MYTESTFLAGS", 'T'), exComparator);
    }
}

