/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.tests.java.util;

import java.io.Serializable;
import java.util.DuplicateFormatFlagsException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.harmony.testframework.serialization.SerializationTest;

public class DuplicateFormatFlagsExceptionTest
extends TestCase {
    private static final SerializationTest.SerializableAssert exComparator = new SerializationTest.SerializableAssert(){

        public void assertDeserialized(Serializable initial, Serializable deserialized) {
            SerializationTest.THROWABLE_COMPARATOR.assertDeserialized(initial, deserialized);
            DuplicateFormatFlagsException initEx = (DuplicateFormatFlagsException)initial;
            DuplicateFormatFlagsException desrEx = (DuplicateFormatFlagsException)deserialized;
            Assert.assertEquals((String)"Flags", (String)initEx.getFlags(), (String)desrEx.getFlags());
        }
    };

    public void test_duplicateFormatFlagsException() {
        try {
            new DuplicateFormatFlagsException(null);
            DuplicateFormatFlagsExceptionTest.fail((String)"should throw NullPointerException.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void test_getFlags() {
        String strFlags = "MYTESTFLAGS";
        DuplicateFormatFlagsException duplicateFormatException = new DuplicateFormatFlagsException(strFlags);
        DuplicateFormatFlagsExceptionTest.assertEquals((String)strFlags, (String)duplicateFormatException.getFlags());
    }

    public void test_getMessage() {
        String strFlags = "MYTESTFLAGS";
        DuplicateFormatFlagsException duplicateFormatException = new DuplicateFormatFlagsException(strFlags);
        DuplicateFormatFlagsExceptionTest.assertTrue((null != duplicateFormatException.getFlags() ? 1 : 0) != 0);
    }

    public void testSerializationSelf() throws Exception {
        SerializationTest.verifySelf(new DuplicateFormatFlagsException("TESTDESC"), exComparator);
    }

    public void testSerializationCompatibility() throws Exception {
        SerializationTest.verifyGolden((TestCase)this, new DuplicateFormatFlagsException("TESTDESC"), exComparator);
    }
}

