/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.tests.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.harmony.testframework.serialization.SerializationTest;
import tests.util.SerializationTester;

@TestTargetClass(value=Collections.class)
public class CollectionsTest
extends TestCase {
    private static final SerializationTest.SerializableAssert comparator = new SerializationTest.SerializableAssert(){

        public void assertDeserialized(Serializable reference, Serializable test) {
            Assert.assertSame((Object)reference, (Object)test);
        }
    };

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="binarySearch", args={List.class, Object.class, Comparator.class})
    public void test_binarySearchLjava_util_ListLjava_lang_ObjectLjava_util_Comparator() {
        LinkedList<Integer> lst = new LinkedList<Integer>();
        lst.add(new Integer(30));
        Collections.sort(lst, null);
        int index = Collections.binarySearch(lst, new Integer(2), null);
        CollectionsTest.assertEquals((int)-1, (int)index);
        LinkedList<String> lls = new LinkedList<String>();
        lls.add("1");
        lls.add("2");
        lls.add("3");
        lls.add("4");
        lls.add("");
        LinkedList<String> ll = lls;
        try {
            Collections.binarySearch(ll, new Integer(10), null);
            CollectionsTest.fail((String)"ClassCastException expected");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="binarySearch", args={List.class, Object.class})
    public void test_binarySearchLjava_util_ListLjava_lang_Object() {
        LinkedList<Object> localList = new LinkedList<Object>();
        CollectionsTest.assertEquals((int)-1, (int)Collections.binarySearch(localList, new Object()));
        localList.add(new Object());
        try {
            Collections.binarySearch(localList, new Integer(1));
            CollectionsTest.fail((String)"Should throw ClassCastException");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        LinkedList<String> lls = new LinkedList<String>();
        lls.add("1");
        lls.add("2");
        lls.add("3");
        lls.add("4");
        lls.add("");
        LinkedList<String> ll = lls;
        try {
            Collections.binarySearch(ll, new Integer(10));
            CollectionsTest.fail((String)"ClassCastException expected");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="UnsupportedOperationException is not tested.", method="rotate", args={List.class, int.class})
    public void test_rotateLjava_util_ListI() {
        Collections.rotate(new ArrayList(), 25);
        ArrayList<String> list = new ArrayList<String>();
        list.add(0, "zero");
        list.add(1, "one");
        list.add(2, "two");
        list.add(3, "three");
        list.add(4, "four");
        Collections.rotate(list, Integer.MIN_VALUE);
        CollectionsTest.assertEquals((String)"Rotated incorrectly at position 0, ", (String)"three", (String)((String)list.get(0)));
        CollectionsTest.assertEquals((String)"Rotated incorrectly at position 1, ", (String)"four", (String)((String)list.get(1)));
        CollectionsTest.assertEquals((String)"Rotated incorrectly at position 2, ", (String)"zero", (String)((String)list.get(2)));
        CollectionsTest.assertEquals((String)"Rotated incorrectly at position 3, ", (String)"one", (String)((String)list.get(3)));
        CollectionsTest.assertEquals((String)"Rotated incorrectly at position 4, ", (String)"two", (String)((String)list.get(4)));
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies NullPointerException.", method="synchronizedCollection", args={Collection.class})
    public void test_synchronizedCollectionLjava_util_Collection() {
        try {
            Collections.synchronizedCollection(null);
            CollectionsTest.fail((String)"Assert 0: synchronizedCollection(null) must throw NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies NullPointerException.", method="synchronizedSortedMap", args={SortedMap.class})
    public void test_synchronizedSortedMapLjava_util_SortedMap() {
        try {
            Collections.synchronizedSortedMap(null);
            CollectionsTest.fail((String)"Assert 0: synchronizedSortedMap(null) must throw NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies NullPointerException.", method="synchronizedMap", args={Map.class})
    public void test_synchronizedMapLjava_util_Map() {
        try {
            Collections.synchronizedMap(null);
            CollectionsTest.fail((String)"Assert 0: synchronizedMap(map) must throw NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies NullPointerException.", method="synchronizedSet", args={Set.class})
    public void test_synchronizedSetLjava_util_Set() {
        try {
            Collections.synchronizedSet(null);
            CollectionsTest.fail((String)"Assert 0: synchronizedSet(set) must throw NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies NullPointerException.", method="synchronizedSortedSet", args={SortedSet.class})
    public void test_synchronizedSortedSetLjava_util_SortedSet() {
        try {
            Collections.synchronizedSortedSet(null);
            CollectionsTest.fail((String)"Assert 0: synchronizedSortedSet(null) must throw NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies NullPointerException.", method="unmodifiableCollection", args={Collection.class})
    public void test_unmodifiableCollectionLjava_util_Collection() {
        try {
            Collections.unmodifiableCollection(null);
            CollectionsTest.fail((String)"Assert 0: unmodifiableCollection(null) must throw NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies NullPointerException.", method="unmodifiableMap", args={Map.class})
    public void test_unmodifiableMapLjava_util_Map() {
        try {
            Collections.unmodifiableMap(null);
            CollectionsTest.fail((String)"Assert 0: unmodifiableMap(null) must throw NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies NullPointerException.", method="unmodifiableSet", args={Set.class})
    public void test_unmodifiableSetLjava_util_Set() {
        try {
            Collections.unmodifiableSet(null);
            CollectionsTest.fail((String)"Assert 0: unmodifiableSet(null) must throw NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies NullPointerException.", method="unmodifiableSortedMap", args={SortedMap.class})
    public void test_unmodifiableSortedMapLjava_util_SortedMap() {
        try {
            Collections.unmodifiableSortedMap(null);
            CollectionsTest.fail((String)"Assert 0: unmodifiableSortedMap(null) must throw NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="Verifies NullPointerException.", method="unmodifiableSortedSet", args={SortedSet.class})
    public void test_unmodifiableSortedSetLjava_util_SortedSet() {
        try {
            Collections.unmodifiableSortedSet(null);
            CollectionsTest.fail((String)"Assert 0: unmodifiableSortedSet(null) must throw NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="frequency", args={Collection.class, Object.class})
    public void test_frequencyLjava_util_CollectionLint() {
        try {
            Collections.frequency(null, null);
            CollectionsTest.fail((String)"Assert 0: frequency(null,<any>) must throw NPE");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        List<String> strings = Arrays.asList("1", "2", "3", "1", "1");
        CollectionsTest.assertEquals((String)"Assert 1: did not find three \"1\" strings", (int)3, (int)Collections.frequency(strings, "1"));
        CollectionsTest.assertEquals((String)"Assert 2: did not find one \"2\" strings", (int)1, (int)Collections.frequency(strings, "2"));
        CollectionsTest.assertEquals((String)"Assert 3: did not find three \"3\" strings", (int)1, (int)Collections.frequency(strings, "3"));
        CollectionsTest.assertEquals((String)"Assert 4: matched on null when there are none", (int)0, (int)Collections.frequency(strings, null));
        List<Object> objects = Arrays.asList(new Integer(1), null, null, new Long(1L));
        CollectionsTest.assertEquals((String)"Assert 5: did not find one Integer(1)", (int)1, (int)Collections.frequency(objects, new Integer(1)));
        CollectionsTest.assertEquals((String)"Assert 6: did not find one Long(1)", (int)1, (int)Collections.frequency(objects, new Long(1L)));
        CollectionsTest.assertEquals((String)"Assert 7: did not find two null references", (int)2, (int)Collections.frequency(objects, null));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="reverseOrder", args={})
    public void test_reverseOrder() {
        Comparator roc = Collections.reverseOrder();
        CollectionsTest.assertNotNull((String)"Assert 0: comparator must not be null", roc);
        CollectionsTest.assertTrue((String)"Assert 1: comparator must implement Serializable", (boolean)(roc instanceof Serializable));
        Object[] fixtureDesc = new String[]{"2", "1", "0"};
        Object[] numbers = new String[]{"0", "1", "2"};
        Arrays.sort(numbers, roc);
        CollectionsTest.assertTrue((String)"Assert 2: the arrays are not equal, the sort failed", (boolean)Arrays.equals(fixtureDesc, numbers));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="reverseOrder", args={Comparator.class})
    public void test_reverseOrderLjava_util_Comparator() {
        Comparator roc = Collections.reverseOrder(String.CASE_INSENSITIVE_ORDER);
        CollectionsTest.assertNotNull((String)"Assert 0: comparator must not be null", roc);
        CollectionsTest.assertTrue((String)"Assert 1: comparator must implement Serializable", (boolean)(roc instanceof Serializable));
        Object[] fixtureDesc = new String[]{"2", "1", "0"};
        Object[] numbers = new String[]{"0", "1", "2"};
        Arrays.sort(numbers, roc);
        CollectionsTest.assertTrue((String)"Assert 2: the arrays are not equal, the sort failed", (boolean)Arrays.equals(fixtureDesc, numbers));
        roc = Collections.reverseOrder(null);
        CollectionsTest.assertNotNull((String)"Assert 3: comparator must not be null", roc);
        CollectionsTest.assertTrue((String)"Assert 4: comparator must implement Serializable", (boolean)(roc instanceof Serializable));
        numbers = new String[]{"0", "1", "2"};
        Arrays.sort(numbers, roc);
        CollectionsTest.assertTrue((String)"Assert 5: the arrays are not equal, the sort failed", (boolean)Arrays.equals(fixtureDesc, numbers));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="addAll", args={Collection.class, Object[].class})
    public void test_AddAll() {
        ArrayList l = new ArrayList();
        CollectionsTest.assertFalse((boolean)Collections.addAll(l, new Object[0]));
        CollectionsTest.assertTrue((boolean)l.isEmpty());
        CollectionsTest.assertTrue((boolean)Collections.addAll(l, new Integer(1), new Integer(2), new Integer(3)));
        CollectionsTest.assertFalse((boolean)l.isEmpty());
        CollectionsTest.assertTrue((boolean)((Object)l).equals(Arrays.asList(new Integer(1), new Integer(2), new Integer(3))));
        try {
            Collections.addAll(null, new Integer(1), new Integer(2), new Integer(3));
            CollectionsTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        Collection c = new Mock_Collection();
        try {
            Collections.addAll(c, new Integer(1), new Integer(2), new Integer(3));
            CollectionsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        c = new Mock_WrongCollection();
        try {
            Collections.addAll(c, "String", "Correct element", null);
            CollectionsTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Collections.addAll(c, "String", "Wrong element", "Correct element");
            CollectionsTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Collections.addAll(c, "String", "", "Correct element");
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="disjoint", args={Collection.class, Collection.class})
    public void test_Disjoint() {
        Object[] arr1 = new Object[10];
        for (int i = 0; i < arr1.length; ++i) {
            arr1[i] = new Integer(i);
        }
        Object[] arr2 = new Object[20];
        for (int i = 0; i < arr2.length; ++i) {
            arr2[i] = new Integer(100 + i);
        }
        AbstractCollection c1 = new ArrayList<Object>();
        AbstractCollection c2 = new ArrayList();
        Collections.addAll(c1, arr1);
        Collections.addAll(c2, arr2);
        CollectionsTest.assertTrue((boolean)Collections.disjoint(c1, c2));
        c1.add(arr2[10]);
        CollectionsTest.assertFalse((boolean)Collections.disjoint(c1, c2));
        c1 = new LinkedList();
        c2 = new LinkedList();
        Collections.addAll(c1, arr1);
        Collections.addAll(c2, arr2);
        CollectionsTest.assertTrue((boolean)Collections.disjoint(c1, c2));
        c1.add(arr2[10]);
        CollectionsTest.assertFalse((boolean)Collections.disjoint(c1, c2));
        c1 = new TreeSet();
        c2 = new TreeSet();
        Collections.addAll(c1, arr1);
        Collections.addAll(c2, arr2);
        CollectionsTest.assertTrue((boolean)Collections.disjoint(c1, c2));
        c1.add(arr2[10]);
        CollectionsTest.assertFalse((boolean)Collections.disjoint(c1, c2));
        c1 = new HashSet();
        c2 = new HashSet();
        Collections.addAll(c1, arr1);
        Collections.addAll(c2, arr2);
        CollectionsTest.assertTrue((boolean)Collections.disjoint(c1, c2));
        c1.add(arr2[10]);
        CollectionsTest.assertFalse((boolean)Collections.disjoint(c1, c2));
        c1 = new LinkedList();
        c2 = new TreeSet();
        Collections.addAll(c1, arr1);
        Collections.addAll(c2, arr2);
        CollectionsTest.assertTrue((boolean)Collections.disjoint(c1, c2));
        c1.add(arr2[10]);
        CollectionsTest.assertFalse((boolean)Collections.disjoint(c1, c2));
        c1 = new Vector();
        c2 = new HashSet();
        Collections.addAll(c1, arr1);
        Collections.addAll(c2, arr2);
        CollectionsTest.assertTrue((boolean)Collections.disjoint(c1, c2));
        c1.add(arr2[10]);
        CollectionsTest.assertFalse((boolean)Collections.disjoint(c1, c2));
        try {
            Collections.disjoint(c1, null);
            CollectionsTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Collections.disjoint(null, c2);
            CollectionsTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="", method="!SerializationSelf", args={})
    public void test_EmptyList_readResolve() throws Exception {
        SerializationTest.verifySelf(Collections.EMPTY_LIST, comparator);
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="", method="!SerializationSelf", args={})
    public void test_EmptyMap_readResolve() throws Exception {
        SerializationTest.verifySelf(Collections.EMPTY_MAP, comparator);
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="", method="!SerializationSelf", args={})
    public void test_EmptySet_readResolve() throws Exception {
        SerializationTest.verifySelf(Collections.EMPTY_SET, comparator);
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="", method="!SerializationGolden", args={})
    public void test_checkedCollectionSerializationCompatability() throws Exception {
        Collection<Object> c = Collections.emptySet();
        c = Collections.checkedCollection(c, String.class);
        SerializationTester.assertCompabilityEquals(c, "/serialization/org/apache/harmony/luni/tests/java/util/Collections_CheckedCollection.golden.ser");
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="", method="!SerializationGolden", args={})
    public void test_checkedListRandomAccessSerializationCompatability() throws Exception {
        List<Object> c = new ArrayList();
        CollectionsTest.assertTrue((boolean)(c instanceof RandomAccess));
        c = Collections.checkedList(c, String.class);
        SerializationTester.assertCompabilityEquals(c, "/serialization/org/apache/harmony/luni/tests/java/util/Collections_CheckedListRandomAccess.golden.ser");
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="", method="!SerializationGolden", args={})
    public void test_checkedListSerializationCompatability() throws Exception {
        List<Object> c = new LinkedList();
        CollectionsTest.assertFalse((boolean)(c instanceof RandomAccess));
        c = Collections.checkedList(c, String.class);
        SerializationTester.assertCompabilityEquals(c, "/serialization/org/apache/harmony/luni/tests/java/util/Collections_CheckedList.golden.ser");
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="", method="!SerializationGolden", args={})
    public void test_checkedSetSerializationCompatability() throws Exception {
        Set<Object> c = new HashSet();
        CollectionsTest.assertFalse((boolean)(c instanceof SortedSet));
        c = Collections.checkedSet(c, String.class);
        SerializationTester.assertCompabilityEquals(c, "/serialization/org/apache/harmony/luni/tests/java/util/Collections_CheckedSet.golden.ser");
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="", method="!SerializationGolden", args={})
    public void test_checkedMapSerializationCompatability() throws Exception {
        Map<Object, Object> c = new HashMap();
        CollectionsTest.assertFalse((boolean)(c instanceof SortedMap));
        c = Collections.checkedMap(c, String.class, String.class);
        SerializationTester.assertCompabilityEquals(c, "/serialization/org/apache/harmony/luni/tests/java/util/Collections_CheckedMap.golden.ser");
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="", method="!SerializationGolden", args={})
    public void test_checkedSortedSetSerializationCompatability() throws Exception {
        SortedSet<Object> c = new TreeSet();
        c = Collections.checkedSortedSet(c, String.class);
        SerializationTester.assertCompabilityEquals(c, "/serialization/org/apache/harmony/luni/tests/java/util/Collections_CheckedSortedSet.golden.ser");
    }

    @TestTargetNew(level=TestLevel.PARTIAL_COMPLETE, notes="", method="!SerializationGolden", args={})
    public void test_checkedSortedMapSerializationCompatability() throws Exception {
        SortedMap<Object, Object> c = new TreeMap();
        c = Collections.checkedSortedMap(c, String.class, String.class);
        SerializationTester.assertCompabilityEquals(c, "/serialization/org/apache/harmony/luni/tests/java/util/Collections_CheckedSortedMap.golden.ser");
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="checkedCollection", args={Collection.class, Class.class})
    public void test_checkedCollectionLjava_util_CollectionLjava_lang_Class() {
        ArrayList al = new ArrayList();
        Collection<Integer> c = Collections.checkedCollection(al, Integer.class);
        c.add(new Integer(1));
        try {
            c.add((Integer)((Object)new Double(3.14)));
            CollectionsTest.fail((String)"ClassCastException expected");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="checkedList", args={List.class, Class.class})
    public void test_checkedListLjava_util_ListLjava_lang_Class() {
        ArrayList al = new ArrayList();
        List<Integer> l = Collections.checkedList(al, Integer.class);
        l.add(new Integer(1));
        try {
            l.add((Integer)((Object)new Double(3.14)));
            CollectionsTest.fail((String)"ClassCastException expected");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="checkedMap", args={Map.class, Class.class, Class.class})
    public void test_checkedMapLjava_util_MapLjava_lang_ClassLjava_lang_Class() {
        HashMap hm = new HashMap();
        Map<Integer, String> m = Collections.checkedMap(hm, Integer.class, String.class);
        m.put(1, "one");
        m.put(2, "two");
        try {
            m.put((Integer)((Object)"wron key"), null);
            CollectionsTest.fail((String)"ClassCastException expected");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        try {
            m.put(3, (String)((Object)new Double(3.14)));
            CollectionsTest.fail((String)"ClassCastException expected");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="checkedSet", args={Set.class, Class.class})
    public void test_checkedSetLjava_util_SetLjava_lang_Class() {
        HashSet hs = new HashSet();
        Set<Integer> s = Collections.checkedSet(hs, Integer.class);
        s.add(new Integer(1));
        try {
            s.add((Integer)((Object)new Double(3.14)));
            CollectionsTest.fail((String)"ClassCastException expected");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="checkedSortedMap", args={SortedMap.class, Class.class, Class.class})
    public void test_checkedSortedMapLjava_util_SortedMapLjava_lang_ClassLjava_lang_Class() {
        TreeMap tm = new TreeMap();
        SortedMap<Integer, String> sm = Collections.checkedSortedMap(tm, Integer.class, String.class);
        sm.put(1, "one");
        sm.put(2, "two");
        try {
            sm.put((Integer)((Object)"wron key"), null);
            CollectionsTest.fail((String)"ClassCastException expected");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        try {
            sm.put(3, (String)((Object)new Double(3.14)));
            CollectionsTest.fail((String)"ClassCastException expected");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="checkedSortedSet", args={SortedSet.class, Class.class})
    public void test_checkedSortedSetLjava_util_SortedSetLjava_lang_Class() {
        TreeSet ts = new TreeSet();
        SortedSet<Integer> ss = Collections.checkedSortedSet(ts, Integer.class);
        ss.add(new Integer(1));
        try {
            ss.add((Integer)((Object)new Double(3.14)));
            CollectionsTest.fail((String)"ClassCastException expected");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="emptyList", args={})
    public void test_emptyList() {
        List ls = Collections.emptyList();
        List li = Collections.emptyList();
        CollectionsTest.assertTrue((boolean)((Object)ls).equals(li));
        CollectionsTest.assertTrue((boolean)((Object)li).equals(Collections.EMPTY_LIST));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="emptyMap", args={})
    public void test_emptyMap() {
        Map mis = Collections.emptyMap();
        Map msi = Collections.emptyMap();
        CollectionsTest.assertTrue((boolean)((Object)mis).equals(msi));
        CollectionsTest.assertTrue((boolean)((Object)msi).equals(Collections.EMPTY_MAP));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="emptySet", args={})
    public void test_emptySet() {
        Set ss = Collections.emptySet();
        Set si = Collections.emptySet();
        CollectionsTest.assertTrue((boolean)((Object)ss).equals(si));
        CollectionsTest.assertTrue((boolean)((Object)si).equals(Collections.EMPTY_SET));
    }

    class Mock_WrongCollection
    implements Collection {
        final String wrongElement = "Wrong element";

        Mock_WrongCollection() {
        }

        public boolean add(Object o) {
            if (o.equals("Wrong element")) {
                throw new IllegalArgumentException();
            }
            if (o == null) {
                throw new NullPointerException();
            }
            return false;
        }

        public boolean addAll(Collection c) {
            return false;
        }

        public void clear() {
        }

        public boolean contains(Object o) {
            return false;
        }

        public boolean containsAll(Collection c) {
            return false;
        }

        public boolean isEmpty() {
            return false;
        }

        public Iterator iterator() {
            return null;
        }

        public boolean remove(Object o) {
            return false;
        }

        public boolean removeAll(Collection c) {
            return false;
        }

        public boolean retainAll(Collection c) {
            return false;
        }

        public int size() {
            return 0;
        }

        public Object[] toArray() {
            return null;
        }

        public Object[] toArray(Object[] a) {
            return null;
        }
    }

    class Mock_Collection
    implements Collection {
        Mock_Collection() {
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            return false;
        }

        public void clear() {
        }

        public boolean contains(Object o) {
            return false;
        }

        public boolean containsAll(Collection c) {
            return false;
        }

        public boolean isEmpty() {
            return false;
        }

        public Iterator iterator() {
            return null;
        }

        public boolean remove(Object o) {
            return false;
        }

        public boolean removeAll(Collection c) {
            return false;
        }

        public boolean retainAll(Collection c) {
            return false;
        }

        public int size() {
            return 0;
        }

        public Object[] toArray() {
            return null;
        }

        public Object[] toArray(Object[] a) {
            return null;
        }
    }
}

