/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.tests.java.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import tests.support.Support_UnmodifiableCollectionTest;

public class ArraysTest
extends TestCase {
    static final int arraySize = 100;
    static Object[] objArray;
    static boolean[] booleanArray;
    static byte[] byteArray;
    static char[] charArray;
    static double[] doubleArray;
    static float[] floatArray;
    static int[] intArray;
    static long[] longArray;
    static Object[] objectArray;
    static short[] shortArray;

    public ArraysTest() {
        objArray = new Object[100];
        for (int i = 0; i < objArray.length; ++i) {
            ArraysTest.objArray[i] = new Integer(i);
        }
    }

    public void test_asList$Ljava_lang_Object() {
        List<Object> convertedList = Arrays.asList(objectArray);
        for (int counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Array and List converted from array do not contain identical elements", (convertedList.get(counter) == objectArray[counter] ? 1 : 0) != 0);
        }
        convertedList.set(50, new Integer(1000));
        ArraysTest.assertTrue((String)"set/get did not work on coverted list", (boolean)convertedList.get(50).equals(new Integer(1000)));
        convertedList.set(50, new Integer(50));
        new Support_UnmodifiableCollectionTest("", convertedList).runTest();
        Object[] myArray = (Object[])objectArray.clone();
        myArray[30] = null;
        myArray[60] = null;
        convertedList = Arrays.asList(myArray);
        for (int counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Array and List converted from array do not contain identical elements", (convertedList.get(counter) == myArray[counter] ? 1 : 0) != 0);
        }
        try {
            Arrays.asList(null);
            ArraysTest.fail((String)"asList with null arg didn't throw NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void test_binarySearch$BB() {
        int counter;
        for (counter = 0; counter < 100; counter = (int)((byte)(counter + 1))) {
            ArraysTest.assertTrue((String)"Binary search on byte[] answered incorrect position", (Arrays.binarySearch(byteArray, (byte)counter) == counter ? 1 : 0) != 0);
        }
        ArraysTest.assertEquals((String)"Binary search succeeded for value not present in array 1", (int)-1, (int)Arrays.binarySearch(intArray, -1));
        ArraysTest.assertTrue((String)"Binary search succeeded for value not present in array 2", (Arrays.binarySearch(intArray, 100) == -101 ? 1 : 0) != 0);
        for (counter = 0; counter < 100; counter = (int)((byte)(counter + 1))) {
            int n = counter;
            byteArray[n] = (byte)(byteArray[n] - 50);
        }
        for (counter = 0; counter < 100; counter = (int)((byte)(counter + 1))) {
            ArraysTest.assertTrue((String)"Binary search on byte[] involving negative numbers answered incorrect position", (Arrays.binarySearch(byteArray, (byte)(counter - 50)) == counter ? 1 : 0) != 0);
        }
    }

    public void test_binarySearch$CC() {
        for (int counter = 0; counter < 100; counter = (int)((char)(counter + 1))) {
            ArraysTest.assertTrue((String)"Binary search on char[] answered incorrect position", (Arrays.binarySearch(charArray, (char)(counter + 1)) == counter ? 1 : 0) != 0);
        }
        ArraysTest.assertEquals((String)"Binary search succeeded for value not present in array 1", (int)-1, (int)Arrays.binarySearch(charArray, '\u0000'));
        ArraysTest.assertTrue((String)"Binary search succeeded for value not present in array 2", (Arrays.binarySearch(charArray, 'e') == -101 ? 1 : 0) != 0);
    }

    public void test_binarySearch$DD() {
        int counter;
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Binary search on double[] answered incorrect position", ((double)Arrays.binarySearch(doubleArray, (double)counter) == (double)counter ? 1 : 0) != 0);
        }
        ArraysTest.assertEquals((String)"Binary search succeeded for value not present in array 1", (int)-1, (int)Arrays.binarySearch(doubleArray, -1.0));
        ArraysTest.assertTrue((String)"Binary search succeeded for value not present in array 2", (Arrays.binarySearch(doubleArray, 100.0) == -101 ? 1 : 0) != 0);
        counter = 0;
        while (counter < 100) {
            int n = counter++;
            doubleArray[n] = doubleArray[n] - 50.0;
        }
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Binary search on double[] involving negative numbers answered incorrect position", ((double)Arrays.binarySearch(doubleArray, (double)(counter - 50)) == (double)counter ? 1 : 0) != 0);
        }
        double[] specials = new double[]{Double.NEGATIVE_INFINITY, -1.7976931348623157E308, -2.0, -4.9E-324, -0.0, 0.0, Double.MIN_VALUE, 2.0, Double.MAX_VALUE, Double.POSITIVE_INFINITY, Double.NaN};
        for (int i = 0; i < specials.length; ++i) {
            int result = Arrays.binarySearch(specials, specials[i]);
            ArraysTest.assertTrue((String)(specials[i] + " invalid: " + result), (result == i ? 1 : 0) != 0);
        }
        ArraysTest.assertEquals((String)"-1d", (int)-4, (int)Arrays.binarySearch(specials, -1.0));
        ArraysTest.assertEquals((String)"1d", (int)-8, (int)Arrays.binarySearch(specials, 1.0));
    }

    public void test_binarySearch$FF() {
        int counter;
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Binary search on float[] answered incorrect position", ((float)Arrays.binarySearch(floatArray, (float)counter) == (float)counter ? 1 : 0) != 0);
        }
        ArraysTest.assertEquals((String)"Binary search succeeded for value not present in array 1", (int)-1, (int)Arrays.binarySearch(floatArray, -1.0f));
        ArraysTest.assertTrue((String)"Binary search succeeded for value not present in array 2", (Arrays.binarySearch(floatArray, 100.0f) == -101 ? 1 : 0) != 0);
        counter = 0;
        while (counter < 100) {
            int n = counter++;
            floatArray[n] = floatArray[n] - 50.0f;
        }
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Binary search on float[] involving negative numbers answered incorrect position", ((float)Arrays.binarySearch(floatArray, (float)counter - 50.0f) == (float)counter ? 1 : 0) != 0);
        }
        float[] specials = new float[]{Float.NEGATIVE_INFINITY, -3.4028235E38f, -2.0f, -1.4E-45f, -0.0f, 0.0f, Float.MIN_VALUE, 2.0f, Float.MAX_VALUE, Float.POSITIVE_INFINITY, Float.NaN};
        for (int i = 0; i < specials.length; ++i) {
            int result = Arrays.binarySearch(specials, specials[i]);
            ArraysTest.assertTrue((String)(specials[i] + " invalid: " + result), (result == i ? 1 : 0) != 0);
        }
        ArraysTest.assertEquals((String)"-1f", (int)-4, (int)Arrays.binarySearch(specials, -1.0f));
        ArraysTest.assertEquals((String)"1f", (int)-8, (int)Arrays.binarySearch(specials, 1.0f));
    }

    public void test_binarySearch$II() {
        int counter;
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Binary search on int[] answered incorrect position", (Arrays.binarySearch(intArray, counter) == counter ? 1 : 0) != 0);
        }
        ArraysTest.assertEquals((String)"Binary search succeeded for value not present in array 1", (int)-1, (int)Arrays.binarySearch(intArray, -1));
        ArraysTest.assertTrue((String)"Binary search succeeded for value not present in array 2", (Arrays.binarySearch(intArray, 100) == -101 ? 1 : 0) != 0);
        counter = 0;
        while (counter < 100) {
            int n = counter++;
            intArray[n] = intArray[n] - 50;
        }
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Binary search on int[] involving negative numbers answered incorrect position", (Arrays.binarySearch(intArray, counter - 50) == counter ? 1 : 0) != 0);
        }
    }

    public void test_binarySearch$JJ() {
        long counter;
        for (counter = 0L; counter < 100L; ++counter) {
            ArraysTest.assertTrue((String)"Binary search on long[] answered incorrect position", ((long)Arrays.binarySearch(longArray, counter) == counter ? 1 : 0) != 0);
        }
        ArraysTest.assertEquals((String)"Binary search succeeded for value not present in array 1", (int)-1, (int)Arrays.binarySearch(longArray, -1L));
        ArraysTest.assertTrue((String)"Binary search succeeded for value not present in array 2", (Arrays.binarySearch(longArray, 100L) == -101 ? 1 : 0) != 0);
        for (counter = 0L; counter < 100L; ++counter) {
            int n = (int)counter;
            longArray[n] = longArray[n] - 50L;
        }
        for (counter = 0L; counter < 100L; ++counter) {
            ArraysTest.assertTrue((String)"Binary search on long[] involving negative numbers answered incorrect position", ((long)Arrays.binarySearch(longArray, counter - 50L) == counter ? 1 : 0) != 0);
        }
    }

    public void test_binarySearch$Ljava_lang_ObjectLjava_lang_Object() {
        ArraysTest.assertEquals((String)"Binary search succeeded for non-comparable value in empty array", (int)-1, (int)Arrays.binarySearch(new Object[0], new Object()));
        ArraysTest.assertEquals((String)"Binary search succeeded for comparable value in empty array", (int)-1, (int)Arrays.binarySearch(new Object[0], new Integer(-1)));
        for (int counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Binary search on Object[] answered incorrect position", (Arrays.binarySearch(objectArray, objArray[counter]) == counter ? 1 : 0) != 0);
        }
        ArraysTest.assertEquals((String)"Binary search succeeded for value not present in array 1", (int)-1, (int)Arrays.binarySearch(objectArray, new Integer(-1)));
        ArraysTest.assertTrue((String)"Binary search succeeded for value not present in array 2", (Arrays.binarySearch(objectArray, new Integer(100)) == -101 ? 1 : 0) != 0);
        Object object = new Object();
        Object[] objects = new MockComparable[]{new MockComparable()};
        ArraysTest.assertEquals((String)"Should always return 0", (int)0, (int)Arrays.binarySearch(objects, object));
        Object[] string_objects = new String[]{"one"};
        try {
            Arrays.binarySearch(string_objects, object);
            ArraysTest.fail((String)"No expected ClassCastException");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
    }

    public void test_binarySearch$Ljava_lang_ObjectLjava_lang_ObjectLjava_util_Comparator() {
        int counter;
        ReversedIntegerComparator comp = new ReversedIntegerComparator();
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.objectArray[counter] = objArray[100 - counter - 1];
        }
        ArraysTest.assertTrue((String)"Binary search succeeded for value not present in array 1", (Arrays.binarySearch(objectArray, new Integer(-1), comp) == -101 ? 1 : 0) != 0);
        ArraysTest.assertEquals((String)"Binary search succeeded for value not present in array 2", (int)-1, (int)Arrays.binarySearch(objectArray, new Integer(100), comp));
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Binary search on Object[] with custom comparator answered incorrect position", (Arrays.binarySearch(objectArray, objArray[counter], comp) == 100 - counter - 1 ? 1 : 0) != 0);
        }
    }

    public void test_binarySearch$SS() {
        int counter;
        for (counter = 0; counter < 100; counter = (int)((short)(counter + 1))) {
            ArraysTest.assertTrue((String)"Binary search on short[] answered incorrect position", (Arrays.binarySearch(shortArray, (short)counter) == counter ? 1 : 0) != 0);
        }
        ArraysTest.assertEquals((String)"Binary search succeeded for value not present in array 1", (int)-1, (int)Arrays.binarySearch(intArray, -1));
        ArraysTest.assertTrue((String)"Binary search succeeded for value not present in array 2", (Arrays.binarySearch(intArray, 100) == -101 ? 1 : 0) != 0);
        for (counter = 0; counter < 100; counter = (int)((short)(counter + 1))) {
            int n = counter;
            shortArray[n] = (short)(shortArray[n] - 50);
        }
        for (counter = 0; counter < 100; counter = (int)((short)(counter + 1))) {
            ArraysTest.assertTrue((String)"Binary search on short[] involving negative numbers answered incorrect position", (Arrays.binarySearch(shortArray, (short)(counter - 50)) == counter ? 1 : 0) != 0);
        }
    }

    public void test_fill$BB() {
        byte[] d = new byte[1000];
        Arrays.fill(d, (byte)127);
        for (int i = 0; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill byte array correctly", (d[i] == 127 ? 1 : 0) != 0);
        }
    }

    public void test_fill$BIIB() {
        int result;
        int i;
        byte val = 127;
        byte[] d = new byte[1000];
        Arrays.fill(d, 400, d.length, val);
        for (i = 0; i < 400; ++i) {
            ArraysTest.assertTrue((String)"Filled elements not in range", (d[i] != val ? 1 : 0) != 0);
        }
        for (i = 400; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill byte array correctly", (d[i] == val ? 1 : 0) != 0);
        }
        try {
            Arrays.fill(new byte[2], 2, 1, (byte)27);
            result = 0;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            result = 1;
        }
        catch (IllegalArgumentException e) {
            result = 2;
        }
        ArraysTest.assertEquals((String)"Wrong exception1", (int)2, (int)result);
        try {
            Arrays.fill(new byte[2], -1, 1, (byte)27);
            result = 0;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            result = 1;
        }
        catch (IllegalArgumentException e) {
            result = 2;
        }
        ArraysTest.assertEquals((String)"Wrong exception2", (int)1, (int)result);
        try {
            Arrays.fill(new byte[2], 1, 4, (byte)27);
            result = 0;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            result = 1;
        }
        catch (IllegalArgumentException e) {
            result = 2;
        }
        ArraysTest.assertEquals((String)"Wrong exception", (int)1, (int)result);
    }

    public void test_fill$SS() {
        short[] d = new short[1000];
        Arrays.fill(d, (short)Short.MAX_VALUE);
        for (int i = 0; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill short array correctly", (d[i] == Short.MAX_VALUE ? 1 : 0) != 0);
        }
    }

    public void test_fill$SIIS() {
        int i;
        short val = Short.MAX_VALUE;
        short[] d = new short[1000];
        Arrays.fill(d, 400, d.length, val);
        for (i = 0; i < 400; ++i) {
            ArraysTest.assertTrue((String)"Filled elements not in range", (d[i] != val ? 1 : 0) != 0);
        }
        for (i = 400; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill short array correctly", (d[i] == val ? 1 : 0) != 0);
        }
    }

    public void test_fill$CC() {
        char[] d = new char[1000];
        Arrays.fill(d, 'V');
        for (int i = 0; i < d.length; ++i) {
            ArraysTest.assertEquals((String)"Failed to fill char array correctly", (char)'V', (char)d[i]);
        }
    }

    public void test_fill$CIIC() {
        int i;
        char val = 'T';
        char[] d = new char[1000];
        Arrays.fill(d, 400, d.length, val);
        for (i = 0; i < 400; ++i) {
            ArraysTest.assertTrue((String)"Filled elements not in range", (d[i] != val ? 1 : 0) != 0);
        }
        for (i = 400; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill char array correctly", (d[i] == val ? 1 : 0) != 0);
        }
    }

    public void test_fill$II() {
        int[] d = new int[1000];
        Arrays.fill(d, Integer.MAX_VALUE);
        for (int i = 0; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill int array correctly", (d[i] == Integer.MAX_VALUE ? 1 : 0) != 0);
        }
    }

    public void test_fill$IIII() {
        int i;
        int val = Integer.MAX_VALUE;
        int[] d = new int[1000];
        Arrays.fill(d, 400, d.length, val);
        for (i = 0; i < 400; ++i) {
            ArraysTest.assertTrue((String)"Filled elements not in range", (d[i] != val ? 1 : 0) != 0);
        }
        for (i = 400; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill int array correctly", (d[i] == val ? 1 : 0) != 0);
        }
    }

    public void test_fill$JJ() {
        long[] d = new long[1000];
        Arrays.fill(d, Long.MAX_VALUE);
        for (int i = 0; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill long array correctly", (d[i] == Long.MAX_VALUE ? 1 : 0) != 0);
        }
    }

    public void test_fill$JIIJ() {
        int i;
        long[] d = new long[1000];
        Arrays.fill(d, 400, d.length, Long.MAX_VALUE);
        for (i = 0; i < 400; ++i) {
            ArraysTest.assertTrue((String)"Filled elements not in range", (d[i] != Long.MAX_VALUE ? 1 : 0) != 0);
        }
        for (i = 400; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill long array correctly", (d[i] == Long.MAX_VALUE ? 1 : 0) != 0);
        }
    }

    public void test_fill$FF() {
        float[] d = new float[1000];
        Arrays.fill(d, Float.MAX_VALUE);
        for (int i = 0; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill float array correctly", (d[i] == Float.MAX_VALUE ? 1 : 0) != 0);
        }
    }

    public void test_fill$FIIF() {
        int i;
        float val = Float.MAX_VALUE;
        float[] d = new float[1000];
        Arrays.fill(d, 400, d.length, val);
        for (i = 0; i < 400; ++i) {
            ArraysTest.assertTrue((String)"Filled elements not in range", (d[i] != val ? 1 : 0) != 0);
        }
        for (i = 400; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill float array correctly", (d[i] == val ? 1 : 0) != 0);
        }
    }

    public void test_fill$DD() {
        double[] d = new double[1000];
        Arrays.fill(d, Double.MAX_VALUE);
        for (int i = 0; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill double array correctly", (d[i] == Double.MAX_VALUE ? 1 : 0) != 0);
        }
    }

    public void test_fill$DIID() {
        int i;
        double val = Double.MAX_VALUE;
        double[] d = new double[1000];
        Arrays.fill(d, 400, d.length, val);
        for (i = 0; i < 400; ++i) {
            ArraysTest.assertTrue((String)"Filled elements not in range", (d[i] != val ? 1 : 0) != 0);
        }
        for (i = 400; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill double array correctly", (d[i] == val ? 1 : 0) != 0);
        }
    }

    public void test_fill$ZZ() {
        boolean[] d = new boolean[1000];
        Arrays.fill(d, true);
        for (int i = 0; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill boolean array correctly", (boolean)d[i]);
        }
    }

    public void test_fill$ZIIZ() {
        int i;
        boolean val = true;
        boolean[] d = new boolean[1000];
        Arrays.fill(d, 400, d.length, val);
        for (i = 0; i < 400; ++i) {
            ArraysTest.assertTrue((String)"Filled elements not in range", (d[i] != val ? 1 : 0) != 0);
        }
        for (i = 400; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill boolean array correctly", (d[i] == val ? 1 : 0) != 0);
        }
    }

    public void test_fill$Ljava_lang_ObjectLjava_lang_Object() {
        Object val = new Object();
        Object[] d = new Object[1000];
        Arrays.fill(d, 0, d.length, val);
        for (int i = 0; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill Object array correctly", (d[i] == val ? 1 : 0) != 0);
        }
    }

    public void test_fill$Ljava_lang_ObjectIILjava_lang_Object() {
        int i;
        Object val = new Object();
        Object[] d = new Object[1000];
        Arrays.fill(d, 400, d.length, val);
        for (i = 0; i < 400; ++i) {
            ArraysTest.assertTrue((String)"Filled elements not in range", (d[i] != val ? 1 : 0) != 0);
        }
        for (i = 400; i < d.length; ++i) {
            ArraysTest.assertTrue((String)"Failed to fill Object array correctly", (d[i] == val ? 1 : 0) != 0);
        }
        Arrays.fill(d, 400, d.length, null);
        for (i = 400; i < d.length; ++i) {
            ArraysTest.assertNull((String)"Failed to fill Object array correctly with nulls", (Object)d[i]);
        }
    }

    public void test_equals$B$B() {
        byte[] d = new byte[1000];
        byte[] x = new byte[1000];
        Arrays.fill(d, (byte)127);
        Arrays.fill(x, (byte)-128);
        ArraysTest.assertTrue((String)"Inequal arrays returned true", (!Arrays.equals(d, x) ? 1 : 0) != 0);
        Arrays.fill(x, (byte)127);
        ArraysTest.assertTrue((String)"equal arrays returned false", (boolean)Arrays.equals(d, x));
    }

    public void test_equals$S$S() {
        short[] d = new short[1000];
        short[] x = new short[1000];
        Arrays.fill(d, (short)Short.MAX_VALUE);
        Arrays.fill(x, (short)Short.MIN_VALUE);
        ArraysTest.assertTrue((String)"Inequal arrays returned true", (!Arrays.equals(d, x) ? 1 : 0) != 0);
        Arrays.fill(x, (short)Short.MAX_VALUE);
        ArraysTest.assertTrue((String)"equal arrays returned false", (boolean)Arrays.equals(d, x));
    }

    public void test_equals$C$C() {
        char[] d = new char[1000];
        char[] x = new char[1000];
        char c = 'T';
        Arrays.fill(d, c);
        Arrays.fill(x, 'L');
        ArraysTest.assertTrue((String)"Inequal arrays returned true", (!Arrays.equals(d, x) ? 1 : 0) != 0);
        Arrays.fill(x, c);
        ArraysTest.assertTrue((String)"equal arrays returned false", (boolean)Arrays.equals(d, x));
    }

    public void test_equals$I$I() {
        int[] d = new int[1000];
        int[] x = new int[1000];
        Arrays.fill(d, Integer.MAX_VALUE);
        Arrays.fill(x, Integer.MIN_VALUE);
        ArraysTest.assertTrue((String)"Inequal arrays returned true", (!Arrays.equals(d, x) ? 1 : 0) != 0);
        Arrays.fill(x, Integer.MAX_VALUE);
        ArraysTest.assertTrue((String)"equal arrays returned false", (boolean)Arrays.equals(d, x));
        ArraysTest.assertTrue((String)"wrong result for null array1", (!Arrays.equals(new int[2], null) ? 1 : 0) != 0);
        ArraysTest.assertTrue((String)"wrong result for null array2", (!Arrays.equals(null, new int[2]) ? 1 : 0) != 0);
    }

    public void test_equals$J$J() {
        long[] d = new long[1000];
        long[] x = new long[1000];
        Arrays.fill(d, Long.MAX_VALUE);
        Arrays.fill(x, Long.MIN_VALUE);
        ArraysTest.assertTrue((String)"Inequal arrays returned true", (!Arrays.equals(d, x) ? 1 : 0) != 0);
        Arrays.fill(x, Long.MAX_VALUE);
        ArraysTest.assertTrue((String)"equal arrays returned false", (boolean)Arrays.equals(d, x));
        ArraysTest.assertTrue((String)"should be false", (!Arrays.equals(new long[]{0x100000000L}, new long[]{0x200000000L}) ? 1 : 0) != 0);
    }

    public void test_equals$F$F() {
        float[] d = new float[1000];
        float[] x = new float[1000];
        Arrays.fill(d, Float.MAX_VALUE);
        Arrays.fill(x, Float.MIN_VALUE);
        ArraysTest.assertTrue((String)"Inequal arrays returned true", (!Arrays.equals(d, x) ? 1 : 0) != 0);
        Arrays.fill(x, Float.MAX_VALUE);
        ArraysTest.assertTrue((String)"equal arrays returned false", (boolean)Arrays.equals(d, x));
        ArraysTest.assertTrue((String)"NaN not equals", (boolean)Arrays.equals(new float[]{Float.NaN}, new float[]{Float.NaN}));
        ArraysTest.assertTrue((String)"0f equals -0f", (!Arrays.equals(new float[]{0.0f}, new float[]{-0.0f}) ? 1 : 0) != 0);
    }

    public void test_equals$D$D() {
        double[] d = new double[1000];
        double[] x = new double[1000];
        Arrays.fill(d, Double.MAX_VALUE);
        Arrays.fill(x, Double.MIN_VALUE);
        ArraysTest.assertTrue((String)"Inequal arrays returned true", (!Arrays.equals(d, x) ? 1 : 0) != 0);
        Arrays.fill(x, Double.MAX_VALUE);
        ArraysTest.assertTrue((String)"equal arrays returned false", (boolean)Arrays.equals(d, x));
        ArraysTest.assertTrue((String)"should be false", (!Arrays.equals(new double[]{1.0}, new double[]{2.0}) ? 1 : 0) != 0);
        ArraysTest.assertTrue((String)"NaN not equals", (boolean)Arrays.equals(new double[]{Double.NaN}, new double[]{Double.NaN}));
        ArraysTest.assertTrue((String)"0d equals -0d", (!Arrays.equals(new double[]{0.0}, new double[]{-0.0}) ? 1 : 0) != 0);
    }

    public void test_equals$Z$Z() {
        boolean[] d = new boolean[1000];
        boolean[] x = new boolean[1000];
        Arrays.fill(d, true);
        Arrays.fill(x, false);
        ArraysTest.assertTrue((String)"Inequal arrays returned true", (!Arrays.equals(d, x) ? 1 : 0) != 0);
        Arrays.fill(x, true);
        ArraysTest.assertTrue((String)"equal arrays returned false", (boolean)Arrays.equals(d, x));
    }

    public void test_equals$Ljava_lang_Object$Ljava_lang_Object() {
        Object[] d = new Object[1000];
        Object[] x = new Object[1000];
        Object o = new Object();
        Arrays.fill(d, o);
        Arrays.fill(x, new Object());
        ArraysTest.assertTrue((String)"Inequal arrays returned true", (!Arrays.equals(d, x) ? 1 : 0) != 0);
        Arrays.fill(x, o);
        d[50] = null;
        x[50] = null;
        ArraysTest.assertTrue((String)"equal arrays returned false", (boolean)Arrays.equals(d, x));
    }

    public void test_sort$B() {
        int counter;
        byte[] reversedArray = new byte[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = (byte)(100 - counter - 1);
        }
        Arrays.sort(reversedArray);
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Resulting array not sorted", (reversedArray[counter] == (byte)counter ? 1 : 0) != 0);
        }
    }

    public void test_sort$BII() {
        int counter;
        int startIndex = 25;
        int endIndex = 75;
        byte[] reversedArray = new byte[100];
        byte[] originalReversedArray = new byte[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = (byte)(100 - counter - 1);
            originalReversedArray[counter] = reversedArray[counter];
        }
        Arrays.sort(reversedArray, startIndex, endIndex);
        for (counter = 0; counter < startIndex; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        for (counter = startIndex; counter < endIndex - 1; ++counter) {
            ArraysTest.assertTrue((String)"Array not sorted within bounds", (reversedArray[counter] <= reversedArray[counter + 1] ? 1 : 0) != 0);
        }
        for (counter = endIndex; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        try {
            Arrays.sort(reversedArray, startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, -1, startIndex);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (1)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, startIndex, reversedArray.length + 1);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (2)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(new byte[1], startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
    }

    public void test_sort$C() {
        int counter;
        char[] reversedArray = new char[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = (char)(100 - counter - 1);
        }
        Arrays.sort(reversedArray);
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Resulting array not sorted", (reversedArray[counter] == (char)counter ? 1 : 0) != 0);
        }
    }

    public void test_sort$CII() {
        int counter;
        int startIndex = 25;
        int endIndex = 75;
        char[] reversedArray = new char[100];
        char[] originalReversedArray = new char[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = (char)(100 - counter - 1);
            originalReversedArray[counter] = reversedArray[counter];
        }
        Arrays.sort(reversedArray, startIndex, endIndex);
        for (counter = 0; counter < startIndex; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        for (counter = startIndex; counter < endIndex - 1; ++counter) {
            ArraysTest.assertTrue((String)"Array not sorted within bounds", (reversedArray[counter] <= reversedArray[counter + 1] ? 1 : 0) != 0);
        }
        for (counter = endIndex; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        try {
            Arrays.sort(reversedArray, startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, -1, startIndex);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (1)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, startIndex, reversedArray.length + 1);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (2)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(new char[1], startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
    }

    public void test_sort$D() {
        int counter;
        double[] reversedArray = new double[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = 100 - counter - 1;
        }
        Arrays.sort(reversedArray);
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Resulting array not sorted", (reversedArray[counter] == (double)counter ? 1 : 0) != 0);
        }
        double[] specials1 = new double[]{Double.NaN, Double.MAX_VALUE, Double.MIN_VALUE, 0.0, -0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        double[] specials2 = new double[]{0.0, Double.POSITIVE_INFINITY, -0.0, Double.NEGATIVE_INFINITY, Double.MIN_VALUE, Double.NaN, Double.MAX_VALUE};
        double[] specials3 = new double[]{0.0, Double.NaN, 1.0, 2.0, Double.NaN, Double.NaN, 1.0, 3.0, -0.0};
        double[] answer = new double[]{Double.NEGATIVE_INFINITY, -0.0, 0.0, Double.MIN_VALUE, Double.MAX_VALUE, Double.POSITIVE_INFINITY, Double.NaN};
        double[] answer3 = new double[]{-0.0, 0.0, 1.0, 1.0, 2.0, 3.0, Double.NaN, Double.NaN, Double.NaN};
        Arrays.sort(specials1);
        Object[] print1 = new Object[specials1.length];
        for (int i = 0; i < specials1.length; ++i) {
            print1[i] = new Double(specials1[i]);
        }
        ArraysTest.assertTrue((String)("specials sort incorrectly 1: " + Arrays.asList(print1)), (boolean)Arrays.equals(specials1, answer));
        Arrays.sort(specials2);
        Object[] print2 = new Object[specials2.length];
        for (int i = 0; i < specials2.length; ++i) {
            print2[i] = new Double(specials2[i]);
        }
        ArraysTest.assertTrue((String)("specials sort incorrectly 2: " + Arrays.asList(print2)), (boolean)Arrays.equals(specials2, answer));
        Arrays.sort(specials3);
        Object[] print3 = new Object[specials3.length];
        for (int i = 0; i < specials3.length; ++i) {
            print3[i] = new Double(specials3[i]);
        }
        ArraysTest.assertTrue((String)("specials sort incorrectly 3: " + Arrays.asList(print3)), (boolean)Arrays.equals(specials3, answer3));
    }

    public void test_sort$DII() {
        int counter;
        int startIndex = 25;
        int endIndex = 75;
        double[] reversedArray = new double[100];
        double[] originalReversedArray = new double[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = 100 - counter - 1;
            originalReversedArray[counter] = reversedArray[counter];
        }
        Arrays.sort(reversedArray, startIndex, endIndex);
        for (counter = 0; counter < startIndex; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        for (counter = startIndex; counter < endIndex - 1; ++counter) {
            ArraysTest.assertTrue((String)"Array not sorted within bounds", (reversedArray[counter] <= reversedArray[counter + 1] ? 1 : 0) != 0);
        }
        for (counter = endIndex; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        try {
            Arrays.sort(reversedArray, startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, -1, startIndex);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (1)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, startIndex, reversedArray.length + 1);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (2)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(new double[1], startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
    }

    public void test_sort$F() {
        int counter;
        float[] reversedArray = new float[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = 100 - counter - 1;
        }
        Arrays.sort(reversedArray);
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Resulting array not sorted", (reversedArray[counter] == (float)counter ? 1 : 0) != 0);
        }
        float[] specials1 = new float[]{Float.NaN, Float.MAX_VALUE, Float.MIN_VALUE, 0.0f, -0.0f, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY};
        float[] specials2 = new float[]{0.0f, Float.POSITIVE_INFINITY, -0.0f, Float.NEGATIVE_INFINITY, Float.MIN_VALUE, Float.NaN, Float.MAX_VALUE};
        float[] answer = new float[]{Float.NEGATIVE_INFINITY, -0.0f, 0.0f, Float.MIN_VALUE, Float.MAX_VALUE, Float.POSITIVE_INFINITY, Float.NaN};
        Arrays.sort(specials1);
        Object[] print1 = new Object[specials1.length];
        for (int i = 0; i < specials1.length; ++i) {
            print1[i] = new Float(specials1[i]);
        }
        ArraysTest.assertTrue((String)("specials sort incorrectly 1: " + Arrays.asList(print1)), (boolean)Arrays.equals(specials1, answer));
        Arrays.sort(specials2);
        Object[] print2 = new Object[specials2.length];
        for (int i = 0; i < specials2.length; ++i) {
            print2[i] = new Float(specials2[i]);
        }
        ArraysTest.assertTrue((String)("specials sort incorrectly 2: " + Arrays.asList(print2)), (boolean)Arrays.equals(specials2, answer));
    }

    public void test_sort$FII() {
        int counter;
        int startIndex = 25;
        int endIndex = 75;
        float[] reversedArray = new float[100];
        float[] originalReversedArray = new float[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = 100 - counter - 1;
            originalReversedArray[counter] = reversedArray[counter];
        }
        Arrays.sort(reversedArray, startIndex, endIndex);
        for (counter = 0; counter < startIndex; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        for (counter = startIndex; counter < endIndex - 1; ++counter) {
            ArraysTest.assertTrue((String)"Array not sorted within bounds", (reversedArray[counter] <= reversedArray[counter + 1] ? 1 : 0) != 0);
        }
        for (counter = endIndex; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        try {
            Arrays.sort(reversedArray, startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, -1, startIndex);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (1)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, startIndex, reversedArray.length + 1);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (2)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(new float[1], startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
    }

    public void test_sort$I() {
        int counter;
        int[] reversedArray = new int[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = 100 - counter - 1;
        }
        Arrays.sort(reversedArray);
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Resulting array not sorted", (reversedArray[counter] == counter ? 1 : 0) != 0);
        }
    }

    public void test_sort$III() {
        int counter;
        int startIndex = 25;
        int endIndex = 75;
        int[] reversedArray = new int[100];
        int[] originalReversedArray = new int[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = 100 - counter - 1;
            originalReversedArray[counter] = reversedArray[counter];
        }
        Arrays.sort(reversedArray, startIndex, endIndex);
        for (counter = 0; counter < startIndex; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        for (counter = startIndex; counter < endIndex - 1; ++counter) {
            ArraysTest.assertTrue((String)"Array not sorted within bounds", (reversedArray[counter] <= reversedArray[counter + 1] ? 1 : 0) != 0);
        }
        for (counter = endIndex; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        try {
            Arrays.sort(reversedArray, startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, -1, startIndex);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (1)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, startIndex, reversedArray.length + 1);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (2)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(new int[1], startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
    }

    public void test_sort$J() {
        int counter;
        long[] reversedArray = new long[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = 100 - counter - 1;
        }
        Arrays.sort(reversedArray);
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Resulting array not sorted", (reversedArray[counter] == (long)counter ? 1 : 0) != 0);
        }
    }

    public void test_sort$JII() {
        int counter;
        int startIndex = 25;
        int endIndex = 75;
        long[] reversedArray = new long[100];
        long[] originalReversedArray = new long[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = 100 - counter - 1;
            originalReversedArray[counter] = reversedArray[counter];
        }
        Arrays.sort(reversedArray, startIndex, endIndex);
        for (counter = 0; counter < startIndex; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        for (counter = startIndex; counter < endIndex - 1; ++counter) {
            ArraysTest.assertTrue((String)"Array not sorted within bounds", (reversedArray[counter] <= reversedArray[counter + 1] ? 1 : 0) != 0);
        }
        for (counter = endIndex; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        try {
            Arrays.sort(reversedArray, startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, -1, startIndex);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (1)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, startIndex, reversedArray.length + 1);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (2)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(new long[1], startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
    }

    public void test_sort$Ljava_lang_Object() {
        int counter;
        Object[] reversedArray = new Object[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = objectArray[100 - counter - 1];
        }
        Arrays.sort(reversedArray);
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Resulting array not sorted", (reversedArray[counter] == objectArray[counter] ? 1 : 0) != 0);
        }
    }

    public void test_sort$Ljava_lang_ObjectII() {
        int counter;
        int startIndex = 25;
        int endIndex = 75;
        Object[] reversedArray = new Object[100];
        Object[] originalReversedArray = new Object[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = objectArray[100 - counter - 1];
            originalReversedArray[counter] = reversedArray[counter];
        }
        Arrays.sort(reversedArray, startIndex, endIndex);
        for (counter = 0; counter < startIndex; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        for (counter = startIndex; counter < endIndex - 1; ++counter) {
            ArraysTest.assertTrue((String)"Array not sorted within bounds", (((Comparable)reversedArray[counter]).compareTo(reversedArray[counter + 1]) <= 0 ? 1 : 0) != 0);
        }
        for (counter = endIndex; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        try {
            Arrays.sort(reversedArray, startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, -1, startIndex);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (1)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, startIndex, reversedArray.length + 1);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (2)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(new Object[1], startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
    }

    public void test_sort$Ljava_lang_ObjectIILjava_util_Comparator() {
        int counter;
        int startIndex = 25;
        int endIndex = 75;
        ReversedIntegerComparator comp = new ReversedIntegerComparator();
        Object[] originalArray = new Object[100];
        for (counter = 0; counter < 100; ++counter) {
            originalArray[counter] = objectArray[counter];
        }
        Arrays.sort(objectArray, startIndex, endIndex, comp);
        for (counter = 0; counter < startIndex; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (objectArray[counter] == originalArray[counter] ? 1 : 0) != 0);
        }
        for (counter = startIndex; counter < endIndex - 1; ++counter) {
            ArraysTest.assertTrue((String)"Array not sorted within bounds", (comp.compare(objectArray[counter], objectArray[counter + 1]) <= 0 ? 1 : 0) != 0);
        }
        for (counter = endIndex; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (objectArray[counter] == originalArray[counter] ? 1 : 0) != 0);
        }
    }

    public void test_sort$Ljava_lang_ObjectLjava_util_Comparator() {
        ReversedIntegerComparator comp = new ReversedIntegerComparator();
        Arrays.sort(objectArray, comp);
        for (int counter = 0; counter < 99; ++counter) {
            ArraysTest.assertTrue((String)"Array not sorted correctly with custom comparator", (comp.compare(objectArray[counter], objectArray[counter + 1]) <= 0 ? 1 : 0) != 0);
        }
    }

    public void test_sort$Ljava_lang_ObjectLjava_util_Comparator_stable() {
        Element[] array = new Element[]{new Element(122), new Element(146), new Element(178), new Element(208), new Element(117), new Element(146), new Element(173), new Element(203), new Element(56), new Element(208), new Element(96)};
        Comparator<Element> comparator = new Comparator<Element>(){

            @Override
            public int compare(Element object1, Element object2) {
                return object1.value - object2.value;
            }
        };
        Arrays.sort(array, comparator);
        for (int i = 1; i < array.length; ++i) {
            ArraysTest.assertTrue((comparator.compare(array[i - 1], array[i]) <= 0 ? 1 : 0) != 0);
            if (comparator.compare(array[i - 1], array[i]) != 0) continue;
            ArraysTest.assertTrue((array[i - 1].index < array[i].index ? 1 : 0) != 0);
        }
    }

    public void test_sort$S() {
        int counter;
        short[] reversedArray = new short[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = (short)(100 - counter - 1);
        }
        Arrays.sort(reversedArray);
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Resulting array not sorted", (reversedArray[counter] == (short)counter ? 1 : 0) != 0);
        }
    }

    public void test_sort$SII() {
        int counter;
        int startIndex = 25;
        int endIndex = 75;
        short[] reversedArray = new short[100];
        short[] originalReversedArray = new short[100];
        for (counter = 0; counter < 100; ++counter) {
            reversedArray[counter] = (short)(100 - counter - 1);
            originalReversedArray[counter] = reversedArray[counter];
        }
        Arrays.sort(reversedArray, startIndex, endIndex);
        for (counter = 0; counter < startIndex; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        for (counter = startIndex; counter < endIndex - 1; ++counter) {
            ArraysTest.assertTrue((String)"Array not sorted within bounds", (reversedArray[counter] <= reversedArray[counter + 1] ? 1 : 0) != 0);
        }
        for (counter = endIndex; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Array modified outside of bounds", (reversedArray[counter] == originalReversedArray[counter] ? 1 : 0) != 0);
        }
        try {
            Arrays.sort(reversedArray, startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, -1, startIndex);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (1)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(reversedArray, startIndex, reversedArray.length + 1);
            ArraysTest.fail((String)"ArrayIndexOutOfBoundsException expected (2)");
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            // empty catch block
        }
        try {
            Arrays.sort(new short[1], startIndex + 1, startIndex);
            ArraysTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
    }

    public void test_java_util_Arrays_sort_byte_array_NPE() {
        byte[] byte_array_null = null;
        try {
            Arrays.sort(byte_array_null);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.sort(byte_array_null, -1, 1);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void test_java_util_Arrays_sort_char_array_NPE() {
        char[] char_array_null = null;
        try {
            Arrays.sort(char_array_null);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.sort(char_array_null, -1, 1);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void test_java_util_Arrays_sort_double_array_NPE() {
        double[] double_array_null = null;
        try {
            Arrays.sort(double_array_null);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.sort(double_array_null, -1, 1);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void test_java_util_Arrays_sort_float_array_NPE() {
        float[] float_array_null = null;
        try {
            Arrays.sort(float_array_null);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.sort(float_array_null, -1, 1);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void test_java_util_Arrays_sort_int_array_NPE() {
        int[] int_array_null = null;
        try {
            Arrays.sort(int_array_null);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.sort(int_array_null, -1, 1);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void test_java_util_Arrays_sort_object_array_NPE() {
        T[] object_array_null = null;
        try {
            Arrays.sort(object_array_null);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.sort(object_array_null, -1, 1);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.sort(object_array_null, -1, 1, null);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void test_java_util_Arrays_sort_long_array_NPE() {
        long[] long_array_null = null;
        try {
            Arrays.sort(long_array_null);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.sort(long_array_null, -1, 1);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void test_java_util_Arrays_sort_short_array_NPE() {
        short[] short_array_null = null;
        try {
            Arrays.sort(short_array_null);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.sort(short_array_null, -1, 1);
            ArraysTest.fail((String)"Should throw java.lang.NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void test_deepEquals$Ljava_lang_ObjectLjava_lang_Object() {
        int[] a1 = new int[]{1, 2, 3};
        short[] a2 = new short[]{0, 1};
        Object[] a3 = new Object[]{new Integer(1), a2};
        int[] a4 = new int[]{6, 5, 4};
        int[] b1 = new int[]{1, 2, 3};
        short[] b2 = new short[]{0, 1};
        Object[] b3 = new Object[]{new Integer(1), b2};
        Object[] a = new Object[]{a1, a2, a3};
        Object[] b = new Object[]{b1, b2, b3};
        ArraysTest.assertFalse((boolean)Arrays.equals(a, b));
        ArraysTest.assertTrue((boolean)Arrays.deepEquals(a, b));
        a[2] = a4;
        ArraysTest.assertFalse((boolean)Arrays.deepEquals(a, b));
    }

    public void test_deepHashCode$Ljava_lang_Object() {
        int[] a1 = new int[]{1, 2, 3};
        short[] a2 = new short[]{0, 1};
        Object[] a3 = new Object[]{new Integer(1), a2};
        int[] b1 = new int[]{1, 2, 3};
        short[] b2 = new short[]{0, 1};
        Object[] b3 = new Object[]{new Integer(1), b2};
        Object[] a = new Object[]{a1, a2, a3};
        Object[] b = new Object[]{b1, b2, b3};
        int deep_hash_a = Arrays.deepHashCode(a);
        int deep_hash_b = Arrays.deepHashCode(b);
        ArraysTest.assertEquals((int)deep_hash_a, (int)deep_hash_b);
    }

    public void test_hashCode$LZ() {
        boolean[] boolArr = new boolean[]{true, false, false, true, false};
        LinkedList<Boolean> listOfBoolean = new LinkedList<Boolean>();
        for (int i = 0; i < boolArr.length; ++i) {
            listOfBoolean.add(new Boolean(boolArr[i]));
        }
        int listHashCode = ((Object)listOfBoolean).hashCode();
        int arrayHashCode = Arrays.hashCode(boolArr);
        ArraysTest.assertEquals((int)listHashCode, (int)arrayHashCode);
    }

    public void test_hashCode$LI() {
        int[] intArr = new int[]{10, 5, 134, 7, 19};
        LinkedList<Integer> listOfInteger = new LinkedList<Integer>();
        for (int i = 0; i < intArr.length; ++i) {
            listOfInteger.add(new Integer(intArr[i]));
        }
        int listHashCode = ((Object)listOfInteger).hashCode();
        int arrayHashCode = Arrays.hashCode(intArr);
        ArraysTest.assertEquals((int)listHashCode, (int)arrayHashCode);
        int[] intArr2 = new int[]{10, 5, 134, 7, 19};
        ArraysTest.assertEquals((int)Arrays.hashCode(intArr2), (int)Arrays.hashCode(intArr));
    }

    public void test_hashCode$LC() {
        char[] charArr = new char[]{'a', 'g', 'x', 'c', 'm'};
        LinkedList<Character> listOfCharacter = new LinkedList<Character>();
        for (int i = 0; i < charArr.length; ++i) {
            listOfCharacter.add(new Character(charArr[i]));
        }
        int listHashCode = ((Object)listOfCharacter).hashCode();
        int arrayHashCode = Arrays.hashCode(charArr);
        ArraysTest.assertEquals((int)listHashCode, (int)arrayHashCode);
    }

    public void test_hashCode$LB() {
        byte[] byteArr = new byte[]{5, 9, 7, 6, 17};
        LinkedList<Byte> listOfByte = new LinkedList<Byte>();
        for (int i = 0; i < byteArr.length; ++i) {
            listOfByte.add(new Byte(byteArr[i]));
        }
        int listHashCode = ((Object)listOfByte).hashCode();
        int arrayHashCode = Arrays.hashCode(byteArr);
        ArraysTest.assertEquals((int)listHashCode, (int)arrayHashCode);
    }

    public void test_hashCode$LJ() {
        long[] longArr = new long[]{67890234512L, 97587236923425L, 257421912912L, 6754268100L, 5L};
        LinkedList<Long> listOfLong = new LinkedList<Long>();
        for (int i = 0; i < longArr.length; ++i) {
            listOfLong.add(new Long(longArr[i]));
        }
        int listHashCode = ((Object)listOfLong).hashCode();
        int arrayHashCode = Arrays.hashCode(longArr);
        ArraysTest.assertEquals((int)listHashCode, (int)arrayHashCode);
    }

    public void test_hashCode$LF() {
        float[] floatArr = new float[]{0.13497f, 0.268934f, 1.2E-4f, -300.0f, 0.001f};
        LinkedList<Float> listOfFloat = new LinkedList<Float>();
        for (int i = 0; i < floatArr.length; ++i) {
            listOfFloat.add(new Float(floatArr[i]));
        }
        int listHashCode = ((Object)listOfFloat).hashCode();
        int arrayHashCode = Arrays.hashCode(floatArr);
        ArraysTest.assertEquals((int)listHashCode, (int)arrayHashCode);
        float[] floatArr2 = new float[]{0.13497f, 0.268934f, 1.2E-4f, -300.0f, 0.001f};
        ArraysTest.assertEquals((int)Arrays.hashCode(floatArr2), (int)Arrays.hashCode(floatArr));
    }

    public void test_hashCode$LD() {
        double[] doubleArr = new double[]{0.134945657, 0.0038754, 1.1E-149, -3.0E-299, 0.001};
        LinkedList<Double> listOfDouble = new LinkedList<Double>();
        for (int i = 0; i < doubleArr.length; ++i) {
            listOfDouble.add(new Double(doubleArr[i]));
        }
        int listHashCode = ((Object)listOfDouble).hashCode();
        int arrayHashCode = Arrays.hashCode(doubleArr);
        ArraysTest.assertEquals((int)listHashCode, (int)arrayHashCode);
    }

    public void test_hashCode$LS() {
        short[] shortArr = new short[]{35, 13, 45, 2, 91};
        LinkedList<Short> listOfShort = new LinkedList<Short>();
        for (int i = 0; i < shortArr.length; ++i) {
            listOfShort.add(new Short(shortArr[i]));
        }
        int listHashCode = ((Object)listOfShort).hashCode();
        int arrayHashCode = Arrays.hashCode(shortArr);
        ArraysTest.assertEquals((int)listHashCode, (int)arrayHashCode);
    }

    public void test_hashCode$Ljava_lang_Object() {
        Object[] objectArr = new Object[]{new Integer(1), new Float(1.0E-11f), null};
        LinkedList<Object> listOfObject = new LinkedList<Object>();
        for (int i = 0; i < objectArr.length; ++i) {
            listOfObject.add(objectArr[i]);
        }
        int listHashCode = ((Object)listOfObject).hashCode();
        int arrayHashCode = Arrays.hashCode(objectArr);
        ArraysTest.assertEquals((int)listHashCode, (int)arrayHashCode);
    }

    protected void setUp() {
        int counter;
        booleanArray = new boolean[100];
        byteArray = new byte[100];
        charArray = new char[100];
        doubleArray = new double[100];
        floatArray = new float[100];
        intArray = new int[100];
        longArray = new long[100];
        objectArray = new Object[100];
        shortArray = new short[100];
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.byteArray[counter] = (byte)counter;
            ArraysTest.charArray[counter] = (char)(counter + 1);
            ArraysTest.doubleArray[counter] = counter;
            ArraysTest.floatArray[counter] = counter;
            ArraysTest.intArray[counter] = counter;
            ArraysTest.longArray[counter] = counter;
            ArraysTest.objectArray[counter] = objArray[counter];
            ArraysTest.shortArray[counter] = (short)counter;
        }
        for (counter = 0; counter < 100; counter += 2) {
            ArraysTest.booleanArray[counter] = false;
            ArraysTest.booleanArray[counter + 1] = true;
        }
    }

    public void test_binarySearch$BIIB() {
        int counter;
        for (counter = 0; counter < 100; counter = (int)((byte)(counter + 1))) {
            ArraysTest.assertTrue((String)"Binary search on byte[] answered incorrect position", (Arrays.binarySearch(byteArray, counter, 100, (byte)counter) == counter ? 1 : 0) != 0);
        }
        ArraysTest.assertEquals((String)"Binary search succeeded for value not present in array 1", (int)-1, (int)Arrays.binarySearch(byteArray, 0, 100, (byte)-1));
        ArraysTest.assertTrue((String)"Binary search succeeded for value not present in array 2", (Arrays.binarySearch(byteArray, (byte)100) == -101 ? 1 : 0) != 0);
        for (counter = 0; counter < 100; counter = (int)((byte)(counter + 1))) {
            int n = counter;
            byteArray[n] = (byte)(byteArray[n] - 50);
        }
        for (counter = 0; counter < 100; counter = (int)((byte)(counter + 1))) {
            ArraysTest.assertTrue((String)"Binary search on byte[] involving negative numbers answered incorrect position", (Arrays.binarySearch(byteArray, counter, 100, (byte)(counter - 50)) == counter ? 1 : 0) != 0);
        }
        try {
            Arrays.binarySearch((byte[])null, 2, 1, (byte)100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch((byte[])null, -1, 0, (byte)100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch((byte[])null, -1, -2, (byte)100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(byteArray, 2, 1, (byte)100);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        ArraysTest.assertEquals((int)-1, (int)Arrays.binarySearch(byteArray, 0, 0, (byte)100));
        try {
            Arrays.binarySearch(byteArray, -1, -2, (byte)100);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(byteArray, 102, 101, (byte)100);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(byteArray, -1, 0, (byte)100);
            ArraysTest.fail((String)"should throw ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(byteArray, 0, 101, (byte)100);
            ArraysTest.fail((String)"should throw ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void test_binarySearch$CIIC() {
        for (int counter = 0; counter < 100; counter = (int)((char)(counter + 1))) {
            ArraysTest.assertTrue((String)"Binary search on char[] answered incorrect position", (Arrays.binarySearch(charArray, counter, 100, (char)(counter + 1)) == counter ? 1 : 0) != 0);
        }
        ArraysTest.assertEquals((String)"Binary search succeeded for value not present in array 1", (int)-1, (int)Arrays.binarySearch(charArray, 0, 100, '\u0000'));
        ArraysTest.assertTrue((String)"Binary search succeeded for value not present in array 2", (Arrays.binarySearch(charArray, 0, 100, 'e') == -101 ? 1 : 0) != 0);
        try {
            Arrays.binarySearch(charArray, 2, 1, 'd');
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch((char[])null, 2, 1, 'd');
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch((char[])null, -1, 0, 'd');
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch((char[])null, -1, -2, 'd');
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        ArraysTest.assertEquals((int)-1, (int)Arrays.binarySearch(charArray, 0, 0, 'd'));
        try {
            Arrays.binarySearch(charArray, -1, -2, 'd');
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(charArray, 102, 101, 'd');
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(charArray, -1, 0, 'd');
            ArraysTest.fail((String)"should throw ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(charArray, 0, 101, 'd');
            ArraysTest.fail((String)"should throw ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void test_binarySearch$DIID() {
        int counter;
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Binary search on double[] answered incorrect position", ((double)Arrays.binarySearch(doubleArray, counter, 100, (double)counter) == (double)counter ? 1 : 0) != 0);
        }
        ArraysTest.assertEquals((String)"Binary search succeeded for value not present in array 1", (int)-1, (int)Arrays.binarySearch(doubleArray, 0, 100, -1.0));
        ArraysTest.assertTrue((String)"Binary search succeeded for value not present in array 2", (Arrays.binarySearch(doubleArray, 0, 100, 100.0) == -101 ? 1 : 0) != 0);
        counter = 0;
        while (counter < 100) {
            int n = counter++;
            doubleArray[n] = doubleArray[n] - 50.0;
        }
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Binary search on double[] involving negative numbers answered incorrect position", ((double)Arrays.binarySearch(doubleArray, counter, 100, (double)(counter - 50)) == (double)counter ? 1 : 0) != 0);
        }
        double[] specials = new double[]{Double.NEGATIVE_INFINITY, -1.7976931348623157E308, -2.0, -4.9E-324, -0.0, 0.0, Double.MIN_VALUE, 2.0, Double.MAX_VALUE, Double.POSITIVE_INFINITY, Double.NaN};
        for (int i = 0; i < specials.length; ++i) {
            int result = Arrays.binarySearch(specials, i, specials.length, specials[i]);
            ArraysTest.assertTrue((String)(specials[i] + " invalid: " + result), (result == i ? 1 : 0) != 0);
        }
        ArraysTest.assertEquals((String)"-1d", (int)-4, (int)Arrays.binarySearch(specials, 0, specials.length, -1.0));
        ArraysTest.assertEquals((String)"1d", (int)-8, (int)Arrays.binarySearch(specials, 0, specials.length, 1.0));
        try {
            Arrays.binarySearch((double[])null, 2, 1, 100.0);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch((double[])null, -1, 0, 100.0);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch((double[])null, -1, -2, 100.0);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(doubleArray, 2, 1, 100.0);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        ArraysTest.assertEquals((int)-1, (int)Arrays.binarySearch(doubleArray, 0, 0, 100.0));
        try {
            Arrays.binarySearch(doubleArray, -1, -2, 100.0);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(doubleArray, 102, 101, 100.0);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(doubleArray, -1, 0, 100.0);
            ArraysTest.fail((String)"should throw ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(doubleArray, 0, 101, 100.0);
            ArraysTest.fail((String)"should throw ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void test_binarySearch$FIIF() {
        int counter;
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Binary search on float[] answered incorrect position", ((float)Arrays.binarySearch(floatArray, counter, 100, (float)counter) == (float)counter ? 1 : 0) != 0);
        }
        ArraysTest.assertEquals((String)"Binary search succeeded for value not present in array 1", (int)-1, (int)Arrays.binarySearch(floatArray, 0, 100, -1.0f));
        ArraysTest.assertTrue((String)"Binary search succeeded for value not present in array 2", (Arrays.binarySearch(floatArray, 0, 100, 100.0f) == -101 ? 1 : 0) != 0);
        counter = 0;
        while (counter < 100) {
            int n = counter++;
            floatArray[n] = floatArray[n] - 50.0f;
        }
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Binary search on float[] involving negative numbers answered incorrect position", ((float)Arrays.binarySearch(floatArray, 0, 100, (float)counter - 50.0f) == (float)counter ? 1 : 0) != 0);
        }
        float[] specials = new float[]{Float.NEGATIVE_INFINITY, -3.4028235E38f, -2.0f, -1.4E-45f, -0.0f, 0.0f, Float.MIN_VALUE, 2.0f, Float.MAX_VALUE, Float.POSITIVE_INFINITY, Float.NaN};
        for (int i = 0; i < specials.length; ++i) {
            int result = Arrays.binarySearch(specials, i, specials.length, specials[i]);
            ArraysTest.assertTrue((String)(specials[i] + " invalid: " + result), (result == i ? 1 : 0) != 0);
        }
        ArraysTest.assertEquals((String)"-1f", (int)-4, (int)Arrays.binarySearch(specials, 0, specials.length, -1.0f));
        ArraysTest.assertEquals((String)"1f", (int)-8, (int)Arrays.binarySearch(specials, 0, specials.length, 1.0f));
        try {
            Arrays.binarySearch((float[])null, 2, 1, 100.0f);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch((float[])null, -1, 0, 100.0f);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch((float[])null, -1, -2, 100.0f);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(floatArray, 2, 1, 100.0f);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        ArraysTest.assertEquals((int)-1, (int)Arrays.binarySearch(floatArray, 0, 0, 100.0f));
        try {
            Arrays.binarySearch(floatArray, -1, -2, 100.0f);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(floatArray, 102, 101, 100.0f);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(floatArray, -1, 0, 100.0f);
            ArraysTest.fail((String)"should throw ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(floatArray, 0, 101, 100.0f);
            ArraysTest.fail((String)"should throw ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void test_binarySearch$IIII() {
        int counter;
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Binary search on int[] answered incorrect position", (Arrays.binarySearch(intArray, counter, 100, counter) == counter ? 1 : 0) != 0);
        }
        ArraysTest.assertEquals((String)"Binary search succeeded for value not present in array 1", (int)-1, (int)Arrays.binarySearch(intArray, 0, 100, -1));
        ArraysTest.assertTrue((String)"Binary search succeeded for value not present in array 2", (Arrays.binarySearch(intArray, 0, 100, 100) == -101 ? 1 : 0) != 0);
        counter = 0;
        while (counter < 100) {
            int n = counter++;
            intArray[n] = intArray[n] - 50;
        }
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Binary search on int[] involving negative numbers answered incorrect position", (Arrays.binarySearch(intArray, 0, 100, counter - 50) == counter ? 1 : 0) != 0);
        }
        try {
            Arrays.binarySearch((int[])null, 2, 1, 100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch((int[])null, -1, 0, 100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch((int[])null, -1, -2, 100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(intArray, 2, 1, 100);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        ArraysTest.assertEquals((int)-1, (int)Arrays.binarySearch(intArray, 0, 0, 100));
        try {
            Arrays.binarySearch(intArray, -1, -2, 100);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(intArray, 102, 101, 100);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(intArray, -1, 0, 100);
            ArraysTest.fail((String)"should throw ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(intArray, 0, 101, 100);
            ArraysTest.fail((String)"should throw ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void test_binarySearch$JIIJ() {
        long counter;
        for (counter = 0L; counter < 100L; ++counter) {
            ArraysTest.assertTrue((String)"Binary search on long[] answered incorrect position", ((long)Arrays.binarySearch(longArray, 0, 100, counter) == counter ? 1 : 0) != 0);
        }
        ArraysTest.assertEquals((String)"Binary search succeeded for value not present in array 1", (int)-1, (int)Arrays.binarySearch(longArray, 0, 100, -1L));
        ArraysTest.assertTrue((String)"Binary search succeeded for value not present in array 2", (Arrays.binarySearch(longArray, 0, 100, 100L) == -101 ? 1 : 0) != 0);
        for (counter = 0L; counter < 100L; ++counter) {
            int n = (int)counter;
            longArray[n] = longArray[n] - 50L;
        }
        for (counter = 0L; counter < 100L; ++counter) {
            ArraysTest.assertTrue((String)"Binary search on long[] involving negative numbers answered incorrect position", ((long)Arrays.binarySearch(longArray, 0, 100, counter - 50L) == counter ? 1 : 0) != 0);
        }
        try {
            Arrays.binarySearch((long[])null, 2, 1, 100L);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch((long[])null, -1, 0, 100L);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch((long[])null, -1, -2, 100L);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(longArray, 2, 1, 100L);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        ArraysTest.assertEquals((int)-1, (int)Arrays.binarySearch(longArray, 0, 0, 100L));
        try {
            Arrays.binarySearch(longArray, -1, -2, 100L);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(longArray, 102, 101, 100L);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(longArray, -1, 0, 100L);
            ArraysTest.fail((String)"should throw ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(longArray, 0, 101, 100L);
            ArraysTest.fail((String)"should throw ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void test_binarySearch$Ljava_lang_ObjectIILjava_lang_Object() {
        ArraysTest.assertEquals((String)"Binary search succeeded for non-comparable value in empty array", (int)-1, (int)Arrays.binarySearch(new Object[0], 0, 0, new Object()));
        ArraysTest.assertEquals((String)"Binary search succeeded for comparable value in empty array", (int)-1, (int)Arrays.binarySearch(new Object[0], 0, 0, new Integer(-1)));
        for (int counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Binary search on Object[] answered incorrect position", (Arrays.binarySearch(objectArray, counter, 100, objArray[counter]) == counter ? 1 : 0) != 0);
        }
        ArraysTest.assertEquals((String)"Binary search succeeded for value not present in array 1", (int)-1, (int)Arrays.binarySearch(objectArray, 0, 100, new Integer(-1)));
        ArraysTest.assertTrue((String)"Binary search succeeded for value not present in array 2", (Arrays.binarySearch(objectArray, 0, 100, new Integer(100)) == -101 ? 1 : 0) != 0);
        try {
            Arrays.binarySearch((Object[])null, 2, 1, (Object)100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch((Object[])null, -1, 0, (Object)100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch((Object[])null, -1, -2, (Object)100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(objectArray, 2, 1, Character.valueOf('d'));
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        ArraysTest.assertEquals((int)-1, (int)Arrays.binarySearch(objectArray, 0, 0, Character.valueOf('d')));
        try {
            Arrays.binarySearch(objectArray, -1, -2, Character.valueOf('d'));
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(objectArray, 102, 101, Character.valueOf('d'));
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(objectArray, -1, 0, Character.valueOf('d'));
            ArraysTest.fail((String)"should throw ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(objectArray, 0, 101, Character.valueOf('d'));
            ArraysTest.fail((String)"should throw ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void test_binarySearch$Ljava_lang_ObjectIILjava_lang_ObjectLjava_util_Comparator() {
        int counter;
        ReversedIntegerComparator comp = new ReversedIntegerComparator();
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.objectArray[counter] = objArray[100 - counter - 1];
        }
        ArraysTest.assertTrue((String)"Binary search succeeded for value not present in array 1", (Arrays.binarySearch(objectArray, 0, 100, new Integer(-1), comp) == -101 ? 1 : 0) != 0);
        ArraysTest.assertEquals((String)"Binary search succeeded for value not present in array 2", (int)-1, (int)Arrays.binarySearch(objectArray, 0, 100, new Integer(100), comp));
        for (counter = 0; counter < 100; ++counter) {
            ArraysTest.assertTrue((String)"Binary search on Object[] with custom comparator answered incorrect position", (Arrays.binarySearch(objectArray, objArray[counter], comp) == 100 - counter - 1 ? 1 : 0) != 0);
        }
        try {
            Arrays.binarySearch((Object[])null, 2, 1, (Object)100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch((Object[])null, -1, 0, (Object)100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch((Object[])null, -1, -2, (Object)100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(objectArray, 2, 1, Character.valueOf('d'), comp);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        ArraysTest.assertEquals((int)-1, (int)Arrays.binarySearch(objectArray, 0, 0, Character.valueOf('d'), comp));
        try {
            Arrays.binarySearch(objectArray, -1, -2, Character.valueOf('d'), comp);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(objectArray, 102, 101, Character.valueOf('d'), comp);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(objectArray, -1, 0, Character.valueOf('d'), comp);
            ArraysTest.fail((String)"should throw ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(objectArray, 0, 101, Character.valueOf('d'), comp);
            ArraysTest.fail((String)"should throw ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(objectArray, 0, 100, new LinkedList(), comp);
            ArraysTest.fail((String)"should throw ClassCastException");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void test_binarySearch$SIIS() {
        int counter;
        for (counter = 0; counter < 100; counter = (int)((short)(counter + 1))) {
            ArraysTest.assertTrue((String)"Binary search on short[] answered incorrect position", (Arrays.binarySearch(shortArray, counter, 100, (short)counter) == counter ? 1 : 0) != 0);
        }
        ArraysTest.assertEquals((String)"Binary search succeeded for value not present in array 1", (int)-1, (int)Arrays.binarySearch(shortArray, 0, 100, (short)-1));
        ArraysTest.assertTrue((String)"Binary search succeeded for value not present in array 2", (Arrays.binarySearch(shortArray, 0, 100, (short)100) == -101 ? 1 : 0) != 0);
        for (counter = 0; counter < 100; counter = (int)((short)(counter + 1))) {
            int n = counter;
            shortArray[n] = (short)(shortArray[n] - 50);
        }
        for (counter = 0; counter < 100; counter = (int)((short)(counter + 1))) {
            ArraysTest.assertTrue((String)"Binary search on short[] involving negative numbers answered incorrect position", (Arrays.binarySearch(shortArray, counter, 100, (short)(counter - 50)) == counter ? 1 : 0) != 0);
        }
        try {
            Arrays.binarySearch((Object[])null, 2, 1, (Object)100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch((Object[])null, -1, 0, (Object)100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch((Object[])null, -1, -2, (Object)100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(shortArray, 2, 1, (short)100);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        ArraysTest.assertEquals((int)-1, (int)Arrays.binarySearch(shortArray, 0, 0, (short)100));
        try {
            Arrays.binarySearch(shortArray, -1, -2, (short)100);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(shortArray, 102, 101, (short)100);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(shortArray, -1, 0, (short)100);
            ArraysTest.fail((String)"should throw ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Arrays.binarySearch(shortArray, 0, 101, (short)100);
            ArraysTest.fail((String)"should throw ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        String[] array = new String[]{"a", "b", "c"};
        ArraysTest.assertEquals((int)-2, (int)Arrays.binarySearch(array, 1, 2, "a", null));
    }

    public void test_copyOf_$BI() throws Exception {
        int i;
        byte[] result = Arrays.copyOf(byteArray, 200);
        for (i = 0; i < 100; ++i) {
            ArraysTest.assertEquals((int)i, (int)result[i]);
        }
        while (i < result.length) {
            ArraysTest.assertEquals((int)0, (int)result[i]);
            ++i;
        }
        result = Arrays.copyOf(byteArray, 50);
        for (i = 0; i < result.length; ++i) {
            ArraysTest.assertEquals((int)i, (int)result[i]);
        }
        try {
            Arrays.copyOf((byte[])null, 100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOf(byteArray, -1);
            ArraysTest.fail((String)"should throw NegativeArraySizeException");
        }
        catch (NegativeArraySizeException e) {
            // empty catch block
        }
        try {
            Arrays.copyOf((byte[])null, -1);
            ArraysTest.fail((String)"should throw NegativeArraySizeException");
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            // empty catch block
        }
    }

    public void test_copyOf_$SI() throws Exception {
        int i;
        short[] result = Arrays.copyOf(shortArray, 200);
        for (i = 0; i < 100; ++i) {
            ArraysTest.assertEquals((int)i, (int)result[i]);
        }
        while (i < result.length) {
            ArraysTest.assertEquals((int)0, (int)result[i]);
            ++i;
        }
        result = Arrays.copyOf(shortArray, 50);
        for (i = 0; i < result.length; ++i) {
            ArraysTest.assertEquals((int)i, (int)result[i]);
        }
        try {
            Arrays.copyOf((short[])null, 100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOf(shortArray, -1);
            ArraysTest.fail((String)"should throw NegativeArraySizeException");
        }
        catch (NegativeArraySizeException e) {
            // empty catch block
        }
        try {
            Arrays.copyOf((short[])null, -1);
            ArraysTest.fail((String)"should throw NegativeArraySizeException");
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            // empty catch block
        }
    }

    public void test_copyOf_$II() throws Exception {
        int i;
        int[] result = Arrays.copyOf(intArray, 200);
        for (i = 0; i < 100; ++i) {
            ArraysTest.assertEquals((int)i, (int)result[i]);
        }
        while (i < result.length) {
            ArraysTest.assertEquals((int)0, (int)result[i]);
            ++i;
        }
        result = Arrays.copyOf(intArray, 50);
        for (i = 0; i < result.length; ++i) {
            ArraysTest.assertEquals((int)i, (int)result[i]);
        }
        try {
            Arrays.copyOf((int[])null, 100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOf(intArray, -1);
            ArraysTest.fail((String)"should throw NegativeArraySizeException");
        }
        catch (NegativeArraySizeException e) {
            // empty catch block
        }
        try {
            Arrays.copyOf((int[])null, -1);
            ArraysTest.fail((String)"should throw NegativeArraySizeException");
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            // empty catch block
        }
    }

    public void test_copyOf_$ZI() throws Exception {
        int i;
        boolean[] result = Arrays.copyOf(booleanArray, 200);
        for (i = 0; i < 100; ++i) {
            ArraysTest.assertEquals((boolean)booleanArray[i], (boolean)result[i]);
        }
        while (i < result.length) {
            ArraysTest.assertEquals((boolean)false, (boolean)result[i]);
            ++i;
        }
        result = Arrays.copyOf(booleanArray, 50);
        for (i = 0; i < result.length; ++i) {
            ArraysTest.assertEquals((boolean)booleanArray[i], (boolean)result[i]);
        }
        try {
            Arrays.copyOf((boolean[])null, 100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOf(booleanArray, -1);
            ArraysTest.fail((String)"should throw NegativeArraySizeException");
        }
        catch (NegativeArraySizeException e) {
            // empty catch block
        }
        try {
            Arrays.copyOf((boolean[])null, -1);
            ArraysTest.fail((String)"should throw NegativeArraySizeException");
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            // empty catch block
        }
    }

    public void test_copyOf_$CI() throws Exception {
        int i;
        char[] result = Arrays.copyOf(charArray, 200);
        for (i = 0; i < 100; ++i) {
            ArraysTest.assertEquals((int)(i + 1), (int)result[i]);
        }
        while (i < result.length) {
            ArraysTest.assertEquals((int)0, (int)result[i]);
            ++i;
        }
        result = Arrays.copyOf(charArray, 50);
        for (i = 0; i < result.length; ++i) {
            ArraysTest.assertEquals((int)(i + 1), (int)result[i]);
        }
        try {
            Arrays.copyOf((char[])null, 100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOf(charArray, -1);
            ArraysTest.fail((String)"should throw NegativeArraySizeException");
        }
        catch (NegativeArraySizeException e) {
            // empty catch block
        }
        try {
            Arrays.copyOf((char[])null, -1);
            ArraysTest.fail((String)"should throw NegativeArraySizeException");
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            // empty catch block
        }
    }

    public void test_copyOf_$FI() throws Exception {
        int i;
        float[] result = Arrays.copyOf(floatArray, 200);
        for (i = 0; i < 100; ++i) {
            ArraysTest.assertEquals((Object)Float.valueOf(floatArray[i]), (Object)Float.valueOf(result[i]));
        }
        while (i < result.length) {
            ArraysTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(result[i]));
            ++i;
        }
        result = Arrays.copyOf(floatArray, 50);
        for (i = 0; i < result.length; ++i) {
            ArraysTest.assertEquals((Object)Float.valueOf(floatArray[i]), (Object)Float.valueOf(result[i]));
        }
        try {
            Arrays.copyOf((float[])null, 100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOf(floatArray, -1);
            ArraysTest.fail((String)"should throw NegativeArraySizeException");
        }
        catch (NegativeArraySizeException e) {
            // empty catch block
        }
        try {
            Arrays.copyOf((float[])null, -1);
            ArraysTest.fail((String)"should throw NegativeArraySizeException");
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            // empty catch block
        }
    }

    public void test_copyOf_$DI() throws Exception {
        int i;
        double[] result = Arrays.copyOf(doubleArray, 200);
        for (i = 0; i < 100; ++i) {
            ArraysTest.assertEquals((Object)doubleArray[i], (Object)result[i]);
        }
        while (i < result.length) {
            ArraysTest.assertEquals((Object)0.0, (Object)result[i]);
            ++i;
        }
        result = Arrays.copyOf(doubleArray, 50);
        for (i = 0; i < result.length; ++i) {
            ArraysTest.assertEquals((Object)doubleArray[i], (Object)result[i]);
        }
        try {
            Arrays.copyOf((double[])null, 100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOf(doubleArray, -1);
            ArraysTest.fail((String)"should throw NegativeArraySizeException");
        }
        catch (NegativeArraySizeException e) {
            // empty catch block
        }
        try {
            Arrays.copyOf((double[])null, -1);
            ArraysTest.fail((String)"should throw NegativeArraySizeException");
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            // empty catch block
        }
    }

    public void test_copyOf_$JI() throws Exception {
        int i;
        long[] result = Arrays.copyOf(longArray, 200);
        for (i = 0; i < 100; ++i) {
            ArraysTest.assertEquals((long)longArray[i], (long)result[i]);
        }
        while (i < result.length) {
            ArraysTest.assertEquals((long)0L, (long)result[i]);
            ++i;
        }
        result = Arrays.copyOf(longArray, 50);
        for (i = 0; i < result.length; ++i) {
            ArraysTest.assertEquals((long)longArray[i], (long)result[i]);
        }
        try {
            Arrays.copyOf((long[])null, 100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOf(longArray, -1);
            ArraysTest.fail((String)"should throw NegativeArraySizeException");
        }
        catch (NegativeArraySizeException e) {
            // empty catch block
        }
        try {
            Arrays.copyOf((long[])null, -1);
            ArraysTest.fail((String)"should throw NegativeArraySizeException");
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            // empty catch block
        }
    }

    public void test_copyOf_$TI() throws Exception {
        int i;
        Object[] result = Arrays.copyOf(objArray, 200);
        for (i = 0; i < 100; ++i) {
            ArraysTest.assertEquals((Object)objArray[i], (Object)result[i]);
        }
        while (i < result.length) {
            ArraysTest.assertNull((Object)result[i]);
            ++i;
        }
        result = Arrays.copyOf(objArray, 50);
        for (i = 0; i < result.length; ++i) {
            ArraysTest.assertEquals((Object)objArray[i], (Object)result[i]);
        }
        try {
            Arrays.copyOf((String[])null, 100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOf(objArray, -1);
            ArraysTest.fail((String)"should throw NegativeArraySizeException");
        }
        catch (NegativeArraySizeException e) {
            // empty catch block
        }
        try {
            Arrays.copyOf((String[])null, -1);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        Date[] component = new Date[]{};
        Date[] object = new Date[]{};
        object = Arrays.copyOf(component, 2);
        ArraysTest.assertNotNull((Object)object);
        component = Arrays.copyOf(component, 2);
        ArraysTest.assertNotNull((Object)component);
        ArraysTest.assertEquals((int)2, (int)component.length);
    }

    public void test_copyOf_$TILClass() throws Exception {
        int i;
        T[] result = Arrays.copyOf(objArray, 200, Object[].class);
        for (i = 0; i < 100; ++i) {
            ArraysTest.assertEquals((Object)objArray[i], result[i]);
        }
        while (i < result.length) {
            ArraysTest.assertNull(result[i]);
            ++i;
        }
        result = Arrays.copyOf(objArray, 50, Object[].class);
        for (i = 0; i < result.length; ++i) {
            ArraysTest.assertEquals((Object)objArray[i], result[i]);
        }
        result = Arrays.copyOf(objArray, 50, Integer[].class);
        for (i = 0; i < result.length; ++i) {
            ArraysTest.assertEquals((Object)objArray[i], result[i]);
        }
        try {
            Arrays.copyOf(null, 100, LinkedList[].class);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOf(objArray, 100, LinkedList[].class);
            ArraysTest.fail((String)"should throw ArrayStoreException ");
        }
        catch (ArrayStoreException e) {
            // empty catch block
        }
        try {
            Arrays.copyOf(null, 100, Object[].class);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOf(objArray, -1, Object[].class);
            ArraysTest.fail((String)"should throw NegativeArraySizeException");
        }
        catch (NegativeArraySizeException e) {
            // empty catch block
        }
        try {
            Arrays.copyOf(null, -1, Object[].class);
            ArraysTest.fail((String)"should throw NegativeArraySizeException");
        }
        catch (NegativeArraySizeException e) {
            // empty catch block
        }
        try {
            Arrays.copyOf(null, -1, LinkedList[].class);
            ArraysTest.fail((String)"should throw NegativeArraySizeException");
        }
        catch (NegativeArraySizeException e) {
            // empty catch block
        }
        try {
            Arrays.copyOf(null, 0, LinkedList[].class);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        ArraysTest.assertEquals((int)0, (int)((LinkedList[])Arrays.copyOf(objArray, 0, LinkedList[].class)).length);
    }

    public void test_copyOfRange_$BII() throws Exception {
        int i;
        byte[] result = Arrays.copyOfRange(byteArray, 0, 200);
        for (i = 0; i < 100; ++i) {
            ArraysTest.assertEquals((int)i, (int)result[i]);
        }
        while (i < result.length) {
            ArraysTest.assertEquals((int)0, (int)result[i]);
            ++i;
        }
        result = Arrays.copyOfRange(byteArray, 0, 50);
        for (i = 0; i < result.length; ++i) {
            ArraysTest.assertEquals((int)i, (int)result[i]);
        }
        result = Arrays.copyOfRange(byteArray, 0, 0);
        ArraysTest.assertEquals((int)0, (int)result.length);
        try {
            Arrays.copyOfRange((byte[])null, 0, 100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange((byte[])null, -1, 100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange((byte[])null, 0, -1);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange(byteArray, -1, 100);
            ArraysTest.fail((String)"should throw ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange(byteArray, 0, -1);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ArraysTest.assertEquals((int)(byteArray.length + 1), (int)Arrays.copyOfRange(byteArray, 0, byteArray.length + 1).length);
    }

    public void test_copyOfRange_$SII() throws Exception {
        int i;
        short[] result = Arrays.copyOfRange(shortArray, 0, 200);
        for (i = 0; i < 100; ++i) {
            ArraysTest.assertEquals((int)i, (int)result[i]);
        }
        while (i < result.length) {
            ArraysTest.assertEquals((int)0, (int)result[i]);
            ++i;
        }
        result = Arrays.copyOfRange(shortArray, 0, 50);
        for (i = 0; i < result.length; ++i) {
            ArraysTest.assertEquals((int)i, (int)result[i]);
        }
        result = Arrays.copyOfRange(shortArray, 0, 0);
        ArraysTest.assertEquals((int)0, (int)result.length);
        try {
            Arrays.copyOfRange((short[])null, 0, 100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange((short[])null, -1, 100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange((short[])null, 0, -1);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange(shortArray, -1, 100);
            ArraysTest.fail((String)"should throw ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange(shortArray, 0, -1);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ArraysTest.assertEquals((int)(shortArray.length + 1), (int)Arrays.copyOfRange(shortArray, 0, shortArray.length + 1).length);
    }

    public void test_copyOfRange_$III() throws Exception {
        int i;
        int[] result = Arrays.copyOfRange(intArray, 0, 200);
        for (i = 0; i < 100; ++i) {
            ArraysTest.assertEquals((int)i, (int)result[i]);
        }
        while (i < result.length) {
            ArraysTest.assertEquals((int)0, (int)result[i]);
            ++i;
        }
        result = Arrays.copyOfRange(intArray, 0, 50);
        for (i = 0; i < result.length; ++i) {
            ArraysTest.assertEquals((int)i, (int)result[i]);
        }
        result = Arrays.copyOfRange(intArray, 0, 0);
        ArraysTest.assertEquals((int)0, (int)result.length);
        try {
            Arrays.copyOfRange((int[])null, 0, 100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange((int[])null, -1, 100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange((int[])null, 0, -1);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange(intArray, -1, 100);
            ArraysTest.fail((String)"should throw ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange(intArray, 0, -1);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ArraysTest.assertEquals((int)(intArray.length + 1), (int)Arrays.copyOfRange(intArray, 0, intArray.length + 1).length);
    }

    public void test_copyOfRange_$JII() throws Exception {
        int i;
        long[] result = Arrays.copyOfRange(longArray, 0, 200);
        for (i = 0; i < 100; ++i) {
            ArraysTest.assertEquals((long)i, (long)result[i]);
        }
        while (i < result.length) {
            ArraysTest.assertEquals((long)0L, (long)result[i]);
            ++i;
        }
        result = Arrays.copyOfRange(longArray, 0, 50);
        for (i = 0; i < result.length; ++i) {
            ArraysTest.assertEquals((long)i, (long)result[i]);
        }
        result = Arrays.copyOfRange(longArray, 0, 0);
        ArraysTest.assertEquals((int)0, (int)result.length);
        try {
            Arrays.copyOfRange((long[])null, 0, 100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange((long[])null, -1, 100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange((long[])null, 0, -1);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange(longArray, -1, 100);
            ArraysTest.fail((String)"should throw ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange(longArray, 0, -1);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ArraysTest.assertEquals((int)(longArray.length + 1), (int)Arrays.copyOfRange(longArray, 0, longArray.length + 1).length);
    }

    public void test_copyOfRange_$CII() throws Exception {
        int i;
        char[] result = Arrays.copyOfRange(charArray, 0, 200);
        for (i = 0; i < 100; ++i) {
            ArraysTest.assertEquals((int)(i + 1), (int)result[i]);
        }
        while (i < result.length) {
            ArraysTest.assertEquals((int)0, (int)result[i]);
            ++i;
        }
        result = Arrays.copyOfRange(charArray, 0, 50);
        for (i = 0; i < result.length; ++i) {
            ArraysTest.assertEquals((int)(i + 1), (int)result[i]);
        }
        result = Arrays.copyOfRange(charArray, 0, 0);
        ArraysTest.assertEquals((int)0, (int)result.length);
        try {
            Arrays.copyOfRange((char[])null, 0, 100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange((char[])null, -1, 100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange((char[])null, 0, -1);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange(charArray, -1, 100);
            ArraysTest.fail((String)"should throw ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange(charArray, 0, -1);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ArraysTest.assertEquals((int)(charArray.length + 1), (int)Arrays.copyOfRange(charArray, 0, charArray.length + 1).length);
    }

    public void test_copyOfRange_$FII() throws Exception {
        int i;
        float[] result = Arrays.copyOfRange(floatArray, 0, 200);
        for (i = 0; i < 100; ++i) {
            ArraysTest.assertEquals((Object)Float.valueOf(i), (Object)Float.valueOf(result[i]));
        }
        while (i < result.length) {
            ArraysTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(result[i]));
            ++i;
        }
        result = Arrays.copyOfRange(floatArray, 0, 50);
        for (i = 0; i < result.length; ++i) {
            ArraysTest.assertEquals((Object)Float.valueOf(i), (Object)Float.valueOf(result[i]));
        }
        result = Arrays.copyOfRange(floatArray, 0, 0);
        ArraysTest.assertEquals((int)0, (int)result.length);
        try {
            Arrays.copyOfRange((float[])null, 0, 100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange((float[])null, -1, 100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange((float[])null, 0, -1);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange(floatArray, -1, 100);
            ArraysTest.fail((String)"should throw ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange(floatArray, 0, -1);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ArraysTest.assertEquals((int)(floatArray.length + 1), (int)Arrays.copyOfRange(floatArray, 0, floatArray.length + 1).length);
    }

    public void test_copyOfRange_$DII() throws Exception {
        int i;
        double[] result = Arrays.copyOfRange(doubleArray, 0, 200);
        for (i = 0; i < 100; ++i) {
            ArraysTest.assertEquals((Object)i, (Object)result[i]);
        }
        while (i < result.length) {
            ArraysTest.assertEquals((Object)0.0, (Object)result[i]);
            ++i;
        }
        result = Arrays.copyOfRange(doubleArray, 0, 50);
        for (i = 0; i < result.length; ++i) {
            ArraysTest.assertEquals((Object)i, (Object)result[i]);
        }
        result = Arrays.copyOfRange(doubleArray, 0, 0);
        ArraysTest.assertEquals((int)0, (int)result.length);
        try {
            Arrays.copyOfRange((double[])null, 0, 100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange((double[])null, -1, 100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange((double[])null, 0, -1);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange(doubleArray, -1, 100);
            ArraysTest.fail((String)"should throw ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange(doubleArray, 0, -1);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ArraysTest.assertEquals((int)(doubleArray.length + 1), (int)Arrays.copyOfRange(doubleArray, 0, doubleArray.length + 1).length);
    }

    public void test_copyOfRange_$ZII() throws Exception {
        int i;
        boolean[] result = Arrays.copyOfRange(booleanArray, 0, 200);
        for (i = 0; i < 100; ++i) {
            ArraysTest.assertEquals((boolean)booleanArray[i], (boolean)result[i]);
        }
        while (i < result.length) {
            ArraysTest.assertEquals((boolean)false, (boolean)result[i]);
            ++i;
        }
        result = Arrays.copyOfRange(booleanArray, 0, 50);
        for (i = 0; i < result.length; ++i) {
            ArraysTest.assertEquals((boolean)booleanArray[i], (boolean)result[i]);
        }
        result = Arrays.copyOfRange(booleanArray, 0, 0);
        ArraysTest.assertEquals((int)0, (int)result.length);
        try {
            Arrays.copyOfRange((boolean[])null, 0, 100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange((boolean[])null, -1, 100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange((boolean[])null, 0, -1);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange(booleanArray, -1, 100);
            ArraysTest.fail((String)"should throw ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange(booleanArray, 0, -1);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ArraysTest.assertEquals((int)(booleanArray.length + 1), (int)Arrays.copyOfRange(booleanArray, 0, booleanArray.length + 1).length);
    }

    public void test_copyOfRange_$TII() throws Exception {
        int i;
        Object[] result = Arrays.copyOfRange(objArray, 0, 200);
        for (i = 0; i < 100; ++i) {
            ArraysTest.assertEquals((Object)objArray[i], (Object)result[i]);
        }
        while (i < result.length) {
            ArraysTest.assertEquals(null, (Object)result[i]);
            ++i;
        }
        result = Arrays.copyOfRange(objArray, 0, 50);
        for (i = 0; i < result.length; ++i) {
            ArraysTest.assertEquals((Object)objArray[i], (Object)result[i]);
        }
        result = Arrays.copyOfRange(objArray, 0, 0);
        ArraysTest.assertEquals((int)0, (int)result.length);
        try {
            Arrays.copyOfRange((Object[])null, 0, 100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange((Object[])null, -1, 100);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange((Object[])null, 0, -1);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange(objArray, -1, 100);
            ArraysTest.fail((String)"should throw ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange(objArray, 0, -1);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ArraysTest.assertEquals((int)(objArray.length + 1), (int)Arrays.copyOfRange(objArray, 0, objArray.length + 1).length);
    }

    public void test_copyOfRange_$TIILClass() throws Exception {
        int i;
        T[] result = Arrays.copyOfRange(objArray, 0, 200, Integer[].class);
        for (i = 0; i < 100; ++i) {
            ArraysTest.assertEquals((Object)objArray[i], result[i]);
        }
        while (i < result.length) {
            ArraysTest.assertEquals(null, result[i]);
            ++i;
        }
        result = Arrays.copyOfRange(objArray, 0, 50, Integer[].class);
        for (i = 0; i < result.length; ++i) {
            ArraysTest.assertEquals((Object)objArray[i], result[i]);
        }
        result = Arrays.copyOfRange(objArray, 0, 0, Integer[].class);
        ArraysTest.assertEquals((int)0, (int)result.length);
        try {
            Arrays.copyOfRange(null, 0, 100, Integer[].class);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange(null, -1, 100, Integer[].class);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange(null, 0, -1, Integer[].class);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange(objArray, -1, 100, Integer[].class);
            ArraysTest.fail((String)"should throw ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange(objArray, 0, -1, Integer[].class);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange(objArray, 0, -1, LinkedList[].class);
            ArraysTest.fail((String)"should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange(objArray, 0, 1, LinkedList[].class);
            ArraysTest.fail((String)"should throw ArrayStoreException");
        }
        catch (ArrayStoreException e) {
            // empty catch block
        }
        try {
            Arrays.copyOfRange(null, 0, 1, LinkedList[].class);
            ArraysTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            ArraysTest.assertEquals((int)(objArray.length + 1), (int)((LinkedList[])Arrays.copyOfRange(objArray, 0, objArray.length + 1, LinkedList[].class)).length);
            ArraysTest.fail((String)"should throw ArrayStoreException");
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
        ArraysTest.assertEquals((int)0, (int)((LinkedList[])Arrays.copyOfRange(objArray, 0, 0, LinkedList[].class)).length);
    }

    protected void tearDown() {
    }

    public static class Element {
        public int value;
        public int index;
        private static int count = 0;

        public Element(int value) {
            this.value = value;
            this.index = count++;
        }
    }

    static class MockComparable
    implements Comparable {
        MockComparable() {
        }

        public int compareTo(Object o) {
            return 0;
        }
    }

    public static class ReversedIntegerComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            return -((Integer)o1).compareTo((Integer)o2);
        }

        public boolean equals(Object o1, Object o2) {
            return ((Integer)o1).compareTo((Integer)o2) == 0;
        }
    }
}

