/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.tests.java.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import junit.framework.TestCase;
import tests.support.Support_ListTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayListTest
extends TestCase {
    List alist;
    static Object[] objArray;

    public ArrayListTest() {
        objArray = new Object[100];
        for (int i = 0; i < objArray.length; ++i) {
            ArrayListTest.objArray[i] = new Integer(i);
        }
    }

    public void test_Constructor() {
        new Support_ListTest("", this.alist).runTest();
        ArrayList<Integer> subList = new ArrayList<Integer>();
        for (int i = -50; i < 150; ++i) {
            subList.add(new Integer(i));
        }
        new Support_ListTest("", subList.subList(50, 150)).runTest();
    }

    public void test_ConstructorI() {
        ArrayList al = new ArrayList(5);
        ArrayListTest.assertEquals((String)"Incorrect arrayList created", (int)0, (int)al.size());
        al = new ArrayList(0);
        ArrayListTest.assertEquals((String)"Incorrect arrayList created", (int)0, (int)al.size());
        try {
            al = new ArrayList(-1);
            ArrayListTest.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_ConstructorLjava_util_Collection() {
        ArrayList<Object> al = new ArrayList<Object>(Arrays.asList(objArray));
        ArrayListTest.assertTrue((String)"arrayList created from collection has incorrect size", (al.size() == objArray.length ? 1 : 0) != 0);
        for (int counter = 0; counter < objArray.length; ++counter) {
            ArrayListTest.assertTrue((String)"arrayList created from collection has incorrect elements", (al.get(counter) == objArray[counter] ? 1 : 0) != 0);
        }
    }

    public void testConstructorWithConcurrentCollection() {
        Collection<String> collection = this.shrinksOnSize("A", "B", "C", "D");
        ArrayList<String> list = new ArrayList<String>(collection);
        ArrayListTest.assertFalse((boolean)list.contains(null));
    }

    public void test_addILjava_lang_Object() {
        Object o = new Object();
        this.alist.add(50, o);
        ArrayListTest.assertTrue((String)"Failed to add Object", (this.alist.get(50) == o ? 1 : 0) != 0);
        ArrayListTest.assertTrue((String)"Failed to fix up list after insert", (this.alist.get(51) == objArray[50] && this.alist.get(52) == objArray[51] ? 1 : 0) != 0);
        Object oldItem = this.alist.get(25);
        this.alist.add(25, null);
        ArrayListTest.assertNull((String)"Should have returned null", this.alist.get(25));
        ArrayListTest.assertTrue((String)"Should have returned the old item from slot 25", (this.alist.get(26) == oldItem ? 1 : 0) != 0);
        o = new Object();
        this.alist.add(0, o);
        ArrayListTest.assertEquals((String)"Failed to add Object", this.alist.get(0), (Object)o);
        ArrayListTest.assertEquals(this.alist.get(1), (Object)objArray[0]);
        ArrayListTest.assertEquals(this.alist.get(2), (Object)objArray[1]);
        oldItem = this.alist.get(0);
        this.alist.add(0, null);
        ArrayListTest.assertNull((String)"Should have returned null", this.alist.get(0));
        ArrayListTest.assertEquals((String)"Should have returned the old item from slot 0", this.alist.get(1), oldItem);
        try {
            this.alist.add(-1, new Object());
            ArrayListTest.fail((String)"Should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            ArrayListTest.assertNotNull((Object)e.getMessage());
        }
        try {
            this.alist.add(-1, null);
            ArrayListTest.fail((String)"Should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            ArrayListTest.assertNotNull((Object)e.getMessage());
        }
        try {
            this.alist.add(this.alist.size() + 1, new Object());
            ArrayListTest.fail((String)"Should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            ArrayListTest.assertNotNull((Object)e.getMessage());
        }
        try {
            this.alist.add(this.alist.size() + 1, null);
            ArrayListTest.fail((String)"Should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            ArrayListTest.assertNotNull((Object)e.getMessage());
        }
    }

    public void test_addILjava_lang_Object_2() {
        Object o = new Object();
        int size = this.alist.size();
        this.alist.add(size, o);
        ArrayListTest.assertEquals((String)"Failed to add Object", this.alist.get(size), (Object)o);
        ArrayListTest.assertEquals(this.alist.get(size - 2), (Object)objArray[size - 2]);
        ArrayListTest.assertEquals(this.alist.get(size - 1), (Object)objArray[size - 1]);
        this.alist.remove(size);
        size = this.alist.size();
        this.alist.add(size, null);
        ArrayListTest.assertNull((String)"Should have returned null", this.alist.get(size));
        ArrayListTest.assertEquals(this.alist.get(size - 2), (Object)objArray[size - 2]);
        ArrayListTest.assertEquals(this.alist.get(size - 1), (Object)objArray[size - 1]);
    }

    public void test_addLjava_lang_Object() {
        Object o = new Object();
        this.alist.add(o);
        ArrayListTest.assertTrue((String)"Failed to add Object", (this.alist.get(this.alist.size() - 1) == o ? 1 : 0) != 0);
        this.alist.add(null);
        ArrayListTest.assertNull((String)"Failed to add null", this.alist.get(this.alist.size() - 1));
    }

    public void test_addAllILjava_util_Collection() {
        int i;
        this.alist.addAll(50, this.alist);
        ArrayListTest.assertEquals((String)"Returned incorrect size after adding to existing list", (int)200, (int)this.alist.size());
        for (i = 0; i < 50; ++i) {
            ArrayListTest.assertTrue((String)"Manipulated elements < index", (this.alist.get(i) == objArray[i] ? 1 : 0) != 0);
        }
        for (i = 0; i >= 50 && i < 150; ++i) {
            ArrayListTest.assertTrue((String)"Failed to ad elements properly", (this.alist.get(i) == objArray[i - 50] ? 1 : 0) != 0);
        }
        for (i = 0; i >= 150 && i < 200; ++i) {
            ArrayListTest.assertTrue((String)"Failed to ad elements properly", (this.alist.get(i) == objArray[i - 100] ? 1 : 0) != 0);
        }
        ArrayList<String> listWithNulls = new ArrayList<String>();
        listWithNulls.add(null);
        listWithNulls.add(null);
        listWithNulls.add("yoink");
        listWithNulls.add("kazoo");
        listWithNulls.add(null);
        this.alist.addAll(100, listWithNulls);
        ArrayListTest.assertTrue((String)("Incorrect size: " + this.alist.size()), (this.alist.size() == 205 ? 1 : 0) != 0);
        ArrayListTest.assertNull((String)"Item at slot 100 should be null", this.alist.get(100));
        ArrayListTest.assertNull((String)"Item at slot 101 should be null", this.alist.get(101));
        ArrayListTest.assertEquals((String)"Item at slot 102 should be 'yoink'", (Object)"yoink", this.alist.get(102));
        ArrayListTest.assertEquals((String)"Item at slot 103 should be 'kazoo'", (Object)"kazoo", this.alist.get(103));
        ArrayListTest.assertNull((String)"Item at slot 104 should be null", this.alist.get(104));
        this.alist.addAll(205, listWithNulls);
        ArrayListTest.assertTrue((String)("Incorrect size2: " + this.alist.size()), (this.alist.size() == 210 ? 1 : 0) != 0);
    }

    public void test_addAllILjava_util_Collection_2() {
        int i;
        ArrayList obj = new ArrayList();
        try {
            obj.addAll(-1, null);
            ArrayListTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            ArrayListTest.assertNotNull((Object)e.getMessage());
        }
        String[] data = new String[]{"1", "2", "3", "4", "5", "6", "7", "8"};
        ArrayList<String> list1 = new ArrayList<String>();
        ArrayList<Object> list2 = new ArrayList<Object>();
        for (String d : data) {
            list1.add(d);
            list2.add(d);
            list2.add(d);
        }
        while (list1.size() > 0) {
            list1.remove(0);
        }
        list1.addAll(list2);
        ArrayListTest.assertTrue((String)"The object list is not the same as original list", (list1.containsAll(list2) && list2.containsAll(list1) ? 1 : 0) != 0);
        obj = new ArrayList();
        for (int i2 = 0; i2 < 100; ++i2) {
            if (list1.size() <= 0) continue;
            obj.removeAll(list1);
            obj.addAll(list1);
        }
        ArrayListTest.assertTrue((String)"The object list is not the same as original list", (obj.containsAll(list1) && list1.containsAll(obj) ? 1 : 0) != 0);
        list1 = new ArrayList();
        list2 = new ArrayList();
        int location = 2;
        String[] strings = new String[]{"0", "1", "2", "3", "4", "5", "6"};
        int[] integers = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        for (i = 0; i < 7; ++i) {
            list1.add(strings[i]);
        }
        for (i = 0; i < 10; ++i) {
            list2.add(integers[i]);
        }
        list1.remove(location);
        list1.addAll(location, list2);
        for (i = 0; i < integers.length; ++i) {
            ArrayListTest.assertEquals((Object)integers[i], list1.get(location + i));
        }
        for (i = location + 1; i < strings.length; ++i) {
            ArrayListTest.assertEquals((Object)strings[i], list1.get(i + integers.length - 1));
        }
    }

    public void test_addAllILjava_util_Collection_3() {
        ArrayList<Object> obj = new ArrayList<Object>();
        obj.addAll(0, obj);
        obj.addAll(obj.size(), obj);
        try {
            obj.addAll(-1, obj);
            ArrayListTest.fail((String)"Should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            ArrayListTest.assertNotNull((Object)e.getMessage());
        }
        try {
            obj.addAll(obj.size() + 1, obj);
            ArrayListTest.fail((String)"Should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            ArrayListTest.assertNotNull((Object)e.getMessage());
        }
        try {
            obj.addAll(0, null);
            ArrayListTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            obj.addAll(obj.size() + 1, null);
            ArrayListTest.fail((String)"Should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            ArrayListTest.assertNotNull((Object)e.getMessage());
        }
        try {
            obj.addAll(-1, null);
            ArrayListTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            ArrayListTest.assertNotNull((Object)e.getMessage());
        }
    }

    public void test_addAllCollectionOfQextendsE() {
        ArrayList<String> alist = new ArrayList<String>();
        ArrayList<String> blist = new ArrayList<String>();
        alist.add("a");
        alist.add("b");
        blist.add("c");
        blist.add("d");
        blist.remove(0);
        blist.addAll(0, alist);
        ArrayListTest.assertEquals((String)"a", (String)((String)blist.get(0)));
        ArrayListTest.assertEquals((String)"b", (String)((String)blist.get(1)));
        ArrayListTest.assertEquals((String)"d", (String)((String)blist.get(2)));
    }

    public void test_addAllLjava_util_Collection() {
        int i;
        ArrayList l = new ArrayList();
        l.addAll(this.alist);
        for (i = 0; i < this.alist.size(); ++i) {
            ArrayListTest.assertTrue((String)"Failed to add elements properly", (boolean)l.get(i).equals(this.alist.get(i)));
        }
        this.alist.addAll(this.alist);
        ArrayListTest.assertEquals((String)"Returned incorrect size after adding to existing list", (int)200, (int)this.alist.size());
        for (i = 0; i < 100; ++i) {
            ArrayListTest.assertTrue((String)"Added to list in incorrect order", (boolean)this.alist.get(i).equals(l.get(i)));
            ArrayListTest.assertTrue((String)"Failed to add to existing list", (boolean)this.alist.get(i + 100).equals(l.get(i)));
        }
        HashSet<String> setWithNulls = new HashSet<String>();
        setWithNulls.add(null);
        setWithNulls.add(null);
        setWithNulls.add("yoink");
        setWithNulls.add("kazoo");
        setWithNulls.add(null);
        this.alist.addAll(100, setWithNulls);
        Iterator i2 = setWithNulls.iterator();
        ArrayListTest.assertTrue((String)("Item at slot 100 is wrong: " + this.alist.get(100)), (this.alist.get(100) == i2.next() ? 1 : 0) != 0);
        ArrayListTest.assertTrue((String)("Item at slot 101 is wrong: " + this.alist.get(101)), (this.alist.get(101) == i2.next() ? 1 : 0) != 0);
        ArrayListTest.assertTrue((String)("Item at slot 103 is wrong: " + this.alist.get(102)), (this.alist.get(102) == i2.next() ? 1 : 0) != 0);
        try {
            this.alist.addAll(null);
            ArrayListTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        ArrayList<Integer> originalList = new ArrayList<Integer>(12);
        for (int j = 0; j < 12; ++j) {
            originalList.add(j);
        }
        originalList.remove(0);
        originalList.remove(0);
        ArrayList<Integer> additionalList = new ArrayList<Integer>(11);
        for (int j = 0; j < 11; ++j) {
            additionalList.add(j);
        }
        ArrayListTest.assertTrue((boolean)originalList.addAll(additionalList));
        ArrayListTest.assertEquals((int)21, (int)originalList.size());
    }

    public void test_ArrayList_addAll_scenario1() {
        ArrayList<Integer> arrayListA = new ArrayList<Integer>();
        arrayListA.add(1);
        ArrayList<Integer> arrayListB = new ArrayList<Integer>();
        arrayListB.add(1);
        arrayListA.addAll(1, arrayListB);
        int size = arrayListA.size();
        ArrayListTest.assertEquals((int)2, (int)size);
        for (int index = 0; index < size; ++index) {
            ArrayListTest.assertEquals((Object)1, arrayListA.get(index));
        }
    }

    public void test_ArrayList_addAll_scenario2() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(1);
        arrayList.addAll(1, arrayList);
        int size = arrayList.size();
        ArrayListTest.assertEquals((int)2, (int)size);
        for (int index = 0; index < size; ++index) {
            ArrayListTest.assertEquals((Object)1, arrayList.get(index));
        }
    }

    public void testaddAllHarmony5839() {
        List<String> coll = Arrays.asList("1", "2");
        ArrayList<String> list = new ArrayList<String>();
        list.add("a");
        list.add(0, "b");
        list.add(0, "c");
        list.add(0, "d");
        list.add(0, "e");
        list.add(0, "f");
        list.add(0, "g");
        list.add(0, "h");
        list.add(0, "i");
        list.addAll(6, coll);
        ArrayListTest.assertEquals((int)11, (int)list.size());
        ArrayListTest.assertFalse((boolean)list.contains(null));
    }

    public void test_clear() {
        this.alist.clear();
        ArrayListTest.assertEquals((String)"List did not clear", (int)0, (int)this.alist.size());
        this.alist.add(null);
        this.alist.add(null);
        this.alist.add(null);
        this.alist.add("bam");
        this.alist.clear();
        ArrayListTest.assertEquals((String)"List with nulls did not clear", (int)0, (int)this.alist.size());
    }

    public void test_clone() {
        int i;
        ArrayList x = (ArrayList)((ArrayList)this.alist).clone();
        ArrayListTest.assertTrue((String)"Cloned list was inequal to original", (boolean)x.equals(this.alist));
        for (i = 0; i < this.alist.size(); ++i) {
            ArrayListTest.assertTrue((String)"Cloned list contains incorrect elements", (this.alist.get(i) == x.get(i) ? 1 : 0) != 0);
        }
        this.alist.add(null);
        this.alist.add(25, null);
        x = (ArrayList)((ArrayList)this.alist).clone();
        ArrayListTest.assertTrue((String)"nulls test - Cloned list was inequal to original", (boolean)x.equals(this.alist));
        for (i = 0; i < this.alist.size(); ++i) {
            ArrayListTest.assertTrue((String)"nulls test - Cloned list contains incorrect elements", (this.alist.get(i) == x.get(i) ? 1 : 0) != 0);
        }
    }

    public void test_containsLjava_lang_Object() {
        ArrayListTest.assertTrue((String)"Returned false for valid element", (boolean)this.alist.contains(objArray[99]));
        ArrayListTest.assertTrue((String)"Returned false for equal element", (boolean)this.alist.contains(new Integer(8)));
        ArrayListTest.assertTrue((String)"Returned true for invalid element", (!this.alist.contains(new Object()) ? 1 : 0) != 0);
        ArrayListTest.assertTrue((String)"Returned true for null but should have returned false", (!this.alist.contains(null) ? 1 : 0) != 0);
        this.alist.add(null);
        ArrayListTest.assertTrue((String)"Returned false for null but should have returned true", (boolean)this.alist.contains(null));
    }

    public void test_ensureCapacityI() {
        int i;
        Object testObject = new Object();
        int capacity = 20;
        ArrayList<Object> al = new ArrayList<Object>(capacity);
        for (i = 0; i < capacity / 2; ++i) {
            al.add(i, new Object());
        }
        al.add(i, testObject);
        int location = al.indexOf(testObject);
        al.ensureCapacity(capacity);
        ArrayListTest.assertTrue((String)"EnsureCapacity moved objects around in array1.", (location == al.indexOf(testObject) ? 1 : 0) != 0);
        al.remove(0);
        al.ensureCapacity(capacity);
        ArrayListTest.assertTrue((String)"EnsureCapacity moved objects around in array2.", (--location == al.indexOf(testObject) ? 1 : 0) != 0);
        al.ensureCapacity(capacity + 2);
        ArrayListTest.assertTrue((String)"EnsureCapacity did not change location.", (location == al.indexOf(testObject) ? 1 : 0) != 0);
    }

    public void test_getI() {
        ArrayListTest.assertTrue((String)"Returned incorrect element", (this.alist.get(22) == objArray[22] ? 1 : 0) != 0);
        try {
            this.alist.get(8765);
            ArrayListTest.fail((String)"Failed to throw expected exception for index > size");
        }
        catch (IndexOutOfBoundsException e) {
            ArrayListTest.assertNotNull((Object)e.getMessage());
        }
    }

    public void test_indexOfLjava_lang_Object() {
        ArrayListTest.assertEquals((String)"Returned incorrect index", (int)87, (int)this.alist.indexOf(objArray[87]));
        ArrayListTest.assertEquals((String)"Returned index for invalid Object", (int)-1, (int)this.alist.indexOf(new Object()));
        this.alist.add(25, null);
        this.alist.add(50, null);
        ArrayListTest.assertTrue((String)("Wrong indexOf for null.  Wanted 25 got: " + this.alist.indexOf(null)), (this.alist.indexOf(null) == 25 ? 1 : 0) != 0);
    }

    public void test_isEmpty() {
        ArrayListTest.assertTrue((String)"isEmpty returned false for new list", (boolean)new ArrayList().isEmpty());
        ArrayListTest.assertTrue((String)"Returned true for existing list with elements", (!this.alist.isEmpty() ? 1 : 0) != 0);
    }

    public void test_lastIndexOfLjava_lang_Object() {
        this.alist.add(new Integer(99));
        ArrayListTest.assertEquals((String)"Returned incorrect index", (int)100, (int)this.alist.lastIndexOf(objArray[99]));
        ArrayListTest.assertEquals((String)"Returned index for invalid Object", (int)-1, (int)this.alist.lastIndexOf(new Object()));
        this.alist.add(25, null);
        this.alist.add(50, null);
        ArrayListTest.assertTrue((String)("Wrong lastIndexOf for null.  Wanted 50 got: " + this.alist.lastIndexOf(null)), (this.alist.lastIndexOf(null) == 50 ? 1 : 0) != 0);
    }

    public void test_removeRange() {
        MockArrayList mylist = new MockArrayList();
        mylist.removeRange(0, 0);
        try {
            mylist.removeRange(0, 1);
            ArrayListTest.fail((String)"Should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            ArrayListTest.assertNotNull((Object)e.getMessage());
        }
        int[] data = new int[]{1, 2, 3};
        for (int i = 0; i < data.length; ++i) {
            mylist.add(i, data[i]);
        }
        mylist.removeRange(0, 1);
        ArrayListTest.assertEquals((Object)data[1], mylist.get(0));
        ArrayListTest.assertEquals((Object)data[2], mylist.get(1));
        try {
            mylist.removeRange(-1, 1);
            ArrayListTest.fail((String)"Should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            ArrayListTest.assertNotNull((Object)e.getMessage());
        }
        try {
            mylist.removeRange(0, -1);
            ArrayListTest.fail((String)"Should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            ArrayListTest.assertNotNull((Object)e.getMessage());
        }
        try {
            mylist.removeRange(1, 0);
            ArrayListTest.fail((String)"Should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            ArrayListTest.assertNotNull((Object)e.getMessage());
        }
        try {
            mylist.removeRange(2, 1);
            ArrayListTest.fail((String)"Should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            ArrayListTest.assertNotNull((Object)e.getMessage());
        }
    }

    public void test_removeI() {
        this.alist.remove(10);
        ArrayListTest.assertEquals((String)"Failed to remove element", (int)-1, (int)this.alist.indexOf(objArray[10]));
        try {
            this.alist.remove(999);
            ArrayListTest.fail((String)"Failed to throw exception when index out of range");
        }
        catch (IndexOutOfBoundsException e) {
            ArrayListTest.assertNotNull((Object)e.getMessage());
        }
        ArrayList myList = (ArrayList)((ArrayList)this.alist).clone();
        this.alist.add(25, null);
        this.alist.add(50, null);
        this.alist.remove(50);
        this.alist.remove(25);
        ArrayListTest.assertTrue((String)"Removing nulls did not work", (boolean)((Object)this.alist).equals(myList));
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("a", "b", "c", "d", "e", "f", "g"));
        ArrayListTest.assertTrue((String)"Removed wrong element 1", (list.remove(0) == "a" ? 1 : 0) != 0);
        ArrayListTest.assertTrue((String)"Removed wrong element 2", (list.remove(4) == "f" ? 1 : 0) != 0);
        Object[] result = new String[5];
        list.toArray(result);
        ArrayListTest.assertTrue((String)"Removed wrong element 3", (boolean)Arrays.equals(result, new String[]{"b", "c", "d", "e", "g"}));
        ArrayList<Object> l = new ArrayList<Object>(0);
        l.add(new Object());
        l.add(new Object());
        l.remove(0);
        l.remove(0);
        try {
            l.remove(-1);
            ArrayListTest.fail((String)"-1 should cause exception");
        }
        catch (IndexOutOfBoundsException e) {
            ArrayListTest.assertNotNull((Object)e.getMessage());
        }
        try {
            l.remove(0);
            ArrayListTest.fail((String)"0 should case exception");
        }
        catch (IndexOutOfBoundsException e) {
            ArrayListTest.assertNotNull((Object)e.getMessage());
        }
    }

    public void test_setILjava_lang_Object() {
        Object obj = new Object();
        this.alist.set(65, obj);
        ArrayListTest.assertTrue((String)"Failed to set object", (this.alist.get(65) == obj ? 1 : 0) != 0);
        this.alist.set(50, null);
        ArrayListTest.assertNull((String)"Setting to null did not work", this.alist.get(50));
        ArrayListTest.assertTrue((String)("Setting increased the list's size to: " + this.alist.size()), (this.alist.size() == 100 ? 1 : 0) != 0);
        obj = new Object();
        this.alist.set(0, obj);
        ArrayListTest.assertTrue((String)"Failed to set object", (this.alist.get(0) == obj ? 1 : 0) != 0);
        try {
            this.alist.set(-1, obj);
            ArrayListTest.fail((String)"Should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            ArrayListTest.assertNotNull((Object)e.getMessage());
        }
        try {
            this.alist.set(this.alist.size(), obj);
            ArrayListTest.fail((String)"Should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            ArrayListTest.assertNotNull((Object)e.getMessage());
        }
        try {
            this.alist.set(-1, null);
            ArrayListTest.fail((String)"Should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            ArrayListTest.assertNotNull((Object)e.getMessage());
        }
        try {
            this.alist.set(this.alist.size(), null);
            ArrayListTest.fail((String)"Should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            ArrayListTest.assertNotNull((Object)e.getMessage());
        }
    }

    public void test_size() {
        ArrayListTest.assertEquals((String)"Returned incorrect size for exiting list", (int)100, (int)this.alist.size());
        ArrayListTest.assertEquals((String)"Returned incorrect size for new list", (int)0, (int)new ArrayList().size());
    }

    public void test_toString() {
        ArrayList l = new ArrayList(1);
        l.add(l);
        String result = l.toString();
        ArrayListTest.assertTrue((String)"should contain self ref", (result.indexOf("(this") > -1 ? 1 : 0) != 0);
    }

    public void test_toArray() {
        this.alist.set(25, null);
        this.alist.set(75, null);
        Object[] obj = this.alist.toArray();
        ArrayListTest.assertEquals((String)"Returned array of incorrect size", (int)objArray.length, (int)obj.length);
        for (int i = 0; i < obj.length; ++i) {
            if (i == 25 || i == 75) {
                ArrayListTest.assertNull((String)("Should be null at: " + i + " but instead got: " + obj[i]), (Object)obj[i]);
                continue;
            }
            ArrayListTest.assertTrue((String)("Returned incorrect array: " + i), (obj[i] == objArray[i] ? 1 : 0) != 0);
        }
    }

    public void test_toArray$Ljava_lang_Object() {
        this.alist.set(25, null);
        this.alist.set(75, null);
        Integer[] argArray = new Integer[100];
        Integer[] retArray = this.alist.toArray(argArray);
        ArrayListTest.assertTrue((String)"Returned different array than passed", (retArray == argArray ? 1 : 0) != 0);
        argArray = new Integer[1000];
        retArray = this.alist.toArray(argArray);
        ArrayListTest.assertNull((String)"Failed to set first extra element to null", (Object)argArray[this.alist.size()]);
        for (int i = 0; i < 100; ++i) {
            if (i == 25 || i == 75) {
                ArrayListTest.assertNull((String)("Should be null: " + i), (Object)retArray[i]);
                continue;
            }
            ArrayListTest.assertTrue((String)("Returned incorrect array: " + i), (retArray[i] == objArray[i] ? 1 : 0) != 0);
        }
    }

    public void test_trimToSize() {
        int i;
        for (i = 99; i > 24; --i) {
            this.alist.remove(i);
        }
        ((ArrayList)this.alist).trimToSize();
        ArrayListTest.assertEquals((String)"Returned incorrect size after trim", (int)25, (int)this.alist.size());
        for (i = 0; i < this.alist.size(); ++i) {
            ArrayListTest.assertTrue((String)"Trimmed list contained incorrect elements", (this.alist.get(i) == objArray[i] ? 1 : 0) != 0);
        }
        Vector<String> v = new Vector<String>();
        v.add("a");
        ArrayList al = new ArrayList(v);
        Iterator it = al.iterator();
        al.trimToSize();
        try {
            it.next();
            ArrayListTest.fail((String)"should throw a ConcurrentModificationException");
        }
        catch (ConcurrentModificationException ioobe) {
            // empty catch block
        }
    }

    public void test_addAll() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        ArrayListTest.assertEquals((int)2, (int)list.size());
        list.remove(0);
        ArrayListTest.assertEquals((int)1, (int)list.size());
        ArrayList<String> collection = new ArrayList<String>();
        collection.add("1");
        collection.add("2");
        collection.add("3");
        ArrayListTest.assertEquals((int)3, (int)collection.size());
        list.addAll(0, collection);
        ArrayListTest.assertEquals((int)4, (int)list.size());
        list.remove(0);
        list.remove(0);
        ArrayListTest.assertEquals((int)2, (int)list.size());
        collection.add("4");
        collection.add("5");
        collection.add("6");
        collection.add("7");
        collection.add("8");
        collection.add("9");
        collection.add("10");
        collection.add("11");
        collection.add("12");
        ArrayListTest.assertEquals((int)12, (int)collection.size());
        list.addAll(0, collection);
        ArrayListTest.assertEquals((int)14, (int)list.size());
    }

    public void testAddAllWithConcurrentCollection() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.shrinksOnSize("A", "B", "C", "D"));
        ArrayListTest.assertFalse((boolean)list.contains(null));
    }

    public void testAddAllAtPositionWithConcurrentCollection() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("A", "B", "C", "D"));
        list.addAll(3, this.shrinksOnSize("E", "F", "G", "H"));
        ArrayListTest.assertFalse((boolean)list.contains(null));
    }

    public void test_override_size() throws Exception {
        MockArrayList testlist = new MockArrayList();
        testlist.add("test_0");
        testlist.add("test_1");
        testlist.add("test_2");
        testlist.add(1, "test_3");
        testlist.get(1);
        testlist.remove(2);
        testlist.set(1, "test_4");
    }

    public void test_subclassing() {
        ArrayListExtend a = new ArrayListExtend();
        for (int i = 0; i < 100; ++i) {
            a.add(new Object());
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.alist = new ArrayList();
        for (int i = 0; i < objArray.length; ++i) {
            this.alist.add(objArray[i]);
        }
    }

    private <T> Collection<T> shrinksOnSize(T ... elements) {
        return new HashSet<T>(Arrays.asList(elements)){
            boolean shrink;
            {
                this.shrink = true;
            }

            @Override
            public int size() {
                int result = super.size();
                if (this.shrink) {
                    Iterator i = this.iterator();
                    i.next();
                    i.remove();
                }
                return result;
            }

            @Override
            public Object[] toArray() {
                this.shrink = false;
                return super.toArray();
            }
        };
    }

    public class MockArrayList
    extends ArrayList {
        public int size() {
            return 0;
        }

        public void removeRange(int start, int end) {
            super.removeRange(start, end);
        }
    }

    public static class ArrayListExtend
    extends ArrayList {
        private int size = 0;

        public ArrayListExtend() {
            super(10);
        }

        public boolean add(Object o) {
            ++this.size;
            return super.add(o);
        }

        public int size() {
            return this.size;
        }
    }
}

