/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.tests.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import dalvik.annotation.TestTargets;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import junit.framework.TestCase;

@TestTargetClass(value=AbstractSet.class)
public class AbstractSetTest
extends TestCase {
    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="hashCode", args={})
    public void testHashCode() {
        Mock_AbstractSet as = new Mock_AbstractSet();
        AbstractSetTest.assertNotNull((Object)as.hashCode());
    }

    @TestTargets(value={@TestTargetNew(level=TestLevel.COMPLETE, notes="", method="equals", args={Object.class}), @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="AbstractSet", args={})})
    public void testEquals() {
        Mock_AbstractSet as1 = new Mock_AbstractSet();
        Mock_AbstractSet as2 = new Mock_AbstractSet();
        AbstractSetTest.assertTrue((boolean)as1.equals(as2));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="", method="removeAll", args={Collection.class})
    public void testRemoveAll() {
        AbstractSet as = new AbstractSet(){

            public Iterator iterator() {
                return new Iterator(){

                    public boolean hasNext() {
                        return true;
                    }

                    public Object next() {
                        return null;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public int size() {
                return 10;
            }
        };
        try {
            as.removeAll(null);
            AbstractSetTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        Vector<Object> c = new Vector<Object>();
        c.add(null);
        try {
            as.removeAll(c);
            AbstractSetTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        as = new Mock_AbstractSet();
        as.removeAll(c);
    }

    class Mock_AbstractSet
    extends AbstractSet {
        Mock_AbstractSet() {
        }

        public Iterator iterator() {
            return new Iterator(){

                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    return null;
                }

                public void remove() {
                }
            };
        }

        public int size() {
            return 0;
        }
    }
}

