/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.tests.java.util;

import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargetNew;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.WeakHashMap;
import junit.framework.TestCase;

@TestTargetClass(value=AbstractMap.class)
public class AbstractMapTest
extends TestCase {
    static final String specialKey = "specialKey".intern();
    static final String specialValue = "specialValue".intern();

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Class is abstract. Functionality tested in subclasses for example in java.util.HashMap.", method="keySet", args={})
    public void test_keySet() {
        HashMap map1 = new HashMap(0);
        AbstractMapTest.assertSame((String)"HashMap(0)", ((AbstractMap)map1).keySet(), ((AbstractMap)map1).keySet());
        HashMap map2 = new HashMap(10);
        AbstractMapTest.assertSame((String)"HashMap(10)", ((AbstractMap)map2).keySet(), ((AbstractMap)map2).keySet());
        Map map3 = Collections.EMPTY_MAP;
        AbstractMapTest.assertSame((String)"EMPTY_MAP", map3.keySet(), map3.keySet());
        IdentityHashMap map4 = new IdentityHashMap(1);
        AbstractMapTest.assertSame((String)"IdentityHashMap", ((AbstractMap)map4).keySet(), ((AbstractMap)map4).keySet());
        LinkedHashMap map5 = new LinkedHashMap(122);
        AbstractMapTest.assertSame((String)"LinkedHashMap", ((AbstractMap)map5).keySet(), ((AbstractMap)map5).keySet());
        TreeMap map6 = new TreeMap();
        AbstractMapTest.assertSame((String)"TreeMap", ((AbstractMap)map6).keySet(), ((AbstractMap)map6).keySet());
        WeakHashMap map7 = new WeakHashMap();
        AbstractMapTest.assertSame((String)"WeakHashMap", ((AbstractMap)map7).keySet(), ((AbstractMap)map7).keySet());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Class is abstract. Functionality tested in subclasses for example in java.util.HashMap.", method="remove", args={Object.class})
    public void test_removeLjava_lang_Object() {
        Object key = new Object();
        Object value = new Object();
        HashMap<String, Object> map1 = new HashMap<String, Object>(0);
        ((AbstractMap)map1).put("key", value);
        AbstractMapTest.assertSame((String)"HashMap(0)", ((AbstractMap)map1).remove("key"), (Object)value);
        IdentityHashMap<Object, Object> map4 = new IdentityHashMap<Object, Object>(1);
        ((AbstractMap)map4).put(key, value);
        AbstractMapTest.assertSame((String)"IdentityHashMap", ((AbstractMap)map4).remove(key), (Object)value);
        LinkedHashMap<Object, Object> map5 = new LinkedHashMap<Object, Object>(122);
        ((AbstractMap)map5).put(key, value);
        AbstractMapTest.assertSame((String)"LinkedHashMap", ((AbstractMap)map5).remove(key), (Object)value);
        TreeMap<Object, Object> map6 = new TreeMap<Object, Object>(new Comparator(){

            public int compare(Object object1, Object object2) {
                return 0;
            }
        });
        ((AbstractMap)map6).put(key, value);
        AbstractMapTest.assertSame((String)"TreeMap", ((AbstractMap)map6).remove(key), (Object)value);
        WeakHashMap<Object, Object> map7 = new WeakHashMap<Object, Object>();
        ((AbstractMap)map7).put(key, value);
        AbstractMapTest.assertSame((String)"WeakHashMap", ((AbstractMap)map7).remove(key), (Object)value);
        MyMap aSpecialMap = new MyMap();
        ((AbstractMap)aSpecialMap).put(specialKey, specialValue);
        Object valueOut = aSpecialMap.remove(specialKey);
        AbstractMapTest.assertSame((String)"MyMap", valueOut, (Object)specialValue);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Class is abstract. Functionality tested in subclasses for example in java.util.HashMap.", method="values", args={})
    public void test_values() {
        HashMap map1 = new HashMap(0);
        AbstractMapTest.assertSame((String)"HashMap(0)", ((AbstractMap)map1).values(), ((AbstractMap)map1).values());
        HashMap map2 = new HashMap(10);
        AbstractMapTest.assertSame((String)"HashMap(10)", ((AbstractMap)map2).values(), ((AbstractMap)map2).values());
        Map map3 = Collections.EMPTY_MAP;
        AbstractMapTest.assertSame((String)"EMPTY_MAP", map3.values(), map3.values());
        IdentityHashMap map4 = new IdentityHashMap(1);
        AbstractMapTest.assertSame((String)"IdentityHashMap", ((AbstractMap)map4).values(), ((AbstractMap)map4).values());
        LinkedHashMap map5 = new LinkedHashMap(122);
        AbstractMapTest.assertSame((String)"IdentityHashMap", ((AbstractMap)map5).values(), ((AbstractMap)map5).values());
        TreeMap map6 = new TreeMap();
        AbstractMapTest.assertSame((String)"TreeMap", ((AbstractMap)map6).values(), ((AbstractMap)map6).values());
        WeakHashMap map7 = new WeakHashMap();
        AbstractMapTest.assertSame((String)"WeakHashMap", ((AbstractMap)map7).values(), ((AbstractMap)map7).values());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Class is abstract. Functionality tested in subclasses for example in java.util.HashMap.", method="clone", args={})
    public void test_clone() {
        class MyMap
        extends AbstractMap
        implements Cloneable {
            private Map map = new HashMap();

            MyMap() {
            }

            public Set entrySet() {
                return this.map.entrySet();
            }

            public Object put(Object key, Object value) {
                return this.map.put(key, value);
            }

            public Map getMap() {
                return this.map;
            }

            public Object clone() {
                try {
                    return super.clone();
                }
                catch (CloneNotSupportedException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
        MyMap map = new MyMap();
        map.put("one", "1");
        Map.Entry entry = (Map.Entry)map.entrySet().iterator().next();
        AbstractMapTest.assertTrue((String)"entry not added", (entry.getKey() == "one" && entry.getValue() == "1" ? 1 : 0) != 0);
        MyMap mapClone = (MyMap)map.clone();
        AbstractMapTest.assertTrue((String)"clone not shallow", (map.getMap() == mapClone.getMap() ? 1 : 0) != 0);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Class is abstract. Functionality tested in subclasses for example in java.util.HashMap.", method="clear", args={})
    public void test_clear() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        ((AbstractMap)map).put(1, 1);
        ((AbstractMap)map).clear();
        AbstractMapTest.assertTrue((boolean)((AbstractMap)map).isEmpty());
        MocAbstractMap myMap = new MocAbstractMap();
        try {
            myMap.clear();
            AbstractMapTest.fail((String)"Should throw UnsupportedOprationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Class is abstract. Functionality tested in subclasses for example in java.util.HashMap.", method="containsKey", args={Object.class})
    public void test_containsKey() {
        AMT map = new AMT();
        AbstractMapTest.assertFalse((boolean)map.containsKey("k"));
        AbstractMapTest.assertFalse((boolean)map.containsKey(null));
        ((AbstractMap)map).put("k", "v");
        ((AbstractMap)map).put("key", null);
        ((AbstractMap)map).put(null, "value");
        ((AbstractMap)map).put(null, null);
        AbstractMapTest.assertTrue((boolean)map.containsKey("k"));
        AbstractMapTest.assertTrue((boolean)map.containsKey("key"));
        AbstractMapTest.assertTrue((boolean)map.containsKey(null));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Class is abstract. Functionality tested in subclasses for example in java.util.HashMap.", method="containsValue", args={Object.class})
    public void test_containValue() {
        AMT map = new AMT();
        AbstractMapTest.assertFalse((boolean)map.containsValue("v"));
        AbstractMapTest.assertFalse((boolean)map.containsValue(null));
        ((AbstractMap)map).put("k", "v");
        ((AbstractMap)map).put("key", null);
        ((AbstractMap)map).put(null, "value");
        AbstractMapTest.assertTrue((boolean)map.containsValue("v"));
        AbstractMapTest.assertTrue((boolean)map.containsValue("value"));
        AbstractMapTest.assertTrue((boolean)map.containsValue(null));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Class is abstract. Functionality tested in subclasses for example in java.util.HashMap.", method="get", args={Object.class})
    public void test_get() {
        AMT map = new AMT();
        AbstractMapTest.assertNull(map.get("key"));
        AbstractMapTest.assertNull(map.get(null));
        ((AbstractMap)map).put("k", "v");
        ((AbstractMap)map).put("key", null);
        ((AbstractMap)map).put(null, "value");
        AbstractMapTest.assertEquals((Object)"v", map.get("k"));
        AbstractMapTest.assertNull(map.get("key"));
        AbstractMapTest.assertEquals((Object)"value", map.get(null));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Class is abstract. Functionality tested in subclasses for example in java.util.HashMap.", method="putAll", args={Map.class})
    public void test_putAllLMap() {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        AMT amt = new AMT();
        ht.put("this", "that");
        amt.putAll(ht);
        AbstractMapTest.assertEquals((String)"Should be equal", (Object)amt, ht);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Class is abstract. Functionality tested in subclasses for example in java.util.HashMap.", method="AbstractMap", args={})
    public void test_Constructor() {
        AMT amt = new AMT();
        AbstractMapTest.assertNotNull((Object)amt);
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Class is abstract. Functionality tested in subclasses for example in java.util.HashMap.", method="equals", args={Object.class})
    public void test_equalsLjava_lang_Object() {
        AMT amt1 = new AMT();
        AMT amt2 = new AMT();
        AbstractMapTest.assertTrue((String)"assert 0", (boolean)amt1.equals(amt2));
        AbstractMapTest.assertTrue((String)"assert 1", (boolean)amt1.equals(amt1));
        AbstractMapTest.assertTrue((String)"assert 2", (boolean)amt2.equals(amt1));
        ((AbstractMap)amt1).put("1", "one");
        AbstractMapTest.assertFalse((String)"assert 3", (boolean)amt1.equals(amt2));
        ((AbstractMap)amt1).put("2", "two");
        ((AbstractMap)amt1).put("3", "three");
        ((AbstractMap)amt2).put("1", "one");
        ((AbstractMap)amt2).put("2", "two");
        ((AbstractMap)amt2).put("3", "three");
        AbstractMapTest.assertTrue((String)"assert 4", (boolean)amt1.equals(amt2));
        AbstractMapTest.assertFalse((String)"assert 5", (boolean)amt1.equals((Object)this));
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Class is abstract. Functionality tested in subclasses for example in java.util.HashMap.", method="hashCode", args={})
    public void test_hashCode() {
        AMT amt1 = new AMT();
        AMT amt2 = new AMT();
        amt1.put("1", "one");
        AbstractMapTest.assertNotSame((Object)amt1.hashCode(), (Object)amt2.hashCode());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Class is abstract. Functionality tested in subclasses for example in java.util.HashMap.", method="isEmpty", args={})
    public void test_isEmpty() {
        AMT amt = new AMT();
        AbstractMapTest.assertTrue((boolean)amt.isEmpty());
        amt.put("1", "one");
        AbstractMapTest.assertFalse((boolean)amt.isEmpty());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Class is abstract. Functionality tested in subclasses for example in java.util.HashMap.", method="put", args={Object.class, Object.class})
    public void test_put() {
        AMT amt = new AMT();
        AbstractMapTest.assertEquals((int)0, (int)amt.size());
        amt.put("1", "one");
        AbstractMapTest.assertEquals((int)1, (int)amt.size());
        amt.put("2", "two");
        AbstractMapTest.assertEquals((int)2, (int)amt.size());
        amt.put("3", "three");
        AbstractMapTest.assertEquals((int)3, (int)amt.size());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Class is abstract. Functionality tested in subclasses for example in java.util.HashMap.", method="size", args={})
    public void test_size() {
        AMT amt = new AMT();
        AbstractMapTest.assertEquals((int)0, (int)amt.size());
        amt.put("1", "one");
        AbstractMapTest.assertEquals((int)1, (int)amt.size());
        amt.put("2", "two");
        AbstractMapTest.assertEquals((int)2, (int)amt.size());
        amt.put("3", "three");
        AbstractMapTest.assertEquals((int)3, (int)amt.size());
    }

    @TestTargetNew(level=TestLevel.COMPLETE, notes="Class is abstract. Functionality tested in subclasses for example in java.util.HashMap.", method="toString", args={})
    public void test_toString() {
        AMT amt = new AMT();
        AbstractMapTest.assertEquals((String)"{}", (String)amt.toString());
        amt.put("1", "one");
        AbstractMapTest.assertEquals((String)"{1=one}", (String)amt.toString());
        amt.put("2", "two");
        AbstractMapTest.assertEquals((String)"{1=one, 2=two}", (String)amt.toString());
        amt.put("3", "three");
        AbstractMapTest.assertEquals((String)"{1=one, 2=two, 3=three}", (String)amt.toString());
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public class AMT
    extends AbstractMap {
        Vector values = new Vector();
        Vector keys = new Vector();

        public Set entrySet() {
            return new AbstractSet(){

                public Iterator iterator() {
                    return new Iterator(){
                        int index = 0;

                        public boolean hasNext() {
                            return this.index < AMT.this.values.size();
                        }

                        public Object next() {
                            if (this.index < AMT.this.values.size()) {
                                Map.Entry me = new Map.Entry(){
                                    Object v;
                                    Object k;
                                    {
                                        this.v = AMT.this.values.elementAt(index);
                                        this.k = AMT.this.keys.elementAt(index);
                                    }

                                    public Object getKey() {
                                        return this.k;
                                    }

                                    public Object getValue() {
                                        return this.v;
                                    }

                                    public Object setValue(Object value) {
                                        return null;
                                    }
                                };
                                ++this.index;
                                return me;
                            }
                            return null;
                        }

                        public void remove() {
                        }
                    };
                }

                public int size() {
                    return AMT.this.values.size();
                }
            };
        }

        public Object put(Object k, Object v) {
            this.keys.add(k);
            this.values.add(v);
            return v;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MocAbstractMap<K, V>
    extends AbstractMap {
        MocAbstractMap() {
        }

        @Override
        public Set entrySet() {
            MySet set = new MySet();
            return set;
        }

        class MySet
        extends HashSet {
            MySet() {
            }

            public void clear() {
                throw new UnsupportedOperationException();
            }
        }
    }

    class MyMap
    extends AbstractMap {
        final Set mySet = new HashSet(1);

        MyMap() {
            this.mySet.add(new Map.Entry(){

                public Object getKey() {
                    return specialKey;
                }

                public Object getValue() {
                    return specialValue;
                }

                public Object setValue(Object object) {
                    return null;
                }
            });
        }

        public Object put(Object key, Object value) {
            return null;
        }

        public Set entrySet() {
            return this.mySet;
        }
    }
}

