/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.tests.java.util;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;

public class AbstractCollectionTest
extends TestCase {
    public void test_addLjava_lang_Object() {
        AbstractCollection<Object> ac = new AbstractCollection<Object>(){

            @Override
            public Iterator<Object> iterator() {
                Assert.fail((String)"iterator should not get called");
                return null;
            }

            @Override
            public int size() {
                Assert.fail((String)"size should not get called");
                return 0;
            }
        };
        try {
            ac.add(null);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void test_addAllLjava_util_Collection() {
        final List<String> fixtures = Arrays.asList("0", "1", "2");
        AbstractCollection<String> ac = new AbstractCollection<String>(){

            @Override
            public boolean add(String object) {
                Assert.assertTrue((boolean)fixtures.contains(object));
                return true;
            }

            @Override
            public Iterator<String> iterator() {
                Assert.fail((String)"iterator should not get called");
                return null;
            }

            @Override
            public int size() {
                Assert.fail((String)"size should not get called");
                return 0;
            }
        };
        AbstractCollectionTest.assertTrue((boolean)ac.addAll(fixtures));
    }

    public void test_containsAllLjava_util_Collection() {
        final List<String> fixtures = Arrays.asList("0", "1", "2");
        AbstractCollection<String> ac = new AbstractCollection<String>(){

            @Override
            public boolean contains(Object object) {
                Assert.assertTrue((boolean)fixtures.contains(object));
                return true;
            }

            @Override
            public Iterator<String> iterator() {
                Assert.fail((String)"iterator should not get called");
                return null;
            }

            @Override
            public int size() {
                Assert.fail((String)"size should not get called");
                return 0;
            }
        };
        AbstractCollectionTest.assertTrue((boolean)ac.containsAll(fixtures));
    }

    public void test_isEmpty() {
        final boolean[] sizeCalled = new boolean[1];
        AbstractCollection<Object> ac = new AbstractCollection<Object>(){

            @Override
            public Iterator<Object> iterator() {
                Assert.fail((String)"iterator should not get called");
                return null;
            }

            @Override
            public int size() {
                sizeCalled[0] = true;
                return 0;
            }
        };
        AbstractCollectionTest.assertTrue((boolean)ac.isEmpty());
        AbstractCollectionTest.assertTrue((boolean)sizeCalled[0]);
    }

    public void test_removeAllLjava_util_Collection() {
        final String[] removed = new String[3];
        AbstractCollection<String> ac = new AbstractCollection<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    String[] values = new String[]{"0", "1", "2"};
                    int index;

                    @Override
                    public boolean hasNext() {
                        return this.index < this.values.length;
                    }

                    @Override
                    public String next() {
                        return this.values[this.index++];
                    }

                    @Override
                    public void remove() {
                        removed[this.index - 1] = this.values[this.index - 1];
                    }
                };
            }

            @Override
            public int size() {
                Assert.fail((String)"size should not get called");
                return 0;
            }
        };
        AbstractCollectionTest.assertTrue((boolean)ac.removeAll(Arrays.asList("0", "1", "2")));
        for (String r : removed) {
            if ("0".equals(r) || "1".equals(r) || "2".equals(r)) continue;
            AbstractCollectionTest.fail((String)"an unexpected element was removed");
        }
    }

    public void test_retainAllLjava_util_Collection() {
        final String[] removed = new String[1];
        AbstractCollection<String> ac = new AbstractCollection<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    String[] values = new String[]{"0", "1", "2"};
                    int index;

                    @Override
                    public boolean hasNext() {
                        return this.index < this.values.length;
                    }

                    @Override
                    public String next() {
                        return this.values[this.index++];
                    }

                    @Override
                    public void remove() {
                        removed[this.index - 1] = this.values[this.index - 1];
                    }
                };
            }

            @Override
            public int size() {
                Assert.fail((String)"size should not get called");
                return 0;
            }
        };
        AbstractCollectionTest.assertTrue((boolean)ac.retainAll(Arrays.asList("1", "2")));
        AbstractCollectionTest.assertEquals((String)"0", (String)removed[0]);
    }

    public void test_toArray() {
        AbstractCollection<String> ac = new AbstractCollection<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    String[] values = new String[]{"0", "1", "2"};
                    int index;

                    @Override
                    public boolean hasNext() {
                        return this.index < this.values.length;
                    }

                    @Override
                    public String next() {
                        return this.values[this.index++];
                    }

                    @Override
                    public void remove() {
                        Assert.fail((String)"remove should not get called");
                    }
                };
            }

            @Override
            public int size() {
                return 3;
            }
        };
        Object[] array = ac.toArray();
        AbstractCollectionTest.assertEquals((int)3, (int)array.length);
        for (Object o : array) {
            if ("0".equals(o) || "1".equals(o) || "2".equals(o)) continue;
            AbstractCollectionTest.fail((String)"an unexpected element was removed");
        }
    }

    public void test_toArray$Ljava_lang_Object() {
        AbstractCollection<String> ac = new AbstractCollection<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    String[] values = new String[]{"0", "1", "2"};
                    int index;

                    @Override
                    public boolean hasNext() {
                        return this.index < this.values.length;
                    }

                    @Override
                    public String next() {
                        return this.values[this.index++];
                    }

                    @Override
                    public void remove() {
                        Assert.fail((String)"remove should not get called");
                    }
                };
            }

            @Override
            public int size() {
                return 3;
            }
        };
        try {
            ac.toArray((T[])null);
            AbstractCollectionTest.fail((String)"No expected NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            ac.toArray(new StringBuffer[ac.size()]);
            AbstractCollectionTest.fail((String)"No expected ArrayStoreException");
        }
        catch (ArrayStoreException e) {
            // empty catch block
        }
        String[] a = new String[3];
        AbstractCollectionTest.assertSame((Object)a, (Object)ac.toArray(a));
        a = new String[]{};
        AbstractCollectionTest.assertNotSame((Object)a, (Object)ac.toArray(a));
        a = ac.toArray(a);
        AbstractCollectionTest.assertEquals((int)3, (int)a.length);
        CharSequence[] csa = new CharSequence[3];
        ac.toArray(csa);
        AbstractCollectionTest.assertEquals((int)3, (int)csa.length);
        AbstractCollectionTest.assertEquals((Object)"0", (Object)csa[0]);
        AbstractCollectionTest.assertEquals((Object)"1", (Object)csa[1]);
        AbstractCollectionTest.assertEquals((Object)"2", (Object)csa[2]);
    }

    public void test_toString() {
        AbstractCollection<Object> c = new AbstractCollection<Object>(){

            @Override
            public int size() {
                return 1;
            }

            @Override
            public Iterator<Object> iterator() {
                return null;
            }
        };
        try {
            c.toString();
            AbstractCollectionTest.fail((String)"No expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

