/*
 * Decompiled with CFR 0.152.
 */
package libcore.javax.net.ssl;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.net.ssl.SSLSocket;
import libcore.javax.net.ssl.TestSSLContext;

public final class TestSSLSocketPair {
    public final TestSSLContext c;
    public final SSLSocket server;
    public final SSLSocket client;

    private TestSSLSocketPair(TestSSLContext c, SSLSocket server, SSLSocket client) {
        this.c = c;
        this.server = server;
        this.client = client;
    }

    public static TestSSLSocketPair create() {
        TestSSLContext c = TestSSLContext.create();
        SSLSocket[] sockets = TestSSLSocketPair.connect(c, null, null);
        return new TestSSLSocketPair(c, sockets[0], sockets[1]);
    }

    public static SSLSocket[] connect(TestSSLContext context, final String[] clientCipherSuites, final String[] serverCipherSuites) {
        try {
            final SSLSocket client = (SSLSocket)context.clientContext.getSocketFactory().createSocket(context.host, context.port);
            final SSLSocket server = (SSLSocket)context.serverSocket.accept();
            ExecutorService executor = Executors.newFixedThreadPool(2);
            Future<Void> s = executor.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (serverCipherSuites != null) {
                        server.setEnabledCipherSuites(serverCipherSuites);
                    }
                    server.startHandshake();
                    return null;
                }
            });
            Future<Void> c = executor.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (clientCipherSuites != null) {
                        client.setEnabledCipherSuites(clientCipherSuites);
                    }
                    client.startHandshake();
                    return null;
                }
            });
            executor.shutdown();
            s.get();
            c.get();
            return new SSLSocket[]{server, client};
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

