/*
 * Decompiled with CFR 0.152.
 */
package libcore.javax.net.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;
import junit.framework.Assert;
import libcore.javax.net.ssl.TestSSLContext;

public final class TestSSLEnginePair
extends Assert {
    public final TestSSLContext c;
    public final SSLEngine server;
    public final SSLEngine client;
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocate(0);

    private TestSSLEnginePair(TestSSLContext c, SSLEngine server, SSLEngine client) {
        this.c = c;
        this.server = server;
        this.client = client;
    }

    public static TestSSLEnginePair create(Hooks hooks) throws IOException {
        return TestSSLEnginePair.create(TestSSLContext.create(), hooks);
    }

    public static TestSSLEnginePair create(TestSSLContext c, Hooks hooks) throws IOException {
        SSLEngine[] engines = TestSSLEnginePair.connect(c, hooks);
        return new TestSSLEnginePair(c, engines[0], engines[1]);
    }

    public static SSLEngine[] connect(TestSSLContext c, Hooks hooks) throws IOException {
        boolean progress;
        if (hooks == null) {
            hooks = new Hooks();
        }
        SSLSession session = c.clientContext.createSSLEngine().getSession();
        int packetBufferSize = session.getPacketBufferSize();
        ByteBuffer clientToServer = ByteBuffer.allocate(packetBufferSize);
        ByteBuffer serverToClient = ByteBuffer.allocate(packetBufferSize);
        int applicationBufferSize = session.getApplicationBufferSize();
        ByteBuffer scratch = ByteBuffer.allocate(applicationBufferSize);
        SSLEngine client = c.clientContext.createSSLEngine();
        SSLEngine server = c.serverContext.createSSLEngine();
        client.setUseClientMode(true);
        server.setUseClientMode(false);
        hooks.beforeBeginHandshake(client, server);
        client.beginHandshake();
        server.beginHandshake();
        do {
            boolean serverDone;
            boolean clientDone = client.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            boolean bl = serverDone = server.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            if (clientDone && serverDone) break;
            progress = false;
            if (!clientDone) {
                progress |= TestSSLEnginePair.handshakeCompleted(client, clientToServer, serverToClient, scratch);
            }
            if (serverDone) continue;
            progress |= TestSSLEnginePair.handshakeCompleted(server, serverToClient, clientToServer, scratch);
        } while (progress);
        return new SSLEngine[]{server, client};
    }

    private static boolean handshakeCompleted(SSLEngine engine, ByteBuffer output, ByteBuffer input, ByteBuffer scratch) throws IOException {
        try {
            input.flip();
            SSLEngineResult.HandshakeStatus status = engine.getHandshakeStatus();
            switch (status) {
                case NEED_TASK: {
                    boolean progress = false;
                    while (true) {
                        Runnable runnable;
                        if ((runnable = engine.getDelegatedTask()) == null) {
                            boolean bl = progress;
                            return bl;
                        }
                        runnable.run();
                        progress = true;
                    }
                }
                case NEED_UNWRAP: {
                    if (input.remaining() == 0) {
                        boolean runnable = false;
                        return runnable;
                    }
                    SSLEngineResult unwrapResult = engine.unwrap(input, scratch);
                    TestSSLEnginePair.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)unwrapResult.getStatus()));
                    TestSSLEnginePair.assertEquals((int)0, (int)scratch.position());
                    boolean bl = true;
                    return bl;
                }
                case NEED_WRAP: {
                    if (output.remaining() != output.capacity()) {
                        boolean bl = false;
                        return bl;
                    }
                    SSLEngineResult wrapResult = engine.wrap(EMPTY_BYTE_BUFFER, output);
                    TestSSLEnginePair.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)wrapResult.getStatus()));
                    boolean bl = true;
                    return bl;
                }
                case NOT_HANDSHAKING: 
                case FINISHED: {
                    throw new IllegalStateException("Unexpected HandshakeStatus = " + (Object)((Object)status));
                }
            }
            throw new IllegalStateException("Unknown HandshakeStatus = " + (Object)((Object)status));
        }
        finally {
            input.compact();
        }
    }

    public static class Hooks {
        void beforeBeginHandshake(SSLEngine client, SSLEngine server) {
        }
    }
}

