/*
 * Decompiled with CFR 0.152.
 */
package libcore.javax.net.ssl;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.security.Principal;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import junit.framework.Assert;
import libcore.java.security.StandardNames;
import libcore.java.security.TestKeyStore;

public final class TestSSLContext
extends Assert {
    private static final boolean IS_RI = StandardNames.IS_RI;
    public static final int EXPECTED_DEFAULT_CLIENT_SSL_SESSION_CACHE_SIZE = IS_RI ? 0 : 10;
    public static final int EXPECTED_DEFAULT_SERVER_SSL_SESSION_CACHE_SIZE = IS_RI ? 0 : 100;
    public static final int EXPECTED_DEFAULT_SSL_SESSION_CACHE_TIMEOUT = IS_RI ? 86400 : 0;
    public final KeyStore clientKeyStore;
    public final char[] clientStorePassword;
    public final KeyStore serverKeyStore;
    public final char[] serverStorePassword;
    public final X509ExtendedKeyManager clientKeyManager;
    public final X509ExtendedKeyManager serverKeyManager;
    public final X509TrustManager clientTrustManager;
    public final X509TrustManager serverTrustManager;
    public final SSLContext clientContext;
    public final SSLContext serverContext;
    public final SSLServerSocket serverSocket;
    public final InetAddress host;
    public final int port;

    public static boolean sslServerSocketSupportsSessionTickets() {
        return false;
    }

    private TestSSLContext(KeyStore clientKeyStore, char[] clientStorePassword, KeyStore serverKeyStore, char[] serverStorePassword, X509ExtendedKeyManager clientKeyManager, X509ExtendedKeyManager serverKeyManager, X509TrustManager clientTrustManager, X509TrustManager serverTrustManager, SSLContext clientContext, SSLContext serverContext, SSLServerSocket serverSocket, InetAddress host, int port) {
        this.clientKeyStore = clientKeyStore;
        this.clientStorePassword = clientStorePassword;
        this.serverKeyStore = serverKeyStore;
        this.serverStorePassword = serverStorePassword;
        this.clientKeyManager = clientKeyManager;
        this.serverKeyManager = serverKeyManager;
        this.clientTrustManager = clientTrustManager;
        this.serverTrustManager = serverTrustManager;
        this.clientContext = clientContext;
        this.serverContext = serverContext;
        this.serverSocket = serverSocket;
        this.host = host;
        this.port = port;
    }

    public static TestSSLContext create() {
        return TestSSLContext.create(TestKeyStore.getClient(), TestKeyStore.getServer());
    }

    public static TestSSLContext create(TestKeyStore client, TestKeyStore server) {
        String provider = StandardNames.JSSE_PROVIDER_NAME;
        return TestSSLContext.create(client, server, provider, provider);
    }

    public static TestSSLContext create(TestKeyStore client, TestKeyStore server, String clientProvider, String serverProvider) {
        String protocol = "TLS";
        SSLContext clientContext = TestSSLContext.createSSLContext(protocol, clientProvider, client.keyManagers, client.trustManagers);
        SSLContext serverContext = TestSSLContext.createSSLContext(protocol, serverProvider, server.keyManagers, server.trustManagers);
        return TestSSLContext.create(client.keyStore, client.storePassword, server.keyStore, server.storePassword, client.keyManagers[0], server.keyManagers[0], client.trustManagers[0], server.trustManagers[0], clientContext, serverContext);
    }

    public static TestSSLContext create(KeyStore clientKeyStore, char[] clientStorePassword, KeyStore serverKeyStore, char[] serverStorePassword, KeyManager clientKeyManagers, KeyManager serverKeyManagers, TrustManager clientTrustManagers, TrustManager serverTrustManagers, SSLContext clientContext, SSLContext serverContext) {
        try {
            SSLServerSocket serverSocket = (SSLServerSocket)serverContext.getServerSocketFactory().createServerSocket(0);
            InetSocketAddress sa = (InetSocketAddress)serverSocket.getLocalSocketAddress();
            InetAddress host = sa.getAddress();
            int port = sa.getPort();
            return new TestSSLContext(clientKeyStore, clientStorePassword, serverKeyStore, serverStorePassword, (X509ExtendedKeyManager)clientKeyManagers, (X509ExtendedKeyManager)serverKeyManagers, (X509TrustManager)clientTrustManagers, (X509TrustManager)serverTrustManagers, clientContext, serverContext, serverSocket, host, port);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static final SSLContext createSSLContext(String protocol, String provider, KeyManager[] keyManagers, TrustManager[] trustManagers) {
        try {
            SSLContext context = SSLContext.getInstance(protocol, provider);
            context.init(keyManagers, trustManagers, new SecureRandom());
            return context;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void assertCertificateInKeyStore(Principal principal, KeyStore keyStore) throws Exception {
        String subjectName = principal.getName();
        boolean found = false;
        for (String alias : Collections.list(keyStore.aliases())) {
            X509Certificate keyStoreCertificate;
            if (!keyStore.isCertificateEntry(alias) || !subjectName.equals((keyStoreCertificate = (X509Certificate)keyStore.getCertificate(alias)).getSubjectDN().getName())) continue;
            found = true;
            break;
        }
        TestSSLContext.assertTrue((boolean)found);
    }

    public static void assertCertificateInKeyStore(Certificate certificate, KeyStore keyStore) throws Exception {
        boolean found = false;
        for (String alias : Collections.list(keyStore.aliases())) {
            Certificate keyStoreCertificate;
            if (!keyStore.isCertificateEntry(alias) || !certificate.equals(keyStoreCertificate = keyStore.getCertificate(alias))) continue;
            found = true;
            break;
        }
        TestSSLContext.assertTrue((boolean)found);
    }

    public static void assertServerCertificateChain(X509TrustManager trustManager, Certificate[] serverChain) throws CertificateException {
        X509Certificate[] chain = (X509Certificate[])serverChain;
        trustManager.checkServerTrusted(chain, chain[0].getPublicKey().getAlgorithm());
    }

    public static void assertClientCertificateChain(X509TrustManager trustManager, Certificate[] clientChain) throws CertificateException {
        X509Certificate[] chain = (X509Certificate[])clientChain;
        trustManager.checkClientTrusted(chain, chain[0].getPublicKey().getAlgorithm());
    }
}

