/*
 * Decompiled with CFR 0.152.
 */
package libcore.java.security;

import java.io.PrintStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import junit.framework.Assert;
import libcore.java.security.StandardNames;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public final class TestKeyStore
extends Assert {
    public final KeyStore keyStore;
    public final char[] storePassword;
    public final char[] keyPassword;
    public final KeyManager[] keyManagers;
    public final TrustManager[] trustManagers;
    private static final TestKeyStore ROOT_CA;
    private static final TestKeyStore INTERMEDIATE_CA;
    private static final TestKeyStore SERVER;
    private static final TestKeyStore CLIENT;
    private static final TestKeyStore CLIENT_CERTIFICATE;
    private static final TestKeyStore ROOT_CA_2;
    private static final TestKeyStore CLIENT_2;

    private TestKeyStore(KeyStore keyStore, char[] storePassword, char[] keyPassword) {
        this.keyStore = keyStore;
        this.storePassword = storePassword;
        this.keyPassword = keyPassword;
        this.keyManagers = TestKeyStore.createKeyManagers(keyStore, storePassword);
        this.trustManagers = TestKeyStore.createTrustManagers(keyStore);
    }

    public static KeyManager[] createKeyManagers(KeyStore keyStore, char[] storePassword) {
        try {
            String kmfa = KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(kmfa);
            kmf.init(keyStore, storePassword);
            return kmf.getKeyManagers();
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    public static TrustManager[] createTrustManagers(KeyStore keyStore) {
        try {
            String tmfa = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfa);
            tmf.init(keyStore);
            return tmf.getTrustManagers();
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    public static TestKeyStore getServer() {
        return SERVER;
    }

    public static TestKeyStore getClient() {
        return CLIENT;
    }

    public static TestKeyStore getClientCertificate() {
        return CLIENT_CERTIFICATE;
    }

    public static TestKeyStore getClientCA2() {
        return CLIENT_2;
    }

    public static TestKeyStore create(String[] keyAlgorithms, char[] storePassword, char[] keyPassword, String aliasPrefix, X509Principal subject, boolean ca, TestKeyStore signer) {
        try {
            KeyStore keyStore = TestKeyStore.createKeyStore();
            for (String keyAlgorithm : keyAlgorithms) {
                String publicAlias = aliasPrefix + "-public-" + keyAlgorithm;
                String privateAlias = aliasPrefix + "-private-" + keyAlgorithm;
                TestKeyStore.createKeys(keyStore, keyPassword, keyAlgorithm, publicAlias, privateAlias, subject, ca, signer);
            }
            if (signer != null) {
                TestKeyStore.copySelfSignedCertificates(keyStore, signer.keyStore);
            }
            return new TestKeyStore(keyStore, storePassword, keyPassword);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static KeyStore createKeyStore() throws Exception {
        KeyStore keyStore = KeyStore.getInstance("BKS");
        keyStore.load(null, null);
        return keyStore;
    }

    public static KeyStore createKeys(KeyStore keyStore, char[] keyPassword, String keyAlgorithm, String publicAlias, String privateAlias, X509Principal subject, boolean ca, TestKeyStore signer) throws Exception {
        Certificate[] x509cc;
        X509Certificate x509c;
        PrivateKey privateKey;
        X509Certificate[] caCertChain;
        X509Certificate caCert;
        PrivateKey caKey;
        if (signer == null) {
            caKey = null;
            caCert = null;
            caCertChain = null;
        } else {
            KeyStore.PrivateKeyEntry privateKeyEntry = TestKeyStore.privateKey(signer.keyStore, signer.keyPassword, keyAlgorithm);
            caKey = privateKeyEntry.getPrivateKey();
            caCert = (X509Certificate)privateKeyEntry.getCertificate();
            caCertChain = (X509Certificate[])privateKeyEntry.getCertificateChain();
        }
        if (publicAlias == null && privateAlias == null) {
            privateKey = null;
            x509c = null;
        } else {
            int keysize = 1024;
            KeyPairGenerator kpg = KeyPairGenerator.getInstance(keyAlgorithm);
            kpg.initialize(keysize, new SecureRandom());
            KeyPair kp = kpg.generateKeyPair();
            privateKey = kp.getPrivate();
            PublicKey publicKey = kp.getPublic();
            X509Principal issuer = caCert == null ? subject : (X509Principal)caCert.getSubjectDN();
            long millisPerDay = 86400000L;
            long now = System.currentTimeMillis();
            Date start = new Date(now - millisPerDay);
            Date end = new Date(now + millisPerDay);
            BigInteger serial = BigInteger.valueOf(1L);
            X509V3CertificateGenerator x509cg = new X509V3CertificateGenerator();
            x509cg.setSubjectDN((X509Name)subject);
            x509cg.setIssuerDN((X509Name)issuer);
            x509cg.setNotBefore(start);
            x509cg.setNotAfter(end);
            x509cg.setPublicKey(publicKey);
            x509cg.setSignatureAlgorithm("sha1With" + keyAlgorithm);
            x509cg.setSerialNumber(serial);
            if (ca) {
                x509cg.addExtension(X509Extensions.BasicConstraints, true, (DEREncodable)new BasicConstraints(true));
            }
            PrivateKey signingKey = caKey == null ? privateKey : caKey;
            x509c = x509cg.generateX509Certificate(signingKey);
        }
        if (privateAlias == null) {
            x509cc = null;
        } else if (caCertChain == null) {
            x509cc = new X509Certificate[]{x509c};
        } else {
            x509cc = new X509Certificate[caCertChain.length + 1];
            x509cc[0] = x509c;
            System.arraycopy(caCertChain, 0, x509cc, 1, caCertChain.length);
        }
        if (privateAlias != null) {
            keyStore.setKeyEntry(privateAlias, privateKey, keyPassword, x509cc);
        }
        if (publicAlias != null) {
            keyStore.setCertificateEntry(publicAlias, x509c);
        }
        return keyStore;
    }

    public static X509Principal localhost() {
        try {
            return TestKeyStore.x509Principal(InetAddress.getLocalHost().getCanonicalHostName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static X509Principal x509Principal(String commonName) {
        Hashtable<DERObjectIdentifier, String> attributes = new Hashtable<DERObjectIdentifier, String>();
        attributes.put(X509Principal.CN, commonName);
        return new X509Principal(attributes);
    }

    public static KeyStore.PrivateKeyEntry privateKey(KeyStore keyStore, char[] keyPassword, String algorithm) {
        try {
            KeyStore.PrivateKeyEntry found = null;
            KeyStore.PasswordProtection password = new KeyStore.PasswordProtection(keyPassword);
            for (String alias : Collections.list(keyStore.aliases())) {
                KeyStore.PrivateKeyEntry privateKey;
                if (!keyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class) || !(privateKey = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, password)).getPrivateKey().getAlgorithm().equals(algorithm)) continue;
                if (found != null) {
                    throw new IllegalStateException("keyStore has more than one private key");
                }
                found = privateKey;
            }
            if (found == null) {
                throw new IllegalStateException("keyStore contained no private key");
            }
            return found;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static KeyStore createClient(KeyStore caKeyStore) {
        try {
            KeyStore clientKeyStore = KeyStore.getInstance("BKS");
            clientKeyStore.load(null, null);
            TestKeyStore.copySelfSignedCertificates(clientKeyStore, caKeyStore);
            return clientKeyStore;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void copySelfSignedCertificates(KeyStore dst, KeyStore src) throws Exception {
        for (String alias : Collections.list(src.aliases())) {
            X509Certificate cert;
            if (!src.isCertificateEntry(alias) || !((Object)(cert = (X509Certificate)src.getCertificate(alias)).getSubjectDN()).equals(cert.getIssuerDN())) continue;
            dst.setCertificateEntry(alias, cert);
        }
    }

    public static void dump(String context, KeyStore keyStore, char[] keyPassword) {
        try {
            PrintStream out = System.out;
            out.println("context=" + context);
            out.println("\tkeyStore=" + keyStore);
            out.println("\tkeyStore.type=" + keyStore.getType());
            out.println("\tkeyStore.provider=" + keyStore.getProvider());
            out.println("\tkeyPassword=" + (keyPassword == null ? null : new String(keyPassword)));
            out.println("\tsize=" + keyStore.size());
            for (String alias : Collections.list(keyStore.aliases())) {
                out.println("alias=" + alias);
                out.println("\tcreationDate=" + keyStore.getCreationDate(alias));
                if (keyStore.isCertificateEntry(alias)) {
                    out.println("\tcertificate:");
                    out.println("==========================================");
                    out.println(keyStore.getCertificate(alias));
                    out.println("==========================================");
                    continue;
                }
                if (keyStore.isKeyEntry(alias)) {
                    String key;
                    out.println("\tkey:");
                    out.println("==========================================");
                    try {
                        key = "Key retreived using password\n" + keyStore.getKey(alias, keyPassword).toString();
                    }
                    catch (UnrecoverableKeyException e1) {
                        try {
                            key = "Key retreived without password\n" + keyStore.getKey(alias, null).toString();
                        }
                        catch (UnrecoverableKeyException e2) {
                            key = "Key could not be retreived";
                        }
                    }
                    out.println(key);
                    out.println("==========================================");
                    continue;
                }
                out.println("\tunknown entry type");
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void assertChainLength(Object[] chain) {
        TestKeyStore.assertEquals((int)3, (int)chain.length);
    }

    static {
        if (StandardNames.IS_RI) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        ROOT_CA = TestKeyStore.create(new String[]{"RSA"}, null, null, "RootCA", TestKeyStore.x509Principal("Test Root Certificate Authority"), true, null);
        INTERMEDIATE_CA = TestKeyStore.create(new String[]{"RSA"}, null, null, "IntermediateCA", TestKeyStore.x509Principal("Test Intermediate Certificate Authority"), true, ROOT_CA);
        SERVER = TestKeyStore.create(new String[]{"RSA"}, null, null, "server", TestKeyStore.localhost(), false, INTERMEDIATE_CA);
        CLIENT = new TestKeyStore(TestKeyStore.createClient(TestKeyStore.INTERMEDIATE_CA.keyStore), null, null);
        CLIENT_CERTIFICATE = TestKeyStore.create(new String[]{"RSA"}, null, null, "client", TestKeyStore.x509Principal("test@user"), false, INTERMEDIATE_CA);
        ROOT_CA_2 = TestKeyStore.create(new String[]{"RSA"}, null, null, "RootCA2", TestKeyStore.x509Principal("Test Root Certificate Authority 2"), true, null);
        CLIENT_2 = new TestKeyStore(TestKeyStore.createClient(TestKeyStore.ROOT_CA_2.keyStore), null, null);
    }
}

