/*
 * Decompiled with CFR 0.152.
 */
package libcore.java.security;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StandardNames
extends Assert {
    public static final boolean IS_RI = !"Dalvik Core Library".equals(System.getProperty("java.specification.name"));
    public static final String JSSE_PROVIDER_NAME = IS_RI ? "SunJSSE" : "AndroidOpenSSL";
    public static final String SECURITY_PROVIDER_NAME = IS_RI ? "SUN" : "BC";
    public static final String KEY_MANAGER_FACTORY_DEFAULT = IS_RI ? "SunX509" : "X509";
    public static final Map<String, Set<String>> PROVIDER_ALGORITHMS = new HashMap<String, Set<String>>();
    public static final String SSL_CONTEXT_PROTOCOLS_DEFAULT = "Default";
    public static final Set<String> SSL_CONTEXT_PROTOCOLS;
    public static final String SSL_CONTEXT_PROTOCOL_DEFAULT = "TLS";
    public static final Set<String> KEY_TYPES;
    public static final Set<String> SSL_SOCKET_PROTOCOLS;
    public static final Set<String> CLIENT_AUTH_TYPES;
    public static final Set<String> SERVER_AUTH_TYPES;
    public static final String CIPHER_SUITE_INVALID = "SSL_NULL_WITH_NULL_NULL";
    public static final Set<String> CIPHER_SUITES_NEITHER;
    public static final Set<String> CIPHER_SUITES_RI;
    public static final Set<String> CIPHER_SUITES_OPENSSL;
    public static final Set<String> CIPHER_SUITES;

    private static void provide(String type, String algorithm) {
        Set<String> algorithms = PROVIDER_ALGORITHMS.get(type);
        if (algorithms == null) {
            algorithms = new HashSet<String>();
            PROVIDER_ALGORITHMS.put(type, algorithms);
        }
        StandardNames.assertTrue((String)("Duplicate " + type + " " + algorithm), (boolean)algorithms.add(algorithm.toUpperCase()));
    }

    private static void unprovide(String type, String algorithm) {
        Set<String> algorithms = PROVIDER_ALGORITHMS.get(type);
        StandardNames.assertNotNull(algorithms);
        StandardNames.assertTrue((String)algorithm, (boolean)algorithms.remove(algorithm.toUpperCase()));
        if (algorithms.isEmpty()) {
            StandardNames.assertNotNull(PROVIDER_ALGORITHMS.remove(type));
        }
    }

    private static final void addRi(String cipherSuite) {
        CIPHER_SUITES_RI.add(cipherSuite);
    }

    private static final void addOpenSsl(String cipherSuite) {
        CIPHER_SUITES_OPENSSL.add(cipherSuite);
    }

    private static final void addBoth(String cipherSuite) {
        StandardNames.addRi(cipherSuite);
        StandardNames.addOpenSsl(cipherSuite);
    }

    private static final void addNeither(String cipherSuite) {
        CIPHER_SUITES_NEITHER.add(cipherSuite);
    }

    public static Set<String> assertValidCipherSuites(Set<String> expected, String[] cipherSuites) {
        StandardNames.assertNotNull((Object)cipherSuites);
        StandardNames.assertTrue((cipherSuites.length != 0 ? 1 : 0) != 0);
        HashSet<String> remainingCipherSuites = new HashSet<String>(expected);
        HashSet<String> unknownCipherSuites = new HashSet<String>();
        for (String cipherSuite : cipherSuites) {
            boolean removed = remainingCipherSuites.remove(cipherSuite);
            if (removed) continue;
            unknownCipherSuites.add(cipherSuite);
        }
        StandardNames.assertEquals((Object)Collections.EMPTY_SET, unknownCipherSuites);
        return remainingCipherSuites;
    }

    public static void assertSupportedCipherSuites(Set<String> expected, String[] cipherSuites) {
        Set<String> remainingCipherSuites = StandardNames.assertValidCipherSuites(expected, cipherSuites);
        StandardNames.assertEquals((Object)Collections.EMPTY_SET, remainingCipherSuites);
        StandardNames.assertEquals((int)expected.size(), (int)cipherSuites.length);
    }

    public static Set<String> assertValidProtocols(Set<String> expected, String[] protocols) {
        StandardNames.assertNotNull((Object)protocols);
        StandardNames.assertTrue((protocols.length != 0 ? 1 : 0) != 0);
        HashSet<String> remainingProtocols = new HashSet<String>(SSL_SOCKET_PROTOCOLS);
        HashSet<String> unknownProtocols = new HashSet<String>();
        for (String protocol : protocols) {
            if (remainingProtocols.remove(protocol)) continue;
            unknownProtocols.add(protocol);
        }
        StandardNames.assertEquals((Object)Collections.EMPTY_SET, unknownProtocols);
        return remainingProtocols;
    }

    public static void assertSupportedProtocols(Set<String> expected, String[] protocols) {
        Set<String> remainingProtocols = StandardNames.assertValidProtocols(expected, protocols);
        StandardNames.assertEquals((Object)Collections.EMPTY_SET, remainingProtocols);
        StandardNames.assertEquals((int)expected.size(), (int)protocols.length);
    }

    static {
        StandardNames.provide("AlgorithmParameterGenerator", "DSA");
        StandardNames.provide("AlgorithmParameterGenerator", "DiffieHellman");
        StandardNames.provide("AlgorithmParameters", "AES");
        StandardNames.provide("AlgorithmParameters", "Blowfish");
        StandardNames.provide("AlgorithmParameters", "DES");
        StandardNames.provide("AlgorithmParameters", "DESede");
        StandardNames.provide("AlgorithmParameters", "DSA");
        StandardNames.provide("AlgorithmParameters", "DiffieHellman");
        StandardNames.provide("AlgorithmParameters", "OAEP");
        StandardNames.provide("AlgorithmParameters", "PBEWithMD5AndDES");
        StandardNames.provide("AlgorithmParameters", "PBEWithMD5AndTripleDES");
        StandardNames.provide("AlgorithmParameters", "PBEWithSHA1AndDESede");
        StandardNames.provide("AlgorithmParameters", "PBEWithSHA1AndRC2_40");
        StandardNames.provide("AlgorithmParameters", "RC2");
        StandardNames.provide("CertPathBuilder", "PKIX");
        StandardNames.provide("CertPathValidator", "PKIX");
        StandardNames.provide("CertStore", "Collection");
        StandardNames.provide("CertStore", "LDAP");
        StandardNames.provide("CertificateFactory", "X.509");
        StandardNames.provide("Cipher", "AES");
        StandardNames.provide("Cipher", "AESWrap");
        StandardNames.provide("Cipher", "ARCFOUR");
        StandardNames.provide("Cipher", "Blowfish");
        StandardNames.provide("Cipher", "DES");
        StandardNames.provide("Cipher", "DESede");
        StandardNames.provide("Cipher", "DESedeWrap");
        StandardNames.provide("Cipher", "PBEWithMD5AndDES");
        StandardNames.provide("Cipher", "PBEWithMD5AndTripleDES");
        StandardNames.provide("Cipher", "PBEWithSHA1AndDESede");
        StandardNames.provide("Cipher", "PBEWithSHA1AndRC2_40");
        StandardNames.provide("Cipher", "RC2");
        StandardNames.provide("Cipher", "RSA");
        StandardNames.provide("Configuration", "JavaLoginConfig");
        StandardNames.provide("KeyAgreement", "DiffieHellman");
        StandardNames.provide("KeyFactory", "DSA");
        StandardNames.provide("KeyFactory", "DiffieHellman");
        StandardNames.provide("KeyFactory", "RSA");
        StandardNames.provide("KeyGenerator", "AES");
        StandardNames.provide("KeyGenerator", "ARCFOUR");
        StandardNames.provide("KeyGenerator", "Blowfish");
        StandardNames.provide("KeyGenerator", "DES");
        StandardNames.provide("KeyGenerator", "DESede");
        StandardNames.provide("KeyGenerator", "HmacMD5");
        StandardNames.provide("KeyGenerator", "HmacSHA1");
        StandardNames.provide("KeyGenerator", "HmacSHA256");
        StandardNames.provide("KeyGenerator", "HmacSHA384");
        StandardNames.provide("KeyGenerator", "HmacSHA512");
        StandardNames.provide("KeyGenerator", "RC2");
        StandardNames.provide("KeyInfoFactory", "DOM");
        StandardNames.provide("KeyManagerFactory", "SunX509");
        StandardNames.provide("KeyPairGenerator", "DSA");
        StandardNames.provide("KeyPairGenerator", "DiffieHellman");
        StandardNames.provide("KeyPairGenerator", "RSA");
        StandardNames.provide("KeyStore", "JCEKS");
        StandardNames.provide("KeyStore", "JKS");
        StandardNames.provide("KeyStore", "PKCS12");
        StandardNames.provide("Mac", "HmacMD5");
        StandardNames.provide("Mac", "HmacSHA1");
        StandardNames.provide("Mac", "HmacSHA256");
        StandardNames.provide("Mac", "HmacSHA384");
        StandardNames.provide("Mac", "HmacSHA512");
        StandardNames.provide("MessageDigest", "MD2");
        StandardNames.provide("MessageDigest", "MD5");
        StandardNames.provide("MessageDigest", "SHA-256");
        StandardNames.provide("MessageDigest", "SHA-384");
        StandardNames.provide("MessageDigest", "SHA-512");
        StandardNames.provide("Policy", "JavaPolicy");
        StandardNames.provide("SSLContext", "SSLv3");
        StandardNames.provide("SSLContext", "TLSv1");
        StandardNames.provide("SecretKeyFactory", "DES");
        StandardNames.provide("SecretKeyFactory", "DESede");
        StandardNames.provide("SecretKeyFactory", "PBEWithMD5AndDES");
        StandardNames.provide("SecretKeyFactory", "PBEWithMD5AndTripleDES");
        StandardNames.provide("SecretKeyFactory", "PBEWithSHA1AndDESede");
        StandardNames.provide("SecretKeyFactory", "PBEWithSHA1AndRC2_40");
        StandardNames.provide("SecretKeyFactory", "PBKDF2WithHmacSHA1");
        StandardNames.provide("SecureRandom", "SHA1PRNG");
        StandardNames.provide("Signature", "MD2withRSA");
        StandardNames.provide("Signature", "MD5withRSA");
        StandardNames.provide("Signature", "NONEwithDSA");
        StandardNames.provide("Signature", "SHA1withDSA");
        StandardNames.provide("Signature", "SHA1withRSA");
        StandardNames.provide("Signature", "SHA256withRSA");
        StandardNames.provide("Signature", "SHA384withRSA");
        StandardNames.provide("Signature", "SHA512withRSA");
        StandardNames.provide("TerminalFactory", "PC/SC");
        StandardNames.provide("TransformService", "http://www.w3.org/2000/09/xmldsig#base64");
        StandardNames.provide("TransformService", "http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        StandardNames.provide("TransformService", "http://www.w3.org/2001/10/xml-exc-c14n#");
        StandardNames.provide("TransformService", "http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        StandardNames.provide("TransformService", "http://www.w3.org/2002/06/xmldsig-filter2");
        StandardNames.provide("TransformService", "http://www.w3.org/TR/1999/REC-xpath-19991116");
        StandardNames.provide("TransformService", "http://www.w3.org/TR/1999/REC-xslt-19991116");
        StandardNames.provide("TransformService", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        StandardNames.provide("TransformService", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        StandardNames.provide("TrustManagerFactory", "PKIX");
        StandardNames.provide("XMLSignatureFactory", "DOM");
        StandardNames.provide("GssApiMechanism", "1.2.840.113554.1.2.2");
        StandardNames.provide("GssApiMechanism", "1.3.6.1.5.5.2");
        StandardNames.provide("SaslClientFactory", "CRAM-MD5");
        StandardNames.provide("SaslClientFactory", "DIGEST-MD5");
        StandardNames.provide("SaslClientFactory", "EXTERNAL");
        StandardNames.provide("SaslClientFactory", "GSSAPI");
        StandardNames.provide("SaslClientFactory", "PLAIN");
        StandardNames.provide("SaslServerFactory", "CRAM-MD5");
        StandardNames.provide("SaslServerFactory", "DIGEST-MD5");
        StandardNames.provide("SaslServerFactory", "GSSAPI");
        StandardNames.provide("MessageDigest", "SHA");
        StandardNames.provide("SSLContext", SSL_CONTEXT_PROTOCOLS_DEFAULT);
        StandardNames.provide("AlgorithmParameters", "PBE");
        StandardNames.provide("SSLContext", "SSL");
        StandardNames.provide("SSLContext", SSL_CONTEXT_PROTOCOL_DEFAULT);
        if (IS_RI) {
            StandardNames.provide("CertStore", "com.sun.security.IndexedCollection");
            StandardNames.provide("KeyGenerator", "SunTlsKeyMaterial");
            StandardNames.provide("KeyGenerator", "SunTlsMasterSecret");
            StandardNames.provide("KeyGenerator", "SunTlsPrf");
            StandardNames.provide("KeyGenerator", "SunTlsRsaPremasterSecret");
            StandardNames.provide("KeyManagerFactory", "NewSunX509");
            StandardNames.provide("KeyStore", "CaseExactJKS");
            StandardNames.provide("Mac", "HmacPBESHA1");
            StandardNames.provide("Mac", "SslMacMD5");
            StandardNames.provide("Mac", "SslMacSHA1");
            StandardNames.provide("SecureRandom", "NativePRNG");
            StandardNames.provide("Signature", "MD5andSHA1withRSA");
            StandardNames.provide("TrustManagerFactory", "SunX509");
        }
        if (!IS_RI) {
            PROVIDER_ALGORITHMS.remove("Configuration");
            PROVIDER_ALGORITHMS.remove("GssApiMechanism");
            PROVIDER_ALGORITHMS.remove("KeyInfoFactory");
            PROVIDER_ALGORITHMS.remove("Policy");
            PROVIDER_ALGORITHMS.remove("SaslClientFactory");
            PROVIDER_ALGORITHMS.remove("SaslServerFactory");
            PROVIDER_ALGORITHMS.remove("TerminalFactory");
            PROVIDER_ALGORITHMS.remove("TransformService");
            PROVIDER_ALGORITHMS.remove("XMLSignatureFactory");
            StandardNames.unprovide("AlgorithmParameterGenerator", "DiffieHellman");
            StandardNames.provide("AlgorithmParameterGenerator", "DH");
            StandardNames.unprovide("AlgorithmParameters", "DiffieHellman");
            StandardNames.provide("AlgorithmParameters", "DH");
            StandardNames.unprovide("KeyAgreement", "DiffieHellman");
            StandardNames.provide("KeyAgreement", "DH");
            StandardNames.unprovide("KeyFactory", "DiffieHellman");
            StandardNames.provide("KeyFactory", "DH");
            StandardNames.unprovide("KeyPairGenerator", "DiffieHellman");
            StandardNames.provide("KeyPairGenerator", "DH");
            StandardNames.unprovide("AlgorithmParameters", "PBEWithSHA1AndDESede");
            StandardNames.unprovide("Cipher", "PBEWithSHA1AndDESede");
            StandardNames.unprovide("SecretKeyFactory", "PBEWithSHA1AndDESede");
            StandardNames.provide("AlgorithmParameters", "PKCS12PBE");
            StandardNames.provide("Cipher", "PBEWithSHAAnd3-KEYTripleDES-CBC");
            StandardNames.provide("SecretKeyFactory", "PBEWithSHAAnd3-KEYTripleDES-CBC");
            StandardNames.unprovide("KeyManagerFactory", "SunX509");
            StandardNames.provide("KeyManagerFactory", "X509");
            StandardNames.unprovide("MessageDigest", "SHA");
            StandardNames.provide("MessageDigest", "SHA-1");
            StandardNames.unprovide("Signature", "MD5withRSA");
            StandardNames.provide("Signature", "MD5WithRSAEncryption");
            StandardNames.unprovide("Signature", "SHA1withRSA");
            StandardNames.provide("Signature", "SHA1WithRSAEncryption");
            StandardNames.unprovide("Signature", "SHA256WithRSA");
            StandardNames.provide("Signature", "SHA256WithRSAEncryption");
            StandardNames.unprovide("Signature", "SHA384WithRSA");
            StandardNames.provide("Signature", "SHA384WithRSAEncryption");
            StandardNames.unprovide("Signature", "SHA512WithRSA");
            StandardNames.provide("Signature", "SHA512WithRSAEncryption");
            StandardNames.unprovide("TrustManagerFactory", "PKIX");
            StandardNames.provide("TrustManagerFactory", "X509");
            StandardNames.unprovide("Cipher", "ARCFOUR");
            StandardNames.provide("Cipher", "ARC4");
            StandardNames.unprovide("KeyGenerator", "ARCFOUR");
            StandardNames.provide("KeyGenerator", "RC4");
            StandardNames.unprovide("AlgorithmParameters", "Blowfish");
            StandardNames.provide("AlgorithmParameters", "BLOWFISH");
            StandardNames.unprovide("Cipher", "Blowfish");
            StandardNames.provide("Cipher", "BLOWFISH");
            StandardNames.unprovide("KeyGenerator", "Blowfish");
            StandardNames.provide("KeyGenerator", "BLOWFISH");
            StandardNames.provide("CertificateFactory", "X509");
            StandardNames.unprovide("KeyStore", "JKS");
            StandardNames.provide("KeyStore", "BKS");
            StandardNames.unprovide("KeyStore", "JCEKS");
            StandardNames.provide("KeyStore", "BouncyCastle");
            StandardNames.provide("Cipher", "PBEWITHMD5AND128BITAES-CBC-OPENSSL");
            StandardNames.provide("Cipher", "PBEWITHMD5AND192BITAES-CBC-OPENSSL");
            StandardNames.provide("Cipher", "PBEWITHMD5AND256BITAES-CBC-OPENSSL");
            StandardNames.provide("Cipher", "PBEWITHMD5ANDRC2");
            StandardNames.provide("Cipher", "PBEWITHSHA1ANDDES");
            StandardNames.provide("Cipher", "PBEWITHSHA1ANDRC2");
            StandardNames.provide("Cipher", "PBEWITHSHA256AND128BITAES-CBC-BC");
            StandardNames.provide("Cipher", "PBEWITHSHA256AND192BITAES-CBC-BC");
            StandardNames.provide("Cipher", "PBEWITHSHA256AND256BITAES-CBC-BC");
            StandardNames.provide("Cipher", "PBEWITHSHAAND128BITAES-CBC-BC");
            StandardNames.provide("Cipher", "PBEWITHSHAAND128BITRC2-CBC");
            StandardNames.provide("Cipher", "PBEWITHSHAAND128BITRC4");
            StandardNames.provide("Cipher", "PBEWITHSHAAND192BITAES-CBC-BC");
            StandardNames.provide("Cipher", "PBEWITHSHAAND2-KEYTRIPLEDES-CBC");
            StandardNames.provide("Cipher", "PBEWITHSHAAND256BITAES-CBC-BC");
            StandardNames.provide("Cipher", "PBEWITHSHAAND40BITRC2-CBC");
            StandardNames.provide("Cipher", "PBEWITHSHAAND40BITRC4");
            StandardNames.provide("Cipher", "PBEWITHSHAANDTWOFISH-CBC");
            StandardNames.provide("Mac", "PBEWITHHMACSHA");
            StandardNames.provide("Mac", "PBEWITHHMACSHA1");
            StandardNames.provide("SecretKeyFactory", "PBEWITHHMACSHA1");
            StandardNames.provide("SecretKeyFactory", "PBEWITHMD5AND128BITAES-CBC-OPENSSL");
            StandardNames.provide("SecretKeyFactory", "PBEWITHMD5AND192BITAES-CBC-OPENSSL");
            StandardNames.provide("SecretKeyFactory", "PBEWITHMD5AND256BITAES-CBC-OPENSSL");
            StandardNames.provide("SecretKeyFactory", "PBEWITHMD5ANDRC2");
            StandardNames.provide("SecretKeyFactory", "PBEWITHSHA1ANDDES");
            StandardNames.provide("SecretKeyFactory", "PBEWITHSHA1ANDRC2");
            StandardNames.provide("SecretKeyFactory", "PBEWITHSHA256AND128BITAES-CBC-BC");
            StandardNames.provide("SecretKeyFactory", "PBEWITHSHA256AND192BITAES-CBC-BC");
            StandardNames.provide("SecretKeyFactory", "PBEWITHSHA256AND256BITAES-CBC-BC");
            StandardNames.provide("SecretKeyFactory", "PBEWITHSHAAND128BITAES-CBC-BC");
            StandardNames.provide("SecretKeyFactory", "PBEWITHSHAAND128BITRC2-CBC");
            StandardNames.provide("SecretKeyFactory", "PBEWITHSHAAND128BITRC4");
            StandardNames.provide("SecretKeyFactory", "PBEWITHSHAAND192BITAES-CBC-BC");
            StandardNames.provide("SecretKeyFactory", "PBEWITHSHAAND2-KEYTRIPLEDES-CBC");
            StandardNames.provide("SecretKeyFactory", "PBEWITHSHAAND256BITAES-CBC-BC");
            StandardNames.provide("SecretKeyFactory", "PBEWITHSHAAND40BITRC2-CBC");
            StandardNames.provide("SecretKeyFactory", "PBEWITHSHAAND40BITRC4");
            StandardNames.provide("SecretKeyFactory", "PBEWITHSHAANDTWOFISH-CBC");
            StandardNames.unprovide("CertStore", "LDAP");
            StandardNames.unprovide("MessageDigest", "MD2");
            StandardNames.unprovide("Signature", "MD2withRSA");
            StandardNames.unprovide("AlgorithmParameters", "PBEWithSHA1AndRC2_40");
            StandardNames.unprovide("AlgorithmParameters", "RC2");
            StandardNames.unprovide("Cipher", "PBEWithSHA1AndRC2_40");
            StandardNames.unprovide("Cipher", "RC2");
            StandardNames.unprovide("KeyGenerator", "RC2");
            StandardNames.unprovide("SecretKeyFactory", "PBEWithSHA1AndRC2_40");
            StandardNames.unprovide("AlgorithmParameters", "PBEWithMD5AndTripleDES");
            StandardNames.unprovide("Cipher", "PBEWithMD5AndTripleDES");
            StandardNames.unprovide("SecretKeyFactory", "PBEWithMD5AndTripleDES");
            StandardNames.unprovide("AlgorithmParameters", "PBE");
            StandardNames.unprovide("AlgorithmParameters", "PBEWithMD5AndDES");
        }
        SSL_CONTEXT_PROTOCOLS = new HashSet<String>(Arrays.asList(SSL_CONTEXT_PROTOCOLS_DEFAULT, "SSL", "SSLv3", SSL_CONTEXT_PROTOCOL_DEFAULT, "TLSv1"));
        KEY_TYPES = new HashSet<String>(Arrays.asList("RSA", "DSA", "DH_RSA", "DH_DSA"));
        SSL_SOCKET_PROTOCOLS = new HashSet<String>(Arrays.asList("SSLv3", "TLSv1"));
        if (IS_RI) {
            SSL_SOCKET_PROTOCOLS.add("SSLv2Hello");
        }
        CLIENT_AUTH_TYPES = new HashSet<String>(KEY_TYPES);
        SERVER_AUTH_TYPES = new HashSet<String>(Arrays.asList("DHE_DSS", "DHE_DSS_EXPORT", "DHE_RSA", "DHE_RSA_EXPORT", "DH_DSS_EXPORT", "DH_RSA_EXPORT", "DH_anon", "DH_anon_EXPORT", "KRB5", "KRB5_EXPORT", "RSA", "RSA_EXPORT", "RSA_EXPORT1024", "UNKNOWN"));
        CIPHER_SUITES_NEITHER = new HashSet<String>();
        CIPHER_SUITES_RI = new LinkedHashSet<String>();
        CIPHER_SUITES_OPENSSL = new LinkedHashSet<String>();
        StandardNames.addBoth("SSL_RSA_WITH_RC4_128_MD5");
        StandardNames.addBoth("SSL_RSA_WITH_RC4_128_SHA");
        StandardNames.addBoth("TLS_RSA_WITH_AES_128_CBC_SHA");
        StandardNames.addBoth("TLS_RSA_WITH_AES_256_CBC_SHA");
        StandardNames.addNeither("TLS_ECDH_ECDSA_WITH_RC4_128_SHA");
        StandardNames.addNeither("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA");
        StandardNames.addNeither("TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA");
        StandardNames.addNeither("TLS_ECDH_RSA_WITH_RC4_128_SHA");
        StandardNames.addNeither("TLS_ECDH_RSA_WITH_AES_128_CBC_SHA");
        StandardNames.addNeither("TLS_ECDH_RSA_WITH_AES_256_CBC_SHA");
        StandardNames.addNeither("TLS_ECDHE_ECDSA_WITH_RC4_128_SHA");
        StandardNames.addNeither("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA");
        StandardNames.addNeither("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA");
        StandardNames.addNeither("TLS_ECDHE_RSA_WITH_RC4_128_SHA");
        StandardNames.addNeither("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA");
        StandardNames.addNeither("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA");
        StandardNames.addBoth("TLS_DHE_RSA_WITH_AES_128_CBC_SHA");
        StandardNames.addBoth("TLS_DHE_RSA_WITH_AES_256_CBC_SHA");
        StandardNames.addBoth("TLS_DHE_DSS_WITH_AES_128_CBC_SHA");
        StandardNames.addBoth("TLS_DHE_DSS_WITH_AES_256_CBC_SHA");
        StandardNames.addBoth("SSL_RSA_WITH_3DES_EDE_CBC_SHA");
        StandardNames.addNeither("TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA");
        StandardNames.addNeither("TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA");
        StandardNames.addNeither("TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA");
        StandardNames.addNeither("TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA");
        StandardNames.addBoth("SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA");
        StandardNames.addBoth("SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA");
        StandardNames.addBoth("SSL_RSA_WITH_DES_CBC_SHA");
        StandardNames.addBoth("SSL_DHE_RSA_WITH_DES_CBC_SHA");
        StandardNames.addBoth("SSL_DHE_DSS_WITH_DES_CBC_SHA");
        StandardNames.addBoth("SSL_RSA_EXPORT_WITH_RC4_40_MD5");
        StandardNames.addBoth("SSL_RSA_EXPORT_WITH_DES40_CBC_SHA");
        StandardNames.addBoth("SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA");
        StandardNames.addBoth("SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA");
        StandardNames.addBoth("SSL_RSA_WITH_NULL_MD5");
        StandardNames.addBoth("SSL_RSA_WITH_NULL_SHA");
        StandardNames.addNeither("TLS_ECDH_ECDSA_WITH_NULL_SHA");
        StandardNames.addNeither("TLS_ECDH_RSA_WITH_NULL_SHA");
        StandardNames.addNeither("TLS_ECDHE_ECDSA_WITH_NULL_SHA");
        StandardNames.addNeither("TLS_ECDHE_RSA_WITH_NULL_SHA");
        StandardNames.addBoth("SSL_DH_anon_WITH_RC4_128_MD5");
        StandardNames.addBoth("TLS_DH_anon_WITH_AES_128_CBC_SHA");
        StandardNames.addBoth("TLS_DH_anon_WITH_AES_256_CBC_SHA");
        StandardNames.addBoth("SSL_DH_anon_WITH_3DES_EDE_CBC_SHA");
        StandardNames.addBoth("SSL_DH_anon_WITH_DES_CBC_SHA");
        StandardNames.addNeither("TLS_ECDH_anon_WITH_RC4_128_SHA");
        StandardNames.addNeither("TLS_ECDH_anon_WITH_AES_128_CBC_SHA");
        StandardNames.addNeither("TLS_ECDH_anon_WITH_AES_256_CBC_SHA");
        StandardNames.addNeither("TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA");
        StandardNames.addBoth("SSL_DH_anon_EXPORT_WITH_RC4_40_MD5");
        StandardNames.addBoth("SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA");
        StandardNames.addNeither("TLS_ECDH_anon_WITH_NULL_SHA");
        StandardNames.addRi("TLS_KRB5_WITH_RC4_128_SHA");
        StandardNames.addRi("TLS_KRB5_WITH_RC4_128_MD5");
        StandardNames.addRi("TLS_KRB5_WITH_3DES_EDE_CBC_SHA");
        StandardNames.addRi("TLS_KRB5_WITH_3DES_EDE_CBC_MD5");
        StandardNames.addRi("TLS_KRB5_WITH_DES_CBC_SHA");
        StandardNames.addRi("TLS_KRB5_WITH_DES_CBC_MD5");
        StandardNames.addRi("TLS_KRB5_EXPORT_WITH_RC4_40_SHA");
        StandardNames.addRi("TLS_KRB5_EXPORT_WITH_RC4_40_MD5");
        StandardNames.addRi("TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA");
        StandardNames.addRi("TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5");
        StandardNames.addNeither("SSL_DH_DSS_EXPORT_WITH_DES40_CBC_SHA");
        StandardNames.addNeither("SSL_DH_RSA_EXPORT_WITH_DES40_CBC_SHA");
        StandardNames.addNeither("SSL_RSA_EXPORT1024_WITH_DES_CBC_SHA");
        StandardNames.addNeither("SSL_RSA_EXPORT1024_WITH_RC4_56_SHA");
        StandardNames.addNeither("SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5");
        StandardNames.addNeither("TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA");
        StandardNames.addNeither("TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5");
        CIPHER_SUITES = IS_RI ? CIPHER_SUITES_RI : CIPHER_SUITES_OPENSSL;
    }
}

