/*
 * Decompiled with CFR 0.152.
 */
package com.android.musicvis.vis5;

import android.content.res.Resources;
import android.os.Handler;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.Primitive;
import android.renderscript.ProgramFragment;
import android.renderscript.ProgramStore;
import android.renderscript.ProgramVertex;
import android.renderscript.RenderScript;
import android.renderscript.Sampler;
import android.renderscript.ScriptC;
import android.renderscript.SimpleMesh;
import android.renderscript.Type;
import android.view.MotionEvent;
import com.android.musicvis.AudioCapture;
import com.android.musicvis.RenderScriptScene;
import java.util.TimeZone;

class Visualization5RS
extends RenderScriptScene {
    private final Handler mHandler = new Handler();
    private final Runnable mDrawCube = new Runnable(){

        public void run() {
            Visualization5RS.this.updateWave();
        }
    };
    private boolean mVisible;
    private int mNeedlePos = 0;
    private int mNeedleSpeed = 0;
    private int mNeedleMass = 10;
    private int mSpringForceAtOrigin = 200;
    WorldState mWorldState = new WorldState();
    private Type mStateType;
    private Allocation mState;
    private ProgramStore mPfsBackground;
    private ProgramFragment mPfBackgroundMip;
    private ProgramFragment mPfBackgroundNoMip;
    private Sampler mSamplerMip;
    private Sampler mSamplerNoMip;
    private Allocation[] mTextures;
    private ProgramVertex mPVBackground;
    private ProgramVertex.MatrixAllocation mPVAlloc;
    private SimpleMesh mCubeMesh;
    protected Allocation mPointAlloc;
    protected float[] mPointData = new float[2048];
    private Allocation mLineIdxAlloc;
    private short[] mIndexData = new short[512];
    private AudioCapture mAudioCapture = null;
    private int[] mVizData = new int[1024];
    private float mTouchY;

    Visualization5RS(int width, int height) {
        super(width, height);
        this.mWidth = width;
        this.mHeight = height;
        int outlen = this.mPointData.length / 8;
        int half = outlen / 2;
        for (int i = 0; i < outlen; ++i) {
            this.mPointData[i * 8] = i - half;
            this.mPointData[i * 8 + 2] = 0.0f;
            this.mPointData[i * 8 + 3] = 0.0f;
            this.mPointData[i * 8 + 4] = i - half;
            this.mPointData[i * 8 + 6] = 1.0f;
            this.mPointData[i * 8 + 7] = 0.0f;
        }
    }

    public void resize(int width, int height) {
        super.resize(width, height);
        if (this.mPVAlloc != null) {
            this.mPVAlloc.setupProjectionNormalized(width, height);
        }
        this.mWorldState.mTilt = -20.0f;
    }

    public void onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.mTouchY = event.getY();
                break;
            }
            case 2: {
                float dy = event.getY() - this.mTouchY;
                this.mTouchY += dy;
                dy /= 10.0f;
                dy += this.mWorldState.mTilt;
                if (dy > 0.0f) {
                    dy = 0.0f;
                } else if (dy < -45.0f) {
                    dy = -45.0f;
                }
                this.mWorldState.mTilt = dy;
                this.mState.data((Object)this.mWorldState);
            }
        }
    }

    public void setOffset(float xOffset, float yOffset, float xStep, float yStep, int xPixels, int yPixels) {
        this.mWorldState.mRotate = (xOffset - 0.5f) * 90.0f;
        this.mState.data((Object)this.mWorldState);
    }

    protected ScriptC createScript() {
        this.mStateType = Type.createFromClass((RenderScript)this.mRS, WorldState.class, (int)1, (String)"WorldState");
        this.mState = Allocation.createTyped((RenderScript)this.mRS, (Type)this.mStateType);
        ProgramVertex.Builder builder = new ProgramVertex.Builder((RenderScript)this.mRS, null, null);
        this.mPVBackground = builder.create();
        this.mPVBackground.setName("PVBackground");
        this.mPVAlloc = new ProgramVertex.MatrixAllocation((RenderScript)this.mRS);
        this.mPVBackground.bindAllocation(this.mPVAlloc);
        this.mPVAlloc.setupProjectionNormalized(this.mWidth, this.mHeight);
        this.mTextures = new Allocation[8];
        this.mTextures[0] = Allocation.createFromBitmapResourceBoxed((RenderScript)this.mRS, (Resources)this.mResources, (int)2130837505, (Element)Element.RGBA_8888((RenderScript)this.mRS), (boolean)true);
        this.mTextures[0].setName("Tvumeter_background");
        this.mTextures[1] = Allocation.createFromBitmapResourceBoxed((RenderScript)this.mRS, (Resources)this.mResources, (int)2130837508, (Element)Element.RGBA_8888((RenderScript)this.mRS), (boolean)true);
        this.mTextures[1].setName("Tvumeter_frame");
        this.mTextures[2] = Allocation.createFromBitmapResourceBoxed((RenderScript)this.mRS, (Resources)this.mResources, (int)2130837513, (Element)Element.RGBA_8888((RenderScript)this.mRS), (boolean)true);
        this.mTextures[2].setName("Tvumeter_peak_on");
        this.mTextures[3] = Allocation.createFromBitmapResourceBoxed((RenderScript)this.mRS, (Resources)this.mResources, (int)2130837512, (Element)Element.RGBA_8888((RenderScript)this.mRS), (boolean)true);
        this.mTextures[3].setName("Tvumeter_peak_off");
        this.mTextures[4] = Allocation.createFromBitmapResourceBoxed((RenderScript)this.mRS, (Resources)this.mResources, (int)2130837511, (Element)Element.RGBA_8888((RenderScript)this.mRS), (boolean)true);
        this.mTextures[4].setName("Tvumeter_needle");
        this.mTextures[5] = Allocation.createFromBitmapResourceBoxed((RenderScript)this.mRS, (Resources)this.mResources, (int)2130837506, (Element)Element.RGB_565((RenderScript)this.mRS), (boolean)false);
        this.mTextures[5].setName("Tvumeter_black");
        this.mTextures[6] = Allocation.createFromBitmapResource((RenderScript)this.mRS, (Resources)this.mResources, (int)2130837504, (Element)Element.RGBA_8888((RenderScript)this.mRS), (boolean)true);
        this.mTextures[6].setName("Tvumeter_album");
        this.mTextures[7] = Allocation.createFromBitmapResource((RenderScript)this.mRS, (Resources)this.mResources, (int)2130837507, (Element)Element.RGB_565((RenderScript)this.mRS), (boolean)false);
        this.mTextures[7].setName("Tlinetexture");
        int n = this.mTextures.length;
        for (int i = 0; i < n; ++i) {
            this.mTextures[i].uploadToTexture(0);
        }
        Sampler.Builder builder2 = new Sampler.Builder((RenderScript)this.mRS);
        builder2.setMin(Sampler.Value.LINEAR);
        builder2.setMag(Sampler.Value.LINEAR);
        builder2.setWrapS(Sampler.Value.WRAP);
        builder2.setWrapT(Sampler.Value.WRAP);
        this.mSamplerNoMip = builder2.create();
        builder2 = new Sampler.Builder((RenderScript)this.mRS);
        builder2.setMin(Sampler.Value.LINEAR_MIP_LINEAR);
        builder2.setMag(Sampler.Value.LINEAR);
        builder2.setWrapS(Sampler.Value.WRAP);
        builder2.setWrapT(Sampler.Value.WRAP);
        this.mSamplerMip = builder2.create();
        builder2 = new ProgramFragment.Builder((RenderScript)this.mRS);
        builder2.setTexture(ProgramFragment.Builder.EnvMode.REPLACE, ProgramFragment.Builder.Format.RGBA, 0);
        this.mPfBackgroundNoMip = builder2.create();
        this.mPfBackgroundNoMip.setName("PFBackgroundNoMip");
        this.mPfBackgroundNoMip.bindSampler(this.mSamplerNoMip, 0);
        builder2 = new ProgramFragment.Builder((RenderScript)this.mRS);
        builder2.setTexture(ProgramFragment.Builder.EnvMode.REPLACE, ProgramFragment.Builder.Format.RGBA, 0);
        this.mPfBackgroundMip = builder2.create();
        this.mPfBackgroundMip.setName("PFBackgroundMip");
        this.mPfBackgroundMip.bindSampler(this.mSamplerMip, 0);
        builder2 = new ProgramStore.Builder((RenderScript)this.mRS, null, null);
        builder2.setDepthFunc(ProgramStore.DepthFunc.EQUAL);
        builder2.setBlendFunc(ProgramStore.BlendSrcFunc.ONE, ProgramStore.BlendDstFunc.ONE_MINUS_SRC_ALPHA);
        builder2.setDitherEnable(true);
        builder2.setDepthMask(false);
        this.mPfsBackground = builder2.create();
        this.mPfsBackground.setName("PFSBackground");
        builder2 = new SimpleMesh.Builder((RenderScript)this.mRS);
        Element.Builder builder3 = new Element.Builder((RenderScript)this.mRS);
        builder3.add(Element.ATTRIB_POSITION_2((RenderScript)this.mRS), "position");
        builder3.add(Element.ATTRIB_TEXTURE_2((RenderScript)this.mRS), "texture");
        Element element = builder3.create();
        int n2 = builder2.addVertexType(element, this.mPointData.length / 4);
        builder2.setIndexType(Element.INDEX_16((RenderScript)this.mRS), this.mIndexData.length);
        builder2.setPrimitive(Primitive.LINE);
        this.mCubeMesh = builder2.create();
        this.mCubeMesh.setName("CubeMesh");
        this.mPointAlloc = this.mCubeMesh.createVertexAllocation(n2);
        this.mPointAlloc.setName("PointBuffer");
        this.mLineIdxAlloc = this.mCubeMesh.createIndexAllocation();
        this.mCubeMesh.bindVertexAllocation(this.mPointAlloc, 0);
        this.mCubeMesh.bindIndexAllocation(this.mLineIdxAlloc);
        this.updateWave();
        for (int i = 0; i < this.mIndexData.length; ++i) {
            this.mIndexData[i] = (short)i;
        }
        this.mPointAlloc.data(this.mPointData);
        this.mPointAlloc.uploadToBufferObject();
        this.mLineIdxAlloc.data(this.mIndexData);
        this.mLineIdxAlloc.uploadToBufferObject();
        ScriptC.Builder builder4 = new ScriptC.Builder((RenderScript)this.mRS);
        builder4.setType(this.mStateType, "State", 0);
        builder4.setScript(this.mResources, 2130968576);
        builder4.setRoot(true);
        ScriptC scriptC = builder4.create();
        scriptC.setClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        scriptC.setTimeZone(TimeZone.getDefault().getID());
        scriptC.bindAllocation(this.mState, 0);
        scriptC.bindAllocation(this.mPointAlloc, 1);
        scriptC.bindAllocation(this.mLineIdxAlloc, 2);
        scriptC.bindAllocation(this.mPVAlloc.mAlloc, 3);
        return scriptC;
    }

    public void start() {
        super.start();
        this.mVisible = true;
        if (this.mAudioCapture == null) {
            this.mAudioCapture = new AudioCapture(0, 1024);
        }
        this.mAudioCapture.start();
        this.updateWave();
    }

    public void stop() {
        super.stop();
        this.mVisible = false;
        if (this.mAudioCapture != null) {
            this.mAudioCapture.stop();
            this.mAudioCapture.release();
            this.mAudioCapture = null;
        }
    }

    void updateWave() {
        this.mHandler.removeCallbacks(this.mDrawCube);
        if (!this.mVisible) {
            return;
        }
        this.mHandler.postDelayed(this.mDrawCube, 20L);
        int len = 0;
        if (this.mAudioCapture != null) {
            this.mVizData = this.mAudioCapture.getFormattedData(512, 1);
            len = this.mVizData.length;
        }
        int volt = 0;
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                int val = this.mVizData[i];
                if (val < 0) {
                    val = -val;
                }
                volt += val;
            }
            volt /= len;
        }
        int netforce = volt - this.mNeedleSpeed * 3 - (this.mNeedlePos + this.mSpringForceAtOrigin);
        int acceleration = netforce / this.mNeedleMass;
        this.mNeedleSpeed += acceleration;
        this.mNeedlePos += this.mNeedleSpeed;
        if (this.mNeedlePos < 0) {
            this.mNeedlePos = 0;
            this.mNeedleSpeed = 0;
        } else if (this.mNeedlePos > Short.MAX_VALUE) {
            if (this.mNeedlePos > 33333) {
                this.mWorldState.mPeak = 10;
            }
            this.mNeedlePos = Short.MAX_VALUE;
            this.mNeedleSpeed = 0;
        }
        if (this.mWorldState.mPeak > 0) {
            --this.mWorldState.mPeak;
        }
        this.mWorldState.mAngle = 131.0f - (float)this.mNeedlePos / 410.0f;
        if (len == 0) {
            if (this.mWorldState.mIdle == 0) {
                this.mWorldState.mIdle = 1;
            }
        } else {
            int outlen;
            if (this.mWorldState.mIdle != 0) {
                this.mWorldState.mIdle = 0;
            }
            if ((len /= 4) > (outlen = this.mPointData.length / 8)) {
                len = outlen;
            }
            for (int i = 0; i < len; ++i) {
                int amp = this.mVizData[i * 4] + this.mVizData[i * 4 + 1] + this.mVizData[i * 4 + 2] + this.mVizData[i * 4 + 3];
                this.mPointData[i * 8 + 1] = amp;
                this.mPointData[i * 8 + 5] = -amp;
            }
            this.mPointAlloc.data(this.mPointData);
            ++this.mWorldState.mWaveCounter;
        }
        this.mState.data((Object)this.mWorldState);
    }

    static class WorldState {
        public float mAngle;
        public int mPeak;
        public float mRotate;
        public float mTilt;
        public int mIdle;
        public int mWaveCounter;

        WorldState() {
        }
    }
}

