/*
 * Decompiled with CFR 0.152.
 */
package com.android.musicvis.vis4;

import android.content.res.Resources;
import android.os.Handler;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.ProgramFragment;
import android.renderscript.ProgramStore;
import android.renderscript.ProgramVertex;
import android.renderscript.RenderScript;
import android.renderscript.Sampler;
import android.renderscript.ScriptC;
import android.renderscript.Type;
import com.android.musicvis.AudioCapture;
import com.android.musicvis.RenderScriptScene;
import java.util.TimeZone;

class Visualization4RS
extends RenderScriptScene {
    private final Handler mHandler = new Handler();
    private final Runnable mDrawCube = new Runnable(){

        public void run() {
            Visualization4RS.this.updateWave();
        }
    };
    private boolean mVisible;
    private int mNeedlePos = 0;
    private int mNeedleSpeed = 0;
    private int mNeedleMass = 10;
    private int mSpringForceAtOrigin = 200;
    WorldState mWorldState = new WorldState();
    private Type mStateType;
    private Allocation mState;
    private ProgramStore mPfsBackground;
    private ProgramFragment mPfBackground;
    private Sampler mSampler;
    private Allocation[] mTextures;
    private ProgramVertex mPVBackground;
    private ProgramVertex.MatrixAllocation mPVAlloc;
    private AudioCapture mAudioCapture = null;
    private int[] mVizData = new int[1024];

    Visualization4RS(int width, int height) {
        super(width, height);
        this.mWidth = width;
        this.mHeight = height;
    }

    public void resize(int width, int height) {
        super.resize(width, height);
        if (this.mPVAlloc != null) {
            this.mPVAlloc.setupProjectionNormalized(width, height);
        }
    }

    protected ScriptC createScript() {
        this.mStateType = Type.createFromClass((RenderScript)this.mRS, WorldState.class, (int)1, (String)"WorldState");
        this.mState = Allocation.createTyped((RenderScript)this.mRS, (Type)this.mStateType);
        ProgramVertex.Builder builder = new ProgramVertex.Builder((RenderScript)this.mRS, null, null);
        this.mPVBackground = builder.create();
        this.mPVBackground.setName("PVBackground");
        this.mPVAlloc = new ProgramVertex.MatrixAllocation((RenderScript)this.mRS);
        this.mPVBackground.bindAllocation(this.mPVAlloc);
        this.mPVAlloc.setupProjectionNormalized(this.mWidth, this.mHeight);
        this.updateWave();
        this.mTextures = new Allocation[6];
        this.mTextures[0] = Allocation.createFromBitmapResourceBoxed((RenderScript)this.mRS, (Resources)this.mResources, (int)2130837505, (Element)Element.RGBA_8888((RenderScript)this.mRS), (boolean)false);
        this.mTextures[0].setName("Tvumeter_background");
        this.mTextures[1] = Allocation.createFromBitmapResourceBoxed((RenderScript)this.mRS, (Resources)this.mResources, (int)2130837508, (Element)Element.RGBA_8888((RenderScript)this.mRS), (boolean)false);
        this.mTextures[1].setName("Tvumeter_frame");
        this.mTextures[2] = Allocation.createFromBitmapResourceBoxed((RenderScript)this.mRS, (Resources)this.mResources, (int)2130837513, (Element)Element.RGBA_8888((RenderScript)this.mRS), (boolean)false);
        this.mTextures[2].setName("Tvumeter_peak_on");
        this.mTextures[3] = Allocation.createFromBitmapResourceBoxed((RenderScript)this.mRS, (Resources)this.mResources, (int)2130837512, (Element)Element.RGBA_8888((RenderScript)this.mRS), (boolean)false);
        this.mTextures[3].setName("Tvumeter_peak_off");
        this.mTextures[4] = Allocation.createFromBitmapResourceBoxed((RenderScript)this.mRS, (Resources)this.mResources, (int)2130837511, (Element)Element.RGBA_8888((RenderScript)this.mRS), (boolean)false);
        this.mTextures[4].setName("Tvumeter_needle");
        this.mTextures[5] = Allocation.createFromBitmapResourceBoxed((RenderScript)this.mRS, (Resources)this.mResources, (int)2130837506, (Element)Element.RGB_565((RenderScript)this.mRS), (boolean)false);
        this.mTextures[5].setName("Tvumeter_black");
        int n = this.mTextures.length;
        for (int i = 0; i < n; ++i) {
            this.mTextures[i].uploadToTexture(0);
        }
        Sampler.Builder builder2 = new Sampler.Builder((RenderScript)this.mRS);
        builder2.setMin(Sampler.Value.LINEAR);
        builder2.setMag(Sampler.Value.LINEAR);
        builder2.setWrapS(Sampler.Value.WRAP);
        builder2.setWrapT(Sampler.Value.WRAP);
        this.mSampler = builder2.create();
        ProgramFragment.Builder builder3 = new ProgramFragment.Builder((RenderScript)this.mRS);
        builder3.setTexture(ProgramFragment.Builder.EnvMode.REPLACE, ProgramFragment.Builder.Format.RGBA, 0);
        this.mPfBackground = builder3.create();
        this.mPfBackground.setName("PFBackground");
        this.mPfBackground.bindSampler(this.mSampler, 0);
        builder3 = new ProgramStore.Builder((RenderScript)this.mRS, null, null);
        builder3.setDepthFunc(ProgramStore.DepthFunc.ALWAYS);
        builder3.setBlendFunc(ProgramStore.BlendSrcFunc.ONE, ProgramStore.BlendDstFunc.ONE_MINUS_SRC_ALPHA);
        builder3.setDitherEnable(true);
        builder3.setDepthMask(false);
        this.mPfsBackground = builder3.create();
        this.mPfsBackground.setName("PFSBackground");
        builder3 = new ScriptC.Builder((RenderScript)this.mRS);
        builder3.setType(this.mStateType, "State", 0);
        builder3.setScript(this.mResources, 2130968577);
        builder3.setRoot(true);
        ScriptC scriptC = builder3.create();
        scriptC.setClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        scriptC.setTimeZone(TimeZone.getDefault().getID());
        scriptC.bindAllocation(this.mState, 0);
        scriptC.bindAllocation(this.mPVAlloc.mAlloc, 3);
        return scriptC;
    }

    public void start() {
        super.start();
        this.mVisible = true;
        if (this.mAudioCapture == null) {
            this.mAudioCapture = new AudioCapture(0, 1024);
        }
        this.mAudioCapture.start();
        this.updateWave();
    }

    public void stop() {
        super.stop();
        this.mVisible = false;
        if (this.mAudioCapture != null) {
            this.mAudioCapture.stop();
            this.mAudioCapture.release();
            this.mAudioCapture = null;
        }
    }

    void updateWave() {
        this.mHandler.removeCallbacks(this.mDrawCube);
        if (!this.mVisible) {
            return;
        }
        this.mHandler.postDelayed(this.mDrawCube, 20L);
        int len = 0;
        if (this.mAudioCapture != null) {
            this.mVizData = this.mAudioCapture.getFormattedData(512, 1);
            len = this.mVizData.length;
        }
        int volt = 0;
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                int val = this.mVizData[i];
                if (val < 0) {
                    val = -val;
                }
                volt += val;
            }
            volt /= len;
        }
        int netforce = volt - this.mNeedleSpeed * 3 - (this.mNeedlePos + this.mSpringForceAtOrigin);
        int acceleration = netforce / this.mNeedleMass;
        this.mNeedleSpeed += acceleration;
        this.mNeedlePos += this.mNeedleSpeed;
        if (this.mNeedlePos < 0) {
            this.mNeedlePos = 0;
            this.mNeedleSpeed = 0;
        } else if (this.mNeedlePos > Short.MAX_VALUE) {
            if (this.mNeedlePos > 33333) {
                this.mWorldState.mPeak = 10;
            }
            this.mNeedlePos = Short.MAX_VALUE;
            this.mNeedleSpeed = 0;
        }
        if (this.mWorldState.mPeak > 0) {
            --this.mWorldState.mPeak;
        }
        this.mWorldState.mAngle = 131.0f - (float)this.mNeedlePos / 410.0f;
        this.mState.data((Object)this.mWorldState);
    }

    static class WorldState {
        public float mAngle;
        public int mPeak;

        WorldState() {
        }
    }
}

