/*
 * Decompiled with CFR 0.152.
 */
package com.android.musicvis.vis3;

import com.android.musicvis.AudioCapture;
import com.android.musicvis.GenericWaveRS;

class Visualization3RS
extends GenericWaveRS {
    private short[] mAnalyzer = new short[512];

    Visualization3RS(int width, int height) {
        super(width, height, 2130837510);
    }

    public void setOffset(float xOffset, float yOffset, float xStep, float yStep, int xPixels, int yPixels) {
        if (xStep <= 0.0f) {
            xStep = xOffset / 2.0f;
        }
        this.mWorldState.yRotation = xStep == 0.0f ? 0.0f : xOffset / xStep * 360.0f;
        this.mState.data((Object)this.mWorldState);
    }

    public void start() {
        if (this.mAudioCapture == null) {
            this.mAudioCapture = new AudioCapture(1, 512);
        }
        super.start();
    }

    public void stop() {
        super.stop();
        if (this.mAudioCapture != null) {
            this.mAudioCapture.release();
            this.mAudioCapture = null;
        }
    }

    public void update() {
        int len = 0;
        if (this.mAudioCapture != null) {
            this.mVizData = this.mAudioCapture.getFormattedData(1, 1);
            len = this.mVizData.length / 2;
        }
        if (len == 0) {
            if (this.mWorldState.idle == 0) {
                this.mWorldState.idle = 1;
                this.mState.data((Object)this.mWorldState);
            }
            return;
        }
        if ((len /= 2) > this.mAnalyzer.length) {
            len = this.mAnalyzer.length;
        }
        if (this.mWorldState.idle != 0) {
            this.mWorldState.idle = 0;
            this.mState.data((Object)this.mWorldState);
        }
        for (int i = 1; i < len - 1; ++i) {
            int val1 = this.mVizData[i * 2];
            int val2 = this.mVizData[i * 2 + 1];
            int val = val1 * val1 + val2 * val2;
            short newval = (short)(val * (i / 16 + 1));
            short oldval = this.mAnalyzer[i];
            if (newval < oldval - 800) {
                newval = (short)(oldval - 800);
            }
            this.mAnalyzer[i] = newval;
        }
        int outlen = this.mPointData.length / 8;
        int width = this.mWidth;
        int skip = (outlen - this.mWidth) / 2;
        int srcidx = 0;
        int cnt = 0;
        for (int i = 0; i < width; ++i) {
            float val = this.mAnalyzer[srcidx] / 8;
            if (val < 1.0f && val > -1.0f) {
                val = 1.0f;
            }
            this.mPointData[(i + skip) * 8 + 1] = val;
            this.mPointData[(i + skip) * 8 + 5] = -val;
            if ((cnt += len) <= width) continue;
            ++srcidx;
            cnt -= width;
        }
        this.mPointAlloc.data(this.mPointData);
    }
}

