/*
 * Decompiled with CFR 0.152.
 */
package com.android.musicvis;

import android.renderscript.RenderScript;
import android.renderscript.RenderScriptGL;
import android.service.wallpaper.WallpaperService;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.android.musicvis.RenderScriptScene;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RenderScriptWallpaper<T extends RenderScriptScene>
extends WallpaperService {
    public WallpaperService.Engine onCreateEngine() {
        return new RenderScriptEngine();
    }

    protected abstract T createScene(int var1, int var2);

    private class RenderScriptEngine
    extends WallpaperService.Engine {
        private RenderScriptGL mRs;
        private T mRenderer;

        private RenderScriptEngine() {
            super((WallpaperService)RenderScriptWallpaper.this);
        }

        public void onCreate(SurfaceHolder surfaceHolder) {
            super.onCreate(surfaceHolder);
            this.setTouchEventsEnabled(true);
            surfaceHolder.setSizeFromLayout();
        }

        public void onDestroy() {
            super.onDestroy();
            this.destroyRenderer();
        }

        private void destroyRenderer() {
            if (this.mRenderer != null) {
                ((RenderScriptScene)this.mRenderer).stop();
                this.mRenderer = null;
            }
            if (this.mRs != null) {
                this.mRs.destroy();
                this.mRs = null;
            }
        }

        public void onVisibilityChanged(boolean visible) {
            super.onVisibilityChanged(visible);
            if (this.mRenderer != null) {
                if (visible) {
                    ((RenderScriptScene)this.mRenderer).start();
                } else {
                    ((RenderScriptScene)this.mRenderer).stop();
                }
            }
        }

        public void onSurfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            super.onSurfaceChanged(holder, format, width, height);
            if (this.mRs != null) {
                this.mRs.contextSetSurface(width, height, holder.getSurface());
            }
            if (this.mRenderer == null) {
                this.mRenderer = RenderScriptWallpaper.this.createScene(width, height);
                ((RenderScriptScene)this.mRenderer).init(this.mRs, RenderScriptWallpaper.this.getResources(), this.isPreview());
                ((RenderScriptScene)this.mRenderer).start();
            } else {
                ((RenderScriptScene)this.mRenderer).resize(width, height);
            }
        }

        public void onTouchEvent(MotionEvent event) {
            if (this.mRenderer != null) {
                ((RenderScriptScene)this.mRenderer).onTouchEvent(event);
            }
        }

        public void onOffsetsChanged(float xOffset, float yOffset, float xStep, float yStep, int xPixels, int yPixels) {
            if (this.mRenderer != null) {
                ((RenderScriptScene)this.mRenderer).setOffset(xOffset, yOffset, xStep, yStep, xPixels, yPixels);
            }
        }

        public void onSurfaceCreated(SurfaceHolder holder) {
            super.onSurfaceCreated(holder);
            Surface surface = null;
            while (surface == null) {
                surface = holder.getSurface();
            }
            this.mRs = new RenderScriptGL(false, false);
            this.mRs.contextSetPriority(RenderScript.Priority.LOW);
        }

        public void onSurfaceDestroyed(SurfaceHolder holder) {
            super.onSurfaceDestroyed(holder);
            this.destroyRenderer();
        }
    }
}

