/*
 * Decompiled with CFR 0.152.
 */
package com.android.musicvis;

import android.content.res.Resources;
import android.os.Handler;
import android.os.SystemClock;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.Primitive;
import android.renderscript.ProgramFragment;
import android.renderscript.ProgramVertex;
import android.renderscript.RenderScript;
import android.renderscript.Sampler;
import android.renderscript.ScriptC;
import android.renderscript.SimpleMesh;
import android.renderscript.Type;
import com.android.musicvis.AudioCapture;
import com.android.musicvis.RenderScriptScene;
import java.util.TimeZone;

public class GenericWaveRS
extends RenderScriptScene {
    private final Handler mHandler = new Handler();
    private final Runnable mDrawCube = new Runnable(){

        public void run() {
            GenericWaveRS.this.updateWave();
        }
    };
    private boolean mVisible;
    private int mTexId;
    protected WorldState mWorldState = new WorldState();
    private Type mStateType;
    protected Allocation mState;
    private SimpleMesh mCubeMesh;
    protected Allocation mPointAlloc;
    protected float[] mPointData = new float[8192];
    private Allocation mLineIdxAlloc;
    private short[] mIndexData = new short[2048];
    private ProgramVertex mPVBackground;
    private ProgramVertex.MatrixAllocation mPVAlloc;
    protected AudioCapture mAudioCapture = null;
    protected int[] mVizData = new int[1024];
    private ProgramFragment mPfBackground;
    private Sampler mSampler;
    private Allocation mTexture;

    protected GenericWaveRS(int width, int height, int texid) {
        super(width, height);
        this.mTexId = texid;
        this.mWidth = width;
        this.mHeight = height;
        int outlen = this.mPointData.length / 8;
        int half = outlen / 2;
        for (int i = 0; i < outlen; ++i) {
            this.mPointData[i * 8] = i - half;
            this.mPointData[i * 8 + 2] = 0.0f;
            this.mPointData[i * 8 + 3] = 0.0f;
            this.mPointData[i * 8 + 4] = i - half;
            this.mPointData[i * 8 + 6] = 1.0f;
            this.mPointData[i * 8 + 7] = 0.0f;
        }
    }

    public void resize(int width, int height) {
        super.resize(width, height);
        this.mWorldState.width = width;
        if (this.mPVAlloc != null) {
            this.mPVAlloc.setupProjectionNormalized(this.mWidth, this.mHeight);
        }
    }

    protected ScriptC createScript() {
        this.mStateType = Type.createFromClass((RenderScript)this.mRS, WorldState.class, (int)1, (String)"WorldState");
        this.mState = Allocation.createTyped((RenderScript)this.mRS, (Type)this.mStateType);
        this.mWorldState.yRotation = 0.0f;
        this.mWorldState.width = this.mWidth;
        this.mState.data((Object)this.mWorldState);
        ProgramVertex.Builder builder = new ProgramVertex.Builder((RenderScript)this.mRS, null, null);
        this.mPVBackground = builder.create();
        this.mPVBackground.setName("PVBackground");
        this.mPVAlloc = new ProgramVertex.MatrixAllocation((RenderScript)this.mRS);
        this.mPVBackground.bindAllocation(this.mPVAlloc);
        this.mPVAlloc.setupProjectionNormalized(this.mWidth, this.mHeight);
        SimpleMesh.Builder builder2 = new SimpleMesh.Builder((RenderScript)this.mRS);
        Element.Builder builder3 = new Element.Builder((RenderScript)this.mRS);
        builder3.add(Element.ATTRIB_POSITION_2((RenderScript)this.mRS), "position");
        builder3.add(Element.ATTRIB_TEXTURE_2((RenderScript)this.mRS), "texture");
        Element element = builder3.create();
        int n = builder2.addVertexType(element, this.mPointData.length / 4);
        builder2.setIndexType(Element.INDEX_16((RenderScript)this.mRS), this.mIndexData.length);
        builder2.setPrimitive(Primitive.LINE);
        this.mCubeMesh = builder2.create();
        this.mCubeMesh.setName("CubeMesh");
        this.mPointAlloc = this.mCubeMesh.createVertexAllocation(n);
        this.mPointAlloc.setName("PointBuffer");
        this.mLineIdxAlloc = this.mCubeMesh.createIndexAllocation();
        this.mCubeMesh.bindVertexAllocation(this.mPointAlloc, 0);
        this.mCubeMesh.bindIndexAllocation(this.mLineIdxAlloc);
        this.updateWave();
        for (int i = 0; i < this.mIndexData.length; ++i) {
            this.mIndexData[i] = (short)i;
        }
        this.mPointAlloc.data(this.mPointData);
        this.mPointAlloc.uploadToBufferObject();
        this.mLineIdxAlloc.data(this.mIndexData);
        this.mLineIdxAlloc.uploadToBufferObject();
        this.mTexture = Allocation.createFromBitmapResourceBoxed((RenderScript)this.mRS, (Resources)this.mResources, (int)this.mTexId, (Element)Element.RGB_565((RenderScript)this.mRS), (boolean)false);
        this.mTexture.setName("Tlinetexture");
        this.mTexture.uploadToTexture(0);
        Sampler.Builder builder4 = new Sampler.Builder((RenderScript)this.mRS);
        builder4.setMin(Sampler.Value.LINEAR);
        builder4.setMag(Sampler.Value.LINEAR);
        builder4.setWrapS(Sampler.Value.WRAP);
        builder4.setWrapT(Sampler.Value.WRAP);
        this.mSampler = builder4.create();
        ProgramFragment.Builder builder5 = new ProgramFragment.Builder((RenderScript)this.mRS);
        builder5.setTexture(ProgramFragment.Builder.EnvMode.REPLACE, ProgramFragment.Builder.Format.RGBA, 0);
        this.mPfBackground = builder5.create();
        this.mPfBackground.setName("PFBackground");
        this.mPfBackground.bindSampler(this.mSampler, 0);
        ScriptC.Builder builder6 = new ScriptC.Builder((RenderScript)this.mRS);
        builder6.setType(this.mStateType, "State", 0);
        builder6.setType(this.mCubeMesh.getVertexType(0), "Points", 1);
        builder6.setScript(this.mResources, 2130968578);
        builder6.setRoot(true);
        ScriptC scriptC = builder6.create();
        scriptC.setClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        scriptC.setTimeZone(TimeZone.getDefault().getID());
        scriptC.bindAllocation(this.mState, 0);
        scriptC.bindAllocation(this.mPointAlloc, 1);
        scriptC.bindAllocation(this.mLineIdxAlloc, 2);
        scriptC.bindAllocation(this.mPVAlloc.mAlloc, 3);
        return scriptC;
    }

    public void setOffset(float xOffset, float yOffset, float xStep, float yStep, int xPixels, int yPixels) {
        if (xStep <= 0.0f) {
            xStep = xOffset / 2.0f;
        }
        this.mWorldState.yRotation = xStep == 0.0f ? 0.0f : xOffset / xStep * 180.0f;
        this.mState.data((Object)this.mWorldState);
    }

    public void start() {
        super.start();
        this.mVisible = true;
        if (this.mAudioCapture != null) {
            this.mAudioCapture.start();
        }
        SystemClock.sleep((long)200L);
        this.updateWave();
    }

    public void stop() {
        super.stop();
        this.mVisible = false;
        if (this.mAudioCapture != null) {
            this.mAudioCapture.stop();
        }
        this.updateWave();
    }

    public void update() {
    }

    void updateWave() {
        this.mHandler.removeCallbacks(this.mDrawCube);
        if (!this.mVisible) {
            return;
        }
        this.mHandler.postDelayed(this.mDrawCube, 20L);
        this.update();
        ++this.mWorldState.waveCounter;
        this.mState.data((Object)this.mWorldState);
    }

    protected static class WorldState {
        public float yRotation;
        public int idle;
        public int waveCounter;
        public int width;

        protected WorldState() {
        }
    }
}

