/*
 * Decompiled with CFR 0.152.
 */
package com.android.musicvis;

import android.media.audiofx.Visualizer;
import android.util.Log;

public class AudioCapture {
    private byte[] mRawVizData;
    private int[] mFormattedVizData;
    private byte[] mRawNullData = new byte[0];
    private int[] mFormattedNullData = new int[0];
    private Visualizer mVisualizer;
    private int mType;
    private static long MAX_IDLE_TIME_MS = 3000L;
    private long mLastValidCaptureTimeMs;

    public AudioCapture(int type, int size) {
        this.mType = type;
        int[] range = new int[2];
        range = Visualizer.getCaptureSizeRange();
        if (size < range[0]) {
            size = range[0];
        }
        if (size > range[1]) {
            size = range[1];
        }
        this.mRawVizData = new byte[size];
        this.mFormattedVizData = new int[size];
        this.mVisualizer = null;
        try {
            this.mVisualizer = new Visualizer(0);
            if (this.mVisualizer != null) {
                if (this.mVisualizer.getEnabled()) {
                    this.mVisualizer.setEnabled(false);
                }
                this.mVisualizer.setCaptureSize(this.mRawVizData.length);
            }
        }
        catch (UnsupportedOperationException e) {
            Log.e((String)"AudioCapture", (String)"Visualizer cstor UnsupportedOperationException");
        }
        catch (IllegalStateException e) {
            Log.e((String)"AudioCapture", (String)"Visualizer cstor IllegalStateException");
        }
        catch (RuntimeException e) {
            Log.e((String)"AudioCapture", (String)"Visualizer cstor RuntimeException");
        }
    }

    public void start() {
        if (this.mVisualizer != null) {
            try {
                if (!this.mVisualizer.getEnabled()) {
                    this.mVisualizer.setEnabled(true);
                    this.mLastValidCaptureTimeMs = System.currentTimeMillis();
                }
            }
            catch (IllegalStateException e) {
                Log.e((String)"AudioCapture", (String)"start() IllegalStateException");
            }
        }
    }

    public void stop() {
        if (this.mVisualizer != null) {
            try {
                if (this.mVisualizer.getEnabled()) {
                    this.mVisualizer.setEnabled(false);
                }
            }
            catch (IllegalStateException e) {
                Log.e((String)"AudioCapture", (String)"stop() IllegalStateException");
            }
        }
    }

    public void release() {
        if (this.mVisualizer != null) {
            this.mVisualizer.release();
            this.mVisualizer = null;
        }
    }

    public int[] getFormattedData(int num, int den) {
        if (this.captureData()) {
            if (this.mType == 0) {
                for (int i = 0; i < this.mFormattedVizData.length; ++i) {
                    int tmp = (this.mRawVizData[i] & 0xFF) - 128;
                    this.mFormattedVizData[i] = tmp * num / den;
                }
            } else {
                for (int i = 0; i < this.mFormattedVizData.length; ++i) {
                    this.mFormattedVizData[i] = this.mRawVizData[i] * num / den;
                }
            }
            return this.mFormattedVizData;
        }
        return this.mFormattedNullData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean captureData() {
        int i22;
        boolean result;
        block16: {
            int status = -1;
            result = true;
            try {
                try {
                    if (this.mVisualizer != null) {
                        status = this.mType == 0 ? this.mVisualizer.getWaveForm(this.mRawVizData) : this.mVisualizer.getFft(this.mRawVizData);
                    }
                }
                catch (IllegalStateException e) {
                    int i22;
                    Log.e((String)"AudioCapture", (String)("captureData() IllegalStateException: " + this));
                    Object var5_4 = null;
                    if (status != 0) {
                        Log.e((String)"AudioCapture", (String)("captureData() :  " + this + " error: " + status));
                        return false;
                    }
                    byte nullValue = 0;
                    if (this.mType == 0) {
                        nullValue = -128;
                    }
                    for (i22 = 0; i22 < this.mRawVizData.length && this.mRawVizData[i22] == nullValue; ++i22) {
                    }
                    if (i22 == this.mRawVizData.length) {
                        if (System.currentTimeMillis() - this.mLastValidCaptureTimeMs <= MAX_IDLE_TIME_MS) return result;
                        return false;
                    }
                    this.mLastValidCaptureTimeMs = System.currentTimeMillis();
                    return result;
                }
                Object var5_3 = null;
                if (status == 0) break block16;
            }
            catch (Throwable throwable) {
                int i22;
                Object var5_5 = null;
                if (status != 0) {
                    Log.e((String)"AudioCapture", (String)("captureData() :  " + this + " error: " + status));
                    result = false;
                    throw throwable;
                }
                byte nullValue = 0;
                if (this.mType == 0) {
                    nullValue = -128;
                }
                for (i22 = 0; i22 < this.mRawVizData.length && this.mRawVizData[i22] == nullValue; ++i22) {
                }
                if (i22 == this.mRawVizData.length) {
                    if (System.currentTimeMillis() - this.mLastValidCaptureTimeMs <= MAX_IDLE_TIME_MS) throw throwable;
                    result = false;
                    throw throwable;
                }
                this.mLastValidCaptureTimeMs = System.currentTimeMillis();
                throw throwable;
            }
            Log.e((String)"AudioCapture", (String)("captureData() :  " + this + " error: " + status));
            return false;
        }
        byte nullValue = 0;
        if (this.mType == 0) {
            nullValue = -128;
        }
        for (i22 = 0; i22 < this.mRawVizData.length && this.mRawVizData[i22] == nullValue; ++i22) {
        }
        if (i22 == this.mRawVizData.length) {
            if (System.currentTimeMillis() - this.mLastValidCaptureTimeMs <= MAX_IDLE_TIME_MS) return result;
            return false;
        }
        this.mLastValidCaptureTimeMs = System.currentTimeMillis();
        return result;
    }
}

