/*
 * Decompiled with CFR 0.152.
 */
package android.tts;

import android.app.Service;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.database.Cursor;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.provider.Settings;
import android.speech.tts.ITts;
import android.speech.tts.ITtsCallback;
import android.tts.SynthProxy;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TtsService
extends Service
implements MediaPlayer.OnCompletionListener {
    private static final int SPEECHQUEUELOCK_TIMEOUT = 5000;
    private static final int MAX_SPEECH_ITEM_CHAR_LENGTH = 4000;
    private static final int MAX_FILENAME_LENGTH = 250;
    private static final int DEFAULT_STREAM_TYPE = 3;
    private static final String DEFAULT_SYNTH = "com.svox.pico";
    private static final String ACTION = "android.intent.action.START_TTS_SERVICE";
    private static final String CATEGORY = "android.intent.category.TTS";
    private static final String PKGNAME = "android.tts";
    protected static final String SERVICE_TAG = "TtsService";
    private final RemoteCallbackList<ITtsCallback> mCallbacks = new RemoteCallbackList();
    private HashMap<String, ITtsCallback> mCallbacksMap;
    private Boolean mIsSpeaking;
    private Boolean mSynthBusy;
    private ArrayList<SpeechItem> mSpeechQueue;
    private HashMap<String, SoundResource> mEarcons;
    private HashMap<String, SoundResource> mUtterances;
    private MediaPlayer mPlayer;
    private SpeechItem mCurrentSpeechItem;
    private HashMap<SpeechItem, Boolean> mKillList;
    private TtsService mSelf;
    private ContentResolver mResolver;
    private final ReentrantLock speechQueueLock = new ReentrantLock();
    private final ReentrantLock synthesizerLock = new ReentrantLock();
    private static SynthProxy sNativeSynth = null;
    private String currentSpeechEngineSOFile = "";
    private final ITts.Stub mBinder = new ITts.Stub(){

        public int registerCallback(String packageName, ITtsCallback cb) {
            if (cb != null) {
                TtsService.this.mCallbacks.register((IInterface)cb);
                TtsService.this.mCallbacksMap.put(packageName, cb);
                return 0;
            }
            return -1;
        }

        public int unregisterCallback(String packageName, ITtsCallback cb) {
            if (cb != null) {
                TtsService.this.mCallbacksMap.remove(packageName);
                TtsService.this.mCallbacks.unregister((IInterface)cb);
                return 0;
            }
            return -1;
        }

        public int speak(String callingApp, String text, int queueMode, String[] params) {
            ArrayList<Object> speakingParams = new ArrayList();
            if (params != null) {
                speakingParams = new ArrayList<String>(Arrays.asList(params));
            }
            return TtsService.this.mSelf.speak(callingApp, text, queueMode, speakingParams);
        }

        public int playEarcon(String callingApp, String earcon, int queueMode, String[] params) {
            ArrayList<Object> speakingParams = new ArrayList();
            if (params != null) {
                speakingParams = new ArrayList<String>(Arrays.asList(params));
            }
            return TtsService.this.mSelf.playEarcon(callingApp, earcon, queueMode, speakingParams);
        }

        public int playSilence(String callingApp, long duration, int queueMode, String[] params) {
            ArrayList<Object> speakingParams = new ArrayList();
            if (params != null) {
                speakingParams = new ArrayList<String>(Arrays.asList(params));
            }
            return TtsService.this.mSelf.playSilence(callingApp, duration, queueMode, speakingParams);
        }

        public int stop(String callingApp) {
            return TtsService.this.mSelf.stop(callingApp);
        }

        public boolean isSpeaking() {
            return TtsService.this.mSelf.mIsSpeaking != false && TtsService.this.mSpeechQueue.size() < 1;
        }

        public void addSpeech(String callingApp, String text, String packageName, int resId) {
            TtsService.this.mSelf.addSpeech(callingApp, text, packageName, resId);
        }

        public void addSpeechFile(String callingApp, String text, String filename) {
            TtsService.this.mSelf.addSpeech(callingApp, text, filename);
        }

        public void addEarcon(String callingApp, String earcon, String packageName, int resId) {
            TtsService.this.mSelf.addEarcon(callingApp, earcon, packageName, resId);
        }

        public void addEarconFile(String callingApp, String earcon, String filename) {
            TtsService.this.mSelf.addEarcon(callingApp, earcon, filename);
        }

        public int setSpeechRate(String callingApp, int speechRate) {
            return TtsService.this.mSelf.setSpeechRate(callingApp, speechRate);
        }

        public int setPitch(String callingApp, int pitch) {
            return TtsService.this.mSelf.setPitch(callingApp, pitch);
        }

        public int isLanguageAvailable(String lang, String country, String variant, String[] params) {
            for (int i = 0; i < params.length - 1; i += 2) {
                String param = params[i];
                if (param == null || !param.equals("engine")) continue;
                TtsService.this.mSelf.setEngine(params[i + 1]);
                break;
            }
            return TtsService.this.mSelf.isLanguageAvailable(lang, country, variant);
        }

        public String[] getLanguage() {
            return TtsService.this.mSelf.getLanguage();
        }

        public int setLanguage(String callingApp, String lang, String country, String variant) {
            return TtsService.this.mSelf.setLanguage(callingApp, lang, country, variant);
        }

        public boolean synthesizeToFile(String callingApp, String text, String[] params, String filename) {
            ArrayList<Object> speakingParams = new ArrayList();
            if (params != null) {
                speakingParams = new ArrayList<String>(Arrays.asList(params));
            }
            return TtsService.this.mSelf.synthesizeToFile(callingApp, text, speakingParams, filename);
        }

        public int setEngineByPackageName(String packageName) {
            return TtsService.this.mSelf.setEngine(packageName);
        }

        public String getDefaultEngine() {
            return TtsService.this.mSelf.getDefaultEngine();
        }

        public boolean areDefaultsEnforced() {
            return TtsService.this.mSelf.isDefaultEnforced();
        }
    };

    public void onCreate() {
        super.onCreate();
        Log.v((String)SERVICE_TAG, (String)"TtsService.onCreate()");
        this.mResolver = this.getContentResolver();
        this.currentSpeechEngineSOFile = "";
        this.setEngine(this.getDefaultEngine());
        this.mSelf = this;
        this.mIsSpeaking = false;
        this.mSynthBusy = false;
        this.mEarcons = new HashMap();
        this.mUtterances = new HashMap();
        this.mCallbacksMap = new HashMap();
        this.mSpeechQueue = new ArrayList();
        this.mPlayer = null;
        this.mCurrentSpeechItem = null;
        this.mKillList = new HashMap();
        this.setDefaultSettings();
    }

    public void onDestroy() {
        super.onDestroy();
        this.killAllUtterances();
        this.cleanUpPlayer();
        if (sNativeSynth != null) {
            sNativeSynth.shutdown();
        }
        sNativeSynth = null;
        this.mCallbacks.kill();
        Log.v((String)SERVICE_TAG, (String)"onDestroy() completed");
    }

    private int setEngine(String enginePackageName) {
        String soFilename = "";
        if (this.isDefaultEnforced()) {
            enginePackageName = this.getDefaultEngine();
        }
        if (!enginePackageName.equals(DEFAULT_SYNTH)) {
            String[] enabledEngines = Settings.Secure.getString((ContentResolver)this.mResolver, (String)"tts_enabled_plugins").split(" ");
            boolean isEnabled = false;
            for (int i = 0; i < enabledEngines.length; ++i) {
                if (!enabledEngines[i].equals(enginePackageName)) continue;
                isEnabled = true;
                break;
            }
            if (!isEnabled) {
                enginePackageName = DEFAULT_SYNTH;
            }
        }
        if (enginePackageName.equals(DEFAULT_SYNTH)) {
            soFilename = "/system/lib/libttspico.so";
        } else {
            Intent intent = new Intent("android.intent.action.START_TTS_ENGINE");
            intent.setPackage(enginePackageName);
            ResolveInfo[] enginesArray = new ResolveInfo[]{};
            PackageManager pm = this.getPackageManager();
            List resolveInfos = pm.queryIntentActivities(intent, 0);
            if (resolveInfos == null || resolveInfos.isEmpty()) {
                Log.e((String)SERVICE_TAG, (String)("Invalid TTS Engine Package: " + enginePackageName));
                return -1;
            }
            enginesArray = resolveInfos.toArray(enginesArray);
            ActivityInfo aInfo = enginesArray[0].activityInfo;
            soFilename = aInfo.name.replace(aInfo.packageName + ".", "") + ".so";
            soFilename = soFilename.toLowerCase();
            soFilename = "/data/data/" + aInfo.packageName + "/lib/libtts" + soFilename;
        }
        if (this.currentSpeechEngineSOFile.equals(soFilename)) {
            return 0;
        }
        File f = new File(soFilename);
        if (!f.exists()) {
            Log.e((String)SERVICE_TAG, (String)("Invalid TTS Binary: " + soFilename));
            return -1;
        }
        if (sNativeSynth != null) {
            sNativeSynth.stopSync();
            sNativeSynth.shutdown();
            sNativeSynth = null;
        }
        String engineConfig = "";
        Cursor c = this.getContentResolver().query(Uri.parse((String)("content://" + enginePackageName + ".providers.SettingsProvider")), null, null, null, null);
        if (c != null) {
            c.moveToFirst();
            engineConfig = c.getString(0);
            c.close();
        }
        sNativeSynth = new SynthProxy(soFilename, engineConfig);
        this.currentSpeechEngineSOFile = soFilename;
        return 0;
    }

    private void setDefaultSettings() {
        this.setLanguage("", this.getDefaultLanguage(), this.getDefaultCountry(), this.getDefaultLocVariant());
        this.setSpeechRate("", this.getDefaultRate());
    }

    private boolean isDefaultEnforced() {
        return Settings.Secure.getInt((ContentResolver)this.mResolver, (String)"tts_use_defaults", (int)0) == 1;
    }

    private String getDefaultEngine() {
        String defaultEngine = Settings.Secure.getString((ContentResolver)this.mResolver, (String)"tts_default_synth");
        if (defaultEngine == null) {
            return DEFAULT_SYNTH;
        }
        return defaultEngine;
    }

    private int getDefaultRate() {
        return Settings.Secure.getInt((ContentResolver)this.mResolver, (String)"tts_default_rate", (int)100);
    }

    private int getDefaultPitch() {
        return 100;
    }

    private String getDefaultLanguage() {
        String defaultLang = Settings.Secure.getString((ContentResolver)this.mResolver, (String)"tts_default_lang");
        if (defaultLang == null) {
            return Locale.getDefault().getISO3Language();
        }
        return defaultLang;
    }

    private String getDefaultCountry() {
        String defaultCountry = Settings.Secure.getString((ContentResolver)this.mResolver, (String)"tts_default_country");
        if (defaultCountry == null) {
            return Locale.getDefault().getISO3Country();
        }
        return defaultCountry;
    }

    private String getDefaultLocVariant() {
        String defaultVar = Settings.Secure.getString((ContentResolver)this.mResolver, (String)"tts_default_variant");
        if (defaultVar == null) {
            return Locale.getDefault().getVariant();
        }
        return defaultVar;
    }

    private int setSpeechRate(String callingApp, int rate) {
        int res = -1;
        try {
            res = this.isDefaultEnforced() ? sNativeSynth.setSpeechRate(this.getDefaultRate()) : sNativeSynth.setSpeechRate(rate);
        }
        catch (NullPointerException e) {
            res = -1;
        }
        return res;
    }

    private int setPitch(String callingApp, int pitch) {
        int res = -1;
        try {
            res = sNativeSynth.setPitch(pitch);
        }
        catch (NullPointerException e) {
            res = -1;
        }
        return res;
    }

    private int isLanguageAvailable(String lang, String country, String variant) {
        int res = -2;
        try {
            res = sNativeSynth.isLanguageAvailable(lang, country, variant);
        }
        catch (NullPointerException e) {
            res = -2;
        }
        return res;
    }

    private String[] getLanguage() {
        try {
            return sNativeSynth.getLanguage();
        }
        catch (Exception e) {
            return null;
        }
    }

    private int setLanguage(String callingApp, String lang, String country, String variant) {
        Log.v((String)SERVICE_TAG, (String)("TtsService.setLanguage(" + lang + ", " + country + ", " + variant + ")"));
        int res = -1;
        try {
            res = this.isDefaultEnforced() ? sNativeSynth.setLanguage(this.getDefaultLanguage(), this.getDefaultCountry(), this.getDefaultLocVariant()) : sNativeSynth.setLanguage(lang, country, variant);
        }
        catch (NullPointerException e) {
            res = -1;
        }
        return res;
    }

    private void addSpeech(String callingApp, String text, String packageName, int resId) {
        this.mUtterances.put(text, new SoundResource(packageName, resId));
    }

    private void addSpeech(String callingApp, String text, String filename) {
        this.mUtterances.put(text, new SoundResource(filename));
    }

    private void addEarcon(String callingApp, String earcon, String packageName, int resId) {
        this.mEarcons.put(earcon, new SoundResource(packageName, resId));
    }

    private void addEarcon(String callingApp, String earcon, String filename) {
        this.mEarcons.put(earcon, new SoundResource(filename));
    }

    private int speak(String callingApp, String text, int queueMode, ArrayList<String> params) {
        Log.v((String)SERVICE_TAG, (String)("TTS service received " + text));
        if (queueMode == 0) {
            this.stop(callingApp);
        } else if (queueMode == 2) {
            this.stopAll(callingApp);
        }
        this.mSpeechQueue.add(new SpeechItem(callingApp, text, params, 0));
        if (!this.mIsSpeaking.booleanValue()) {
            this.processSpeechQueue();
        }
        return 0;
    }

    private int playEarcon(String callingApp, String earcon, int queueMode, ArrayList<String> params) {
        if (queueMode == 0) {
            this.stop(callingApp);
        } else if (queueMode == 2) {
            this.stopAll(callingApp);
        }
        this.mSpeechQueue.add(new SpeechItem(callingApp, earcon, params, 1));
        if (!this.mIsSpeaking.booleanValue()) {
            this.processSpeechQueue();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int stop(String callingApp) {
        int result = -1;
        boolean speechQueueAvailable = false;
        try {
            speechQueueAvailable = this.speechQueueLock.tryLock(5000L, TimeUnit.MILLISECONDS);
            if (speechQueueAvailable) {
                Log.i((String)SERVICE_TAG, (String)"Stopping");
                for (int i = this.mSpeechQueue.size() - 1; i > -1; --i) {
                    if (!this.mSpeechQueue.get((int)i).mCallingApp.equals(callingApp)) continue;
                    this.mSpeechQueue.remove(i);
                }
                if (this.mCurrentSpeechItem != null && this.mCurrentSpeechItem.mCallingApp.equals(callingApp)) {
                    try {
                        result = sNativeSynth.stop();
                    }
                    catch (NullPointerException e1) {
                        result = -1;
                    }
                    this.mKillList.put(this.mCurrentSpeechItem, true);
                    if (this.mPlayer != null) {
                        try {
                            this.mPlayer.stop();
                        }
                        catch (IllegalStateException e) {
                            // empty catch block
                        }
                    }
                    this.mIsSpeaking = false;
                    this.mCurrentSpeechItem = null;
                } else {
                    result = 0;
                }
                Log.i((String)SERVICE_TAG, (String)"Stopped");
            }
            Log.e((String)SERVICE_TAG, (String)"TTS stop(): queue locked longer than expected");
            result = -1;
            return result;
        }
        catch (InterruptedException e) {
            Log.e((String)SERVICE_TAG, (String)"TTS stop: tryLock interrupted");
            e.printStackTrace();
        }
        finally {
            if (speechQueueAvailable) {
                this.speechQueueLock.unlock();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int killAllUtterances() {
        int result = -1;
        boolean speechQueueAvailable = false;
        try {
            speechQueueAvailable = this.speechQueueLock.tryLock(5000L, TimeUnit.MILLISECONDS);
            if (speechQueueAvailable) {
                this.mSpeechQueue.clear();
                if (this.mCurrentSpeechItem != null) {
                    result = sNativeSynth.stopSync();
                    this.mKillList.put(this.mCurrentSpeechItem, true);
                    this.mIsSpeaking = false;
                    if (this.mCurrentSpeechItem.mType == 3 && this.mCurrentSpeechItem.mFilename != null) {
                        File tempFile = new File(this.mCurrentSpeechItem.mFilename);
                        Log.v((String)SERVICE_TAG, (String)("Leaving behind " + this.mCurrentSpeechItem.mFilename));
                        if (tempFile.exists()) {
                            Log.v((String)SERVICE_TAG, (String)("About to delete " + this.mCurrentSpeechItem.mFilename));
                            if (tempFile.delete()) {
                                Log.v((String)SERVICE_TAG, (String)"file successfully deleted");
                            }
                        }
                    }
                    this.mCurrentSpeechItem = null;
                }
            } else {
                Log.e((String)SERVICE_TAG, (String)"TTS killAllUtterances(): queue locked longer than expected");
                result = -1;
                return result;
            }
        }
        catch (InterruptedException e) {
            Log.e((String)SERVICE_TAG, (String)"TTS killAllUtterances(): tryLock interrupted");
            result = -1;
            return result;
        }
        finally {
            if (speechQueueAvailable) {
                this.speechQueueLock.unlock();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int stopAll(String callingApp) {
        int result = -1;
        boolean speechQueueAvailable = false;
        try {
            speechQueueAvailable = this.speechQueueLock.tryLock(5000L, TimeUnit.MILLISECONDS);
            if (speechQueueAvailable) {
                for (int i = this.mSpeechQueue.size() - 1; i > -1; --i) {
                    if (this.mSpeechQueue.get((int)i).mType == 3) continue;
                    this.mSpeechQueue.remove(i);
                }
                if (this.mCurrentSpeechItem != null && (this.mCurrentSpeechItem.mType != 3 || this.mCurrentSpeechItem.mCallingApp.equals(callingApp))) {
                    try {
                        result = sNativeSynth.stop();
                    }
                    catch (NullPointerException e1) {
                        result = -1;
                    }
                    this.mKillList.put(this.mCurrentSpeechItem, true);
                    if (this.mPlayer != null) {
                        try {
                            this.mPlayer.stop();
                        }
                        catch (IllegalStateException e) {
                            // empty catch block
                        }
                    }
                    this.mIsSpeaking = false;
                    this.mCurrentSpeechItem = null;
                } else {
                    result = 0;
                }
                Log.i((String)SERVICE_TAG, (String)"Stopped all");
            }
            Log.e((String)SERVICE_TAG, (String)"TTS stopAll(): queue locked longer than expected");
            result = -1;
            return result;
        }
        catch (InterruptedException e) {
            Log.e((String)SERVICE_TAG, (String)"TTS stopAll: tryLock interrupted");
            e.printStackTrace();
        }
        finally {
            if (speechQueueAvailable) {
                this.speechQueueLock.unlock();
            }
            return result;
        }
    }

    public void onCompletion(MediaPlayer arg0) {
        SpeechItem currentSpeechItemCopy = this.mCurrentSpeechItem;
        if (currentSpeechItemCopy != null) {
            String callingApp = currentSpeechItemCopy.mCallingApp;
            ArrayList<String> params = currentSpeechItemCopy.mParams;
            String utteranceId = "";
            if (params != null) {
                for (int i = 0; i < params.size() - 1; i += 2) {
                    String param = params.get(i);
                    if (!param.equals("utteranceId")) continue;
                    utteranceId = params.get(i + 1);
                }
            }
            if (utteranceId.length() > 0) {
                this.dispatchUtteranceCompletedCallback(utteranceId, callingApp);
            }
        }
        this.processSpeechQueue();
    }

    private int playSilence(String callingApp, long duration, int queueMode, ArrayList<String> params) {
        if (queueMode == 0) {
            this.stop(callingApp);
        }
        this.mSpeechQueue.add(new SpeechItem(callingApp, duration, params));
        if (!this.mIsSpeaking.booleanValue()) {
            this.processSpeechQueue();
        }
        return 0;
    }

    private void silence(final SpeechItem speechItem) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class SilenceThread
        implements Runnable {
            SilenceThread() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String utteranceId = "";
                if (speechItem.mParams != null) {
                    for (int i = 0; i < speechItem.mParams.size() - 1; i += 2) {
                        String param = speechItem.mParams.get(i);
                        if (!param.equals("utteranceId")) continue;
                        utteranceId = speechItem.mParams.get(i + 1);
                    }
                }
                try {
                    Thread.sleep(speechItem.mDuration);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                finally {
                    if (utteranceId.length() > 0) {
                        TtsService.this.dispatchUtteranceCompletedCallback(utteranceId, speechItem.mCallingApp);
                    }
                    TtsService.this.processSpeechQueue();
                }
            }
        }
        Thread slnc = new Thread(new SilenceThread());
        slnc.setPriority(1);
        slnc.start();
    }

    private void speakInternalOnly(SpeechItem speechItem) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class SynthThread
        implements Runnable {
            final /* synthetic */ SpeechItem val$speechItem;

            SynthThread() {
                this.val$speechItem = speechItem;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean synthAvailable = false;
                String utteranceId = "";
                try {
                    synthAvailable = TtsService.this.synthesizerLock.tryLock();
                    if (!synthAvailable) {
                        TtsService.this.mSynthBusy = true;
                        Thread.sleep(100L);
                        Thread synth = new Thread(new SynthThread());
                        synth.start();
                        TtsService.this.mSynthBusy = false;
                        return;
                    }
                    int streamType = 3;
                    String language = "";
                    String country = "";
                    String variant = "";
                    String speechRate = "";
                    String engine = "";
                    String pitch = "";
                    if (this.val$speechItem.mParams != null) {
                        for (int i = 0; i < this.val$speechItem.mParams.size() - 1; i += 2) {
                            String param = this.val$speechItem.mParams.get(i);
                            if (param == null) continue;
                            if (param.equals("rate")) {
                                speechRate = this.val$speechItem.mParams.get(i + 1);
                                continue;
                            }
                            if (param.equals("language")) {
                                language = this.val$speechItem.mParams.get(i + 1);
                                continue;
                            }
                            if (param.equals("country")) {
                                country = this.val$speechItem.mParams.get(i + 1);
                                continue;
                            }
                            if (param.equals("variant")) {
                                variant = this.val$speechItem.mParams.get(i + 1);
                                continue;
                            }
                            if (param.equals("utteranceId")) {
                                utteranceId = this.val$speechItem.mParams.get(i + 1);
                                continue;
                            }
                            if (param.equals("streamType")) {
                                try {
                                    streamType = Integer.parseInt(this.val$speechItem.mParams.get(i + 1));
                                }
                                catch (NumberFormatException e) {
                                    streamType = 3;
                                }
                                continue;
                            }
                            if (param.equals("engine")) {
                                engine = this.val$speechItem.mParams.get(i + 1);
                                continue;
                            }
                            if (!param.equals("pitch")) continue;
                            pitch = this.val$speechItem.mParams.get(i + 1);
                        }
                    }
                    if (TtsService.this.mKillList.get(this.val$speechItem) == null) {
                        if (engine.length() > 0) {
                            TtsService.this.setEngine(engine);
                        } else {
                            TtsService.this.setEngine(TtsService.this.getDefaultEngine());
                        }
                        if (language.length() > 0) {
                            TtsService.this.setLanguage("", language, country, variant);
                        } else {
                            TtsService.this.setLanguage("", TtsService.this.getDefaultLanguage(), TtsService.this.getDefaultCountry(), TtsService.this.getDefaultLocVariant());
                        }
                        if (speechRate.length() > 0) {
                            TtsService.this.setSpeechRate("", Integer.parseInt(speechRate));
                        } else {
                            TtsService.this.setSpeechRate("", TtsService.this.getDefaultRate());
                        }
                        if (pitch.length() > 0) {
                            TtsService.this.setPitch("", Integer.parseInt(pitch));
                        } else {
                            TtsService.this.setPitch("", TtsService.this.getDefaultPitch());
                        }
                        try {
                            sNativeSynth.speak(this.val$speechItem.mText, streamType);
                        }
                        catch (NullPointerException e) {
                            Log.v((String)TtsService.SERVICE_TAG, (String)" null synth, can't speak");
                        }
                    }
                }
                catch (InterruptedException e) {
                    Log.e((String)TtsService.SERVICE_TAG, (String)"TTS speakInternalOnly(): tryLock interrupted");
                    e.printStackTrace();
                }
                finally {
                    if (utteranceId.length() > 0) {
                        TtsService.this.dispatchUtteranceCompletedCallback(utteranceId, this.val$speechItem.mCallingApp);
                    }
                    if (synthAvailable) {
                        TtsService.this.synthesizerLock.unlock();
                        TtsService.this.processSpeechQueue();
                    }
                }
            }
        }
        Thread synth = new Thread(new SynthThread());
        synth.setPriority(10);
        synth.start();
    }

    private void synthToFileInternalOnly(SpeechItem speechItem) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class SynthThread
        implements Runnable {
            final /* synthetic */ SpeechItem val$speechItem;

            SynthThread() {
                this.val$speechItem = speechItem;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean synthAvailable = false;
                String utteranceId = "";
                Log.i((String)TtsService.SERVICE_TAG, (String)("Synthesizing to " + this.val$speechItem.mFilename));
                try {
                    synthAvailable = TtsService.this.synthesizerLock.tryLock();
                    if (!synthAvailable) {
                        SynthThread synthThread = this;
                        synchronized (synthThread) {
                            TtsService.this.mSynthBusy = true;
                        }
                        Thread.sleep(100L);
                        Thread synth = new Thread(new SynthThread());
                        synth.start();
                        SynthThread synthThread2 = this;
                        synchronized (synthThread2) {
                            TtsService.this.mSynthBusy = false;
                        }
                        return;
                    }
                    String language = "";
                    String country = "";
                    String variant = "";
                    String speechRate = "";
                    String engine = "";
                    String pitch = "";
                    if (this.val$speechItem.mParams != null) {
                        for (int i = 0; i < this.val$speechItem.mParams.size() - 1; i += 2) {
                            String param = this.val$speechItem.mParams.get(i);
                            if (param == null) continue;
                            if (param.equals("rate")) {
                                speechRate = this.val$speechItem.mParams.get(i + 1);
                                continue;
                            }
                            if (param.equals("language")) {
                                language = this.val$speechItem.mParams.get(i + 1);
                                continue;
                            }
                            if (param.equals("country")) {
                                country = this.val$speechItem.mParams.get(i + 1);
                                continue;
                            }
                            if (param.equals("variant")) {
                                variant = this.val$speechItem.mParams.get(i + 1);
                                continue;
                            }
                            if (param.equals("utteranceId")) {
                                utteranceId = this.val$speechItem.mParams.get(i + 1);
                                continue;
                            }
                            if (param.equals("engine")) {
                                engine = this.val$speechItem.mParams.get(i + 1);
                                continue;
                            }
                            if (!param.equals("pitch")) continue;
                            pitch = this.val$speechItem.mParams.get(i + 1);
                        }
                    }
                    if (TtsService.this.mKillList.get(this.val$speechItem) == null) {
                        if (engine.length() > 0) {
                            TtsService.this.setEngine(engine);
                        } else {
                            TtsService.this.setEngine(TtsService.this.getDefaultEngine());
                        }
                        if (language.length() > 0) {
                            TtsService.this.setLanguage("", language, country, variant);
                        } else {
                            TtsService.this.setLanguage("", TtsService.this.getDefaultLanguage(), TtsService.this.getDefaultCountry(), TtsService.this.getDefaultLocVariant());
                        }
                        if (speechRate.length() > 0) {
                            TtsService.this.setSpeechRate("", Integer.parseInt(speechRate));
                        } else {
                            TtsService.this.setSpeechRate("", TtsService.this.getDefaultRate());
                        }
                        if (pitch.length() > 0) {
                            TtsService.this.setPitch("", Integer.parseInt(pitch));
                        } else {
                            TtsService.this.setPitch("", TtsService.this.getDefaultPitch());
                        }
                        try {
                            sNativeSynth.synthesizeToFile(this.val$speechItem.mText, this.val$speechItem.mFilename);
                        }
                        catch (NullPointerException e) {
                            Log.v((String)TtsService.SERVICE_TAG, (String)" null synth, can't synthesize to file");
                        }
                    }
                }
                catch (InterruptedException e) {
                    Log.e((String)TtsService.SERVICE_TAG, (String)"TTS synthToFileInternalOnly(): tryLock interrupted");
                    e.printStackTrace();
                }
                finally {
                    if (utteranceId.length() > 0) {
                        TtsService.this.dispatchUtteranceCompletedCallback(utteranceId, this.val$speechItem.mCallingApp);
                    }
                    if (synthAvailable) {
                        TtsService.this.synthesizerLock.unlock();
                        TtsService.this.processSpeechQueue();
                    }
                }
            }
        }
        Thread synth = new Thread(new SynthThread());
        synth.setPriority(10);
        synth.start();
    }

    private SoundResource getSoundResource(SpeechItem speechItem) {
        SoundResource sr = null;
        String text = speechItem.mText;
        if (speechItem.mType != 2) {
            sr = speechItem.mType == 1 ? this.mEarcons.get(text) : this.mUtterances.get(text);
        }
        return sr;
    }

    private void broadcastTtsQueueProcessingCompleted() {
        Intent i = new Intent("android.speech.tts.TTS_QUEUE_PROCESSING_COMPLETED");
        this.sendBroadcast(i);
    }

    private void dispatchUtteranceCompletedCallback(String utteranceId, String packageName) {
        ITtsCallback cb = this.mCallbacksMap.get(packageName);
        if (cb == null) {
            return;
        }
        Log.v((String)SERVICE_TAG, (String)"TTS callback: dispatch started");
        int N = this.mCallbacks.beginBroadcast();
        try {
            cb.utteranceCompleted(utteranceId);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        this.mCallbacks.finishBroadcast();
        Log.v((String)SERVICE_TAG, (String)("TTS callback: dispatch completed to " + N));
    }

    private SpeechItem splitCurrentTextIfNeeded(SpeechItem currentSpeechItem) {
        SpeechItem splitItem;
        String splitText;
        if (currentSpeechItem.mText.length() < 4000) {
            return currentSpeechItem;
        }
        String callingApp = currentSpeechItem.mCallingApp;
        ArrayList<SpeechItem> splitItems = new ArrayList<SpeechItem>();
        int start = 0;
        int end = start + 4000 - 1;
        while (end < currentSpeechItem.mText.length()) {
            splitText = currentSpeechItem.mText.substring(start, end);
            splitItem = new SpeechItem(callingApp, splitText, null, 0);
            splitItems.add(splitItem);
            start = end;
            end = start + 4000 - 1;
        }
        splitText = currentSpeechItem.mText.substring(start);
        splitItem = new SpeechItem(callingApp, splitText, null, 0);
        splitItems.add(splitItem);
        this.mSpeechQueue.remove(0);
        for (int i = splitItems.size() - 1; i >= 0; --i) {
            this.mSpeechQueue.add(0, (SpeechItem)splitItems.get(i));
        }
        return this.mSpeechQueue.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSpeechQueue() {
        boolean speechQueueAvailable = false;
        TtsService ttsService = this;
        synchronized (ttsService) {
            if (this.mSynthBusy.booleanValue()) {
                return;
            }
        }
        try {
            speechQueueAvailable = this.speechQueueLock.tryLock(5000L, TimeUnit.MILLISECONDS);
            if (!speechQueueAvailable) {
                Log.e((String)SERVICE_TAG, (String)"processSpeechQueue - Speech queue is unavailable.");
                return;
            }
            if (this.mSpeechQueue.size() < 1) {
                this.mIsSpeaking = false;
                this.mKillList.clear();
                this.broadcastTtsQueueProcessingCompleted();
                return;
            }
            this.mCurrentSpeechItem = this.mSpeechQueue.get(0);
            this.mIsSpeaking = true;
            SoundResource sr = this.getSoundResource(this.mCurrentSpeechItem);
            Log.v((String)SERVICE_TAG, (String)("TTS processing: " + this.mCurrentSpeechItem.mText));
            if (sr == null) {
                if (this.mCurrentSpeechItem.mType == 0) {
                    this.mCurrentSpeechItem = this.splitCurrentTextIfNeeded(this.mCurrentSpeechItem);
                    this.speakInternalOnly(this.mCurrentSpeechItem);
                } else if (this.mCurrentSpeechItem.mType == 3) {
                    this.synthToFileInternalOnly(this.mCurrentSpeechItem);
                } else {
                    this.silence(this.mCurrentSpeechItem);
                }
            } else {
                this.cleanUpPlayer();
                if (sr.mSourcePackageName == PKGNAME) {
                    this.mPlayer = MediaPlayer.create((Context)this, (int)sr.mResId);
                } else if (sr.mSourcePackageName != null) {
                    Context ctx;
                    try {
                        ctx = this.createPackageContext(sr.mSourcePackageName, 0);
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        e.printStackTrace();
                        this.mSpeechQueue.remove(0);
                        this.mIsSpeaking = false;
                        if (speechQueueAvailable) {
                            this.speechQueueLock.unlock();
                        }
                        return;
                    }
                    this.mPlayer = MediaPlayer.create((Context)ctx, (int)sr.mResId);
                } else {
                    this.mPlayer = MediaPlayer.create((Context)this, (Uri)Uri.parse((String)sr.mFilename));
                }
                if (this.mPlayer == null) {
                    this.mSpeechQueue.clear();
                    this.mIsSpeaking = false;
                    return;
                }
                this.mPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
                try {
                    this.mPlayer.setAudioStreamType(this.getStreamTypeFromParams(this.mCurrentSpeechItem.mParams));
                    this.mPlayer.start();
                }
                catch (IllegalStateException e) {
                    this.mSpeechQueue.clear();
                    this.mIsSpeaking = false;
                    this.cleanUpPlayer();
                    if (speechQueueAvailable) {
                        this.speechQueueLock.unlock();
                    }
                    return;
                }
            }
            if (this.mSpeechQueue.size() > 0) {
                this.mSpeechQueue.remove(0);
            }
        }
        catch (InterruptedException e) {
            Log.e((String)SERVICE_TAG, (String)"TTS processSpeechQueue: tryLock interrupted");
            e.printStackTrace();
        }
        finally {
            if (speechQueueAvailable) {
                this.speechQueueLock.unlock();
            }
        }
    }

    private int getStreamTypeFromParams(ArrayList<String> paramList) {
        int streamType = 3;
        if (paramList == null) {
            return streamType;
        }
        for (int i = 0; i < paramList.size() - 1; i += 2) {
            String param = paramList.get(i);
            if (param == null || !param.equals("streamType")) continue;
            try {
                streamType = Integer.parseInt(paramList.get(i + 1));
                continue;
            }
            catch (NumberFormatException e) {
                streamType = 3;
            }
        }
        return streamType;
    }

    private void cleanUpPlayer() {
        if (this.mPlayer != null) {
            this.mPlayer.release();
            this.mPlayer = null;
        }
    }

    private boolean synthesizeToFile(String callingApp, String text, ArrayList<String> params, String filename) {
        if (filename.length() > 250) {
            return false;
        }
        if (text.length() >= 4000) {
            return false;
        }
        try {
            File tempFile = new File(filename);
            if (tempFile.exists()) {
                Log.v((String)SERVICE_TAG, (String)("File " + filename + " exists, deleting."));
                tempFile.delete();
            }
            if (!tempFile.createNewFile()) {
                Log.e((String)SERVICE_TAG, (String)("Unable to synthesize to file: can't create " + filename));
                return false;
            }
            tempFile.delete();
        }
        catch (IOException e) {
            Log.e((String)SERVICE_TAG, (String)("Can't create " + filename + " due to exception " + e));
            return false;
        }
        this.mSpeechQueue.add(new SpeechItem(callingApp, text, params, 3, filename));
        if (!this.mIsSpeaking.booleanValue()) {
            this.processSpeechQueue();
        }
        return true;
    }

    public IBinder onBind(Intent intent) {
        if (ACTION.equals(intent.getAction())) {
            for (String category : intent.getCategories()) {
                if (!category.equals(CATEGORY)) continue;
                return this.mBinder;
            }
        }
        return null;
    }

    private static class SoundResource {
        public String mSourcePackageName = null;
        public int mResId = -1;
        public String mFilename = null;

        public SoundResource(String packageName, int id) {
            this.mSourcePackageName = packageName;
            this.mResId = id;
            this.mFilename = null;
        }

        public SoundResource(String file) {
            this.mSourcePackageName = null;
            this.mResId = -1;
            this.mFilename = file;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SpeechItem {
        public static final int TEXT = 0;
        public static final int EARCON = 1;
        public static final int SILENCE = 2;
        public static final int TEXT_TO_FILE = 3;
        public String mText = "";
        public ArrayList<String> mParams = null;
        public int mType = 0;
        public long mDuration = 0L;
        public String mFilename = null;
        public String mCallingApp = "";

        public SpeechItem(String source, String text, ArrayList<String> params, int itemType) {
            this.mText = text;
            this.mParams = params;
            this.mType = itemType;
            this.mCallingApp = source;
        }

        public SpeechItem(String source, long silenceTime, ArrayList<String> params) {
            this.mDuration = silenceTime;
            this.mParams = params;
            this.mType = 2;
            this.mCallingApp = source;
        }

        public SpeechItem(String source, String text, ArrayList<String> params, int itemType, String filename) {
            this.mText = text;
            this.mParams = params;
            this.mType = itemType;
            this.mFilename = filename;
            this.mCallingApp = source;
        }
    }
}

