/*
 * Decompiled with CFR 0.152.
 */
package android.tts;

import android.media.AudioSystem;
import android.util.Log;
import java.lang.ref.WeakReference;

public class SynthProxy {
    private static final float PICO_FILTER_GAIN = 5.0f;
    private static final float PICO_FILTER_LOWSHELF_ATTENUATION = -18.0f;
    private static final float PICO_FILTER_TRANSITION_FREQ = 1100.0f;
    private static final float PICO_FILTER_SHELF_SLOPE = 1.0f;
    private static final String TAG = "SynthProxy";
    private int mJniData = 0;

    public SynthProxy(String nativeSoLib, String engineConfig) {
        boolean applyFilter = nativeSoLib.toLowerCase().contains("pico");
        Log.v((String)"TtsService", (String)("About to load " + nativeSoLib + ", applyFilter=" + applyFilter));
        this.native_setup(new WeakReference<SynthProxy>(this), nativeSoLib, engineConfig);
        this.native_setLowShelf(applyFilter, 5.0f, -18.0f, 1100.0f, 1.0f);
    }

    public int stop() {
        return this.native_stop(this.mJniData);
    }

    public int stopSync() {
        return this.native_stopSync(this.mJniData);
    }

    public int speak(String text, int streamType) {
        if (streamType > -1 && streamType < AudioSystem.getNumStreamTypes()) {
            return this.native_speak(this.mJniData, text, streamType);
        }
        Log.e((String)TAG, (String)("Trying to speak with invalid stream type " + streamType));
        return this.native_speak(this.mJniData, text, 3);
    }

    public int synthesizeToFile(String text, String filename) {
        return this.native_synthesizeToFile(this.mJniData, text, filename);
    }

    public int isLanguageAvailable(String language, String country, String variant) {
        return this.native_isLanguageAvailable(this.mJniData, language, country, variant);
    }

    public int setConfig(String engineConfig) {
        return this.native_setConfig(this.mJniData, engineConfig);
    }

    public int setLanguage(String language, String country, String variant) {
        return this.native_setLanguage(this.mJniData, language, country, variant);
    }

    public int loadLanguage(String language, String country, String variant) {
        return this.native_loadLanguage(this.mJniData, language, country, variant);
    }

    public final int setSpeechRate(int speechRate) {
        return this.native_setSpeechRate(this.mJniData, speechRate);
    }

    public final int setPitch(int pitch) {
        return this.native_setPitch(this.mJniData, pitch);
    }

    public String[] getLanguage() {
        return this.native_getLanguage(this.mJniData);
    }

    public int getRate() {
        return this.native_getRate(this.mJniData);
    }

    public void shutdown() {
        this.native_shutdown(this.mJniData);
    }

    protected void finalize() {
        this.native_finalize(this.mJniData);
        this.mJniData = 0;
    }

    private final native int native_setup(Object var1, String var2, String var3);

    private final native int native_setLowShelf(boolean var1, float var2, float var3, float var4, float var5);

    private final native void native_finalize(int var1);

    private final native int native_stop(int var1);

    private final native int native_stopSync(int var1);

    private final native int native_speak(int var1, String var2, int var3);

    private final native int native_synthesizeToFile(int var1, String var2, String var3);

    private final native int native_isLanguageAvailable(int var1, String var2, String var3, String var4);

    private final native int native_setLanguage(int var1, String var2, String var3, String var4);

    private final native int native_loadLanguage(int var1, String var2, String var3, String var4);

    private final native int native_setConfig(int var1, String var2);

    private final native int native_setSpeechRate(int var1, int var2);

    private final native int native_setPitch(int var1, int var2);

    private final native String[] native_getLanguage(int var1);

    private final native int native_getRate(int var1);

    private final native void native_shutdown(int var1);

    private static void postNativeSpeechSynthesizedInJava(Object tts_ref, int bufferPointer, int bufferSize) {
        Log.i((String)"TTS plugin debug", (String)("bufferPointer: " + bufferPointer + " bufferSize: " + bufferSize));
        SynthProxy nativeTTS = (SynthProxy)((WeakReference)tts_ref).get();
    }

    static {
        System.loadLibrary("ttssynthproxy");
    }
}

