/*
 * Decompiled with CFR 0.152.
 */
package com.android.providers.telephony;

import android.content.ContentProvider;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.UriMatcher;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.os.Environment;
import android.provider.Telephony;
import android.util.Log;
import android.util.Xml;
import com.android.internal.util.XmlUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class TelephonyProvider
extends ContentProvider {
    private static final String DATABASE_NAME = "telephony.db";
    private static final int DATABASE_VERSION = 393216;
    private static final int URL_TELEPHONY = 1;
    private static final int URL_CURRENT = 2;
    private static final int URL_ID = 3;
    private static final int URL_RESTOREAPN = 4;
    private static final int URL_PREFERAPN = 5;
    private static final String TAG = "TelephonyProvider";
    private static final String CARRIERS_TABLE = "carriers";
    private static final String PREF_FILE = "preferred-apn";
    private static final String COLUMN_APN_ID = "apn_id";
    private static final String PARTNER_APNS_PATH = "etc/apns-conf.xml";
    private static final UriMatcher s_urlMatcher = new UriMatcher(-1);
    private static final ContentValues s_currentNullMap;
    private static final ContentValues s_currentSetMap;
    private SQLiteOpenHelper mOpenHelper;

    public boolean onCreate() {
        this.mOpenHelper = new DatabaseHelper(this.getContext());
        return true;
    }

    private void setPreferredApnId(Long id) {
        SharedPreferences sp = this.getContext().getSharedPreferences(PREF_FILE, 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putLong(COLUMN_APN_ID, id != null ? id : -1L);
        editor.apply();
    }

    private long getPreferredApnId() {
        SharedPreferences sp = this.getContext().getSharedPreferences(PREF_FILE, 0);
        return sp.getLong(COLUMN_APN_ID, -1L);
    }

    public Cursor query(Uri url, String[] projectionIn, String selection, String[] selectionArgs, String sort) {
        SQLiteQueryBuilder qb = new SQLiteQueryBuilder();
        qb.setTables(CARRIERS_TABLE);
        int match = s_urlMatcher.match(url);
        switch (match) {
            case 1: {
                break;
            }
            case 2: {
                qb.appendWhere((CharSequence)"current IS NOT NULL");
                break;
            }
            case 3: {
                qb.appendWhere((CharSequence)("_id = " + (String)url.getPathSegments().get(1)));
                break;
            }
            case 5: {
                qb.appendWhere((CharSequence)("_id = " + this.getPreferredApnId()));
                break;
            }
            default: {
                return null;
            }
        }
        SQLiteDatabase db = this.mOpenHelper.getReadableDatabase();
        Cursor ret = qb.query(db, projectionIn, selection, selectionArgs, null, null, sort);
        ret.setNotificationUri(this.getContext().getContentResolver(), url);
        return ret;
    }

    public String getType(Uri url) {
        switch (s_urlMatcher.match(url)) {
            case 1: {
                return "vnd.android.cursor.dir/telephony-carrier";
            }
            case 3: {
                return "vnd.android.cursor.item/telephony-carrier";
            }
            case 5: {
                return "vnd.android.cursor.item/telephony-carrier";
            }
        }
        throw new IllegalArgumentException("Unknown URL " + url);
    }

    public Uri insert(Uri url, ContentValues initialValues) {
        Uri result = null;
        this.checkPermission();
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        int match = s_urlMatcher.match(url);
        boolean notify = false;
        switch (match) {
            case 1: {
                long rowID;
                ContentValues values = initialValues != null ? new ContentValues(initialValues) : new ContentValues();
                if (!values.containsKey("name")) {
                    values.put("name", "");
                }
                if (!values.containsKey("apn")) {
                    values.put("apn", "");
                }
                if (!values.containsKey("port")) {
                    values.put("port", "");
                }
                if (!values.containsKey("proxy")) {
                    values.put("proxy", "");
                }
                if (!values.containsKey("user")) {
                    values.put("user", "");
                }
                if (!values.containsKey("server")) {
                    values.put("server", "");
                }
                if (!values.containsKey("password")) {
                    values.put("password", "");
                }
                if (!values.containsKey("mmsport")) {
                    values.put("mmsport", "");
                }
                if (!values.containsKey("mmsproxy")) {
                    values.put("mmsproxy", "");
                }
                if (!values.containsKey("authtype")) {
                    values.put("authtype", Integer.valueOf(-1));
                }
                if (!values.containsKey("protocol")) {
                    values.put("protocol", "IP");
                }
                if (!values.containsKey("roaming_protocol")) {
                    values.put("roaming_protocol", "IP");
                }
                if ((rowID = db.insert(CARRIERS_TABLE, null, values)) > 0L) {
                    result = ContentUris.withAppendedId((Uri)Telephony.Carriers.CONTENT_URI, (long)rowID);
                    notify = true;
                }
                Log.d((String)TAG, (String)("inserted " + values.toString() + " rowID = " + rowID));
                break;
            }
            case 2: {
                db.update(CARRIERS_TABLE, s_currentNullMap, "current IS NOT NULL", null);
                String numeric = initialValues.getAsString("numeric");
                int updated = db.update(CARRIERS_TABLE, s_currentSetMap, "numeric = '" + numeric + "'", null);
                if (updated > 0) {
                    Log.d((String)TAG, (String)("Setting numeric '" + numeric + "' to be the current operator"));
                    break;
                }
                Log.e((String)TAG, (String)("Failed setting numeric '" + numeric + "' to the current operator"));
                break;
            }
            case 5: {
                if (initialValues == null || !initialValues.containsKey(COLUMN_APN_ID)) break;
                this.setPreferredApnId(initialValues.getAsLong(COLUMN_APN_ID));
            }
        }
        if (notify) {
            this.getContext().getContentResolver().notifyChange(Telephony.Carriers.CONTENT_URI, null);
        }
        return result;
    }

    public int delete(Uri url, String where, String[] whereArgs) {
        int count;
        this.checkPermission();
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        int match = s_urlMatcher.match(url);
        switch (match) {
            case 1: {
                count = db.delete(CARRIERS_TABLE, where, whereArgs);
                break;
            }
            case 2: {
                count = db.delete(CARRIERS_TABLE, where, whereArgs);
                break;
            }
            case 3: {
                count = db.delete(CARRIERS_TABLE, "_id=?", new String[]{url.getLastPathSegment()});
                break;
            }
            case 4: {
                count = 1;
                this.restoreDefaultAPN();
                break;
            }
            case 5: {
                this.setPreferredApnId(-1L);
                count = 1;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot delete that URL: " + url);
            }
        }
        if (count > 0) {
            this.getContext().getContentResolver().notifyChange(Telephony.Carriers.CONTENT_URI, null);
        }
        return count;
    }

    public int update(Uri url, ContentValues values, String where, String[] whereArgs) {
        int count = 0;
        this.checkPermission();
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        int match = s_urlMatcher.match(url);
        switch (match) {
            case 1: {
                count = db.update(CARRIERS_TABLE, values, where, whereArgs);
                break;
            }
            case 2: {
                count = db.update(CARRIERS_TABLE, values, where, whereArgs);
                break;
            }
            case 3: {
                if (where != null || whereArgs != null) {
                    throw new UnsupportedOperationException("Cannot update URL " + url + " with a where clause");
                }
                count = db.update(CARRIERS_TABLE, values, "_id=?", new String[]{url.getLastPathSegment()});
                break;
            }
            case 5: {
                if (values == null || !values.containsKey(COLUMN_APN_ID)) break;
                this.setPreferredApnId(values.getAsLong(COLUMN_APN_ID));
                count = 1;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot update that URL: " + url);
            }
        }
        if (count > 0) {
            this.getContext().getContentResolver().notifyChange(Telephony.Carriers.CONTENT_URI, null);
        }
        return count;
    }

    private void checkPermission() {
        this.getContext().enforceCallingOrSelfPermission("android.permission.WRITE_APN_SETTINGS", "No permission to write APN settings");
    }

    private void restoreDefaultAPN() {
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        db.delete(CARRIERS_TABLE, null, null);
        this.setPreferredApnId(-1L);
        ((DatabaseHelper)this.mOpenHelper).initDatabase(db);
    }

    static {
        s_urlMatcher.addURI("telephony", CARRIERS_TABLE, 1);
        s_urlMatcher.addURI("telephony", "carriers/current", 2);
        s_urlMatcher.addURI("telephony", "carriers/#", 3);
        s_urlMatcher.addURI("telephony", "carriers/restore", 4);
        s_urlMatcher.addURI("telephony", "carriers/preferapn", 5);
        s_currentNullMap = new ContentValues(1);
        s_currentNullMap.put("current", (Long)null);
        s_currentSetMap = new ContentValues(1);
        s_currentSetMap.put("current", "1");
    }

    private static class DatabaseHelper
    extends SQLiteOpenHelper {
        private Context mContext;

        public DatabaseHelper(Context context) {
            super(context, TelephonyProvider.DATABASE_NAME, null, DatabaseHelper.getVersion(context));
            this.mContext = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static int getVersion(Context context) {
            Resources r = context.getResources();
            XmlResourceParser parser = r.getXml(0x10B0000);
            try {
                XmlUtils.beginDocument((XmlPullParser)parser, (String)"apns");
                int publicversion = Integer.parseInt(parser.getAttributeValue(null, "version"));
                int n = 0x60000 | publicversion;
                return n;
            }
            catch (Exception e) {
                Log.e((String)TelephonyProvider.TAG, (String)"Can't get version of APN database", (Throwable)e);
                int n = 393216;
                return n;
            }
            finally {
                parser.close();
            }
        }

        public void onCreate(SQLiteDatabase db) {
            db.execSQL("CREATE TABLE carriers(_id INTEGER PRIMARY KEY,name TEXT,numeric TEXT,mcc TEXT,mnc TEXT,apn TEXT,user TEXT,server TEXT,password TEXT,proxy TEXT,port TEXT,mmsproxy TEXT,mmsport TEXT,mmsc TEXT,authtype INTEGER,type TEXT,current INTEGER,protocol TEXT,roaming_protocol TEXT);");
            this.initDatabase(db);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initDatabase(SQLiteDatabase db) {
            Resources r = this.mContext.getResources();
            XmlResourceParser parser = r.getXml(0x10B0000);
            int publicversion = -1;
            try {
                XmlUtils.beginDocument((XmlPullParser)parser, (String)"apns");
                publicversion = Integer.parseInt(parser.getAttributeValue(null, "version"));
                this.loadApns(db, (XmlPullParser)parser);
            }
            catch (Exception e) {
                Log.e((String)TelephonyProvider.TAG, (String)"Got exception while loading APN database.", (Throwable)e);
            }
            finally {
                parser.close();
            }
            XmlPullParser confparser = null;
            File confFile = new File(Environment.getRootDirectory(), TelephonyProvider.PARTNER_APNS_PATH);
            FileReader confreader = null;
            try {
                confreader = new FileReader(confFile);
                confparser = Xml.newPullParser();
                confparser.setInput((Reader)confreader);
                XmlUtils.beginDocument((XmlPullParser)confparser, (String)"apns");
                int confversion = Integer.parseInt(confparser.getAttributeValue(null, "version"));
                if (publicversion != confversion) {
                    throw new IllegalStateException("Internal APNS file version doesn't match " + confFile.getAbsolutePath());
                }
                this.loadApns(db, confparser);
            }
            catch (FileNotFoundException e) {
            }
            catch (Exception e) {
                Log.e((String)TelephonyProvider.TAG, (String)("Exception while parsing '" + confFile.getAbsolutePath() + "'"), (Throwable)e);
            }
            finally {
                try {
                    if (confreader != null) {
                        confreader.close();
                    }
                }
                catch (IOException e) {}
            }
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            if (oldVersion < 327686) {
                db.execSQL("ALTER TABLE carriers ADD COLUMN authtype INTEGER DEFAULT -1;");
                oldVersion = 327686;
            }
            if (oldVersion < 393222) {
                db.execSQL("ALTER TABLE carriers ADD COLUMN protocol TEXT DEFAULT IP;");
                db.execSQL("ALTER TABLE carriers ADD COLUMN roaming_protocol TEXT DEFAULT IP;");
                oldVersion = 393222;
            }
        }

        private ContentValues getRow(XmlPullParser parser) {
            String roamingProtocol;
            String protocol;
            String auth;
            String mmsport;
            String mmsproxy;
            String port;
            if (!"apn".equals(parser.getName())) {
                return null;
            }
            ContentValues map = new ContentValues();
            String mcc = parser.getAttributeValue(null, "mcc");
            String mnc = parser.getAttributeValue(null, "mnc");
            String numeric = mcc + mnc;
            map.put("numeric", numeric);
            map.put("mcc", mcc);
            map.put("mnc", mnc);
            map.put("name", parser.getAttributeValue(null, "carrier"));
            map.put("apn", parser.getAttributeValue(null, "apn"));
            map.put("user", parser.getAttributeValue(null, "user"));
            map.put("server", parser.getAttributeValue(null, "server"));
            map.put("password", parser.getAttributeValue(null, "password"));
            String proxy = parser.getAttributeValue(null, "proxy");
            if (proxy != null) {
                map.put("proxy", proxy);
            }
            if ((port = parser.getAttributeValue(null, "port")) != null) {
                map.put("port", port);
            }
            if ((mmsproxy = parser.getAttributeValue(null, "mmsproxy")) != null) {
                map.put("mmsproxy", mmsproxy);
            }
            if ((mmsport = parser.getAttributeValue(null, "mmsport")) != null) {
                map.put("mmsport", mmsport);
            }
            map.put("mmsc", parser.getAttributeValue(null, "mmsc"));
            String type = parser.getAttributeValue(null, "type");
            if (type != null) {
                map.put("type", type);
            }
            if ((auth = parser.getAttributeValue(null, "authtype")) != null) {
                map.put("authtype", Integer.valueOf(Integer.parseInt(auth)));
            }
            if ((protocol = parser.getAttributeValue(null, "protocol")) != null) {
                map.put("protocol", protocol);
            }
            if ((roamingProtocol = parser.getAttributeValue(null, "roaming_protocol")) != null) {
                map.put("roaming_protocol", roamingProtocol);
            }
            return map;
        }

        private void loadApns(SQLiteDatabase db, XmlPullParser parser) {
            if (parser != null) {
                try {
                    while (true) {
                        XmlUtils.nextElement((XmlPullParser)parser);
                        ContentValues row = this.getRow(parser);
                        if (row != null) {
                            this.insertAddingDefaults(db, TelephonyProvider.CARRIERS_TABLE, row);
                            continue;
                        }
                        break;
                    }
                }
                catch (XmlPullParserException e) {
                    Log.e((String)TelephonyProvider.TAG, (String)"Got execption while getting perferred time zone.", (Throwable)e);
                }
                catch (IOException e) {
                    Log.e((String)TelephonyProvider.TAG, (String)"Got execption while getting perferred time zone.", (Throwable)e);
                }
            }
        }

        private void insertAddingDefaults(SQLiteDatabase db, String table, ContentValues row) {
            if (!row.containsKey("authtype")) {
                row.put("authtype", Integer.valueOf(-1));
            }
            if (!row.containsKey("protocol")) {
                row.put("protocol", "IP");
            }
            if (!row.containsKey("roaming_protocol")) {
                row.put("roaming_protocol", "IP");
            }
            db.insert(TelephonyProvider.CARRIERS_TABLE, null, row);
        }
    }
}

