/*
 * Decompiled with CFR 0.152.
 */
package com.android.providers.telephony;

import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.provider.Contacts;
import android.provider.Telephony;
import android.telephony.SmsManager;
import android.telephony.SmsMessage;
import android.text.TextUtils;
import android.util.Log;
import com.android.common.ArrayListCursor;
import com.android.providers.telephony.MmsSmsDatabaseHelper;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmsProvider
extends ContentProvider {
    private static final Uri NOTIFICATION_URI = Uri.parse((String)"content://sms");
    private static final Uri ICC_URI = Uri.parse((String)"content://sms/icc");
    static final String TABLE_SMS = "sms";
    private static final String TABLE_RAW = "raw";
    private static final String TABLE_SR_PENDING = "sr_pending";
    private static final String TABLE_WORDS = "words";
    private static final Integer ONE = 1;
    private static final String[] CONTACT_QUERY_PROJECTION = new String[]{"person"};
    private static final int PERSON_ID_COLUMN = 0;
    private static final String[] ICC_COLUMNS = new String[]{"service_center_address", "address", "message_class", "body", "date", "status", "index_on_icc", "is_status_report", "transport_type", "type", "locked", "error_code"};
    private SQLiteOpenHelper mOpenHelper;
    private static final String TAG = "SmsProvider";
    private static final String VND_ANDROID_SMS = "vnd.android.cursor.item/sms";
    private static final String VND_ANDROID_SMSCHAT = "vnd.android.cursor.item/sms-chat";
    private static final String VND_ANDROID_DIR_SMS = "vnd.android.cursor.dir/sms";
    private static final HashMap<String, String> sConversationProjectionMap = new HashMap();
    private static final String[] sIDProjection = new String[]{"_id"};
    private static final int SMS_ALL = 0;
    private static final int SMS_ALL_ID = 1;
    private static final int SMS_INBOX = 2;
    private static final int SMS_INBOX_ID = 3;
    private static final int SMS_SENT = 4;
    private static final int SMS_SENT_ID = 5;
    private static final int SMS_DRAFT = 6;
    private static final int SMS_DRAFT_ID = 7;
    private static final int SMS_OUTBOX = 8;
    private static final int SMS_OUTBOX_ID = 9;
    private static final int SMS_CONVERSATIONS = 10;
    private static final int SMS_CONVERSATIONS_ID = 11;
    private static final int SMS_RAW_MESSAGE = 15;
    private static final int SMS_ATTACHMENT = 16;
    private static final int SMS_ATTACHMENT_ID = 17;
    private static final int SMS_NEW_THREAD_ID = 18;
    private static final int SMS_QUERY_THREAD_ID = 19;
    private static final int SMS_STATUS_ID = 20;
    private static final int SMS_STATUS_PENDING = 21;
    private static final int SMS_ALL_ICC = 22;
    private static final int SMS_ICC = 23;
    private static final int SMS_FAILED = 24;
    private static final int SMS_FAILED_ID = 25;
    private static final int SMS_QUEUED = 26;
    private static final int SMS_UNDELIVERED = 27;
    private static final UriMatcher sURLMatcher = new UriMatcher(-1);

    public boolean onCreate() {
        this.mOpenHelper = MmsSmsDatabaseHelper.getInstance(this.getContext());
        return true;
    }

    public Cursor query(Uri url, String[] projectionIn, String selection, String[] selectionArgs, String sort) {
        SQLiteQueryBuilder qb = new SQLiteQueryBuilder();
        int match = sURLMatcher.match(url);
        switch (match) {
            case 0: {
                this.constructQueryForBox(qb, 0);
                break;
            }
            case 27: {
                this.constructQueryForUndelivered(qb);
                break;
            }
            case 24: {
                this.constructQueryForBox(qb, 5);
                break;
            }
            case 26: {
                this.constructQueryForBox(qb, 6);
                break;
            }
            case 2: {
                this.constructQueryForBox(qb, 1);
                break;
            }
            case 4: {
                this.constructQueryForBox(qb, 2);
                break;
            }
            case 6: {
                this.constructQueryForBox(qb, 3);
                break;
            }
            case 8: {
                this.constructQueryForBox(qb, 4);
                break;
            }
            case 1: {
                qb.setTables(TABLE_SMS);
                qb.appendWhere((CharSequence)("(_id = " + (String)url.getPathSegments().get(0) + ")"));
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 25: {
                qb.setTables(TABLE_SMS);
                qb.appendWhere((CharSequence)("(_id = " + (String)url.getPathSegments().get(1) + ")"));
                break;
            }
            case 11: {
                int threadID;
                try {
                    threadID = Integer.parseInt((String)url.getPathSegments().get(1));
                    if (Log.isLoggable((String)TAG, (int)2)) {
                        Log.d((String)TAG, (String)("query conversations: threadID=" + threadID));
                    }
                }
                catch (Exception ex) {
                    Log.e((String)TAG, (String)("Bad conversation thread id: " + (String)url.getPathSegments().get(1)));
                    return null;
                }
                qb.setTables(TABLE_SMS);
                qb.appendWhere((CharSequence)("thread_id = " + threadID));
                break;
            }
            case 10: {
                qb.setTables("sms, (SELECT thread_id AS group_thread_id, MAX(date)AS group_date,COUNT(*) AS msg_count FROM sms GROUP BY thread_id) AS groups");
                qb.appendWhere((CharSequence)"sms.thread_id = groups.group_thread_id AND sms.date =groups.group_date");
                qb.setProjectionMap(sConversationProjectionMap);
                break;
            }
            case 15: {
                qb.setTables(TABLE_RAW);
                break;
            }
            case 21: {
                qb.setTables(TABLE_SR_PENDING);
                break;
            }
            case 16: {
                qb.setTables("attachments");
                break;
            }
            case 17: {
                qb.setTables("attachments");
                qb.appendWhere((CharSequence)("(sms_id = " + (String)url.getPathSegments().get(1) + ")"));
                break;
            }
            case 19: {
                qb.setTables("canonical_addresses");
                if (projectionIn != null) break;
                projectionIn = sIDProjection;
                break;
            }
            case 20: {
                qb.setTables(TABLE_SMS);
                qb.appendWhere((CharSequence)("(_id = " + (String)url.getPathSegments().get(1) + ")"));
                break;
            }
            case 22: {
                return this.getAllMessagesFromIcc();
            }
            case 23: {
                String messageIndexString = (String)url.getPathSegments().get(1);
                return this.getSingleMessageFromIcc(messageIndexString);
            }
            default: {
                Log.e((String)TAG, (String)("Invalid request: " + url));
                return null;
            }
        }
        String orderBy = null;
        if (!TextUtils.isEmpty((CharSequence)sort)) {
            orderBy = sort;
        } else if (qb.getTables().equals(TABLE_SMS)) {
            orderBy = "date DESC";
        }
        SQLiteDatabase db = this.mOpenHelper.getReadableDatabase();
        Cursor ret = qb.query(db, projectionIn, selection, selectionArgs, null, null, orderBy);
        ret.setNotificationUri(this.getContext().getContentResolver(), NOTIFICATION_URI);
        return ret;
    }

    private ArrayList<String> convertIccToSms(SmsMessage message) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(message.getServiceCenterAddress());
        result.add(message.getDisplayOriginatingAddress());
        result.add(String.valueOf(message.getMessageClass()));
        result.add(message.getDisplayMessageBody());
        result.add((String)((Object)Long.valueOf(message.getTimestampMillis())));
        result.add((String)((Object)Integer.valueOf(-1)));
        result.add((String)((Object)Integer.valueOf(message.getIndexOnIcc())));
        result.add((String)((Object)Boolean.valueOf(message.isStatusReportMessage())));
        result.add(TABLE_SMS);
        result.add((String)((Object)Integer.valueOf(0)));
        result.add((String)((Object)Integer.valueOf(0)));
        result.add((String)((Object)Integer.valueOf(0)));
        return result;
    }

    private Cursor getSingleMessageFromIcc(String messageIndexString) {
        try {
            int messageIndex = Integer.parseInt(messageIndexString);
            SmsManager smsManager = SmsManager.getDefault();
            ArrayList messages = smsManager.getAllMessagesFromIcc();
            ArrayList<ArrayList> singleRow = new ArrayList<ArrayList>();
            SmsMessage message = (SmsMessage)messages.get(messageIndex);
            if (message == null) {
                throw new IllegalArgumentException("Message not retrieved. ID: " + messageIndexString);
            }
            singleRow.add(this.convertIccToSms(message));
            return this.withIccNotificationUri((Cursor)new ArrayListCursor(ICC_COLUMNS, singleRow));
        }
        catch (NumberFormatException exception) {
            throw new IllegalArgumentException("Bad SMS ICC ID: " + messageIndexString);
        }
    }

    private Cursor getAllMessagesFromIcc() {
        SmsManager smsManager = SmsManager.getDefault();
        ArrayList messages = smsManager.getAllMessagesFromIcc();
        ArrayList<ArrayList> rows = new ArrayList<ArrayList>();
        int count = messages.size();
        for (int i = 0; i < count; ++i) {
            SmsMessage message = (SmsMessage)messages.get(i);
            if (message == null) continue;
            rows.add(this.convertIccToSms(message));
        }
        return this.withIccNotificationUri((Cursor)new ArrayListCursor(ICC_COLUMNS, rows));
    }

    private Cursor withIccNotificationUri(Cursor cursor) {
        cursor.setNotificationUri(this.getContext().getContentResolver(), ICC_URI);
        return cursor;
    }

    private void constructQueryForBox(SQLiteQueryBuilder qb, int type) {
        qb.setTables(TABLE_SMS);
        if (type != 0) {
            qb.appendWhere((CharSequence)("type=" + type));
        }
    }

    private void constructQueryForUndelivered(SQLiteQueryBuilder qb) {
        qb.setTables(TABLE_SMS);
        qb.appendWhere((CharSequence)"(type=4 OR type=5 OR type=6)");
    }

    public String getType(Uri url) {
        switch (url.getPathSegments().size()) {
            case 0: {
                return VND_ANDROID_DIR_SMS;
            }
            case 1: {
                try {
                    Integer.parseInt((String)url.getPathSegments().get(0));
                    return VND_ANDROID_SMS;
                }
                catch (NumberFormatException ex) {
                    return VND_ANDROID_DIR_SMS;
                }
            }
            case 2: {
                if (((String)url.getPathSegments().get(0)).equals("conversations")) {
                    return VND_ANDROID_SMSCHAT;
                }
                return VND_ANDROID_SMS;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Uri insert(Uri url, ContentValues initialValues) {
        type = 0;
        match = SmsProvider.sURLMatcher.match(url);
        table = "sms";
        switch (match) {
            case 0: {
                typeObj = initialValues.getAsInteger("type");
                if (typeObj != null) {
                    type = typeObj;
                    break;
                }
                type = 1;
                break;
            }
            case 2: {
                type = 1;
                break;
            }
            case 24: {
                type = 5;
                break;
            }
            case 26: {
                type = 6;
                break;
            }
            case 4: {
                type = 2;
                break;
            }
            case 6: {
                type = 3;
                break;
            }
            case 8: {
                type = 4;
                break;
            }
            case 15: {
                table = "raw";
                break;
            }
            case 21: {
                table = "sr_pending";
                break;
            }
            case 16: {
                table = "attachments";
                break;
            }
            case 18: {
                table = "canonical_addresses";
                break;
            }
            default: {
                Log.e((String)"SmsProvider", (String)("Invalid request: " + url));
                return null;
            }
        }
        db = this.mOpenHelper.getWritableDatabase();
        if (table.equals("sms")) {
            addDate = false;
            addType = false;
            if (initialValues == null) {
                values = new ContentValues(1);
                addDate = true;
                addType = true;
            } else {
                values = new ContentValues(initialValues);
                if (!initialValues.containsKey("date")) {
                    addDate = true;
                }
                if (!initialValues.containsKey("type")) {
                    addType = true;
                }
            }
            if (addDate) {
                values.put("date", new Long(System.currentTimeMillis()));
            }
            if (addType && type != 0) {
                values.put("type", Integer.valueOf(type));
            }
            threadId = values.getAsLong("thread_id");
            address = values.getAsString("address");
            if ((threadId == null || threadId == 0L) && address != null) {
                values.put("thread_id", Long.valueOf(Telephony.Threads.getOrCreateThreadId((Context)this.getContext(), (String)address)));
            }
            if (values.getAsInteger("type") == 3) {
                db.delete("sms", "thread_id=? AND type=?", new String[]{values.getAsString("thread_id"), Integer.toString(3)});
            }
            if (type == 1) {
                if (values.getAsLong("person") == null && !TextUtils.isEmpty((CharSequence)address)) {
                    cursor = null;
                    uri = Uri.withAppendedPath((Uri)Contacts.Phones.CONTENT_FILTER_URL, (String)Uri.encode((String)address));
                    try {
                        cursor = this.getContext().getContentResolver().query(uri, SmsProvider.CONTACT_QUERY_PROJECTION, null, null, null);
                        if (!cursor.moveToFirst()) ** GOTO lbl93
                        id = cursor.getLong(0);
                        values.put("person", id);
                    }
                    catch (Exception ex) {
                        Log.e((String)"SmsProvider", (String)("insert: query contact uri " + uri + " caught "), (Throwable)ex);
                    }
                    finally {
                        if (cursor != null) {
                            cursor.close();
                        }
                    }
                }
            } else {
                values.put("read", SmsProvider.ONE);
            }
        } else {
            values = initialValues == null ? new ContentValues(1) : initialValues;
        }
lbl93:
        // 6 sources

        rowID = db.insert(table, "body", values);
        if (table == "sms") {
            cv = new ContentValues();
            cv.put("_id", Long.valueOf(rowID));
            cv.put("index_text", values.getAsString("body"));
            cv.put("source_id", Long.valueOf(rowID));
            cv.put("table_to_use", Integer.valueOf(1));
            db.insert("words", "index_text", cv);
        }
        if (rowID > 0L) {
            uri = Uri.parse((String)("content://" + table + "/" + rowID));
            if (Log.isLoggable((String)"SmsProvider", (int)2)) {
                Log.d((String)"SmsProvider", (String)("insert " + uri + " succeeded"));
            }
            this.notifyChange(uri);
            return uri;
        }
        Log.e((String)"SmsProvider", (String)("insert: failed! " + values.toString()));
        return null;
    }

    public int delete(Uri url, String where, String[] whereArgs) {
        int count;
        int match = sURLMatcher.match(url);
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        switch (match) {
            case 0: {
                count = db.delete(TABLE_SMS, where, whereArgs);
                if (count == 0) break;
                MmsSmsDatabaseHelper.updateAllThreads(db, where, whereArgs);
                break;
            }
            case 1: {
                try {
                    int message_id = Integer.parseInt((String)url.getPathSegments().get(0));
                    count = MmsSmsDatabaseHelper.deleteOneSms(db, message_id);
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Bad message id: " + (String)url.getPathSegments().get(0));
                }
            }
            case 11: {
                int threadID;
                try {
                    threadID = Integer.parseInt((String)url.getPathSegments().get(1));
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Bad conversation thread id: " + (String)url.getPathSegments().get(1));
                }
                where = DatabaseUtils.concatenateWhere((String)("thread_id=" + threadID), (String)where);
                count = db.delete(TABLE_SMS, where, whereArgs);
                MmsSmsDatabaseHelper.updateThread(db, threadID);
                break;
            }
            case 15: {
                count = db.delete(TABLE_RAW, where, whereArgs);
                break;
            }
            case 21: {
                count = db.delete(TABLE_SR_PENDING, where, whereArgs);
                break;
            }
            case 23: {
                String messageIndexString = (String)url.getPathSegments().get(1);
                return this.deleteMessageFromIcc(messageIndexString);
            }
            default: {
                throw new IllegalArgumentException("Unknown URL");
            }
        }
        if (count > 0) {
            this.notifyChange(url);
        }
        return count;
    }

    private int deleteMessageFromIcc(String messageIndexString) {
        SmsManager smsManager = SmsManager.getDefault();
        try {
            int n = smsManager.deleteMessageFromIcc(Integer.parseInt(messageIndexString)) ? 1 : 0;
            return n;
        }
        catch (NumberFormatException exception) {
            throw new IllegalArgumentException("Bad SMS ICC ID: " + messageIndexString);
        }
        finally {
            ContentResolver cr = this.getContext().getContentResolver();
            cr.notifyChange(ICC_URI, null);
        }
    }

    public int update(Uri url, ContentValues values, String where, String[] whereArgs) {
        int count = 0;
        String table = TABLE_SMS;
        String extraWhere = null;
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        switch (sURLMatcher.match(url)) {
            case 15: {
                table = TABLE_RAW;
                break;
            }
            case 21: {
                table = TABLE_SR_PENDING;
                break;
            }
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 24: 
            case 26: {
                break;
            }
            case 1: {
                extraWhere = "_id=" + (String)url.getPathSegments().get(0);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 25: {
                extraWhere = "_id=" + (String)url.getPathSegments().get(1);
                break;
            }
            case 11: {
                String threadId = (String)url.getPathSegments().get(1);
                try {
                    Integer.parseInt(threadId);
                }
                catch (Exception ex) {
                    Log.e((String)TAG, (String)("Bad conversation thread id: " + threadId));
                    break;
                }
                extraWhere = "thread_id=" + threadId;
                break;
            }
            case 20: {
                extraWhere = "_id=" + (String)url.getPathSegments().get(1);
                break;
            }
            default: {
                throw new UnsupportedOperationException("URI " + url + " not supported");
            }
        }
        where = DatabaseUtils.concatenateWhere((String)where, extraWhere);
        count = db.update(table, values, where, whereArgs);
        if (count > 0) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.d((String)TAG, (String)("update " + url + " succeeded"));
            }
            this.notifyChange(url);
        }
        return count;
    }

    private void notifyChange(Uri uri) {
        ContentResolver cr = this.getContext().getContentResolver();
        cr.notifyChange(uri, null);
        cr.notifyChange(Telephony.MmsSms.CONTENT_URI, null);
        cr.notifyChange(Uri.parse((String)"content://mms-sms/conversations/"), null);
    }

    static {
        sURLMatcher.addURI(TABLE_SMS, null, 0);
        sURLMatcher.addURI(TABLE_SMS, "#", 1);
        sURLMatcher.addURI(TABLE_SMS, "inbox", 2);
        sURLMatcher.addURI(TABLE_SMS, "inbox/#", 3);
        sURLMatcher.addURI(TABLE_SMS, "sent", 4);
        sURLMatcher.addURI(TABLE_SMS, "sent/#", 5);
        sURLMatcher.addURI(TABLE_SMS, "draft", 6);
        sURLMatcher.addURI(TABLE_SMS, "draft/#", 7);
        sURLMatcher.addURI(TABLE_SMS, "outbox", 8);
        sURLMatcher.addURI(TABLE_SMS, "outbox/#", 9);
        sURLMatcher.addURI(TABLE_SMS, "undelivered", 27);
        sURLMatcher.addURI(TABLE_SMS, "failed", 24);
        sURLMatcher.addURI(TABLE_SMS, "failed/#", 25);
        sURLMatcher.addURI(TABLE_SMS, "queued", 26);
        sURLMatcher.addURI(TABLE_SMS, "conversations", 10);
        sURLMatcher.addURI(TABLE_SMS, "conversations/*", 11);
        sURLMatcher.addURI(TABLE_SMS, TABLE_RAW, 15);
        sURLMatcher.addURI(TABLE_SMS, "attachments", 16);
        sURLMatcher.addURI(TABLE_SMS, "attachments/#", 17);
        sURLMatcher.addURI(TABLE_SMS, "threadID", 18);
        sURLMatcher.addURI(TABLE_SMS, "threadID/*", 19);
        sURLMatcher.addURI(TABLE_SMS, "status/#", 20);
        sURLMatcher.addURI(TABLE_SMS, TABLE_SR_PENDING, 21);
        sURLMatcher.addURI(TABLE_SMS, "icc", 22);
        sURLMatcher.addURI(TABLE_SMS, "icc/#", 23);
        sURLMatcher.addURI(TABLE_SMS, "sim", 22);
        sURLMatcher.addURI(TABLE_SMS, "sim/#", 23);
        sConversationProjectionMap.put("snippet", "sms.body AS snippet");
        sConversationProjectionMap.put("thread_id", "sms.thread_id AS thread_id");
        sConversationProjectionMap.put("msg_count", "groups.msg_count AS msg_count");
        sConversationProjectionMap.put("delta", null);
    }
}

