/*
 * Decompiled with CFR 0.152.
 */
package com.android.providers.telephony;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.provider.Telephony;
import android.text.TextUtils;
import android.util.Log;
import com.android.providers.telephony.MmsProvider;
import com.android.providers.telephony.MmsSmsDatabaseHelper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MmsSmsProvider
extends ContentProvider {
    private static final UriMatcher URI_MATCHER = new UriMatcher(-1);
    private static final String LOG_TAG = "MmsSmsProvider";
    private static final boolean DEBUG = false;
    private static final String NO_DELETES_INSERTS_OR_UPDATES = "MmsSmsProvider does not support deletes, inserts, or updates for this URI.";
    private static final int URI_CONVERSATIONS = 0;
    private static final int URI_CONVERSATIONS_MESSAGES = 1;
    private static final int URI_CONVERSATIONS_RECIPIENTS = 2;
    private static final int URI_MESSAGES_BY_PHONE = 3;
    private static final int URI_THREAD_ID = 4;
    private static final int URI_CANONICAL_ADDRESS = 5;
    private static final int URI_PENDING_MSG = 6;
    private static final int URI_COMPLETE_CONVERSATIONS = 7;
    private static final int URI_UNDELIVERED_MSG = 8;
    private static final int URI_CONVERSATIONS_SUBJECT = 9;
    private static final int URI_NOTIFICATIONS = 10;
    private static final int URI_OBSOLETE_THREADS = 11;
    private static final int URI_DRAFT = 12;
    private static final int URI_CANONICAL_ADDRESSES = 13;
    private static final int URI_SEARCH = 14;
    private static final int URI_SEARCH_SUGGEST = 15;
    private static final int URI_FIRST_LOCKED_MESSAGE_ALL = 16;
    private static final int URI_FIRST_LOCKED_MESSAGE_BY_THREAD_ID = 17;
    public static final String TABLE_PENDING_MSG = "pending_msgs";
    private static final String TABLE_CANONICAL_ADDRESSES = "canonical_addresses";
    private static final String[] MMS_SMS_COLUMNS = new String[]{"_id", "date", "read", "thread_id", "locked"};
    private static final String[] MMS_ONLY_COLUMNS = new String[]{"ct_cls", "ct_l", "ct_t", "d_rpt", "exp", "m_cls", "m_id", "m_size", "m_type", "msg_box", "pri", "read_status", "resp_st", "resp_txt", "retr_st", "retr_txt_cs", "rpt_a", "rr", "st", "sub", "sub_cs", "tr_id", "v"};
    private static final String[] SMS_ONLY_COLUMNS = new String[]{"address", "body", "person", "reply_path_present", "service_center", "status", "subject", "type", "error_code"};
    private static final String[] THREADS_COLUMNS = new String[]{"_id", "date", "recipient_ids", "message_count"};
    private static final String[] CANONICAL_ADDRESSES_COLUMNS_1 = new String[]{"address"};
    private static final String[] CANONICAL_ADDRESSES_COLUMNS_2 = new String[]{"_id", "address"};
    private static final String[] UNION_COLUMNS = new String[MMS_SMS_COLUMNS.length + MMS_ONLY_COLUMNS.length + SMS_ONLY_COLUMNS.length];
    private static final Set<String> MMS_COLUMNS = new HashSet<String>();
    private static final Set<String> SMS_COLUMNS = new HashSet<String>();
    private static final String VND_ANDROID_DIR_MMS_SMS = "vnd.android-dir/mms-sms";
    private static final String[] ID_PROJECTION = new String[]{"_id"};
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String SMS_CONVERSATION_CONSTRAINT = "(type != 3)";
    private static final String MMS_CONVERSATION_CONSTRAINT = "(msg_box != 3 AND (m_type = 128 OR m_type = 132 OR m_type = 130))";
    private static final String AUTHORITY = "mms-sms";
    private SQLiteOpenHelper mOpenHelper;
    private boolean mUseStrictPhoneNumberComparation;
    private static final String THREAD_QUERY = "SELECT _id FROM threads WHERE recipient_ids=?";

    public boolean onCreate() {
        this.mOpenHelper = MmsSmsDatabaseHelper.getInstance(this.getContext());
        this.mUseStrictPhoneNumberComparation = this.getContext().getResources().getBoolean(17629196);
        return true;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        SQLiteDatabase db = this.mOpenHelper.getReadableDatabase();
        Cursor cursor = null;
        switch (URI_MATCHER.match(uri)) {
            case 7: {
                cursor = this.getCompleteConversations(projection, selection, selectionArgs, sortOrder);
                break;
            }
            case 0: {
                String simple = uri.getQueryParameter("simple");
                if (simple != null && simple.equals("true")) {
                    String threadType = uri.getQueryParameter("thread_type");
                    if (!TextUtils.isEmpty((CharSequence)threadType)) {
                        selection = MmsSmsProvider.concatSelections(selection, "type=" + threadType);
                    }
                    cursor = this.getSimpleConversations(projection, selection, selectionArgs, sortOrder);
                    break;
                }
                cursor = this.getConversations(projection, selection, selectionArgs, sortOrder);
                break;
            }
            case 1: {
                cursor = this.getConversationMessages((String)uri.getPathSegments().get(1), projection, selection, selectionArgs, sortOrder);
                break;
            }
            case 2: {
                cursor = this.getConversationById((String)uri.getPathSegments().get(1), projection, selection, selectionArgs, sortOrder);
                break;
            }
            case 9: {
                cursor = this.getConversationById((String)uri.getPathSegments().get(1), projection, selection, selectionArgs, sortOrder);
                break;
            }
            case 3: {
                cursor = this.getMessagesByPhoneNumber((String)uri.getPathSegments().get(2), projection, selection, selectionArgs, sortOrder);
                break;
            }
            case 4: {
                List recipients = uri.getQueryParameters("recipient");
                cursor = this.getThreadId(recipients);
                break;
            }
            case 5: {
                String extraSelection = "_id=" + (String)uri.getPathSegments().get(1);
                String finalSelection = TextUtils.isEmpty((CharSequence)selection) ? extraSelection : extraSelection + " AND " + selection;
                cursor = db.query(TABLE_CANONICAL_ADDRESSES, CANONICAL_ADDRESSES_COLUMNS_1, finalSelection, selectionArgs, null, null, sortOrder);
                break;
            }
            case 13: {
                cursor = db.query(TABLE_CANONICAL_ADDRESSES, CANONICAL_ADDRESSES_COLUMNS_2, selection, selectionArgs, null, null, sortOrder);
                break;
            }
            case 15: {
                String searchString = uri.getQueryParameter("pattern");
                String query = String.format("SELECT _id, index_text, source_id, table_to_use, offsets(words) FROM words WHERE words MATCH '%s*' LIMIT 50;", searchString);
                if (sortOrder != null || selection != null || selectionArgs != null || projection != null) {
                    throw new IllegalArgumentException("do not specify sortOrder, selection, selectionArgs, or projectionwith this query");
                }
                cursor = db.rawQuery(query, null);
                break;
            }
            case 14: {
                if (sortOrder != null || selection != null || selectionArgs != null || projection != null) {
                    throw new IllegalArgumentException("do not specify sortOrder, selection, selectionArgs, or projectionwith this query");
                }
                String searchString = uri.getQueryParameter("pattern") + "*";
                String smsProjection = "sms._id as _id,thread_id,address,body,date,index_text,words._id";
                String mmsProjection = "pdu._id,thread_id,addr.address,part.text as body,pdu.date,index_text,words._id";
                String smsQuery = String.format("SELECT %s FROM sms,words WHERE (words MATCH ?  AND sms._id=words.source_id AND words.table_to_use=1) ", smsProjection);
                String mmsQuery = String.format("SELECT %s FROM pdu,part,addr,words WHERE ((part.mid=pdu._id) AND (addr.msg_id=pdu._id) AND (addr.type=%d) AND (part.ct='text/plain') AND (words MATCH ?) AND (part._id = words.source_id) AND (words.table_to_use=2))", mmsProjection, 151);
                String rawQuery = String.format("%s UNION %s GROUP BY %s ORDER BY %s", smsQuery, mmsQuery, "thread_id", "thread_id ASC, date DESC");
                try {
                    cursor = db.rawQuery(rawQuery, new String[]{searchString, searchString});
                }
                catch (Exception ex) {
                    Log.e((String)LOG_TAG, (String)("got exception: " + ex.toString()));
                }
                break;
            }
            case 6: {
                String extraSelection;
                String protoName = uri.getQueryParameter("protocol");
                String msgId = uri.getQueryParameter("message");
                int proto = TextUtils.isEmpty((CharSequence)protoName) ? -1 : (protoName.equals("sms") ? 0 : 1);
                String string2 = extraSelection = proto != -1 ? "proto_type=" + proto : " 0=0 ";
                if (!TextUtils.isEmpty((CharSequence)msgId)) {
                    extraSelection = extraSelection + " AND msg_id=" + msgId;
                }
                String finalSelection = TextUtils.isEmpty((CharSequence)selection) ? extraSelection : "(" + extraSelection + ") AND " + selection;
                String finalOrder = TextUtils.isEmpty((CharSequence)sortOrder) ? "due_time" : sortOrder;
                cursor = db.query(TABLE_PENDING_MSG, null, finalSelection, selectionArgs, null, null, finalOrder);
                break;
            }
            case 8: {
                cursor = this.getUndeliveredMessages(projection, selection, selectionArgs, sortOrder);
                break;
            }
            case 12: {
                cursor = this.getDraftThread(projection, selection, selectionArgs, sortOrder);
                break;
            }
            case 17: {
                long threadId;
                try {
                    threadId = Long.parseLong(uri.getLastPathSegment());
                }
                catch (NumberFormatException e) {
                    Log.e((String)LOG_TAG, (String)"Thread ID must be a long.");
                    break;
                }
                cursor = this.getFirstLockedMessage(projection, "thread_id=" + Long.toString(threadId), null, sortOrder);
                break;
            }
            case 16: {
                cursor = this.getFirstLockedMessage(projection, selection, selectionArgs, sortOrder);
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized URI:" + uri);
            }
        }
        cursor.setNotificationUri(this.getContext().getContentResolver(), Telephony.MmsSms.CONTENT_URI);
        return cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getSingleAddressId(String address) {
        String[] selectionArgs;
        boolean isEmail = Telephony.Mms.isEmailAddress((String)address);
        boolean isPhoneNumber = Telephony.Mms.isPhoneNumber((String)address);
        String refinedAddress = isEmail ? address.toLowerCase() : address;
        String selection = "address=?";
        long retVal = -1L;
        if (!isPhoneNumber) {
            selectionArgs = new String[]{refinedAddress};
        } else {
            selection = selection + " OR " + String.format("PHONE_NUMBERS_EQUAL(address, ?, %d)", this.mUseStrictPhoneNumberComparation ? 1 : 0);
            selectionArgs = new String[]{refinedAddress, refinedAddress};
        }
        Cursor cursor = null;
        try {
            SQLiteDatabase db = this.mOpenHelper.getReadableDatabase();
            cursor = db.query(TABLE_CANONICAL_ADDRESSES, ID_PROJECTION, selection, selectionArgs, null, null, null);
            if (cursor.getCount() == 0) {
                ContentValues contentValues = new ContentValues(1);
                contentValues.put("address", refinedAddress);
                db = this.mOpenHelper.getWritableDatabase();
                retVal = db.insert(TABLE_CANONICAL_ADDRESSES, "address", contentValues);
                Log.d((String)LOG_TAG, (String)("getSingleAddressId: insert new canonical_address for xxxxxx, _id=" + retVal));
                long l = retVal;
                return l;
            }
            if (cursor.moveToFirst()) {
                retVal = cursor.getLong(cursor.getColumnIndexOrThrow("_id"));
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return retVal;
    }

    private Set<Long> getAddressIds(List<String> addresses) {
        HashSet<Long> result = new HashSet<Long>(addresses.size());
        for (String address : addresses) {
            if (address.equals("insert-address-token")) continue;
            long id = this.getSingleAddressId(address);
            if (id != -1L) {
                result.add(id);
                continue;
            }
            Log.e((String)LOG_TAG, (String)("getAddressIds: address ID not found for " + address));
        }
        return result;
    }

    private long[] getSortedSet(Set<Long> numbers) {
        int size = numbers.size();
        long[] result = new long[size];
        int i = 0;
        for (Long number : numbers) {
            result[i++] = number;
        }
        if (size > 1) {
            Arrays.sort(result);
        }
        return result;
    }

    private String getSpaceSeparatedNumbers(long[] numbers) {
        int size = numbers.length;
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                buffer.append(' ');
            }
            buffer.append(numbers[i]);
        }
        return buffer.toString();
    }

    private void insertThread(String recipientIds, int numberOfRecipients) {
        ContentValues values = new ContentValues(4);
        long date = System.currentTimeMillis();
        values.put("date", Long.valueOf(date - date % 1000L));
        values.put("recipient_ids", recipientIds);
        if (numberOfRecipients > 1) {
            values.put("type", Integer.valueOf(1));
        }
        values.put("message_count", Integer.valueOf(0));
        long result = this.mOpenHelper.getWritableDatabase().insert("threads", null, values);
        Log.d((String)LOG_TAG, (String)("insertThread: created new thread_id " + result + " for recipientIds " + "xxxxxxx"));
        this.getContext().getContentResolver().notifyChange(Telephony.MmsSms.CONTENT_URI, null);
    }

    private synchronized Cursor getThreadId(List<String> recipients) {
        Set<Long> addressIds = this.getAddressIds(recipients);
        String recipientIds = "";
        if (addressIds.size() == 1) {
            for (Long addressId : addressIds) {
                recipientIds = Long.toString(addressId);
            }
        } else {
            recipientIds = this.getSpaceSeparatedNumbers(this.getSortedSet(addressIds));
        }
        if (Log.isLoggable((String)LOG_TAG, (int)2)) {
            Log.d((String)LOG_TAG, (String)"getThreadId: recipientIds (selectionArgs) =xxxxxxx");
        }
        String[] selectionArgs = new String[]{recipientIds};
        SQLiteDatabase db = this.mOpenHelper.getReadableDatabase();
        Cursor cursor = db.rawQuery(THREAD_QUERY, selectionArgs);
        if (cursor.getCount() == 0) {
            cursor.close();
            Log.d((String)LOG_TAG, (String)"getThreadId: create new thread_id for recipients xxxxxxxx");
            this.insertThread(recipientIds, recipients.size());
            db = this.mOpenHelper.getReadableDatabase();
            cursor = db.rawQuery(THREAD_QUERY, selectionArgs);
        }
        if (cursor.getCount() > 1) {
            Log.w((String)LOG_TAG, (String)("getThreadId: why is cursorCount=" + cursor.getCount()));
        }
        return cursor;
    }

    private static String concatSelections(String selection1, String selection2) {
        if (TextUtils.isEmpty((CharSequence)selection1)) {
            return selection2;
        }
        if (TextUtils.isEmpty((CharSequence)selection2)) {
            return selection1;
        }
        return selection1 + " AND " + selection2;
    }

    private static String[] handleNullMessageProjection(String[] projection) {
        return projection == null ? UNION_COLUMNS : projection;
    }

    private static String[] handleNullThreadsProjection(String[] projection) {
        return projection == null ? THREADS_COLUMNS : projection;
    }

    private static String handleNullSortOrder(String sortOrder) {
        return sortOrder == null ? "normalized_date ASC" : sortOrder;
    }

    private Cursor getSimpleConversations(String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return this.mOpenHelper.getReadableDatabase().query("threads", projection, selection, selectionArgs, null, null, " date DESC");
    }

    private Cursor getDraftThread(String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        String[] innerProjection = new String[]{"_id", "thread_id"};
        SQLiteQueryBuilder mmsQueryBuilder = new SQLiteQueryBuilder();
        SQLiteQueryBuilder smsQueryBuilder = new SQLiteQueryBuilder();
        mmsQueryBuilder.setTables("pdu");
        smsQueryBuilder.setTables("sms");
        String mmsSubQuery = mmsQueryBuilder.buildUnionSubQuery("transport_type", innerProjection, MMS_COLUMNS, 1, "mms", MmsSmsProvider.concatSelections(selection, "msg_box=3"), selectionArgs, null, null);
        String smsSubQuery = smsQueryBuilder.buildUnionSubQuery("transport_type", innerProjection, SMS_COLUMNS, 1, "sms", MmsSmsProvider.concatSelections(selection, "type=3"), selectionArgs, null, null);
        SQLiteQueryBuilder unionQueryBuilder = new SQLiteQueryBuilder();
        unionQueryBuilder.setDistinct(true);
        String unionQuery = unionQueryBuilder.buildUnionQuery(new String[]{mmsSubQuery, smsSubQuery}, null, null);
        SQLiteQueryBuilder outerQueryBuilder = new SQLiteQueryBuilder();
        outerQueryBuilder.setTables("(" + unionQuery + ")");
        String outerQuery = outerQueryBuilder.buildQuery(projection, null, null, null, null, sortOrder, null);
        return this.mOpenHelper.getReadableDatabase().rawQuery(outerQuery, EMPTY_STRING_ARRAY);
    }

    private Cursor getConversations(String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        SQLiteQueryBuilder mmsQueryBuilder = new SQLiteQueryBuilder();
        SQLiteQueryBuilder smsQueryBuilder = new SQLiteQueryBuilder();
        mmsQueryBuilder.setTables("pdu");
        smsQueryBuilder.setTables("sms");
        String[] columns = MmsSmsProvider.handleNullMessageProjection(projection);
        String[] innerMmsProjection = this.makeProjectionWithDateAndThreadId(UNION_COLUMNS, 1000);
        String[] innerSmsProjection = this.makeProjectionWithDateAndThreadId(UNION_COLUMNS, 1);
        String mmsSubQuery = mmsQueryBuilder.buildUnionSubQuery("transport_type", innerMmsProjection, MMS_COLUMNS, 1, "mms", MmsSmsProvider.concatSelections(selection, MMS_CONVERSATION_CONSTRAINT), selectionArgs, "thread_id", "date = MAX(date)");
        String smsSubQuery = smsQueryBuilder.buildUnionSubQuery("transport_type", innerSmsProjection, SMS_COLUMNS, 1, "sms", MmsSmsProvider.concatSelections(selection, SMS_CONVERSATION_CONSTRAINT), selectionArgs, "thread_id", "date = MAX(date)");
        SQLiteQueryBuilder unionQueryBuilder = new SQLiteQueryBuilder();
        unionQueryBuilder.setDistinct(true);
        String unionQuery = unionQueryBuilder.buildUnionQuery(new String[]{mmsSubQuery, smsSubQuery}, null, null);
        SQLiteQueryBuilder outerQueryBuilder = new SQLiteQueryBuilder();
        outerQueryBuilder.setTables("(" + unionQuery + ")");
        String outerQuery = outerQueryBuilder.buildQuery(columns, null, null, "tid", "normalized_date = MAX(normalized_date)", sortOrder, null);
        return this.mOpenHelper.getReadableDatabase().rawQuery(outerQuery, EMPTY_STRING_ARRAY);
    }

    private Cursor getFirstLockedMessage(String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        SQLiteQueryBuilder mmsQueryBuilder = new SQLiteQueryBuilder();
        SQLiteQueryBuilder smsQueryBuilder = new SQLiteQueryBuilder();
        mmsQueryBuilder.setTables("pdu");
        smsQueryBuilder.setTables("sms");
        String[] idColumn = new String[]{"_id"};
        String mmsSubQuery = mmsQueryBuilder.buildUnionSubQuery("transport_type", idColumn, null, 1, "mms", selection, selectionArgs, "_id", "locked=1");
        String smsSubQuery = smsQueryBuilder.buildUnionSubQuery("transport_type", idColumn, null, 1, "sms", selection, selectionArgs, "_id", "locked=1");
        SQLiteQueryBuilder unionQueryBuilder = new SQLiteQueryBuilder();
        unionQueryBuilder.setDistinct(true);
        String unionQuery = unionQueryBuilder.buildUnionQuery(new String[]{mmsSubQuery, smsSubQuery}, null, "1");
        Cursor cursor = this.mOpenHelper.getReadableDatabase().rawQuery(unionQuery, EMPTY_STRING_ARRAY);
        return cursor;
    }

    private Cursor getCompleteConversations(String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        String unionQuery = MmsSmsProvider.buildConversationQuery(projection, selection, selectionArgs, sortOrder);
        return this.mOpenHelper.getReadableDatabase().rawQuery(unionQuery, EMPTY_STRING_ARRAY);
    }

    private String[] makeProjectionWithDateAndThreadId(String[] projection, int dateMultiple) {
        int projectionSize = projection.length;
        String[] result = new String[projectionSize + 2];
        result[0] = "thread_id AS tid";
        result[1] = "date * " + dateMultiple + " AS normalized_date";
        for (int i = 0; i < projectionSize; ++i) {
            result[i + 2] = projection[i];
        }
        return result;
    }

    private Cursor getConversationMessages(String threadIdString, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        try {
            Long.parseLong(threadIdString);
        }
        catch (NumberFormatException exception) {
            Log.e((String)LOG_TAG, (String)"Thread ID must be a Long.");
            return null;
        }
        String finalSelection = MmsSmsProvider.concatSelections(selection, "thread_id = " + threadIdString);
        String unionQuery = MmsSmsProvider.buildConversationQuery(projection, finalSelection, selectionArgs, sortOrder);
        return this.mOpenHelper.getReadableDatabase().rawQuery(unionQuery, EMPTY_STRING_ARRAY);
    }

    private Cursor getMessagesByPhoneNumber(String phoneNumber, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        String escapedPhoneNumber = DatabaseUtils.sqlEscapeString((String)phoneNumber);
        String finalMmsSelection = MmsSmsProvider.concatSelections(selection, "pdu._id = matching_addresses.address_id");
        String finalSmsSelection = MmsSmsProvider.concatSelections(selection, "(address=" + escapedPhoneNumber + " OR PHONE_NUMBERS_EQUAL(address, " + escapedPhoneNumber + (this.mUseStrictPhoneNumberComparation ? ", 1))" : ", 0))"));
        SQLiteQueryBuilder mmsQueryBuilder = new SQLiteQueryBuilder();
        SQLiteQueryBuilder smsQueryBuilder = new SQLiteQueryBuilder();
        mmsQueryBuilder.setDistinct(true);
        smsQueryBuilder.setDistinct(true);
        mmsQueryBuilder.setTables("pdu, (SELECT _id AS address_id FROM addr WHERE (address=" + escapedPhoneNumber + " OR PHONE_NUMBERS_EQUAL(addr.address, " + escapedPhoneNumber + (this.mUseStrictPhoneNumberComparation ? ", 1))) " : ", 0))) ") + "AS matching_addresses");
        smsQueryBuilder.setTables("sms");
        String[] columns = MmsSmsProvider.handleNullMessageProjection(projection);
        String mmsSubQuery = mmsQueryBuilder.buildUnionSubQuery("transport_type", columns, MMS_COLUMNS, 0, "mms", finalMmsSelection, selectionArgs, null, null);
        String smsSubQuery = smsQueryBuilder.buildUnionSubQuery("transport_type", columns, SMS_COLUMNS, 0, "sms", finalSmsSelection, selectionArgs, null, null);
        SQLiteQueryBuilder unionQueryBuilder = new SQLiteQueryBuilder();
        unionQueryBuilder.setDistinct(true);
        String unionQuery = unionQueryBuilder.buildUnionQuery(new String[]{mmsSubQuery, smsSubQuery}, sortOrder, null);
        return this.mOpenHelper.getReadableDatabase().rawQuery(unionQuery, EMPTY_STRING_ARRAY);
    }

    private Cursor getConversationById(String threadIdString, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        try {
            Long.parseLong(threadIdString);
        }
        catch (NumberFormatException exception) {
            Log.e((String)LOG_TAG, (String)"Thread ID must be a Long.");
            return null;
        }
        String extraSelection = "_id=" + threadIdString;
        String finalSelection = MmsSmsProvider.concatSelections(selection, extraSelection);
        SQLiteQueryBuilder queryBuilder = new SQLiteQueryBuilder();
        String[] columns = MmsSmsProvider.handleNullThreadsProjection(projection);
        queryBuilder.setDistinct(true);
        queryBuilder.setTables("threads");
        return queryBuilder.query(this.mOpenHelper.getReadableDatabase(), columns, finalSelection, selectionArgs, sortOrder, null, null);
    }

    private static String joinPduAndPendingMsgTables() {
        return "pdu LEFT JOIN pending_msgs ON pdu._id = pending_msgs.msg_id";
    }

    private static String[] createMmsProjection(String[] old) {
        String[] newProjection = new String[old.length];
        for (int i = 0; i < old.length; ++i) {
            newProjection[i] = old[i].equals("_id") ? "pdu._id" : old[i];
        }
        return newProjection;
    }

    private Cursor getUndeliveredMessages(String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        String[] mmsProjection = MmsSmsProvider.createMmsProjection(projection);
        SQLiteQueryBuilder mmsQueryBuilder = new SQLiteQueryBuilder();
        SQLiteQueryBuilder smsQueryBuilder = new SQLiteQueryBuilder();
        mmsQueryBuilder.setTables(MmsSmsProvider.joinPduAndPendingMsgTables());
        smsQueryBuilder.setTables("sms");
        String finalMmsSelection = MmsSmsProvider.concatSelections(selection, "msg_box = 4");
        String finalSmsSelection = MmsSmsProvider.concatSelections(selection, "(type = 4 OR type = 5 OR type = 6)");
        String[] smsColumns = MmsSmsProvider.handleNullMessageProjection(projection);
        String[] mmsColumns = MmsSmsProvider.handleNullMessageProjection(mmsProjection);
        String[] innerMmsProjection = this.makeProjectionWithDateAndThreadId(mmsColumns, 1000);
        String[] innerSmsProjection = this.makeProjectionWithDateAndThreadId(smsColumns, 1);
        HashSet<String> columnsPresentInTable = new HashSet<String>(MMS_COLUMNS);
        columnsPresentInTable.add("pdu._id");
        columnsPresentInTable.add("err_type");
        String mmsSubQuery = mmsQueryBuilder.buildUnionSubQuery("transport_type", innerMmsProjection, columnsPresentInTable, 1, "mms", finalMmsSelection, selectionArgs, null, null);
        String smsSubQuery = smsQueryBuilder.buildUnionSubQuery("transport_type", innerSmsProjection, SMS_COLUMNS, 1, "sms", finalSmsSelection, selectionArgs, null, null);
        SQLiteQueryBuilder unionQueryBuilder = new SQLiteQueryBuilder();
        unionQueryBuilder.setDistinct(true);
        String unionQuery = unionQueryBuilder.buildUnionQuery(new String[]{smsSubQuery, mmsSubQuery}, null, null);
        SQLiteQueryBuilder outerQueryBuilder = new SQLiteQueryBuilder();
        outerQueryBuilder.setTables("(" + unionQuery + ")");
        String outerQuery = outerQueryBuilder.buildQuery(smsColumns, null, null, null, null, sortOrder, null);
        return this.mOpenHelper.getReadableDatabase().rawQuery(outerQuery, EMPTY_STRING_ARRAY);
    }

    private static String[] makeProjectionWithNormalizedDate(String[] projection, int dateMultiple) {
        int projectionSize = projection.length;
        String[] result = new String[projectionSize + 1];
        result[0] = "date * " + dateMultiple + " AS normalized_date";
        System.arraycopy(projection, 0, result, 1, projectionSize);
        return result;
    }

    private static String buildConversationQuery(String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        String[] mmsProjection = MmsSmsProvider.createMmsProjection(projection);
        SQLiteQueryBuilder mmsQueryBuilder = new SQLiteQueryBuilder();
        SQLiteQueryBuilder smsQueryBuilder = new SQLiteQueryBuilder();
        mmsQueryBuilder.setDistinct(true);
        smsQueryBuilder.setDistinct(true);
        mmsQueryBuilder.setTables(MmsSmsProvider.joinPduAndPendingMsgTables());
        smsQueryBuilder.setTables("sms");
        String[] smsColumns = MmsSmsProvider.handleNullMessageProjection(projection);
        String[] mmsColumns = MmsSmsProvider.handleNullMessageProjection(mmsProjection);
        String[] innerMmsProjection = MmsSmsProvider.makeProjectionWithNormalizedDate(mmsColumns, 1000);
        String[] innerSmsProjection = MmsSmsProvider.makeProjectionWithNormalizedDate(smsColumns, 1);
        HashSet<String> columnsPresentInTable = new HashSet<String>(MMS_COLUMNS);
        columnsPresentInTable.add("pdu._id");
        columnsPresentInTable.add("err_type");
        String mmsSelection = MmsSmsProvider.concatSelections(selection, "msg_box != 3");
        String mmsSubQuery = mmsQueryBuilder.buildUnionSubQuery("transport_type", innerMmsProjection, columnsPresentInTable, 0, "mms", MmsSmsProvider.concatSelections(mmsSelection, MMS_CONVERSATION_CONSTRAINT), selectionArgs, null, null);
        String smsSubQuery = smsQueryBuilder.buildUnionSubQuery("transport_type", innerSmsProjection, SMS_COLUMNS, 0, "sms", MmsSmsProvider.concatSelections(selection, SMS_CONVERSATION_CONSTRAINT), selectionArgs, null, null);
        SQLiteQueryBuilder unionQueryBuilder = new SQLiteQueryBuilder();
        unionQueryBuilder.setDistinct(true);
        String unionQuery = unionQueryBuilder.buildUnionQuery(new String[]{smsSubQuery, mmsSubQuery}, MmsSmsProvider.handleNullSortOrder(sortOrder), null);
        SQLiteQueryBuilder outerQueryBuilder = new SQLiteQueryBuilder();
        outerQueryBuilder.setTables("(" + unionQuery + ")");
        return outerQueryBuilder.buildQuery(smsColumns, null, null, null, null, sortOrder, null);
    }

    public String getType(Uri uri) {
        return VND_ANDROID_DIR_MMS_SMS;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        Context context = this.getContext();
        int affectedRows = 0;
        switch (URI_MATCHER.match(uri)) {
            case 1: {
                long threadId;
                try {
                    threadId = Long.parseLong(uri.getLastPathSegment());
                }
                catch (NumberFormatException e) {
                    Log.e((String)LOG_TAG, (String)"Thread ID must be a long.");
                    break;
                }
                affectedRows = this.deleteConversation(uri, selection, selectionArgs);
                MmsSmsDatabaseHelper.updateThread(db, threadId);
                break;
            }
            case 0: {
                affectedRows = MmsProvider.deleteMessages(context, db, selection, selectionArgs, uri) + db.delete("sms", selection, selectionArgs);
                MmsSmsDatabaseHelper.updateAllThreads(db, null, null);
                break;
            }
            case 11: {
                affectedRows = db.delete("threads", "_id NOT IN (SELECT DISTINCT thread_id FROM sms UNION SELECT DISTINCT thread_id FROM pdu)", null);
                break;
            }
            default: {
                throw new UnsupportedOperationException(NO_DELETES_INSERTS_OR_UPDATES);
            }
        }
        if (affectedRows > 0) {
            context.getContentResolver().notifyChange(Telephony.MmsSms.CONTENT_URI, null);
        }
        return affectedRows;
    }

    private int deleteConversation(Uri uri, String selection, String[] selectionArgs) {
        String threadId = uri.getLastPathSegment();
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        String finalSelection = MmsSmsProvider.concatSelections(selection, "thread_id = " + threadId);
        return MmsProvider.deleteMessages(this.getContext(), db, finalSelection, selectionArgs, uri) + db.delete("sms", finalSelection, selectionArgs);
    }

    public Uri insert(Uri uri, ContentValues values) {
        throw new UnsupportedOperationException(NO_DELETES_INSERTS_OR_UPDATES);
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        int affectedRows = 0;
        switch (URI_MATCHER.match(uri)) {
            case 1: {
                String threadIdString = (String)uri.getPathSegments().get(1);
                affectedRows = this.updateConversation(threadIdString, values, selection, selectionArgs);
                break;
            }
            case 6: {
                affectedRows = db.update(TABLE_PENDING_MSG, values, selection, null);
                break;
            }
            case 5: {
                String extraSelection = "_id=" + (String)uri.getPathSegments().get(1);
                String finalSelection = TextUtils.isEmpty((CharSequence)selection) ? extraSelection : extraSelection + " AND " + selection;
                affectedRows = db.update(TABLE_CANONICAL_ADDRESSES, values, finalSelection, null);
                break;
            }
            default: {
                throw new UnsupportedOperationException(NO_DELETES_INSERTS_OR_UPDATES);
            }
        }
        if (affectedRows > 0) {
            this.getContext().getContentResolver().notifyChange(Telephony.MmsSms.CONTENT_URI, null);
        }
        return affectedRows;
    }

    private int updateConversation(String threadIdString, ContentValues values, String selection, String[] selectionArgs) {
        try {
            Long.parseLong(threadIdString);
        }
        catch (NumberFormatException exception) {
            Log.e((String)LOG_TAG, (String)"Thread ID must be a Long.");
            return 0;
        }
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        String finalSelection = MmsSmsProvider.concatSelections(selection, "thread_id=" + threadIdString);
        return db.update("pdu", values, finalSelection, selectionArgs) + db.update("sms", values, finalSelection, selectionArgs);
    }

    private static void initializeColumnSets() {
        int i;
        int commonColumnCount = MMS_SMS_COLUMNS.length;
        int mmsOnlyColumnCount = MMS_ONLY_COLUMNS.length;
        int smsOnlyColumnCount = SMS_ONLY_COLUMNS.length;
        HashSet<String> unionColumns = new HashSet<String>();
        for (i = 0; i < commonColumnCount; ++i) {
            MMS_COLUMNS.add(MMS_SMS_COLUMNS[i]);
            SMS_COLUMNS.add(MMS_SMS_COLUMNS[i]);
            unionColumns.add(MMS_SMS_COLUMNS[i]);
        }
        for (i = 0; i < mmsOnlyColumnCount; ++i) {
            MMS_COLUMNS.add(MMS_ONLY_COLUMNS[i]);
            unionColumns.add(MMS_ONLY_COLUMNS[i]);
        }
        for (i = 0; i < smsOnlyColumnCount; ++i) {
            SMS_COLUMNS.add(SMS_ONLY_COLUMNS[i]);
            unionColumns.add(SMS_ONLY_COLUMNS[i]);
        }
        i = 0;
        for (String columnName : unionColumns) {
            MmsSmsProvider.UNION_COLUMNS[i++] = columnName;
        }
    }

    static {
        URI_MATCHER.addURI(AUTHORITY, "conversations", 0);
        URI_MATCHER.addURI(AUTHORITY, "complete-conversations", 7);
        URI_MATCHER.addURI(AUTHORITY, "conversations/#", 1);
        URI_MATCHER.addURI(AUTHORITY, "conversations/#/recipients", 2);
        URI_MATCHER.addURI(AUTHORITY, "conversations/#/subject", 9);
        URI_MATCHER.addURI(AUTHORITY, "conversations/obsolete", 11);
        URI_MATCHER.addURI(AUTHORITY, "messages/byphone/*", 3);
        URI_MATCHER.addURI(AUTHORITY, "threadID", 4);
        URI_MATCHER.addURI(AUTHORITY, "canonical-address/#", 5);
        URI_MATCHER.addURI(AUTHORITY, "canonical-addresses", 13);
        URI_MATCHER.addURI(AUTHORITY, "search", 14);
        URI_MATCHER.addURI(AUTHORITY, "searchSuggest", 15);
        URI_MATCHER.addURI(AUTHORITY, "pending", 6);
        URI_MATCHER.addURI(AUTHORITY, "undelivered", 8);
        URI_MATCHER.addURI(AUTHORITY, "notifications", 10);
        URI_MATCHER.addURI(AUTHORITY, "draft", 12);
        URI_MATCHER.addURI(AUTHORITY, "locked", 16);
        URI_MATCHER.addURI(AUTHORITY, "locked/#", 17);
        MmsSmsProvider.initializeColumnSets();
    }
}

