/*
 * Decompiled with CFR 0.152.
 */
package com.android.providers.telephony;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import com.google.android.mms.pdu.EncodedStringValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class MmsSmsDatabaseHelper
extends SQLiteOpenHelper {
    private static final String TAG = "MmsSmsDatabaseHelper";
    private static final String SMS_UPDATE_THREAD_READ_BODY = "  UPDATE threads SET read =     CASE (SELECT COUNT(*)          FROM sms          WHERE read = 0            AND thread_id = threads._id)      WHEN 0 THEN 1      ELSE 0    END  WHERE threads._id = new.thread_id; ";
    private static final String UPDATE_THREAD_COUNT_ON_NEW = "  UPDATE threads SET message_count =      (SELECT COUNT(sms._id) FROM sms LEFT JOIN threads       ON threads._id = thread_id      WHERE thread_id = new.thread_id        AND sms.type != 3) +      (SELECT COUNT(pdu._id) FROM pdu LEFT JOIN threads       ON threads._id = thread_id      WHERE thread_id = new.thread_id        AND (m_type=132 OR m_type=130 OR m_type=128)        AND msg_box != 3)   WHERE threads._id = new.thread_id; ";
    private static final String UPDATE_THREAD_COUNT_ON_OLD = "  UPDATE threads SET message_count =      (SELECT COUNT(sms._id) FROM sms LEFT JOIN threads       ON threads._id = thread_id      WHERE thread_id = old.thread_id        AND sms.type != 3) +      (SELECT COUNT(pdu._id) FROM pdu LEFT JOIN threads       ON threads._id = thread_id      WHERE thread_id = old.thread_id        AND (m_type=132 OR m_type=130 OR m_type=128)        AND msg_box != 3)   WHERE threads._id = old.thread_id; ";
    private static final String SMS_UPDATE_THREAD_DATE_SNIPPET_COUNT_ON_UPDATE = "BEGIN  UPDATE threads SET    date = (strftime('%s','now') * 1000),     snippet = new.body,     snippet_cs = 0  WHERE threads._id = new.thread_id;   UPDATE threads SET message_count =      (SELECT COUNT(sms._id) FROM sms LEFT JOIN threads       ON threads._id = thread_id      WHERE thread_id = new.thread_id        AND sms.type != 3) +      (SELECT COUNT(pdu._id) FROM pdu LEFT JOIN threads       ON threads._id = thread_id      WHERE thread_id = new.thread_id        AND (m_type=132 OR m_type=130 OR m_type=128)        AND msg_box != 3)   WHERE threads._id = new.thread_id;   UPDATE threads SET read =     CASE (SELECT COUNT(*)          FROM sms          WHERE read = 0            AND thread_id = threads._id)      WHEN 0 THEN 1      ELSE 0    END  WHERE threads._id = new.thread_id; END;";
    private static final String PDU_UPDATE_THREAD_CONSTRAINTS = "  WHEN new.m_type=132    OR new.m_type=130    OR new.m_type=128 ";
    private static final String PDU_UPDATE_THREAD_READ_BODY = "  UPDATE threads SET read =     CASE (SELECT COUNT(*)          FROM pdu          WHERE read = 0            AND thread_id = threads._id             AND (m_type=132 OR m_type=130 OR m_type=128))       WHEN 0 THEN 1      ELSE 0    END  WHERE threads._id = new.thread_id; ";
    private static final String PDU_UPDATE_THREAD_DATE_SNIPPET_COUNT_ON_UPDATE = "BEGIN  UPDATE threads SET    date = (strftime('%s','now') * 1000),     snippet = new.sub,     snippet_cs = new.sub_cs  WHERE threads._id = new.thread_id;   UPDATE threads SET message_count =      (SELECT COUNT(sms._id) FROM sms LEFT JOIN threads       ON threads._id = thread_id      WHERE thread_id = new.thread_id        AND sms.type != 3) +      (SELECT COUNT(pdu._id) FROM pdu LEFT JOIN threads       ON threads._id = thread_id      WHERE thread_id = new.thread_id        AND (m_type=132 OR m_type=130 OR m_type=128)        AND msg_box != 3)   WHERE threads._id = new.thread_id;   UPDATE threads SET read =     CASE (SELECT COUNT(*)          FROM pdu          WHERE read = 0            AND thread_id = threads._id             AND (m_type=132 OR m_type=130 OR m_type=128))       WHEN 0 THEN 1      ELSE 0    END  WHERE threads._id = new.thread_id; END;";
    private static final String UPDATE_THREAD_SNIPPET_SNIPPET_CS_ON_DELETE = "  UPDATE threads SET snippet =    (SELECT snippet FROM     (SELECT date * 1000 AS date, sub AS snippet, thread_id FROM pdu      UNION SELECT date, body AS snippet, thread_id FROM sms)    WHERE thread_id = OLD.thread_id ORDER BY date DESC LIMIT 1)   WHERE threads._id = OLD.thread_id;   UPDATE threads SET snippet_cs =    (SELECT snippet_cs FROM     (SELECT date * 1000 AS date, sub_cs AS snippet_cs, thread_id FROM pdu      UNION SELECT date, 0 AS snippet_cs, thread_id FROM sms)    WHERE thread_id = OLD.thread_id ORDER BY date DESC LIMIT 1)   WHERE threads._id = OLD.thread_id; ";
    private static final String PART_UPDATE_THREADS_ON_INSERT_TRIGGER = "CREATE TRIGGER update_threads_on_insert_part  AFTER INSERT ON part  WHEN new.ct != 'text/plain' AND new.ct != 'application/smil'  BEGIN   UPDATE threads SET has_attachment=1 WHERE _id IN    (SELECT pdu.thread_id FROM part JOIN pdu ON pdu._id=part.mid      WHERE part._id=new._id LIMIT 1);  END";
    private static final String PART_UPDATE_THREADS_ON_UPDATE_TRIGGER = "CREATE TRIGGER update_threads_on_update_part  AFTER UPDATE of mid ON part  WHEN new.ct != 'text/plain' AND new.ct != 'application/smil'  BEGIN   UPDATE threads SET has_attachment=1 WHERE _id IN    (SELECT pdu.thread_id FROM part JOIN pdu ON pdu._id=part.mid      WHERE part._id=new._id LIMIT 1);  END";
    private static final String PART_UPDATE_THREADS_ON_DELETE_TRIGGER = "CREATE TRIGGER update_threads_on_delete_part  AFTER DELETE ON part  WHEN old.ct != 'text/plain' AND old.ct != 'application/smil'  BEGIN   UPDATE threads SET has_attachment =    CASE     (SELECT COUNT(*) FROM part JOIN pdu      WHERE pdu.thread_id = threads._id      AND part.ct != 'text/plain' AND part.ct != 'application/smil'      AND part.mid = pdu._id)   WHEN 0 THEN 0    ELSE 1    END;  END";
    private static final String PDU_UPDATE_THREADS_ON_UPDATE_TRIGGER = "CREATE TRIGGER update_threads_on_update_pdu  AFTER UPDATE of thread_id ON pdu  BEGIN   UPDATE threads SET has_attachment=1 WHERE _id IN    (SELECT pdu.thread_id FROM part JOIN pdu      WHERE part.ct != 'text/plain' AND part.ct != 'application/smil'      AND part.mid = pdu._id); END";
    private static MmsSmsDatabaseHelper mInstance = null;
    static final String DATABASE_NAME = "mmssms.db";
    static final int DATABASE_VERSION = 53;

    private MmsSmsDatabaseHelper(Context context) {
        super(context, DATABASE_NAME, null, 53);
    }

    static synchronized MmsSmsDatabaseHelper getInstance(Context context) {
        if (mInstance == null) {
            mInstance = new MmsSmsDatabaseHelper(context);
        }
        return mInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateThread(SQLiteDatabase db, long thread_id) {
        String errorQuery;
        if (thread_id < 0L) {
            MmsSmsDatabaseHelper.updateAllThreads(db, null, null);
            return;
        }
        int rows = db.delete("threads", "_id = ? AND _id NOT IN          (SELECT thread_id FROM sms            UNION SELECT thread_id FROM pdu)", new String[]{String.valueOf(thread_id)});
        if (rows > 0) {
            return;
        }
        db.execSQL("  UPDATE threads SET message_count =      (SELECT COUNT(sms._id) FROM sms LEFT JOIN threads       ON threads._id = thread_id      WHERE thread_id = " + thread_id + "        AND sms." + "type" + " != 3) + " + "     (SELECT COUNT(pdu._id) FROM pdu LEFT JOIN threads " + "      ON threads._id = " + "thread_id" + "      WHERE " + "thread_id" + " = " + thread_id + "        AND (m_type=132 OR m_type=130 OR m_type=128)" + "        AND " + "msg_box" + " != 3) " + "  WHERE threads._id = " + thread_id + ";");
        db.execSQL("  UPDATE threads  SET  date =    (SELECT date FROM        (SELECT date * 1000 AS date, thread_id FROM pdu         UNION SELECT date, thread_id FROM sms)     WHERE thread_id = " + thread_id + " ORDER BY date DESC LIMIT 1)," + "  snippet =" + "    (SELECT snippet FROM" + "        (SELECT date * 1000 AS date, sub AS snippet, thread_id FROM pdu" + "         UNION SELECT date, body AS snippet, thread_id FROM sms)" + "     WHERE thread_id = " + thread_id + " ORDER BY date DESC LIMIT 1)," + "  snippet_cs =" + "    (SELECT snippet_cs FROM" + "        (SELECT date * 1000 AS date, sub_cs AS snippet_cs, thread_id FROM pdu" + "         UNION SELECT date, 0 AS snippet_cs, thread_id FROM sms)" + "     WHERE thread_id = " + thread_id + " ORDER BY date DESC LIMIT 1)" + "  WHERE threads._id = " + thread_id + ";");
        String query = "SELECT thread_id FROM sms WHERE type=5 AND thread_id = " + thread_id + " LIMIT 1";
        int setError = 0;
        Cursor c = db.rawQuery(query, null);
        if (c != null) {
            try {
                setError = c.getCount();
            }
            finally {
                c.close();
            }
        }
        if ((c = db.rawQuery(errorQuery = "SELECT error FROM threads WHERE _id = " + thread_id, null)) != null) {
            try {
                int curError;
                if (c.moveToNext() && (curError = c.getInt(0)) != setError) {
                    db.execSQL("UPDATE threads SET error=" + setError + " WHERE _id = " + thread_id);
                }
            }
            finally {
                c.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateAllThreads(SQLiteDatabase db, String where, String[] whereArgs) {
        where = where == null ? "" : "WHERE (" + where + ")";
        String query = "SELECT _id FROM threads WHERE _id IN (SELECT DISTINCT thread_id FROM sms " + where + ")";
        Cursor c = db.rawQuery(query, whereArgs);
        if (c != null) {
            try {
                while (c.moveToNext()) {
                    MmsSmsDatabaseHelper.updateThread(db, c.getInt(0));
                }
            }
            finally {
                c.close();
            }
        }
        db.delete("threads", "_id NOT IN (SELECT DISTINCT thread_id FROM sms UNION SELECT DISTINCT thread_id FROM pdu)", null);
    }

    public static int deleteOneSms(SQLiteDatabase db, int message_id) {
        int thread_id = -1;
        Cursor c = db.query("sms", new String[]{"thread_id"}, "_id=" + message_id, null, null, null, null);
        if (c != null) {
            if (c.moveToFirst()) {
                thread_id = c.getInt(0);
            }
            c.close();
        }
        int rows = db.delete("sms", "_id=" + message_id, null);
        if (thread_id > 0) {
            MmsSmsDatabaseHelper.updateThread(db, thread_id);
        }
        return rows;
    }

    public void onCreate(SQLiteDatabase db) {
        this.createMmsTables(db);
        this.createSmsTables(db);
        this.createCommonTables(db);
        this.createCommonTriggers(db);
        this.createMmsTriggers(db);
        this.createWordsTables(db);
        this.createIndices(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateWordsTable(SQLiteDatabase db) {
        String body;
        long id;
        ContentValues cv;
        String TABLE_WORDS = "words";
        Cursor smsRows = db.query("sms", new String[]{"_id", "body"}, null, null, null, null, null);
        try {
            if (smsRows != null) {
                smsRows.moveToPosition(-1);
                cv = new ContentValues();
                while (smsRows.moveToNext()) {
                    cv.clear();
                    id = smsRows.getLong(0);
                    body = smsRows.getString(1);
                    cv.put("_id", Long.valueOf(id));
                    cv.put("index_text", body);
                    cv.put("source_id", Long.valueOf(id));
                    cv.put("table_to_use", Integer.valueOf(1));
                    db.insert("words", "index_text", cv);
                }
            }
        }
        finally {
            if (smsRows != null) {
                smsRows.close();
            }
        }
        Cursor mmsRows = db.query("part", new String[]{"_id", "text"}, "ct = 'text/plain'", null, null, null, null);
        try {
            if (mmsRows != null) {
                mmsRows.moveToPosition(-1);
                cv = new ContentValues();
                while (mmsRows.moveToNext()) {
                    cv.clear();
                    id = mmsRows.getLong(0);
                    body = mmsRows.getString(1);
                    cv.put("_id", Long.valueOf(id));
                    cv.put("index_text", body);
                    cv.put("source_id", Long.valueOf(id));
                    cv.put("table_to_use", Integer.valueOf(1));
                    db.insert("words", "index_text", cv);
                }
            }
        }
        finally {
            if (mmsRows != null) {
                mmsRows.close();
            }
        }
    }

    private void createWordsTables(SQLiteDatabase db) {
        try {
            db.execSQL("CREATE VIRTUAL TABLE words USING FTS3 (_id INTEGER PRIMARY KEY, index_text TEXT, source_id INTEGER, table_to_use INTEGER);");
            db.execSQL("CREATE TRIGGER sms_words_update AFTER UPDATE ON sms BEGIN UPDATE words  SET index_text = NEW.body WHERE (source_id=NEW._id AND table_to_use=1);  END;");
            db.execSQL("CREATE TRIGGER sms_words_delete AFTER DELETE ON sms BEGIN DELETE FROM   words WHERE source_id = OLD._id AND table_to_use = 1; END;");
            db.execSQL("CREATE TRIGGER mms_words_update AFTER UPDATE ON part BEGIN UPDATE words  SET index_text = NEW.text WHERE (source_id=NEW._id AND table_to_use=2);  END;");
            db.execSQL("CREATE TRIGGER mms_words_delete AFTER DELETE ON part BEGIN DELETE FROM  words WHERE source_id = OLD._id AND table_to_use = 2; END;");
            this.populateWordsTable(db);
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("got exception creating words table: " + ex.toString()));
        }
    }

    private void createIndices(SQLiteDatabase db) {
        this.createThreadIdIndex(db);
    }

    private void createThreadIdIndex(SQLiteDatabase db) {
        try {
            db.execSQL("CREATE INDEX IF NOT EXISTS typeThreadIdIndex ON sms (type, thread_id);");
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("got exception creating indices: " + ex.toString()));
        }
    }

    private void createMmsTables(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE pdu (_id INTEGER PRIMARY KEY,thread_id INTEGER,date INTEGER,msg_box INTEGER,read INTEGER DEFAULT 0,m_id TEXT,sub TEXT,sub_cs INTEGER,ct_t TEXT,ct_l TEXT,exp INTEGER,m_cls TEXT,m_type INTEGER,v INTEGER,m_size INTEGER,pri INTEGER,rr INTEGER,rpt_a INTEGER,resp_st INTEGER,st INTEGER,tr_id TEXT,retr_st INTEGER,retr_txt TEXT,retr_txt_cs INTEGER,read_status INTEGER,ct_cls INTEGER,resp_txt TEXT,d_tm INTEGER,d_rpt INTEGER,locked INTEGER DEFAULT 0,seen INTEGER DEFAULT 0);");
        db.execSQL("CREATE TABLE addr (_id INTEGER PRIMARY KEY,msg_id INTEGER,contact_id INTEGER,address TEXT,type INTEGER,charset INTEGER);");
        db.execSQL("CREATE TABLE part (_id INTEGER PRIMARY KEY,mid INTEGER,seq INTEGER DEFAULT 0,ct TEXT,name TEXT,chset INTEGER,cd TEXT,fn TEXT,cid TEXT,cl TEXT,ctt_s INTEGER,ctt_t TEXT,_data TEXT,text TEXT);");
        db.execSQL("CREATE TABLE rate (sent_time INTEGER);");
        db.execSQL("CREATE TABLE drm (_id INTEGER PRIMARY KEY,_data TEXT);");
    }

    private void createMmsTriggers(SQLiteDatabase db) {
        db.execSQL("CREATE TRIGGER part_cleanup DELETE ON pdu BEGIN   DELETE FROM part  WHERE mid=old._id;END;");
        db.execSQL("CREATE TRIGGER addr_cleanup DELETE ON pdu BEGIN   DELETE FROM addr  WHERE msg_id=old._id;END;");
        db.execSQL("CREATE TRIGGER cleanup_delivery_and_read_report AFTER DELETE ON pdu WHEN old.m_type=128 BEGIN   DELETE FROM pdu  WHERE (m_type=134    OR m_type=136)    AND m_id=old.m_id; END;");
        db.execSQL(PART_UPDATE_THREADS_ON_INSERT_TRIGGER);
        db.execSQL(PART_UPDATE_THREADS_ON_UPDATE_TRIGGER);
        db.execSQL(PART_UPDATE_THREADS_ON_DELETE_TRIGGER);
        db.execSQL(PDU_UPDATE_THREADS_ON_UPDATE_TRIGGER);
    }

    private void createSmsTables(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE sms (_id INTEGER PRIMARY KEY,thread_id INTEGER,address TEXT,person INTEGER,date INTEGER,protocol INTEGER,read INTEGER DEFAULT 0,status INTEGER DEFAULT -1,type INTEGER,reply_path_present INTEGER,subject TEXT,body TEXT,service_center TEXT,locked INTEGER DEFAULT 0,error_code INTEGER DEFAULT 0,seen INTEGER DEFAULT 0);");
        db.execSQL("CREATE TABLE raw (_id INTEGER PRIMARY KEY,date INTEGER,reference_number INTEGER,count INTEGER,sequence INTEGER,destination_port INTEGER,address TEXT,pdu TEXT);");
        db.execSQL("CREATE TABLE attachments (sms_id INTEGER,content_url TEXT,offset INTEGER);");
        db.execSQL("CREATE TABLE sr_pending (reference_number INTEGER,action TEXT,data TEXT);");
    }

    private void createCommonTables(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE canonical_addresses (_id INTEGER PRIMARY KEY,address TEXT);");
        db.execSQL("CREATE TABLE threads (_id INTEGER PRIMARY KEY,date INTEGER DEFAULT 0,message_count INTEGER DEFAULT 0,recipient_ids TEXT,snippet TEXT,snippet_cs INTEGER DEFAULT 0,read INTEGER DEFAULT 1,type INTEGER DEFAULT 0,error INTEGER DEFAULT 0,has_attachment INTEGER DEFAULT 0);");
        db.execSQL("CREATE TABLE pending_msgs (_id INTEGER PRIMARY KEY,proto_type INTEGER,msg_id INTEGER,msg_type INTEGER,err_type INTEGER,err_code INTEGER,retry_index INTEGER NOT NULL DEFAULT 0,due_time INTEGER,last_try INTEGER);");
    }

    private void createCommonTriggers(SQLiteDatabase db) {
        db.execSQL("CREATE TRIGGER pdu_update_thread_on_insert AFTER INSERT ON pdu   WHEN new.m_type=132    OR new.m_type=130    OR new.m_type=128 BEGIN  UPDATE threads SET    date = (strftime('%s','now') * 1000),     snippet = new.sub,     snippet_cs = new.sub_cs  WHERE threads._id = new.thread_id;   UPDATE threads SET message_count =      (SELECT COUNT(sms._id) FROM sms LEFT JOIN threads       ON threads._id = thread_id      WHERE thread_id = new.thread_id        AND sms.type != 3) +      (SELECT COUNT(pdu._id) FROM pdu LEFT JOIN threads       ON threads._id = thread_id      WHERE thread_id = new.thread_id        AND (m_type=132 OR m_type=130 OR m_type=128)        AND msg_box != 3)   WHERE threads._id = new.thread_id;   UPDATE threads SET read =     CASE (SELECT COUNT(*)          FROM pdu          WHERE read = 0            AND thread_id = threads._id             AND (m_type=132 OR m_type=130 OR m_type=128))       WHEN 0 THEN 1      ELSE 0    END  WHERE threads._id = new.thread_id; END;");
        db.execSQL("CREATE TRIGGER sms_update_thread_on_insert AFTER INSERT ON sms BEGIN  UPDATE threads SET    date = (strftime('%s','now') * 1000),     snippet = new.body,     snippet_cs = 0  WHERE threads._id = new.thread_id;   UPDATE threads SET message_count =      (SELECT COUNT(sms._id) FROM sms LEFT JOIN threads       ON threads._id = thread_id      WHERE thread_id = new.thread_id        AND sms.type != 3) +      (SELECT COUNT(pdu._id) FROM pdu LEFT JOIN threads       ON threads._id = thread_id      WHERE thread_id = new.thread_id        AND (m_type=132 OR m_type=130 OR m_type=128)        AND msg_box != 3)   WHERE threads._id = new.thread_id;   UPDATE threads SET read =     CASE (SELECT COUNT(*)          FROM sms          WHERE read = 0            AND thread_id = threads._id)      WHEN 0 THEN 1      ELSE 0    END  WHERE threads._id = new.thread_id; END;");
        db.execSQL("CREATE TRIGGER pdu_update_thread_date_subject_on_update AFTER  UPDATE OF date, sub, msg_box  ON pdu   WHEN new.m_type=132    OR new.m_type=130    OR new.m_type=128 BEGIN  UPDATE threads SET    date = (strftime('%s','now') * 1000),     snippet = new.sub,     snippet_cs = new.sub_cs  WHERE threads._id = new.thread_id;   UPDATE threads SET message_count =      (SELECT COUNT(sms._id) FROM sms LEFT JOIN threads       ON threads._id = thread_id      WHERE thread_id = new.thread_id        AND sms.type != 3) +      (SELECT COUNT(pdu._id) FROM pdu LEFT JOIN threads       ON threads._id = thread_id      WHERE thread_id = new.thread_id        AND (m_type=132 OR m_type=130 OR m_type=128)        AND msg_box != 3)   WHERE threads._id = new.thread_id;   UPDATE threads SET read =     CASE (SELECT COUNT(*)          FROM pdu          WHERE read = 0            AND thread_id = threads._id             AND (m_type=132 OR m_type=130 OR m_type=128))       WHEN 0 THEN 1      ELSE 0    END  WHERE threads._id = new.thread_id; END;");
        db.execSQL("CREATE TRIGGER sms_update_thread_date_subject_on_update AFTER  UPDATE OF date, body, type  ON sms BEGIN  UPDATE threads SET    date = (strftime('%s','now') * 1000),     snippet = new.body,     snippet_cs = 0  WHERE threads._id = new.thread_id;   UPDATE threads SET message_count =      (SELECT COUNT(sms._id) FROM sms LEFT JOIN threads       ON threads._id = thread_id      WHERE thread_id = new.thread_id        AND sms.type != 3) +      (SELECT COUNT(pdu._id) FROM pdu LEFT JOIN threads       ON threads._id = thread_id      WHERE thread_id = new.thread_id        AND (m_type=132 OR m_type=130 OR m_type=128)        AND msg_box != 3)   WHERE threads._id = new.thread_id;   UPDATE threads SET read =     CASE (SELECT COUNT(*)          FROM sms          WHERE read = 0            AND thread_id = threads._id)      WHEN 0 THEN 1      ELSE 0    END  WHERE threads._id = new.thread_id; END;");
        db.execSQL("CREATE TRIGGER pdu_update_thread_read_on_update AFTER  UPDATE OF read  ON pdu   WHEN new.m_type=132    OR new.m_type=130    OR new.m_type=128 BEGIN   UPDATE threads SET read =     CASE (SELECT COUNT(*)          FROM pdu          WHERE read = 0            AND thread_id = threads._id             AND (m_type=132 OR m_type=130 OR m_type=128))       WHEN 0 THEN 1      ELSE 0    END  WHERE threads._id = new.thread_id; END;");
        db.execSQL("CREATE TRIGGER sms_update_thread_read_on_update AFTER  UPDATE OF read  ON sms BEGIN   UPDATE threads SET read =     CASE (SELECT COUNT(*)          FROM sms          WHERE read = 0            AND thread_id = threads._id)      WHEN 0 THEN 1      ELSE 0    END  WHERE threads._id = new.thread_id; END;");
        db.execSQL("CREATE TRIGGER pdu_update_thread_on_delete AFTER DELETE ON pdu BEGIN   UPDATE threads SET      date = (strftime('%s','now') * 1000)  WHERE threads._id = old.thread_id;   UPDATE threads SET message_count =      (SELECT COUNT(sms._id) FROM sms LEFT JOIN threads       ON threads._id = thread_id      WHERE thread_id = old.thread_id        AND sms.type != 3) +      (SELECT COUNT(pdu._id) FROM pdu LEFT JOIN threads       ON threads._id = thread_id      WHERE thread_id = old.thread_id        AND (m_type=132 OR m_type=130 OR m_type=128)        AND msg_box != 3)   WHERE threads._id = old.thread_id;   UPDATE threads SET snippet =    (SELECT snippet FROM     (SELECT date * 1000 AS date, sub AS snippet, thread_id FROM pdu      UNION SELECT date, body AS snippet, thread_id FROM sms)    WHERE thread_id = OLD.thread_id ORDER BY date DESC LIMIT 1)   WHERE threads._id = OLD.thread_id;   UPDATE threads SET snippet_cs =    (SELECT snippet_cs FROM     (SELECT date * 1000 AS date, sub_cs AS snippet_cs, thread_id FROM pdu      UNION SELECT date, 0 AS snippet_cs, thread_id FROM sms)    WHERE thread_id = OLD.thread_id ORDER BY date DESC LIMIT 1)   WHERE threads._id = OLD.thread_id; END;");
        db.execSQL("CREATE TRIGGER delete_obsolete_threads_pdu AFTER DELETE ON pdu BEGIN   DELETE FROM threads   WHERE     _id = old.thread_id     AND _id NOT IN     (SELECT thread_id FROM sms      UNION SELECT thread_id from pdu); END;");
        db.execSQL("CREATE TRIGGER delete_obsolete_threads_when_update_pdu AFTER UPDATE OF thread_id ON pdu WHEN old.thread_id != new.thread_id BEGIN   DELETE FROM threads   WHERE     _id = old.thread_id     AND _id NOT IN     (SELECT thread_id FROM sms      UNION SELECT thread_id from pdu); END;");
        db.execSQL("CREATE TRIGGER insert_mms_pending_on_insert AFTER INSERT ON pdu WHEN new.m_type=130  OR new.m_type=135 BEGIN   INSERT INTO pending_msgs    (proto_type,     msg_id,     msg_type,     err_type,     err_code,     retry_index,     due_time)   VALUES     (1,      new._id,      new.m_type,0,0,0,0);END;");
        db.execSQL("CREATE TRIGGER insert_mms_pending_on_update AFTER UPDATE ON pdu WHEN new.m_type=128  AND new.msg_box=4  AND old.msg_box!=4 BEGIN   INSERT INTO pending_msgs    (proto_type,     msg_id,     msg_type,     err_type,     err_code,     retry_index,     due_time)   VALUES     (1,      new._id,      new.m_type,0,0,0,0);END;");
        db.execSQL("CREATE TRIGGER delete_mms_pending_on_update AFTER UPDATE ON pdu WHEN old.msg_box=4  AND new.msg_box!=4 BEGIN   DELETE FROM pending_msgs  WHERE msg_id=new._id; END;");
        db.execSQL("CREATE TRIGGER delete_mms_pending_on_delete AFTER DELETE ON pdu BEGIN   DELETE FROM pending_msgs  WHERE msg_id=old._id; END;");
        db.execSQL("CREATE TRIGGER update_threads_error_on_update_mms   AFTER UPDATE OF err_type ON pending_msgs   WHEN (OLD.err_type < 10 AND NEW.err_type >= 10)    OR (OLD.err_type >= 10 AND NEW.err_type < 10) BEGIN  UPDATE threads SET error =     CASE      WHEN NEW.err_type >= 10 THEN error + 1      ELSE error - 1    END   WHERE _id =   (SELECT DISTINCT thread_id    FROM pdu    WHERE _id = NEW.msg_id); END;");
        db.execSQL("CREATE TRIGGER update_threads_error_on_delete_mms   BEFORE DELETE ON pdu  WHEN OLD._id IN (SELECT DISTINCT msg_id                   FROM pending_msgs                   WHERE err_type >= 10) BEGIN   UPDATE threads SET error = error - 1  WHERE _id = OLD.thread_id; END;");
        db.execSQL("CREATE TRIGGER update_threads_error_on_move_mms   BEFORE UPDATE OF msg_box ON pdu   WHEN (OLD.msg_box = 4 AND NEW.msg_box != 4)   AND (OLD._id IN (SELECT DISTINCT msg_id                   FROM pending_msgs                   WHERE err_type >= 10)) BEGIN   UPDATE threads SET error = error - 1  WHERE _id = OLD.thread_id; END;");
        db.execSQL("CREATE TRIGGER update_threads_error_on_update_sms   AFTER UPDATE OF type ON sms  WHEN (OLD.type != 5 AND NEW.type = 5)    OR (OLD.type = 5 AND NEW.type != 5) BEGIN   UPDATE threads SET error =     CASE      WHEN NEW.type = 5 THEN error + 1      ELSE error - 1    END   WHERE _id = NEW.thread_id; END;");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int currentVersion) {
        Log.w((String)TAG, (String)("Upgrading database from version " + oldVersion + " to " + currentVersion + "."));
        switch (oldVersion) {
            case 40: {
                if (currentVersion <= 40) {
                    return;
                }
                db.beginTransaction();
                try {
                    this.upgradeDatabaseToVersion41(db);
                    db.setTransactionSuccessful();
                }
                catch (Throwable ex) {
                    Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
                    break;
                }
                finally {
                    db.endTransaction();
                }
            }
            case 41: {
                if (currentVersion <= 41) {
                    return;
                }
                db.beginTransaction();
                try {
                    this.upgradeDatabaseToVersion42(db);
                    db.setTransactionSuccessful();
                }
                catch (Throwable ex) {
                    Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
                    break;
                }
                finally {
                    db.endTransaction();
                }
            }
            case 42: {
                if (currentVersion <= 42) {
                    return;
                }
                db.beginTransaction();
                try {
                    this.upgradeDatabaseToVersion43(db);
                    db.setTransactionSuccessful();
                }
                catch (Throwable ex) {
                    Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
                    break;
                }
                finally {
                    db.endTransaction();
                }
            }
            case 43: {
                if (currentVersion <= 43) {
                    return;
                }
                db.beginTransaction();
                try {
                    this.upgradeDatabaseToVersion44(db);
                    db.setTransactionSuccessful();
                }
                catch (Throwable ex) {
                    Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
                    break;
                }
                finally {
                    db.endTransaction();
                }
            }
            case 44: {
                if (currentVersion <= 44) {
                    return;
                }
                db.beginTransaction();
                try {
                    this.upgradeDatabaseToVersion45(db);
                    db.setTransactionSuccessful();
                }
                catch (Throwable ex) {
                    Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
                    break;
                }
                finally {
                    db.endTransaction();
                }
            }
            case 45: {
                if (currentVersion <= 45) {
                    return;
                }
                db.beginTransaction();
                try {
                    this.upgradeDatabaseToVersion46(db);
                    db.setTransactionSuccessful();
                }
                catch (Throwable ex) {
                    Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
                    break;
                }
                finally {
                    db.endTransaction();
                }
            }
            case 46: {
                if (currentVersion <= 46) {
                    return;
                }
                db.beginTransaction();
                try {
                    this.upgradeDatabaseToVersion47(db);
                    db.setTransactionSuccessful();
                }
                catch (Throwable ex) {
                    Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
                    break;
                }
                finally {
                    db.endTransaction();
                }
            }
            case 47: {
                if (currentVersion <= 47) {
                    return;
                }
                db.beginTransaction();
                try {
                    this.upgradeDatabaseToVersion48(db);
                    db.setTransactionSuccessful();
                }
                catch (Throwable ex) {
                    Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
                    break;
                }
                finally {
                    db.endTransaction();
                }
            }
            case 48: {
                if (currentVersion <= 48) {
                    return;
                }
                db.beginTransaction();
                try {
                    this.createWordsTables(db);
                    db.setTransactionSuccessful();
                }
                catch (Throwable ex) {
                    Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
                    break;
                }
                finally {
                    db.endTransaction();
                }
            }
            case 49: {
                if (currentVersion <= 49) {
                    return;
                }
                db.beginTransaction();
                try {
                    this.createThreadIdIndex(db);
                    db.setTransactionSuccessful();
                }
                catch (Throwable ex) {
                    Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
                    break;
                }
                finally {
                    db.endTransaction();
                }
            }
            case 50: {
                if (currentVersion <= 50) {
                    return;
                }
                db.beginTransaction();
                try {
                    this.upgradeDatabaseToVersion51(db);
                    db.setTransactionSuccessful();
                }
                catch (Throwable ex) {
                    Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
                    break;
                }
                finally {
                    db.endTransaction();
                }
            }
            case 51: {
                if (currentVersion <= 51) {
                    return;
                }
            }
            case 52: {
                if (currentVersion <= 52) {
                    return;
                }
                db.beginTransaction();
                try {
                    this.upgradeDatabaseToVersion53(db);
                    db.setTransactionSuccessful();
                }
                catch (Throwable ex) {
                    Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
                    break;
                }
                finally {
                    db.endTransaction();
                }
                return;
            }
        }
        Log.e((String)TAG, (String)"Destroying all old data.");
        this.dropAll(db);
        this.onCreate(db);
    }

    private void dropAll(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS canonical_addresses");
        db.execSQL("DROP TABLE IF EXISTS threads");
        db.execSQL("DROP TABLE IF EXISTS pending_msgs");
        db.execSQL("DROP TABLE IF EXISTS sms");
        db.execSQL("DROP TABLE IF EXISTS raw");
        db.execSQL("DROP TABLE IF EXISTS attachments");
        db.execSQL("DROP TABLE IF EXISTS thread_ids");
        db.execSQL("DROP TABLE IF EXISTS sr_pending");
        db.execSQL("DROP TABLE IF EXISTS pdu;");
        db.execSQL("DROP TABLE IF EXISTS addr;");
        db.execSQL("DROP TABLE IF EXISTS part;");
        db.execSQL("DROP TABLE IF EXISTS rate;");
        db.execSQL("DROP TABLE IF EXISTS drm;");
    }

    private void upgradeDatabaseToVersion41(SQLiteDatabase db) {
        db.execSQL("DROP TRIGGER IF EXISTS update_threads_error_on_move_mms");
        db.execSQL("CREATE TRIGGER update_threads_error_on_move_mms   BEFORE UPDATE OF msg_box ON pdu   WHEN (OLD.msg_box = 4 AND NEW.msg_box != 4)   AND (OLD._id IN (SELECT DISTINCT msg_id                   FROM pending_msgs                   WHERE err_type >= 10)) BEGIN   UPDATE threads SET error = error - 1  WHERE _id = OLD.thread_id; END;");
    }

    private void upgradeDatabaseToVersion42(SQLiteDatabase db) {
        db.execSQL("DROP TRIGGER IF EXISTS sms_update_thread_on_delete");
        db.execSQL("DROP TRIGGER IF EXISTS delete_obsolete_threads_sms");
        db.execSQL("DROP TRIGGER IF EXISTS update_threads_error_on_delete_sms");
    }

    private void upgradeDatabaseToVersion43(SQLiteDatabase db) {
        db.execSQL("ALTER TABLE threads ADD COLUMN has_attachment INTEGER DEFAULT 0");
        this.updateThreadsAttachmentColumn(db);
        db.execSQL(PART_UPDATE_THREADS_ON_INSERT_TRIGGER);
        db.execSQL(PART_UPDATE_THREADS_ON_DELETE_TRIGGER);
    }

    private void upgradeDatabaseToVersion44(SQLiteDatabase db) {
        this.updateThreadsAttachmentColumn(db);
        db.execSQL(PART_UPDATE_THREADS_ON_UPDATE_TRIGGER);
    }

    private void upgradeDatabaseToVersion45(SQLiteDatabase db) {
        db.execSQL("ALTER TABLE sms ADD COLUMN locked INTEGER DEFAULT 0");
        db.execSQL("ALTER TABLE pdu ADD COLUMN locked INTEGER DEFAULT 0");
    }

    private void upgradeDatabaseToVersion53(SQLiteDatabase db) {
        db.execSQL("DROP TRIGGER IF EXISTS pdu_update_thread_read_on_update");
        db.execSQL("CREATE TRIGGER pdu_update_thread_read_on_update AFTER  UPDATE OF read  ON pdu   WHEN new.m_type=132    OR new.m_type=130    OR new.m_type=128 BEGIN   UPDATE threads SET read =     CASE (SELECT COUNT(*)          FROM pdu          WHERE read = 0            AND thread_id = threads._id             AND (m_type=132 OR m_type=130 OR m_type=128))       WHEN 0 THEN 1      ELSE 0    END  WHERE threads._id = new.thread_id; END;");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeDatabaseToVersion46(SQLiteDatabase db) {
        db.execSQL("ALTER TABLE part ADD COLUMN text TEXT");
        Cursor textRows = db.query("part", new String[]{"_id", "_data", "text"}, "ct = 'text/plain' OR ct == 'application/smil'", null, null, null, null);
        ArrayList<String> filesToDelete = new ArrayList<String>();
        try {
            if (textRows != null) {
                int partIdColumn = textRows.getColumnIndex("_id");
                int partDataColumn = textRows.getColumnIndex("_data");
                int partTextColumn = textRows.getColumnIndex("text");
                while (textRows.moveToNext()) {
                    String path = textRows.getString(partDataColumn);
                    if (path == null) continue;
                    try {
                        FileInputStream is = new FileInputStream(path);
                        byte[] data = new byte[((InputStream)is).available()];
                        ((InputStream)is).read(data);
                        EncodedStringValue v = new EncodedStringValue(data);
                        textRows.updateString(partTextColumn, v.getString());
                        textRows.updateToNull(partDataColumn);
                        ((InputStream)is).close();
                        filesToDelete.add(path);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        finally {
            textRows.commitUpdates();
            for (String pathToDelete : filesToDelete) {
                try {
                    new File(pathToDelete).delete();
                }
                catch (SecurityException ex) {
                    Log.e((String)TAG, (String)("unable to clean up old mms file for " + pathToDelete), (Throwable)ex);
                }
            }
            if (textRows != null) {
                textRows.close();
            }
        }
    }

    private void upgradeDatabaseToVersion47(SQLiteDatabase db) {
        this.updateThreadsAttachmentColumn(db);
        db.execSQL(PDU_UPDATE_THREADS_ON_UPDATE_TRIGGER);
    }

    private void upgradeDatabaseToVersion48(SQLiteDatabase db) {
        db.execSQL("ALTER TABLE sms ADD COLUMN error_code INTEGER DEFAULT 0");
    }

    private void upgradeDatabaseToVersion51(SQLiteDatabase db) {
        db.execSQL("ALTER TABLE sms add COLUMN seen INTEGER DEFAULT 0");
        db.execSQL("ALTER TABLE pdu add COLUMN seen INTEGER DEFAULT 0");
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put("seen", Integer.valueOf(1));
            int count = db.update("sms", contentValues, "read=1", null);
            Log.d((String)TAG, (String)("[MmsSmsDb] upgradeDatabaseToVersion51: updated " + count + " rows in sms table to have READ=1"));
            count = db.update("pdu", contentValues, "read=1", null);
            Log.d((String)TAG, (String)("[MmsSmsDb] upgradeDatabaseToVersion51: updated " + count + " rows in pdu table to have READ=1"));
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"[MmsSmsDb] upgradeDatabaseToVersion51 caught ", (Throwable)ex);
        }
    }

    private void updateThreadsAttachmentColumn(SQLiteDatabase db) {
        db.execSQL("UPDATE threads SET has_attachment=1 WHERE _id IN   (SELECT DISTINCT pdu.thread_id FROM part    JOIN pdu ON pdu._id=part.mid    WHERE part.ct != 'text/plain' AND part.ct != 'application/smil')");
    }
}

