/*
 * Decompiled with CFR 0.152.
 */
package com.android.providers.telephony;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.provider.Telephony;
import android.text.TextUtils;
import android.util.Log;
import com.android.providers.telephony.MmsSmsDatabaseHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class MmsProvider
extends ContentProvider {
    static final String TABLE_PDU = "pdu";
    static final String TABLE_ADDR = "addr";
    static final String TABLE_PART = "part";
    static final String TABLE_RATE = "rate";
    static final String TABLE_DRM = "drm";
    static final String TABLE_WORDS = "words";
    private static final String TAG = "MmsProvider";
    private static final String VND_ANDROID_MMS = "vnd.android/mms";
    private static final String VND_ANDROID_DIR_MMS = "vnd.android-dir/mms";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private static final int MMS_ALL = 0;
    private static final int MMS_ALL_ID = 1;
    private static final int MMS_INBOX = 2;
    private static final int MMS_INBOX_ID = 3;
    private static final int MMS_SENT = 4;
    private static final int MMS_SENT_ID = 5;
    private static final int MMS_DRAFTS = 6;
    private static final int MMS_DRAFTS_ID = 7;
    private static final int MMS_OUTBOX = 8;
    private static final int MMS_OUTBOX_ID = 9;
    private static final int MMS_ALL_PART = 10;
    private static final int MMS_MSG_PART = 11;
    private static final int MMS_PART_ID = 12;
    private static final int MMS_MSG_ADDR = 13;
    private static final int MMS_SENDING_RATE = 14;
    private static final int MMS_REPORT_STATUS = 15;
    private static final int MMS_REPORT_REQUEST = 16;
    private static final int MMS_DRM_STORAGE = 17;
    private static final int MMS_DRM_STORAGE_ID = 18;
    private static final int MMS_THREADS = 19;
    private static final int MMS_SCRAP_SPACE = 20;
    private static final UriMatcher sURLMatcher = new UriMatcher(-1);
    private SQLiteOpenHelper mOpenHelper;

    public boolean onCreate() {
        this.mOpenHelper = MmsSmsDatabaseHelper.getInstance(this.getContext());
        return true;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        SQLiteQueryBuilder qb = new SQLiteQueryBuilder();
        int match = sURLMatcher.match(uri);
        switch (match) {
            case 0: {
                this.constructQueryForBox(qb, 0);
                break;
            }
            case 2: {
                this.constructQueryForBox(qb, 1);
                break;
            }
            case 4: {
                this.constructQueryForBox(qb, 2);
                break;
            }
            case 6: {
                this.constructQueryForBox(qb, 3);
                break;
            }
            case 8: {
                this.constructQueryForBox(qb, 4);
                break;
            }
            case 1: {
                qb.setTables(TABLE_PDU);
                qb.appendWhere((CharSequence)("_id=" + (String)uri.getPathSegments().get(0)));
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                qb.setTables(TABLE_PDU);
                qb.appendWhere((CharSequence)("_id=" + (String)uri.getPathSegments().get(1)));
                qb.appendWhere((CharSequence)(" AND msg_box=" + this.getMessageBoxByMatch(match)));
                break;
            }
            case 10: {
                qb.setTables(TABLE_PART);
                break;
            }
            case 11: {
                qb.setTables(TABLE_PART);
                qb.appendWhere((CharSequence)("mid=" + (String)uri.getPathSegments().get(0)));
                break;
            }
            case 12: {
                qb.setTables(TABLE_PART);
                qb.appendWhere((CharSequence)("_id=" + (String)uri.getPathSegments().get(1)));
                break;
            }
            case 13: {
                qb.setTables(TABLE_ADDR);
                qb.appendWhere((CharSequence)("msg_id=" + (String)uri.getPathSegments().get(0)));
                break;
            }
            case 15: {
                qb.setTables("addr INNER JOIN (SELECT P1._id AS id1, P2._id AS id2, P3._id AS id3, ifnull(P2.st, 0) AS delivery_status, ifnull(P3.read_status, 0) AS read_status FROM pdu P1 INNER JOIN pdu P2 ON P1.m_id=P2.m_id AND P2.m_type=134 LEFT JOIN pdu P3 ON P1.m_id=P3.m_id AND P3.m_type=136 UNION SELECT P1._id AS id1, P2._id AS id2, P3._id AS id3, ifnull(P2.st, 0) AS delivery_status, ifnull(P3.read_status, 0) AS read_status FROM pdu P1 INNER JOIN pdu P3 ON P1.m_id=P3.m_id AND P3.m_type=136 LEFT JOIN pdu P2 ON P1.m_id=P2.m_id AND P2.m_type=134) T ON (msg_id=id2 AND type=151) OR (msg_id=id3 AND type=137)");
                qb.appendWhere((CharSequence)("T.id1 = " + uri.getLastPathSegment()));
                qb.setDistinct(true);
                break;
            }
            case 16: {
                qb.setTables("addr join pdu on pdu._id = addr.msg_id");
                qb.appendWhere((CharSequence)("pdu._id = " + uri.getLastPathSegment()));
                qb.appendWhere((CharSequence)" AND addr.type = 151");
                break;
            }
            case 14: {
                qb.setTables(TABLE_RATE);
                break;
            }
            case 18: {
                qb.setTables(TABLE_DRM);
                qb.appendWhere((CharSequence)("_id=" + uri.getLastPathSegment()));
                break;
            }
            case 19: {
                qb.setTables("pdu group by thread_id");
                break;
            }
            default: {
                Log.e((String)TAG, (String)("query: invalid request: " + uri));
                return null;
            }
        }
        String finalSortOrder = null;
        if (TextUtils.isEmpty((CharSequence)sortOrder)) {
            if (qb.getTables().equals(TABLE_PDU)) {
                finalSortOrder = "date DESC";
            } else if (qb.getTables().equals(TABLE_PART)) {
                finalSortOrder = "seq";
            }
        } else {
            finalSortOrder = sortOrder;
        }
        SQLiteDatabase db = this.mOpenHelper.getReadableDatabase();
        Cursor ret = qb.query(db, projection, selection, selectionArgs, null, null, finalSortOrder);
        ret.setNotificationUri(this.getContext().getContentResolver(), uri);
        return ret;
    }

    private void constructQueryForBox(SQLiteQueryBuilder qb, int msgBox) {
        qb.setTables(TABLE_PDU);
        if (msgBox != 0) {
            qb.appendWhere((CharSequence)("msg_box=" + msgBox));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getType(Uri uri) {
        int match = sURLMatcher.match(uri);
        switch (match) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                return VND_ANDROID_DIR_MMS;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                return VND_ANDROID_MMS;
            }
            case 12: {
                Cursor cursor = this.mOpenHelper.getReadableDatabase().query(TABLE_PART, new String[]{"ct"}, "_id = ?", new String[]{uri.getLastPathSegment()}, null, null, null);
                if (cursor != null) {
                    try {
                        if (cursor.getCount() == 1 && cursor.moveToFirst()) {
                            String string2 = cursor.getString(0);
                            return string2;
                        }
                        Log.e((String)TAG, (String)("cursor.count() != 1: " + uri));
                    }
                    finally {
                        cursor.close();
                    }
                } else {
                    Log.e((String)TAG, (String)("cursor == null: " + uri));
                }
                return "*/*";
            }
        }
        return "*/*";
    }

    public Uri insert(Uri uri, ContentValues values) {
        int msgBox = 0;
        boolean notify = true;
        int match = sURLMatcher.match(uri);
        String table = TABLE_PDU;
        switch (match) {
            case 0: {
                Integer msgBoxObj = values.getAsInteger("msg_box");
                if (msgBoxObj != null) {
                    msgBox = msgBoxObj;
                    break;
                }
                msgBox = 1;
                break;
            }
            case 2: {
                msgBox = 1;
                break;
            }
            case 4: {
                msgBox = 2;
                break;
            }
            case 6: {
                msgBox = 3;
                break;
            }
            case 8: {
                msgBox = 4;
                break;
            }
            case 11: {
                notify = false;
                table = TABLE_PART;
                break;
            }
            case 13: {
                notify = false;
                table = TABLE_ADDR;
                break;
            }
            case 14: {
                notify = false;
                table = TABLE_RATE;
                break;
            }
            case 17: {
                notify = false;
                table = TABLE_DRM;
                break;
            }
            default: {
                Log.e((String)TAG, (String)("insert: invalid request: " + uri));
                return null;
            }
        }
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        Uri res = Telephony.Mms.CONTENT_URI;
        if (table.equals(TABLE_PDU)) {
            long rowId;
            boolean addDate = !values.containsKey("date");
            boolean addMsgBox = !values.containsKey("msg_box");
            this.filterUnsupportedKeys(values);
            ContentValues finalValues = new ContentValues(values);
            long timeInMillis = System.currentTimeMillis();
            if (addDate) {
                finalValues.put("date", Long.valueOf(timeInMillis / 1000L));
            }
            if (addMsgBox && msgBox != 0) {
                finalValues.put("msg_box", Integer.valueOf(msgBox));
            }
            if (msgBox != 1) {
                finalValues.put("read", Integer.valueOf(1));
            }
            Long threadId = values.getAsLong("thread_id");
            String address = values.getAsString("address");
            if ((threadId == null || threadId == 0L) && address != null) {
                finalValues.put("thread_id", Long.valueOf(Telephony.Threads.getOrCreateThreadId((Context)this.getContext(), (String)address)));
            }
            if ((rowId = db.insert(table, null, finalValues)) <= 0L) {
                Log.e((String)TAG, (String)("MmsProvider.insert: failed! " + finalValues));
                return null;
            }
            res = Uri.parse((String)(res + "/" + rowId));
        } else if (table.equals(TABLE_ADDR)) {
            ContentValues finalValues = new ContentValues(values);
            finalValues.put("msg_id", (String)uri.getPathSegments().get(0));
            long rowId = db.insert(table, null, finalValues);
            if (rowId <= 0L) {
                Log.e((String)TAG, (String)("Failed to insert address: " + finalValues));
                return null;
            }
            res = Uri.parse((String)(res + "/addr/" + rowId));
        } else if (table.equals(TABLE_PART)) {
            long rowId;
            ContentValues finalValues = new ContentValues(values);
            if (match == 11) {
                finalValues.put("mid", (String)uri.getPathSegments().get(0));
            }
            String contentType = values.getAsString("ct");
            boolean plainText = "text/plain".equals(contentType);
            boolean smilText = "application/smil".equals(contentType);
            if (!plainText && !smilText) {
                String path = this.getContext().getDir("parts", 0).getPath() + "/PART_" + System.currentTimeMillis();
                finalValues.put("_data", path);
                File partFile = new File(path);
                if (!partFile.exists()) {
                    try {
                        if (!partFile.createNewFile()) {
                            throw new IllegalStateException("Unable to create new partFile: " + path);
                        }
                    }
                    catch (IOException e) {
                        Log.e((String)TAG, (String)"createNewFile", (Throwable)e);
                        throw new IllegalStateException("Unable to create new partFile: " + path);
                    }
                }
            }
            if ((rowId = db.insert(table, null, finalValues)) <= 0L) {
                Log.e((String)TAG, (String)("MmsProvider.insert: failed! " + finalValues));
                return null;
            }
            res = Uri.parse((String)(res + "/part/" + rowId));
            if (plainText) {
                ContentValues cv = new ContentValues();
                cv.put("_id", Long.valueOf(2L + rowId));
                cv.put("index_text", values.getAsString("text"));
                cv.put("source_id", Long.valueOf(rowId));
                cv.put("table_to_use", Integer.valueOf(2));
                db.insert(TABLE_WORDS, "index_text", cv);
            }
        } else if (table.equals(TABLE_RATE)) {
            long now = values.getAsLong("sent_time");
            long oneHourAgo = now - 3600000L;
            db.delete(table, "sent_time<=" + oneHourAgo, null);
            db.insert(table, null, values);
        } else if (table.equals(TABLE_DRM)) {
            long rowId;
            String path = this.getContext().getDir("parts", 0).getPath() + "/PART_" + System.currentTimeMillis();
            ContentValues finalValues = new ContentValues(1);
            finalValues.put("_data", path);
            File partFile = new File(path);
            if (!partFile.exists()) {
                try {
                    if (!partFile.createNewFile()) {
                        throw new IllegalStateException("Unable to create new file: " + path);
                    }
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"createNewFile", (Throwable)e);
                    throw new IllegalStateException("Unable to create new file: " + path);
                }
            }
            if ((rowId = db.insert(table, null, finalValues)) <= 0L) {
                Log.e((String)TAG, (String)("MmsProvider.insert: failed! " + finalValues));
                return null;
            }
            res = Uri.parse((String)(res + "/drm/" + rowId));
        } else {
            throw new AssertionError((Object)("Unknown table type: " + table));
        }
        if (notify) {
            this.notifyChange();
        }
        return res;
    }

    private int getMessageBoxByMatch(int match) {
        switch (match) {
            case 2: 
            case 3: {
                return 1;
            }
            case 4: 
            case 5: {
                return 2;
            }
            case 6: 
            case 7: {
                return 3;
            }
            case 8: 
            case 9: {
                return 4;
            }
        }
        throw new IllegalArgumentException("bad Arg: " + match);
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        String table;
        int match = sURLMatcher.match(uri);
        String extraSelection = null;
        boolean notify = false;
        switch (match) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                notify = true;
                table = TABLE_PDU;
                extraSelection = "_id=" + uri.getLastPathSegment();
                break;
            }
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                notify = true;
                table = TABLE_PDU;
                if (match == 0) break;
                int msgBox = this.getMessageBoxByMatch(match);
                extraSelection = "msg_box=" + msgBox;
                break;
            }
            case 10: {
                table = TABLE_PART;
                break;
            }
            case 11: {
                table = TABLE_PART;
                extraSelection = "mid=" + (String)uri.getPathSegments().get(0);
                break;
            }
            case 12: {
                table = TABLE_PART;
                extraSelection = "_id=" + (String)uri.getPathSegments().get(1);
                break;
            }
            case 13: {
                table = TABLE_ADDR;
                extraSelection = "msg_id=" + (String)uri.getPathSegments().get(0);
                break;
            }
            case 17: {
                table = TABLE_DRM;
                break;
            }
            default: {
                Log.w((String)TAG, (String)("No match for URI '" + uri + "'"));
                return 0;
            }
        }
        String finalSelection = MmsProvider.concatSelections(selection, extraSelection);
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        int deletedRows = 0;
        deletedRows = TABLE_PDU.equals(table) ? MmsProvider.deleteMessages(this.getContext(), db, finalSelection, selectionArgs, uri) : (TABLE_PART.equals(table) ? MmsProvider.deleteParts(db, finalSelection, selectionArgs) : (TABLE_DRM.equals(table) ? MmsProvider.deleteTempDrmData(db, finalSelection, selectionArgs) : db.delete(table, finalSelection, selectionArgs)));
        if (deletedRows > 0 && notify) {
            this.notifyChange();
        }
        return deletedRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int deleteMessages(Context context, SQLiteDatabase db, String selection, String[] selectionArgs, Uri uri) {
        Cursor cursor = db.query(TABLE_PDU, new String[]{"_id"}, selection, selectionArgs, null, null, null);
        if (cursor == null) {
            return 0;
        }
        try {
            if (cursor.getCount() == 0) {
                int n = 0;
                return n;
            }
            while (cursor.moveToNext()) {
                MmsProvider.deleteParts(db, "mid = ?", new String[]{String.valueOf(cursor.getLong(0))});
            }
        }
        finally {
            cursor.close();
        }
        int count = db.delete(TABLE_PDU, selection, selectionArgs);
        if (count > 0) {
            Intent intent = new Intent("android.intent.action.CONTENT_CHANGED");
            intent.putExtra("deleted_contents", (Parcelable)uri);
            context.sendBroadcast(intent);
        }
        return count;
    }

    private static int deleteParts(SQLiteDatabase db, String selection, String[] selectionArgs) {
        return MmsProvider.deleteDataRows(db, TABLE_PART, selection, selectionArgs);
    }

    private static int deleteTempDrmData(SQLiteDatabase db, String selection, String[] selectionArgs) {
        return MmsProvider.deleteDataRows(db, TABLE_DRM, selection, selectionArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int deleteDataRows(SQLiteDatabase db, String table, String selection, String[] selectionArgs) {
        Cursor cursor = db.query(table, new String[]{"_data"}, selection, selectionArgs, null, null, null);
        if (cursor == null) {
            return 0;
        }
        try {
            if (cursor.getCount() == 0) {
                int n = 0;
                return n;
            }
            while (cursor.moveToNext()) {
                try {
                    String path = cursor.getString(0);
                    if (path == null) continue;
                    new File(path).delete();
                }
                catch (Throwable ex) {
                    Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        finally {
            cursor.close();
        }
        return db.delete(table, selection, selectionArgs);
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        ContentValues finalValues;
        String table;
        int match = sURLMatcher.match(uri);
        boolean notify = false;
        String msgId = null;
        switch (match) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                msgId = uri.getLastPathSegment();
            }
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                notify = true;
                table = TABLE_PDU;
                break;
            }
            case 11: 
            case 12: {
                table = TABLE_PART;
                break;
            }
            default: {
                Log.w((String)TAG, (String)("Update operation for '" + uri + "' not implemented."));
                return 0;
            }
        }
        String extraSelection = null;
        if (table.equals(TABLE_PDU)) {
            this.filterUnsupportedKeys(values);
            finalValues = new ContentValues(values);
            if (msgId != null) {
                extraSelection = "_id=" + msgId;
            }
        } else if (table.equals(TABLE_PART)) {
            finalValues = new ContentValues(values);
            switch (match) {
                case 11: {
                    extraSelection = "mid=" + (String)uri.getPathSegments().get(0);
                    break;
                }
                case 12: {
                    extraSelection = "_id=" + (String)uri.getPathSegments().get(1);
                    break;
                }
            }
        } else {
            return 0;
        }
        String finalSelection = MmsProvider.concatSelections(selection, extraSelection);
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        int count = db.update(table, finalValues, finalSelection, selectionArgs);
        if (notify && count > 0) {
            this.notifyChange();
        }
        return count;
    }

    private ParcelFileDescriptor getTempStoreFd() {
        String fileName = "/sdcard/mms/scrapSpace/.temp.jpg";
        ParcelFileDescriptor pfd = null;
        try {
            File file = new File(fileName);
            File parentFile = file.getParentFile();
            if (!parentFile.exists() && !parentFile.mkdirs()) {
                Log.e((String)TAG, (String)("[MmsProvider] getTempStoreFd: " + parentFile.getPath() + "does not exist!"));
                return null;
            }
            pfd = ParcelFileDescriptor.open((File)file, (int)0x38000000);
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("getTempStoreFd: error creating pfd for " + fileName), (Throwable)ex);
        }
        return pfd;
    }

    public ParcelFileDescriptor openFile(Uri uri, String mode) throws FileNotFoundException {
        ParcelFileDescriptor fd;
        int match = sURLMatcher.match(uri);
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.d((String)TAG, (String)("openFile: uri=" + uri + ", mode=" + mode));
        }
        switch (match) {
            case 20: {
                fd = this.getTempStoreFd();
                break;
            }
            default: {
                fd = this.openFileHelper(uri, mode);
            }
        }
        return fd;
    }

    private void filterUnsupportedKeys(ContentValues values) {
        values.remove("d_tm_tok");
        values.remove("s_vis");
        values.remove("r_chg");
        values.remove("r_chg_dl_tok");
        values.remove("r_chg_dl");
        values.remove("r_chg_id");
        values.remove("r_chg_sz");
        values.remove("p_s_by");
        values.remove("p_s_d");
        values.remove("store");
        values.remove("mm_st");
        values.remove("mm_flg_tok");
        values.remove("mm_flg");
        values.remove("store_st");
        values.remove("store_st_txt");
        values.remove("stored");
        values.remove("totals");
        values.remove("mb_t");
        values.remove("mb_t_tok");
        values.remove("qt");
        values.remove("mb_qt");
        values.remove("mb_qt_tok");
        values.remove("m_cnt");
        values.remove("start");
        values.remove("d_ind");
        values.remove("e_des");
        values.remove("limit");
        values.remove("r_r_mod");
        values.remove("r_r_mod_txt");
        values.remove("st_txt");
        values.remove("apl_id");
        values.remove("r_apl_id");
        values.remove("aux_apl_id");
        values.remove("drm_c");
        values.remove("adp_a");
        values.remove("repl_id");
        values.remove("cl_id");
        values.remove("cl_st");
        values.remove("_id");
    }

    private void notifyChange() {
        this.getContext().getContentResolver().notifyChange(Telephony.MmsSms.CONTENT_URI, null);
    }

    private static String concatSelections(String selection1, String selection2) {
        if (TextUtils.isEmpty((CharSequence)selection1)) {
            return selection2;
        }
        if (TextUtils.isEmpty((CharSequence)selection2)) {
            return selection1;
        }
        return selection1 + " AND " + selection2;
    }

    static {
        sURLMatcher.addURI("mms", null, 0);
        sURLMatcher.addURI("mms", "#", 1);
        sURLMatcher.addURI("mms", "inbox", 2);
        sURLMatcher.addURI("mms", "inbox/#", 3);
        sURLMatcher.addURI("mms", "sent", 4);
        sURLMatcher.addURI("mms", "sent/#", 5);
        sURLMatcher.addURI("mms", "drafts", 6);
        sURLMatcher.addURI("mms", "drafts/#", 7);
        sURLMatcher.addURI("mms", "outbox", 8);
        sURLMatcher.addURI("mms", "outbox/#", 9);
        sURLMatcher.addURI("mms", TABLE_PART, 10);
        sURLMatcher.addURI("mms", "#/part", 11);
        sURLMatcher.addURI("mms", "part/#", 12);
        sURLMatcher.addURI("mms", "#/addr", 13);
        sURLMatcher.addURI("mms", TABLE_RATE, 14);
        sURLMatcher.addURI("mms", "report-status/#", 15);
        sURLMatcher.addURI("mms", "report-request/#", 16);
        sURLMatcher.addURI("mms", TABLE_DRM, 17);
        sURLMatcher.addURI("mms", "drm/#", 18);
        sURLMatcher.addURI("mms", "threads", 19);
        sURLMatcher.addURI("mms", "scrapSpace", 20);
    }
}

