/*
 * Decompiled with CFR 0.152.
 */
package com.example.android.snake;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import com.example.android.snake.R;

public class TileView
extends View {
    protected static int mTileSize;
    protected static int mXTileCount;
    protected static int mYTileCount;
    private static int mXOffset;
    private static int mYOffset;
    private Bitmap[] mTileArray;
    private int[][] mTileGrid;
    private final Paint mPaint = new Paint();

    public TileView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TileView);
        mTileSize = a.getInt(0, 12);
        a.recycle();
    }

    public TileView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TileView);
        mTileSize = a.getInt(0, 12);
        a.recycle();
    }

    public void resetTiles(int tilecount) {
        this.mTileArray = new Bitmap[tilecount];
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        mXTileCount = (int)Math.floor(w / mTileSize);
        mYTileCount = (int)Math.floor(h / mTileSize);
        mXOffset = (w - mTileSize * mXTileCount) / 2;
        mYOffset = (h - mTileSize * mYTileCount) / 2;
        this.mTileGrid = new int[mXTileCount][mYTileCount];
        this.clearTiles();
    }

    public void loadTile(int key, Drawable tile) {
        Bitmap bitmap = Bitmap.createBitmap((int)mTileSize, (int)mTileSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        tile.setBounds(0, 0, mTileSize, mTileSize);
        tile.draw(canvas);
        this.mTileArray[key] = bitmap;
    }

    public void clearTiles() {
        for (int x = 0; x < mXTileCount; ++x) {
            for (int y = 0; y < mYTileCount; ++y) {
                this.setTile(0, x, y);
            }
        }
    }

    public void setTile(int tileindex, int x, int y) {
        this.mTileGrid[x][y] = tileindex;
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (int x = 0; x < mXTileCount; ++x) {
            for (int y = 0; y < mYTileCount; ++y) {
                if (this.mTileGrid[x][y] <= 0) continue;
                canvas.drawBitmap(this.mTileArray[this.mTileGrid[x][y]], (float)(mXOffset + x * mTileSize), (float)(mYOffset + y * mTileSize), this.mPaint);
            }
        }
    }
}

