/*
 * Decompiled with CFR 0.152.
 */
package com.example.android.snake;

import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.widget.TextView;
import com.example.android.snake.TileView;
import java.util.ArrayList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnakeView
extends TileView {
    private static final String TAG = "SnakeView";
    private int mMode = 1;
    public static final int PAUSE = 0;
    public static final int READY = 1;
    public static final int RUNNING = 2;
    public static final int LOSE = 3;
    private int mDirection = 1;
    private int mNextDirection = 1;
    private static final int NORTH = 1;
    private static final int SOUTH = 2;
    private static final int EAST = 3;
    private static final int WEST = 4;
    private static final int RED_STAR = 1;
    private static final int YELLOW_STAR = 2;
    private static final int GREEN_STAR = 3;
    private long mScore = 0L;
    private long mMoveDelay = 600L;
    private long mLastMove;
    private TextView mStatusText;
    private ArrayList<Coordinate> mSnakeTrail = new ArrayList();
    private ArrayList<Coordinate> mAppleList = new ArrayList();
    private static final Random RNG = new Random();
    private RefreshHandler mRedrawHandler = new RefreshHandler();

    public SnakeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initSnakeView();
    }

    public SnakeView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initSnakeView();
    }

    private void initSnakeView() {
        this.setFocusable(true);
        Resources r = this.getContext().getResources();
        this.resetTiles(4);
        this.loadTile(1, r.getDrawable(2130837505));
        this.loadTile(2, r.getDrawable(2130837506));
        this.loadTile(3, r.getDrawable(2130837504));
    }

    private void initNewGame() {
        this.mSnakeTrail.clear();
        this.mAppleList.clear();
        this.mSnakeTrail.add(new Coordinate(7, 7));
        this.mSnakeTrail.add(new Coordinate(6, 7));
        this.mSnakeTrail.add(new Coordinate(5, 7));
        this.mSnakeTrail.add(new Coordinate(4, 7));
        this.mSnakeTrail.add(new Coordinate(3, 7));
        this.mSnakeTrail.add(new Coordinate(2, 7));
        this.mNextDirection = 1;
        this.addRandomApple();
        this.addRandomApple();
        this.mMoveDelay = 600L;
        this.mScore = 0L;
    }

    private int[] coordArrayListToArray(ArrayList<Coordinate> cvec) {
        int count = cvec.size();
        int[] rawArray = new int[count * 2];
        for (int index = 0; index < count; ++index) {
            Coordinate c = cvec.get(index);
            rawArray[2 * index] = c.x;
            rawArray[2 * index + 1] = c.y;
        }
        return rawArray;
    }

    public Bundle saveState() {
        Bundle map = new Bundle();
        map.putIntArray("mAppleList", this.coordArrayListToArray(this.mAppleList));
        map.putInt("mDirection", Integer.valueOf(this.mDirection).intValue());
        map.putInt("mNextDirection", Integer.valueOf(this.mNextDirection).intValue());
        map.putLong("mMoveDelay", Long.valueOf(this.mMoveDelay).longValue());
        map.putLong("mScore", Long.valueOf(this.mScore).longValue());
        map.putIntArray("mSnakeTrail", this.coordArrayListToArray(this.mSnakeTrail));
        return map;
    }

    private ArrayList<Coordinate> coordArrayToArrayList(int[] rawArray) {
        ArrayList<Coordinate> coordArrayList = new ArrayList<Coordinate>();
        int coordCount = rawArray.length;
        for (int index = 0; index < coordCount; index += 2) {
            Coordinate c = new Coordinate(rawArray[index], rawArray[index + 1]);
            coordArrayList.add(c);
        }
        return coordArrayList;
    }

    public void restoreState(Bundle icicle) {
        this.setMode(0);
        this.mAppleList = this.coordArrayToArrayList(icicle.getIntArray("mAppleList"));
        this.mDirection = icicle.getInt("mDirection");
        this.mNextDirection = icicle.getInt("mNextDirection");
        this.mMoveDelay = icicle.getLong("mMoveDelay");
        this.mScore = icicle.getLong("mScore");
        this.mSnakeTrail = this.coordArrayToArrayList(icicle.getIntArray("mSnakeTrail"));
    }

    public boolean onKeyDown(int keyCode, KeyEvent msg) {
        if (keyCode == 19) {
            if (this.mMode == 1 | this.mMode == 3) {
                this.initNewGame();
                this.setMode(2);
                this.update();
                return true;
            }
            if (this.mMode == 0) {
                this.setMode(2);
                this.update();
                return true;
            }
            if (this.mDirection != 2) {
                this.mNextDirection = 1;
            }
            return true;
        }
        if (keyCode == 20) {
            if (this.mDirection != 1) {
                this.mNextDirection = 2;
            }
            return true;
        }
        if (keyCode == 21) {
            if (this.mDirection != 3) {
                this.mNextDirection = 4;
            }
            return true;
        }
        if (keyCode == 22) {
            if (this.mDirection != 4) {
                this.mNextDirection = 3;
            }
            return true;
        }
        return super.onKeyDown(keyCode, msg);
    }

    public void setTextView(TextView newView) {
        this.mStatusText = newView;
    }

    public void setMode(int newMode) {
        int oldMode = this.mMode;
        this.mMode = newMode;
        if (newMode == 2 & oldMode != 2) {
            this.mStatusText.setVisibility(4);
            this.update();
            return;
        }
        Resources res = this.getContext().getResources();
        CharSequence str = "";
        if (newMode == 0) {
            str = res.getText(2130968577);
        }
        if (newMode == 1) {
            str = res.getText(2130968576);
        }
        if (newMode == 3) {
            str = res.getString(2130968578) + this.mScore + res.getString(2130968579);
        }
        this.mStatusText.setText(str);
        this.mStatusText.setVisibility(0);
    }

    private void addRandomApple() {
        Coordinate newCoord = null;
        boolean found = false;
        while (!found) {
            int newX = 1 + RNG.nextInt(mXTileCount - 2);
            int newY = 1 + RNG.nextInt(mYTileCount - 2);
            newCoord = new Coordinate(newX, newY);
            boolean collision = false;
            int snakelength = this.mSnakeTrail.size();
            for (int index = 0; index < snakelength; ++index) {
                if (!this.mSnakeTrail.get(index).equals(newCoord)) continue;
                collision = true;
            }
            found = !collision;
        }
        if (newCoord == null) {
            Log.e((String)TAG, (String)"Somehow ended up with a null newCoord!");
        }
        this.mAppleList.add(newCoord);
    }

    public void update() {
        if (this.mMode == 2) {
            long now = System.currentTimeMillis();
            if (now - this.mLastMove > this.mMoveDelay) {
                this.clearTiles();
                this.updateWalls();
                this.updateSnake();
                this.updateApples();
                this.mLastMove = now;
            }
            this.mRedrawHandler.sleep(this.mMoveDelay);
        }
    }

    private void updateWalls() {
        for (int x = 0; x < mXTileCount; ++x) {
            this.setTile(3, x, 0);
            this.setTile(3, x, mYTileCount - 1);
        }
        for (int y = 1; y < mYTileCount - 1; ++y) {
            this.setTile(3, 0, y);
            this.setTile(3, mXTileCount - 1, y);
        }
    }

    private void updateApples() {
        for (Coordinate c : this.mAppleList) {
            this.setTile(2, c.x, c.y);
        }
    }

    private void updateSnake() {
        boolean growSnake = false;
        Coordinate head = this.mSnakeTrail.get(0);
        Coordinate newHead = new Coordinate(1, 1);
        this.mDirection = this.mNextDirection;
        switch (this.mDirection) {
            case 3: {
                newHead = new Coordinate(head.x + 1, head.y);
                break;
            }
            case 4: {
                newHead = new Coordinate(head.x - 1, head.y);
                break;
            }
            case 1: {
                newHead = new Coordinate(head.x, head.y - 1);
                break;
            }
            case 2: {
                newHead = new Coordinate(head.x, head.y + 1);
            }
        }
        if (newHead.x < 1 || newHead.y < 1 || newHead.x > mXTileCount - 2 || newHead.y > mYTileCount - 2) {
            this.setMode(3);
            return;
        }
        int snakelength = this.mSnakeTrail.size();
        for (int snakeindex = 0; snakeindex < snakelength; ++snakeindex) {
            Coordinate c = this.mSnakeTrail.get(snakeindex);
            if (!c.equals(newHead)) continue;
            this.setMode(3);
            return;
        }
        int applecount = this.mAppleList.size();
        for (int appleindex = 0; appleindex < applecount; ++appleindex) {
            Coordinate c = this.mAppleList.get(appleindex);
            if (!c.equals(newHead)) continue;
            this.mAppleList.remove(c);
            this.addRandomApple();
            ++this.mScore;
            this.mMoveDelay = (long)((double)this.mMoveDelay * 0.9);
            growSnake = true;
        }
        this.mSnakeTrail.add(0, newHead);
        if (!growSnake) {
            this.mSnakeTrail.remove(this.mSnakeTrail.size() - 1);
        }
        int index = 0;
        for (Coordinate c : this.mSnakeTrail) {
            if (index == 0) {
                this.setTile(2, c.x, c.y);
            } else {
                this.setTile(1, c.x, c.y);
            }
            ++index;
        }
    }

    private class Coordinate {
        public int x;
        public int y;

        public Coordinate(int newX, int newY) {
            this.x = newX;
            this.y = newY;
        }

        public boolean equals(Coordinate other) {
            return this.x == other.x && this.y == other.y;
        }

        public String toString() {
            return "Coordinate: [" + this.x + "," + this.y + "]";
        }
    }

    class RefreshHandler
    extends Handler {
        RefreshHandler() {
        }

        public void handleMessage(Message msg) {
            SnakeView.this.update();
            SnakeView.this.invalidate();
        }

        public void sleep(long delayMillis) {
            this.removeMessages(0);
            this.sendMessageDelayed(this.obtainMessage(0), delayMillis);
        }
    }
}

