/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.wifi;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.NetworkInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.android.settings.wifi.Summary;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public class WifiStatusTest
extends Activity {
    private static final String TAG = "WifiStatusTest";
    private Button updateButton;
    private TextView mWifiState;
    private TextView mNetworkState;
    private TextView mSupplicantState;
    private TextView mRSSI;
    private TextView mBSSID;
    private TextView mSSID;
    private TextView mHiddenSSID;
    private TextView mIPAddr;
    private TextView mMACAddr;
    private TextView mNetworkId;
    private TextView mLinkSpeed;
    private TextView mScanList;
    private TextView mPingIpAddr;
    private TextView mPingHostname;
    private TextView mHttpClientTest;
    private Button pingTestButton;
    private String mPingIpAddrResult;
    private String mPingHostnameResult;
    private String mHttpClientTestResult;
    private WifiManager mWifiManager;
    private IntentFilter mWifiStateFilter;
    private final BroadcastReceiver mWifiStateReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.net.wifi.WIFI_STATE_CHANGED")) {
                WifiStatusTest.this.handleWifiStateChanged(intent.getIntExtra("wifi_state", 4));
            } else if (intent.getAction().equals("android.net.wifi.STATE_CHANGE")) {
                WifiStatusTest.this.handleNetworkStateChanged((NetworkInfo)intent.getParcelableExtra("networkInfo"));
            } else if (intent.getAction().equals("android.net.wifi.SCAN_RESULTS")) {
                WifiStatusTest.this.handleScanResultsAvailable();
            } else if (!intent.getAction().equals("android.net.wifi.supplicant.CONNECTION_CHANGE")) {
                if (intent.getAction().equals("android.net.wifi.supplicant.STATE_CHANGE")) {
                    WifiStatusTest.this.handleSupplicantStateChanged((SupplicantState)intent.getParcelableExtra("newState"), intent.hasExtra("supplicantError"), intent.getIntExtra("supplicantError", 0));
                } else if (intent.getAction().equals("android.net.wifi.RSSI_CHANGED")) {
                    WifiStatusTest.this.handleSignalChanged(intent.getIntExtra("newRssi", 0));
                } else if (!intent.getAction().equals("android.net.wifi.NETWORK_IDS_CHANGED")) {
                    Log.e((String)WifiStatusTest.TAG, (String)"Received an unknown Wifi Intent");
                }
            }
        }
    };
    View.OnClickListener mPingButtonHandler = new View.OnClickListener(){

        public void onClick(View v) {
            WifiStatusTest.this.updatePingState();
        }
    };
    View.OnClickListener updateButtonHandler = new View.OnClickListener(){

        public void onClick(View v) {
            WifiInfo wifiInfo = WifiStatusTest.this.mWifiManager.getConnectionInfo();
            WifiStatusTest.this.setWifiStateText(WifiStatusTest.this.mWifiManager.getWifiState());
            WifiStatusTest.this.mBSSID.setText((CharSequence)wifiInfo.getBSSID());
            WifiStatusTest.this.mHiddenSSID.setText((CharSequence)String.valueOf(wifiInfo.getHiddenSSID()));
            int ipAddr = wifiInfo.getIpAddress();
            StringBuffer ipBuf = new StringBuffer();
            StringBuffer stringBuffer = ipBuf.append(ipAddr & 0xFF).append('.');
            int n = ipAddr >>> 8;
            ipAddr = n;
            ipAddr = ipAddr >>> 8;
            stringBuffer.append(n & 0xFF).append('.').append(ipAddr & 0xFF).append('.').append((ipAddr >>>= 8) & 0xFF);
            WifiStatusTest.this.mIPAddr.setText((CharSequence)ipBuf);
            WifiStatusTest.this.mLinkSpeed.setText((CharSequence)(String.valueOf(wifiInfo.getLinkSpeed()) + " Mbps"));
            WifiStatusTest.this.mMACAddr.setText((CharSequence)wifiInfo.getMacAddress());
            WifiStatusTest.this.mNetworkId.setText((CharSequence)String.valueOf(wifiInfo.getNetworkId()));
            WifiStatusTest.this.mRSSI.setText((CharSequence)String.valueOf(wifiInfo.getRssi()));
            WifiStatusTest.this.mSSID.setText((CharSequence)wifiInfo.getSSID());
            SupplicantState supplicantState = wifiInfo.getSupplicantState();
            WifiStatusTest.this.setSupplicantStateText(supplicantState);
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mWifiManager = (WifiManager)this.getSystemService("wifi");
        this.mWifiStateFilter = new IntentFilter("android.net.wifi.WIFI_STATE_CHANGED");
        this.mWifiStateFilter.addAction("android.net.wifi.STATE_CHANGE");
        this.mWifiStateFilter.addAction("android.net.wifi.SCAN_RESULTS");
        this.mWifiStateFilter.addAction("android.net.wifi.supplicant.STATE_CHANGE");
        this.mWifiStateFilter.addAction("android.net.wifi.RSSI_CHANGED");
        this.mWifiStateFilter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
        this.registerReceiver(this.mWifiStateReceiver, this.mWifiStateFilter);
        this.setContentView(2130903109);
        this.updateButton = (Button)this.findViewById(2131427560);
        this.updateButton.setOnClickListener(this.updateButtonHandler);
        this.mWifiState = (TextView)this.findViewById(2131427561);
        this.mNetworkState = (TextView)this.findViewById(2131427562);
        this.mSupplicantState = (TextView)this.findViewById(2131427563);
        this.mRSSI = (TextView)this.findViewById(2131427564);
        this.mBSSID = (TextView)this.findViewById(2131427565);
        this.mSSID = (TextView)this.findViewById(2131427547);
        this.mHiddenSSID = (TextView)this.findViewById(2131427566);
        this.mIPAddr = (TextView)this.findViewById(2131427567);
        this.mMACAddr = (TextView)this.findViewById(2131427568);
        this.mNetworkId = (TextView)this.findViewById(2131427569);
        this.mLinkSpeed = (TextView)this.findViewById(2131427570);
        this.mScanList = (TextView)this.findViewById(2131427571);
        this.mPingIpAddr = (TextView)this.findViewById(2131427468);
        this.mPingHostname = (TextView)this.findViewById(2131427469);
        this.mHttpClientTest = (TextView)this.findViewById(2131427470);
        this.pingTestButton = (Button)this.findViewById(2131427467);
        this.pingTestButton.setOnClickListener(this.mPingButtonHandler);
    }

    protected void onResume() {
        super.onResume();
        this.registerReceiver(this.mWifiStateReceiver, this.mWifiStateFilter);
    }

    protected void onPause() {
        super.onPause();
        this.unregisterReceiver(this.mWifiStateReceiver);
    }

    private void setSupplicantStateText(SupplicantState supplicantState) {
        if (SupplicantState.FOUR_WAY_HANDSHAKE.equals((Object)supplicantState)) {
            this.mSupplicantState.setText((CharSequence)"FOUR WAY HANDSHAKE");
        } else if (SupplicantState.ASSOCIATED.equals((Object)supplicantState)) {
            this.mSupplicantState.setText((CharSequence)"ASSOCIATED");
        } else if (SupplicantState.ASSOCIATING.equals((Object)supplicantState)) {
            this.mSupplicantState.setText((CharSequence)"ASSOCIATING");
        } else if (SupplicantState.COMPLETED.equals((Object)supplicantState)) {
            this.mSupplicantState.setText((CharSequence)"COMPLETED");
        } else if (SupplicantState.DISCONNECTED.equals((Object)supplicantState)) {
            this.mSupplicantState.setText((CharSequence)"DISCONNECTED");
        } else if (SupplicantState.DORMANT.equals((Object)supplicantState)) {
            this.mSupplicantState.setText((CharSequence)"DORMANT");
        } else if (SupplicantState.GROUP_HANDSHAKE.equals((Object)supplicantState)) {
            this.mSupplicantState.setText((CharSequence)"GROUP HANDSHAKE");
        } else if (SupplicantState.INACTIVE.equals((Object)supplicantState)) {
            this.mSupplicantState.setText((CharSequence)"INACTIVE");
        } else if (SupplicantState.INVALID.equals((Object)supplicantState)) {
            this.mSupplicantState.setText((CharSequence)"INVALID");
        } else if (SupplicantState.SCANNING.equals((Object)supplicantState)) {
            this.mSupplicantState.setText((CharSequence)"SCANNING");
        } else if (SupplicantState.UNINITIALIZED.equals((Object)supplicantState)) {
            this.mSupplicantState.setText((CharSequence)"UNINITIALIZED");
        } else {
            this.mSupplicantState.setText((CharSequence)"BAD");
            Log.e((String)TAG, (String)"supplicant state is bad");
        }
    }

    private void setWifiStateText(int wifiState) {
        String wifiStateString;
        switch (wifiState) {
            case 0: {
                wifiStateString = this.getString(2131231144);
                break;
            }
            case 1: {
                wifiStateString = this.getString(2131231145);
                break;
            }
            case 2: {
                wifiStateString = this.getString(2131231146);
                break;
            }
            case 3: {
                wifiStateString = this.getString(2131231147);
                break;
            }
            case 4: {
                wifiStateString = this.getString(2131231148);
                break;
            }
            default: {
                wifiStateString = "BAD";
                Log.e((String)TAG, (String)"wifi state is bad");
            }
        }
        this.mWifiState.setText((CharSequence)wifiStateString);
    }

    private void handleSignalChanged(int rssi) {
        this.mRSSI.setText((CharSequence)String.valueOf(rssi));
    }

    private void handleWifiStateChanged(int wifiState) {
        this.setWifiStateText(wifiState);
    }

    private void handleScanResultsAvailable() {
        List list = this.mWifiManager.getScanResults();
        StringBuffer scanList = new StringBuffer();
        if (list != null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                ScanResult scanResult = (ScanResult)list.get(i);
                if (scanResult == null || TextUtils.isEmpty((CharSequence)scanResult.SSID)) continue;
                scanList.append(scanResult.SSID + " ");
            }
        }
        this.mScanList.setText((CharSequence)scanList);
    }

    private void handleSupplicantStateChanged(SupplicantState state, boolean hasError, int error) {
        if (hasError) {
            this.mSupplicantState.setText((CharSequence)"ERROR AUTHENTICATING");
        } else {
            this.setSupplicantStateText(state);
        }
    }

    private void handleNetworkStateChanged(NetworkInfo networkInfo) {
        if (this.mWifiManager.isWifiEnabled()) {
            String summary = Summary.get((Context)this, this.mWifiManager.getConnectionInfo().getSSID(), networkInfo.getDetailedState());
            this.mNetworkState.setText((CharSequence)summary);
        }
    }

    private final void updatePingState() {
        final Handler handler = new Handler();
        this.mPingIpAddrResult = this.getResources().getString(2131230744);
        this.mPingHostnameResult = this.getResources().getString(2131230744);
        this.mHttpClientTestResult = this.getResources().getString(2131230744);
        this.mPingIpAddr.setText((CharSequence)this.mPingIpAddrResult);
        this.mPingHostname.setText((CharSequence)this.mPingHostnameResult);
        this.mHttpClientTest.setText((CharSequence)this.mHttpClientTestResult);
        final Runnable updatePingResults = new Runnable(){

            public void run() {
                WifiStatusTest.this.mPingIpAddr.setText((CharSequence)WifiStatusTest.this.mPingIpAddrResult);
                WifiStatusTest.this.mPingHostname.setText((CharSequence)WifiStatusTest.this.mPingHostnameResult);
                WifiStatusTest.this.mHttpClientTest.setText((CharSequence)WifiStatusTest.this.mHttpClientTestResult);
            }
        };
        Thread ipAddrThread = new Thread(){

            public void run() {
                WifiStatusTest.this.pingIpAddr();
                handler.post(updatePingResults);
            }
        };
        ipAddrThread.start();
        Thread hostnameThread = new Thread(){

            public void run() {
                WifiStatusTest.this.pingHostname();
                handler.post(updatePingResults);
            }
        };
        hostnameThread.start();
        Thread httpClientThread = new Thread(){

            public void run() {
                WifiStatusTest.this.httpClientTest();
                handler.post(updatePingResults);
            }
        };
        httpClientThread.start();
    }

    private final void pingIpAddr() {
        try {
            String ipAddress = "74.125.47.104";
            Process p = Runtime.getRuntime().exec("ping -c 1 -w 100 " + ipAddress);
            int status = p.waitFor();
            this.mPingIpAddrResult = status == 0 ? "Pass" : "Fail: IP addr not reachable";
        }
        catch (IOException e) {
            this.mPingIpAddrResult = "Fail: IOException";
        }
        catch (InterruptedException e) {
            this.mPingIpAddrResult = "Fail: InterruptedException";
        }
    }

    private final void pingHostname() {
        try {
            Process p = Runtime.getRuntime().exec("ping -c 1 -w 100 www.google.com");
            int status = p.waitFor();
            this.mPingHostnameResult = status == 0 ? "Pass" : "Fail: Host unreachable";
        }
        catch (UnknownHostException e) {
            this.mPingHostnameResult = "Fail: Unknown Host";
        }
        catch (IOException e) {
            this.mPingHostnameResult = "Fail: IOException";
        }
        catch (InterruptedException e) {
            this.mPingHostnameResult = "Fail: InterruptedException";
        }
    }

    private void httpClientTest() {
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            HttpGet request = new HttpGet("http://www.google.com");
            HttpResponse response = client.execute((HttpUriRequest)request);
            this.mHttpClientTestResult = response.getStatusLine().getStatusCode() == 200 ? "Pass" : "Fail: Code: " + String.valueOf(response);
            request.abort();
        }
        catch (IOException e) {
            this.mHttpClientTestResult = "Fail: IOException";
        }
    }
}

