/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.wifi;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.NetworkInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.preference.CheckBoxPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceScreen;
import android.provider.Settings;
import android.security.Credentials;
import android.security.KeyStore;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Toast;
import com.android.settings.ProgressCategory;
import com.android.settings.wifi.AccessPoint;
import com.android.settings.wifi.AdvancedSettings;
import com.android.settings.wifi.WifiDialog;
import com.android.settings.wifi.WifiEnabler;
import java.util.ArrayList;
import java.util.List;

public class WifiSettings
extends PreferenceActivity
implements DialogInterface.OnClickListener {
    private static final int MENU_ID_SCAN = 1;
    private static final int MENU_ID_ADVANCED = 2;
    private static final int MENU_ID_CONNECT = 3;
    private static final int MENU_ID_FORGET = 4;
    private static final int MENU_ID_MODIFY = 5;
    private final IntentFilter mFilter = new IntentFilter();
    private final BroadcastReceiver mReceiver;
    private final Scanner mScanner;
    private WifiManager mWifiManager;
    private WifiEnabler mWifiEnabler;
    private CheckBoxPreference mNotifyOpenNetworks;
    private ProgressCategory mAccessPoints;
    private Preference mAddNetwork;
    private NetworkInfo.DetailedState mLastState;
    private WifiInfo mLastInfo;
    private int mLastPriority;
    private boolean mResetNetworks = false;
    private int mKeyStoreNetworkId = -1;
    private AccessPoint mSelected;
    private WifiDialog mDialog;

    public WifiSettings() {
        this.mFilter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
        this.mFilter.addAction("android.net.wifi.SCAN_RESULTS");
        this.mFilter.addAction("android.net.wifi.NETWORK_IDS_CHANGED");
        this.mFilter.addAction("android.net.wifi.supplicant.STATE_CHANGE");
        this.mFilter.addAction("android.net.wifi.STATE_CHANGE");
        this.mFilter.addAction("android.net.wifi.RSSI_CHANGED");
        this.mReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                WifiSettings.this.handleEvent(intent);
            }
        };
        this.mScanner = new Scanner();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mWifiManager = (WifiManager)this.getSystemService("wifi");
        if (this.getIntent().getBooleanExtra("only_access_points", false)) {
            this.addPreferencesFromResource(2130968615);
        } else {
            this.addPreferencesFromResource(2130968618);
            this.mWifiEnabler = new WifiEnabler((Context)this, (CheckBoxPreference)this.findPreference("enable_wifi"));
            this.mNotifyOpenNetworks = (CheckBoxPreference)this.findPreference("notify_open_networks");
            this.mNotifyOpenNetworks.setChecked(Settings.Secure.getInt((ContentResolver)this.getContentResolver(), (String)"wifi_networks_available_notification_on", (int)0) == 1);
        }
        this.mAccessPoints = (ProgressCategory)this.findPreference("access_points");
        this.mAccessPoints.setOrderingAsAdded(false);
        this.mAddNetwork = this.findPreference("add_network");
        this.registerForContextMenu((View)this.getListView());
    }

    protected void onResume() {
        super.onResume();
        if (this.mWifiEnabler != null) {
            this.mWifiEnabler.resume();
        }
        this.registerReceiver(this.mReceiver, this.mFilter);
        if (this.mKeyStoreNetworkId != -1 && KeyStore.getInstance().test() == 1) {
            this.connect(this.mKeyStoreNetworkId);
        }
        this.mKeyStoreNetworkId = -1;
    }

    protected void onPause() {
        super.onPause();
        if (this.mWifiEnabler != null) {
            this.mWifiEnabler.pause();
        }
        this.unregisterReceiver(this.mReceiver);
        this.mScanner.pause();
        if (this.mDialog != null) {
            this.mDialog.dismiss();
            this.mDialog = null;
        }
        if (this.mResetNetworks) {
            this.enableNetworks();
        }
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        menu.add(0, 1, 0, 2131231065).setIcon(2130837548);
        menu.add(0, 2, 0, 2131231066).setIcon(17301570);
        return super.onCreateOptionsMenu(menu);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 1: {
                if (this.mWifiManager.isWifiEnabled()) {
                    this.mScanner.resume();
                }
                return true;
            }
            case 2: {
                this.startActivity(new Intent((Context)this, AdvancedSettings.class));
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onCreateContextMenu(ContextMenu menu, View view, ContextMenu.ContextMenuInfo info) {
        Preference preference;
        if (info instanceof AdapterView.AdapterContextMenuInfo && (preference = (Preference)this.getListView().getItemAtPosition(((AdapterView.AdapterContextMenuInfo)info).position)) instanceof AccessPoint) {
            this.mSelected = (AccessPoint)preference;
            menu.setHeaderTitle((CharSequence)this.mSelected.ssid);
            if (this.mSelected.getLevel() != -1 && this.mSelected.getState() == null) {
                menu.add(0, 3, 0, 2131231067);
            }
            if (this.mSelected.networkId != -1) {
                menu.add(0, 4, 0, 2131231068);
                if (this.mSelected.security != 0) {
                    menu.add(0, 5, 0, 2131231069);
                }
            }
        }
    }

    public boolean onContextItemSelected(MenuItem item) {
        if (this.mSelected == null) {
            return super.onContextItemSelected(item);
        }
        switch (item.getItemId()) {
            case 3: {
                if (this.mSelected.networkId != -1) {
                    if (!this.requireKeyStore(this.mSelected.getConfig())) {
                        this.connect(this.mSelected.networkId);
                    }
                } else if (this.mSelected.security == 0) {
                    WifiConfiguration config = new WifiConfiguration();
                    config.SSID = AccessPoint.convertToQuotedString(this.mSelected.ssid);
                    config.allowedKeyManagement.set(0);
                    int networkId = this.mWifiManager.addNetwork(config);
                    this.mWifiManager.enableNetwork(networkId, false);
                    this.connect(networkId);
                } else {
                    this.showDialog(this.mSelected, false);
                }
                return true;
            }
            case 4: {
                this.forget(this.mSelected.networkId);
                return true;
            }
            case 5: {
                this.showDialog(this.mSelected, true);
                return true;
            }
        }
        return super.onContextItemSelected(item);
    }

    public boolean onPreferenceTreeClick(PreferenceScreen screen, Preference preference) {
        if (preference instanceof AccessPoint) {
            this.mSelected = (AccessPoint)preference;
            this.showDialog(this.mSelected, false);
        } else if (preference == this.mAddNetwork) {
            this.mSelected = null;
            this.showDialog(null, true);
        } else if (preference == this.mNotifyOpenNetworks) {
            Settings.Secure.putInt((ContentResolver)this.getContentResolver(), (String)"wifi_networks_available_notification_on", (int)(this.mNotifyOpenNetworks.isChecked() ? 1 : 0));
        } else {
            return super.onPreferenceTreeClick(screen, preference);
        }
        return true;
    }

    public void onClick(DialogInterface dialogInterface, int button) {
        if (button == -3 && this.mSelected != null) {
            this.forget(this.mSelected.networkId);
        } else if (button == -1 && this.mDialog != null) {
            WifiConfiguration config = this.mDialog.getConfig();
            if (config == null) {
                if (this.mSelected != null && !this.requireKeyStore(this.mSelected.getConfig())) {
                    this.connect(this.mSelected.networkId);
                }
            } else if (config.networkId != -1) {
                if (this.mSelected != null) {
                    this.mWifiManager.updateNetwork(config);
                    this.saveNetworks();
                }
            } else {
                int networkId = this.mWifiManager.addNetwork(config);
                if (networkId != -1) {
                    this.mWifiManager.enableNetwork(networkId, false);
                    config.networkId = networkId;
                    if (this.mDialog.edit || this.requireKeyStore(config)) {
                        this.saveNetworks();
                    } else {
                        this.connect(networkId);
                    }
                }
            }
        }
    }

    private void showDialog(AccessPoint accessPoint, boolean edit) {
        if (this.mDialog != null) {
            this.mDialog.dismiss();
        }
        this.mDialog = new WifiDialog((Context)this, this, accessPoint, edit);
        this.mDialog.show();
    }

    private boolean requireKeyStore(WifiConfiguration config) {
        if (WifiDialog.requireKeyStore(config) && KeyStore.getInstance().test() != 1) {
            this.mKeyStoreNetworkId = config.networkId;
            Credentials.getInstance().unlock((Context)this);
            return true;
        }
        return false;
    }

    private void forget(int networkId) {
        this.mWifiManager.removeNetwork(networkId);
        this.saveNetworks();
    }

    private void connect(int networkId) {
        if (networkId == -1) {
            return;
        }
        if (this.mLastPriority > 1000000) {
            for (int i = this.mAccessPoints.getPreferenceCount() - 1; i >= 0; --i) {
                AccessPoint accessPoint = (AccessPoint)this.mAccessPoints.getPreference(i);
                if (accessPoint.networkId == -1) continue;
                WifiConfiguration config = new WifiConfiguration();
                config.networkId = accessPoint.networkId;
                config.priority = 0;
                this.mWifiManager.updateNetwork(config);
            }
            this.mLastPriority = 0;
        }
        WifiConfiguration config = new WifiConfiguration();
        config.networkId = networkId;
        config.priority = ++this.mLastPriority;
        this.mWifiManager.updateNetwork(config);
        this.saveNetworks();
        this.mWifiManager.enableNetwork(networkId, true);
        this.mWifiManager.reconnect();
        this.mResetNetworks = true;
    }

    private void enableNetworks() {
        for (int i = this.mAccessPoints.getPreferenceCount() - 1; i >= 0; --i) {
            WifiConfiguration config = ((AccessPoint)this.mAccessPoints.getPreference(i)).getConfig();
            if (config == null || config.status == 2) continue;
            this.mWifiManager.enableNetwork(config.networkId, false);
        }
        this.mResetNetworks = false;
    }

    private void saveNetworks() {
        this.enableNetworks();
        this.mWifiManager.saveConfiguration();
        this.updateAccessPoints();
    }

    private void updateAccessPoints() {
        List results;
        ArrayList<AccessPoint> accessPoints = new ArrayList<AccessPoint>();
        List configs = this.mWifiManager.getConfiguredNetworks();
        if (configs != null) {
            this.mLastPriority = 0;
            for (WifiConfiguration config : configs) {
                if (config.priority > this.mLastPriority) {
                    this.mLastPriority = config.priority;
                }
                if (config.status == 0) {
                    config.status = 2;
                } else if (this.mResetNetworks && config.status == 1) {
                    config.status = 0;
                }
                AccessPoint accessPoint = new AccessPoint((Context)this, config);
                accessPoint.update(this.mLastInfo, this.mLastState);
                accessPoints.add(accessPoint);
            }
        }
        if ((results = this.mWifiManager.getScanResults()) != null) {
            for (ScanResult result : results) {
                if (result.SSID == null || result.SSID.length() == 0 || result.capabilities.contains("[IBSS]")) continue;
                boolean found = false;
                for (AccessPoint accessPoint : accessPoints) {
                    if (!accessPoint.update(result)) continue;
                    found = true;
                }
                if (found) continue;
                accessPoints.add(new AccessPoint((Context)this, result));
            }
        }
        this.mAccessPoints.removeAll();
        for (AccessPoint accessPoint : accessPoints) {
            this.mAccessPoints.addPreference(accessPoint);
        }
    }

    private void handleEvent(Intent intent) {
        String action = intent.getAction();
        if ("android.net.wifi.WIFI_STATE_CHANGED".equals(action)) {
            this.updateWifiState(intent.getIntExtra("wifi_state", 4));
        } else if ("android.net.wifi.SCAN_RESULTS".equals(action)) {
            this.updateAccessPoints();
        } else if ("android.net.wifi.NETWORK_IDS_CHANGED".equals(action)) {
            if (this.mSelected != null && this.mSelected.networkId != -1) {
                this.mSelected = null;
            }
            this.updateAccessPoints();
        } else if ("android.net.wifi.supplicant.STATE_CHANGE".equals(action)) {
            this.updateConnectionState(WifiInfo.getDetailedStateOf((SupplicantState)((SupplicantState)intent.getParcelableExtra("newState"))));
        } else if ("android.net.wifi.STATE_CHANGE".equals(action)) {
            this.updateConnectionState(((NetworkInfo)intent.getParcelableExtra("networkInfo")).getDetailedState());
        } else if ("android.net.wifi.RSSI_CHANGED".equals(action)) {
            this.updateConnectionState(null);
        }
    }

    private void updateConnectionState(NetworkInfo.DetailedState state) {
        if (!this.mWifiManager.isWifiEnabled()) {
            this.mScanner.pause();
            return;
        }
        if (state == NetworkInfo.DetailedState.OBTAINING_IPADDR) {
            this.mScanner.pause();
        } else {
            this.mScanner.resume();
        }
        this.mLastInfo = this.mWifiManager.getConnectionInfo();
        if (state != null) {
            this.mLastState = state;
        }
        for (int i = this.mAccessPoints.getPreferenceCount() - 1; i >= 0; --i) {
            ((AccessPoint)this.mAccessPoints.getPreference(i)).update(this.mLastInfo, this.mLastState);
        }
        if (this.mResetNetworks && (state == NetworkInfo.DetailedState.CONNECTED || state == NetworkInfo.DetailedState.DISCONNECTED || state == NetworkInfo.DetailedState.FAILED)) {
            this.updateAccessPoints();
            this.enableNetworks();
        }
    }

    private void updateWifiState(int state) {
        if (state == 3) {
            this.mScanner.resume();
            this.updateAccessPoints();
        } else {
            this.mScanner.pause();
            this.mAccessPoints.removeAll();
        }
    }

    private class Scanner
    extends Handler {
        private int mRetry = 0;

        private Scanner() {
        }

        void resume() {
            if (!this.hasMessages(0)) {
                this.sendEmptyMessage(0);
            }
        }

        void pause() {
            this.mRetry = 0;
            WifiSettings.this.mAccessPoints.setProgress(false);
            this.removeMessages(0);
        }

        public void handleMessage(Message message) {
            if (WifiSettings.this.mWifiManager.startScanActive()) {
                this.mRetry = 0;
            } else if (++this.mRetry >= 3) {
                this.mRetry = 0;
                Toast.makeText((Context)WifiSettings.this, (int)2131231060, (int)1).show();
                return;
            }
            WifiSettings.this.mAccessPoints.setProgress(this.mRetry != 0);
            this.sendEmptyMessageDelayed(0, 6000L);
        }
    }
}

