/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.wifi;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.NetworkInfo;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.preference.CheckBoxPreference;
import android.preference.Preference;
import android.widget.Toast;
import com.android.settings.WirelessSettings;
import com.android.settings.wifi.Summary;

public class WifiEnabler
implements Preference.OnPreferenceChangeListener {
    private final Context mContext;
    private final CheckBoxPreference mCheckBox;
    private final CharSequence mOriginalSummary;
    private final WifiManager mWifiManager;
    private final IntentFilter mIntentFilter;
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.net.wifi.WIFI_STATE_CHANGED".equals(action)) {
                WifiEnabler.this.handleWifiStateChanged(intent.getIntExtra("wifi_state", 4));
            } else if ("android.net.wifi.supplicant.STATE_CHANGE".equals(action)) {
                WifiEnabler.this.handleStateChanged(WifiInfo.getDetailedStateOf((SupplicantState)((SupplicantState)intent.getParcelableExtra("newState"))));
            } else if ("android.net.wifi.STATE_CHANGE".equals(action)) {
                WifiEnabler.this.handleStateChanged(((NetworkInfo)intent.getParcelableExtra("networkInfo")).getDetailedState());
            }
        }
    };

    public WifiEnabler(Context context, CheckBoxPreference checkBox) {
        this.mContext = context;
        this.mCheckBox = checkBox;
        this.mOriginalSummary = checkBox.getSummary();
        checkBox.setPersistent(false);
        this.mWifiManager = (WifiManager)context.getSystemService("wifi");
        this.mIntentFilter = new IntentFilter("android.net.wifi.WIFI_STATE_CHANGED");
        this.mIntentFilter.addAction("android.net.wifi.supplicant.STATE_CHANGE");
        this.mIntentFilter.addAction("android.net.wifi.STATE_CHANGE");
    }

    public void resume() {
        this.mContext.registerReceiver(this.mReceiver, this.mIntentFilter);
        this.mCheckBox.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
    }

    public void pause() {
        this.mContext.unregisterReceiver(this.mReceiver);
        this.mCheckBox.setOnPreferenceChangeListener(null);
    }

    public boolean onPreferenceChange(Preference preference, Object value) {
        boolean enable = (Boolean)value;
        if (enable && !WirelessSettings.isRadioAllowed(this.mContext, "wifi")) {
            Toast.makeText((Context)this.mContext, (int)2131231059, (int)0).show();
            return false;
        }
        int wifiApState = this.mWifiManager.getWifiApState();
        if (enable && (wifiApState == 2 || wifiApState == 3)) {
            this.mWifiManager.setWifiApEnabled(null, false);
        }
        if (this.mWifiManager.setWifiEnabled(enable)) {
            this.mCheckBox.setEnabled(false);
        } else {
            this.mCheckBox.setSummary(2131231058);
        }
        return false;
    }

    private void handleWifiStateChanged(int state) {
        switch (state) {
            case 2: {
                this.mCheckBox.setSummary(2131231056);
                this.mCheckBox.setEnabled(false);
                break;
            }
            case 3: {
                this.mCheckBox.setChecked(true);
                this.mCheckBox.setSummary(null);
                this.mCheckBox.setEnabled(true);
                break;
            }
            case 0: {
                this.mCheckBox.setSummary(2131231057);
                this.mCheckBox.setEnabled(false);
                break;
            }
            case 1: {
                this.mCheckBox.setChecked(false);
                this.mCheckBox.setSummary(this.mOriginalSummary);
                this.mCheckBox.setEnabled(true);
                break;
            }
            default: {
                this.mCheckBox.setChecked(false);
                this.mCheckBox.setSummary(2131231058);
                this.mCheckBox.setEnabled(true);
            }
        }
    }

    private void handleStateChanged(NetworkInfo.DetailedState state) {
        WifiInfo info;
        if (state != null && this.mCheckBox.isChecked() && (info = this.mWifiManager.getConnectionInfo()) != null) {
            this.mCheckBox.setSummary((CharSequence)Summary.get(this.mContext, info.getSSID(), state));
        }
    }
}

