/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.wifi;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.net.NetworkInfo;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.os.Bundle;
import android.security.KeyStore;
import android.text.Editable;
import android.text.TextWatcher;
import android.text.format.Formatter;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import com.android.settings.wifi.AccessPoint;
import com.android.settings.wifi.Summary;

class WifiDialog
extends AlertDialog
implements View.OnClickListener,
TextWatcher,
AdapterView.OnItemSelectedListener {
    private static final String KEYSTORE_SPACE = "keystore://";
    static final int BUTTON_SUBMIT = -1;
    static final int BUTTON_FORGET = -3;
    final boolean edit;
    private final DialogInterface.OnClickListener mListener;
    private final AccessPoint mAccessPoint;
    private View mView;
    private TextView mSsid;
    private int mSecurity;
    private TextView mPassword;
    private Spinner mEapMethod;
    private Spinner mEapCaCert;
    private Spinner mPhase2;
    private Spinner mEapUserCert;
    private TextView mEapIdentity;
    private TextView mEapAnonymous;

    static boolean requireKeyStore(WifiConfiguration config) {
        String[] values;
        for (String value : values = new String[]{config.ca_cert.value(), config.client_cert.value(), config.private_key.value()}) {
            if (value == null || !value.startsWith(KEYSTORE_SPACE)) continue;
            return true;
        }
        return false;
    }

    WifiDialog(Context context, DialogInterface.OnClickListener listener, AccessPoint accessPoint, boolean edit) {
        super(context);
        this.edit = edit;
        this.mListener = listener;
        this.mAccessPoint = accessPoint;
        this.mSecurity = accessPoint == null ? 0 : accessPoint.security;
    }

    WifiConfiguration getConfig() {
        if (this.mAccessPoint != null && this.mAccessPoint.networkId != -1 && !this.edit) {
            return null;
        }
        WifiConfiguration config = new WifiConfiguration();
        if (this.mAccessPoint == null) {
            config.SSID = AccessPoint.convertToQuotedString(((Object)this.mSsid.getText()).toString());
            config.hiddenSSID = true;
        } else if (this.mAccessPoint.networkId == -1) {
            config.SSID = AccessPoint.convertToQuotedString(this.mAccessPoint.ssid);
        } else {
            config.networkId = this.mAccessPoint.networkId;
        }
        switch (this.mSecurity) {
            case 0: {
                config.allowedKeyManagement.set(0);
                return config;
            }
            case 1: {
                config.allowedKeyManagement.set(0);
                config.allowedAuthAlgorithms.set(0);
                config.allowedAuthAlgorithms.set(1);
                if (this.mPassword.length() != 0) {
                    int length = this.mPassword.length();
                    String password = ((Object)this.mPassword.getText()).toString();
                    config.wepKeys[0] = (length == 10 || length == 26 || length == 58) && password.matches("[0-9A-Fa-f]*") ? password : '\"' + password + '\"';
                }
                return config;
            }
            case 2: {
                config.allowedKeyManagement.set(1);
                if (this.mPassword.length() != 0) {
                    String password = ((Object)this.mPassword.getText()).toString();
                    config.preSharedKey = password.matches("[0-9A-Fa-f]{64}") ? password : '\"' + password + '\"';
                }
                return config;
            }
            case 3: {
                config.allowedKeyManagement.set(2);
                config.allowedKeyManagement.set(3);
                config.eap.setValue((String)this.mEapMethod.getSelectedItem());
                config.phase2.setValue(this.mPhase2.getSelectedItemPosition() == 0 ? "" : "auth=" + this.mPhase2.getSelectedItem());
                config.ca_cert.setValue(this.mEapCaCert.getSelectedItemPosition() == 0 ? "" : "keystore://CACERT_" + (String)this.mEapCaCert.getSelectedItem());
                config.client_cert.setValue(this.mEapUserCert.getSelectedItemPosition() == 0 ? "" : "keystore://USRCERT_" + (String)this.mEapUserCert.getSelectedItem());
                config.private_key.setValue(this.mEapUserCert.getSelectedItemPosition() == 0 ? "" : "keystore://USRPKEY_" + (String)this.mEapUserCert.getSelectedItem());
                config.identity.setValue(this.mEapIdentity.length() == 0 ? "" : ((Object)this.mEapIdentity.getText()).toString());
                config.anonymous_identity.setValue(this.mEapAnonymous.length() == 0 ? "" : ((Object)this.mEapAnonymous.getText()).toString());
                if (this.mPassword.length() != 0) {
                    config.password.setValue(((Object)this.mPassword.getText()).toString());
                }
                return config;
            }
        }
        return null;
    }

    protected void onCreate(Bundle savedInstanceState) {
        this.mView = this.getLayoutInflater().inflate(2130903107, null);
        this.setView(this.mView);
        this.setInverseBackgroundForced(true);
        Context context = this.getContext();
        Resources resources = context.getResources();
        if (this.mAccessPoint == null) {
            this.setTitle(2131231063);
            this.mView.findViewById(2131427546).setVisibility(0);
            this.mSsid = (TextView)this.mView.findViewById(2131427547);
            this.mSsid.addTextChangedListener((TextWatcher)this);
            ((Spinner)this.mView.findViewById(2131427548)).setOnItemSelectedListener((AdapterView.OnItemSelectedListener)this);
            this.setButton(-1, context.getString(2131231093), this.mListener);
        } else {
            WifiInfo info;
            this.setTitle(this.mAccessPoint.ssid);
            ViewGroup group = (ViewGroup)this.mView.findViewById(2131427545);
            NetworkInfo.DetailedState state = this.mAccessPoint.getState();
            if (state != null) {
                this.addRow(group, 2131231073, Summary.get(this.getContext(), state));
            }
            String[] type = resources.getStringArray(2131034130);
            this.addRow(group, 2131231071, type[this.mAccessPoint.security]);
            int level = this.mAccessPoint.getLevel();
            if (level != -1) {
                String[] signal = resources.getStringArray(2131034135);
                this.addRow(group, 2131231072, signal[level]);
            }
            if ((info = this.mAccessPoint.getInfo()) != null) {
                this.addRow(group, 2131231074, info.getLinkSpeed() + "Mbps");
                int address = info.getIpAddress();
                if (address != 0) {
                    this.addRow(group, 2131231075, Formatter.formatIpAddress((int)address));
                }
            }
            if (this.mAccessPoint.networkId == -1 || this.edit) {
                this.showSecurityFields();
            }
            if (this.edit) {
                this.setButton(-1, context.getString(2131231093), this.mListener);
            } else {
                if (state == null && level != -1) {
                    this.setButton(-1, context.getString(2131231091), this.mListener);
                }
                if (this.mAccessPoint.networkId != -1) {
                    this.setButton(-3, context.getString(2131231092), this.mListener);
                }
            }
        }
        this.setButton(-2, context.getString(2131231094), this.mListener);
        super.onCreate(savedInstanceState);
        if (this.getButton(-1) != null) {
            this.validate();
        }
    }

    private void addRow(ViewGroup group, int name, String value) {
        View row = this.getLayoutInflater().inflate(2130903108, group, false);
        ((TextView)row.findViewById(2131427379)).setText(name);
        ((TextView)row.findViewById(2131427436)).setText((CharSequence)value);
        group.addView(row);
    }

    private void validate() {
        if (this.mSsid != null && this.mSsid.length() == 0 || (this.mAccessPoint == null || this.mAccessPoint.networkId == -1) && (this.mSecurity == 1 && this.mPassword.length() == 0 || this.mSecurity == 2 && this.mPassword.length() < 8)) {
            this.getButton(-1).setEnabled(false);
        } else {
            this.getButton(-1).setEnabled(true);
        }
    }

    public void onClick(View view) {
        this.mPassword.setInputType(1 | (((CheckBox)view).isChecked() ? 144 : 128));
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void afterTextChanged(Editable editable) {
        this.validate();
    }

    public void onItemSelected(AdapterView parent, View view, int position, long id2) {
        this.mSecurity = position;
        this.showSecurityFields();
        this.validate();
    }

    public void onNothingSelected(AdapterView parent) {
    }

    private void showSecurityFields() {
        if (this.mSecurity == 0) {
            this.mView.findViewById(2131427549).setVisibility(8);
            return;
        }
        this.mView.findViewById(2131427549).setVisibility(0);
        if (this.mPassword == null) {
            this.mPassword = (TextView)this.mView.findViewById(2131427550);
            this.mPassword.addTextChangedListener((TextWatcher)this);
            ((CheckBox)this.mView.findViewById(2131427551)).setOnClickListener((View.OnClickListener)this);
            if (this.mAccessPoint != null && this.mAccessPoint.networkId != -1) {
                this.mPassword.setHint(2131231084);
            }
        }
        if (this.mSecurity != 3) {
            this.mView.findViewById(2131427553).setVisibility(8);
            return;
        }
        this.mView.findViewById(2131427553).setVisibility(0);
        if (this.mEapMethod == null) {
            this.mEapMethod = (Spinner)this.mView.findViewById(2131427554);
            this.mPhase2 = (Spinner)this.mView.findViewById(2131427555);
            this.mEapCaCert = (Spinner)this.mView.findViewById(2131427556);
            this.mEapUserCert = (Spinner)this.mView.findViewById(2131427557);
            this.mEapIdentity = (TextView)this.mView.findViewById(2131427558);
            this.mEapAnonymous = (TextView)this.mView.findViewById(2131427559);
            this.loadCertificates(this.mEapCaCert, "CACERT_");
            this.loadCertificates(this.mEapUserCert, "USRPKEY_");
            if (this.mAccessPoint != null && this.mAccessPoint.networkId != -1) {
                WifiConfiguration config = this.mAccessPoint.getConfig();
                this.setSelection(this.mEapMethod, config.eap.value());
                this.setSelection(this.mPhase2, config.phase2.value());
                this.setCertificate(this.mEapCaCert, "CACERT_", config.ca_cert.value());
                this.setCertificate(this.mEapUserCert, "USRPKEY_", config.private_key.value());
                this.mEapIdentity.setText((CharSequence)config.identity.value());
                this.mEapAnonymous.setText((CharSequence)config.anonymous_identity.value());
            }
        }
    }

    private void loadCertificates(Spinner spinner, String prefix) {
        Object[] certs = KeyStore.getInstance().saw(prefix);
        Context context = this.getContext();
        String unspecified = context.getString(2131231085);
        if (certs == null || certs.length == 0) {
            certs = new String[]{unspecified};
        } else {
            String[] array2 = new String[certs.length + 1];
            array2[0] = unspecified;
            System.arraycopy(certs, 0, array2, 1, certs.length);
            certs = array2;
        }
        ArrayAdapter adapter = new ArrayAdapter(context, 17367048, certs);
        adapter.setDropDownViewResource(0x1090009);
        spinner.setAdapter((SpinnerAdapter)adapter);
    }

    private void setCertificate(Spinner spinner, String prefix, String cert) {
        prefix = KEYSTORE_SPACE + prefix;
        if (cert != null && cert.startsWith(prefix)) {
            this.setSelection(spinner, cert.substring(prefix.length()));
        }
    }

    private void setSelection(Spinner spinner, String value) {
        if (value != null) {
            ArrayAdapter adapter = (ArrayAdapter)spinner.getAdapter();
            for (int i = adapter.getCount() - 1; i >= 0; --i) {
                if (!value.equals(adapter.getItem(i))) continue;
                spinner.setSelection(i);
                break;
            }
        }
    }
}

