/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings.wifi;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import android.preference.CheckBoxPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceScreen;
import com.android.settings.wifi.WifiApDialog;
import com.android.settings.wifi.WifiApEnabler;

public class WifiApSettings
extends PreferenceActivity
implements DialogInterface.OnClickListener {
    private static final String WIFI_AP_SSID_AND_SECURITY = "wifi_ap_ssid_and_security";
    private static final String ENABLE_WIFI_AP = "enable_wifi_ap";
    private static final int CONFIG_SUBTEXT = 2131231121;
    private static final int OPEN_INDEX = 0;
    private static final int WPA_INDEX = 1;
    private static final int DIALOG_AP_SETTINGS = 1;
    private String[] mSecurityType;
    private Preference mCreateNetwork;
    private CheckBoxPreference mEnableWifiAp;
    private WifiApDialog mDialog;
    private WifiManager mWifiManager;
    private WifiApEnabler mWifiApEnabler;
    private WifiConfiguration mWifiConfig = null;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mWifiManager = (WifiManager)this.getSystemService("wifi");
        this.mWifiConfig = this.mWifiManager.getWifiApConfiguration();
        this.mSecurityType = this.getResources().getStringArray(2131034131);
        this.addPreferencesFromResource(2130968617);
        this.mCreateNetwork = this.findPreference(WIFI_AP_SSID_AND_SECURITY);
        this.mEnableWifiAp = (CheckBoxPreference)this.findPreference(ENABLE_WIFI_AP);
        this.mWifiApEnabler = new WifiApEnabler((Context)this, this.mEnableWifiAp);
        if (this.mWifiConfig == null) {
            String s = this.getString(17040161);
            this.mCreateNetwork.setSummary((CharSequence)String.format(this.getString(2131231121), s, this.mSecurityType[0]));
        } else {
            this.mCreateNetwork.setSummary((CharSequence)String.format(this.getString(2131231121), this.mWifiConfig.SSID, this.mWifiConfig.allowedKeyManagement.get(1) ? this.mSecurityType[1] : this.mSecurityType[0]));
        }
    }

    protected Dialog onCreateDialog(int id2) {
        if (id2 == 1) {
            this.mDialog = new WifiApDialog((Context)this, this, this.mWifiConfig);
            return this.mDialog;
        }
        return null;
    }

    protected void onResume() {
        super.onResume();
        this.mWifiApEnabler.resume();
    }

    protected void onPause() {
        super.onPause();
        this.mWifiApEnabler.pause();
    }

    public boolean onPreferenceTreeClick(PreferenceScreen screen, Preference preference) {
        if (preference == this.mCreateNetwork) {
            this.showDialog(1);
        }
        return true;
    }

    public void onClick(DialogInterface dialogInterface, int button) {
        if (button == -1) {
            this.mWifiConfig = this.mDialog.getConfig();
            if (this.mWifiConfig != null) {
                if (this.mWifiManager.getWifiApState() == 3) {
                    this.mWifiManager.setWifiApEnabled(this.mWifiConfig, true);
                    this.mWifiApEnabler.updateConfigSummary(this.mWifiConfig);
                } else {
                    this.mWifiManager.setWifiApConfiguration(this.mWifiConfig);
                }
                this.mCreateNetwork.setSummary((CharSequence)String.format(this.getString(2131231121), this.mWifiConfig.SSID, this.mWifiConfig.allowedKeyManagement.get(1) ? this.mSecurityType[1] : this.mSecurityType[0]));
            }
        }
    }
}

